#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

PW_DIR=`pwd`

if test x$1 = x1; then
    exec ./testcompile.sh
fi
if test x$1 = x2; then
    exec ./testhash.sh
fi
if test x$1 = x3; then
    exec ./testrun_1.sh
fi
if test x$1 = x4; then
    exec ./testrun_1a.sh
fi
if test x$1 = x5; then
    exec ./testext.sh
fi
if test x$1 = x6; then
    exec ./testtimesrv.sh
fi
if test x$1 = x7; then
    exec ./testrun_1b.sh
fi
if test x$1 = x10; then
    exec ./testrun_2.sh $2
fi
if test x$1 = x11; then
    exec ./testrun_2a.sh $2
fi
if test x$1 = x12; then
    exec ./testrun_2b.sh $2
fi
if test x$1 = x13; then
    exec ./testrun_2c.sh $2
fi
if test x$1 = x14; then
    exec ./testrun_2d.sh $2
fi
if test x$1 = xall; then
    ./testcompile.sh
    ./testhash.sh
    ./testrun_1.sh
    ./testrun_1a.sh
    ./testext.sh
    ./testtimesrv.sh
    ./testrun_1b.sh
    ./testrun_2.sh $2
    ./testrun_2a.sh $2
fi

echo "Usage (in brackets: config files used):"
echo
echo "  ${S}test.sh 1${E}            -- Compilation with many different options"
echo "  ${S}test.sh 2${E}            -- Hash function"
echo "  ${S}test.sh 3${E}            -- Standalone init/check    (testrc_1)"
echo "  ${S}test.sh 4${E}            -- Microstealth init/check  (testrc_1)"
echo "  ${S}test.sh 5${E}            -- External program call    (testrc_1ext.in)"
echo "  ${S}test.sh 6${E}            -- Timeserver option        (testrc_1)"
echo "  ${S}test.sh 7${E}            -- GnuPG signed files       (testrc_1)"
#
#
#
echo "  ${S}test.sh 10 hostname${E}  -- Test c/s init/check      (testrc_2.in)"
echo "  ${S}test.sh 11 hostname${E}  -- Test full c/s init/check (testrc_2.in)"
echo "  ${S}test.sh 12 hostname${E}  -- Test full c/s w/gpg      (testrc_2.in)"
echo "  ${S}test.sh 13 hostname${E}  -- Test full c/s w/mysql    (testrc_2.in)"
echo "  ${S}test.sh 14 hostname${E}  -- Test c/s w/syslog logging(testrc_2.in)"
echo "  ${S}test.sh a  hostname${E}  -- All except 7,12+"

echo 
echo "Scripts used: (1) ./testcompile.sh  (2) ./testhash.sh    (3) ./testrun_1.sh"
echo "              (4) ./testrun_1a.sh   (5) ./testext.sh     (6) ./testtimesrv.sh"
echo "              (7) ./testrun_1b.sh  (10) ./testrun_2.sh  (11) ./testrun_2a.sh"
echo "             (12) ./testrun_2b.sh  (13) ./testrun_2c.sh (14) ./testrun_2d.sh"

