#! /usr/bin/perl

use warnings;
use strict;

my $fno = 0;
my $file = '';
my @last2 = ();
my $line = '';

sub usage () {
    print "Usage: concat.pl <list_of_database_files>\n\n";
    print "       Will concatenate samhain file signature database files\n";
    print "       and print to stdout.\n";
    print "       Does not work on signed or otherwise modified\n";
    print "       file signature databases.\n";
}

if ($#ARGV < 0) { # must be at least one file
    usage();
    exit 1;
} elsif ($ARGV[0] =~ /^-h$/ || $ARGV[0] =~ /^--?help$/) {
    usage();
    exit 0;
}
    

for $file (@ARGV) {
    open FH, "< $file" or die "Cannot open $file: $!";
    if ($fno != 0) { # search and read past the start-of-file marker
	while (<FH>) {
	    last if ($_ =~ /^\[SOF\]$/);
	}
    } 
    @last2 = ();
    while (<FH>) {
	push @last2, $_;
	if (@last2 > 2) {
	    $line = shift @last2;
	    print $line;
	}
    }
    close FH;
    ++$fno;
}

# last two lines of last file
$line = shift @last2;
print $line;
$line = shift @last2;
print $line;
