# Samizdat profile field plugin superclass
#
#   Copyright (c) 2002-2009  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 3 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'

class ProfilePlugin < Plugin
  def api
    'profile'
  end

  def match?(name)
    field == name
  end

  def field
  end

  # translated field label
  #
  def label
  end

  # validate and normalize value, raise UserError if value is invalid
  #
  def validate(value)
    value
  end

  def current_value(profile)
    profile[field]
  end

  def set_value(profile, value)
    profile[field] = validate(value)
    profile.save
  end

  def form_label
    [:label, field, label]
  end

  def form_field(profile)
    [:text, field, current_value(profile)]
  end

  # update the value of a profile field, return a notice if value was changed
  #
  def update(request, profile = nil)
    value = request[field]

    if value
      profile ||= Preferences.new(request.session.login)

      if value != current_value(profile)
        set_value(profile, value)
        return sprintf(_('%s updated'), label)
      end
    end
  end
end
