 /* sane - Scanner Access Now Easy.
   Copyright (C) 2003 Johannes Hub (JohannesHub@foni.net)

   This file was initially copied from the hp3300 backend.
   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an exutable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
*/

/*
    Concept for a backend for scanners based on the RTS88xx chipset,
    such as HP4400C, HP4470C, HP3500C, 3530C, and HP ScanJet 3570C.
    Parts of this source were inspired by other backends.

    History:

    Version 0.17g 18.04.04 10.alpha, little fixes
    Version 0.17e 07.04.04 10.alpha, little fixes
    Version 0.17d 05.04.04 10.alpha, little fixes
    Version 0.17b 30.03.04 10.alpha, little fixes and libusb implemented
    Version 0.17a 22.03.04 10.alpha, little fixes
    Version 0.17  09.03.04 9. alpha, HP3500 included
    Version 0.16  06.02.04 8. alpha, wait counting on LCD
    Version 0.15a 29.01.04 7. alpha, CCD switch moved to config file
    Version 0.15  11.01.04 6. alpha, a second CCD implemented
    Version 0.14  21/11/22 5. alpha
    Version 0.13a 21.11.04 4. alpha, an little fix included
    Version 0.13  13.11.04 4. alpha
    Version 0.12  22.10.03 third alpha, Backend name changed to HP_RTS88xx
    Version 0.11  30.08.03 second alpha
    Version 0.10  19.07.03 first alpha
*/

#ifndef _HP_RTS88xx_H_
#define _HP_RTS88xx_H_


#define MM_TO_PIXEL(_mm_, _dpi_)    ((_mm_) * (_dpi_) / 25.4)
#define PIXEL_TO_MM(_pixel_, _dpi_) ((_pixel_) * 25.4 / (_dpi_))
#define ENABLE(OPTION)  s->opt[OPTION].cap &= ~SANE_CAP_INACTIVE
#define DISABLE(OPTION) s->opt[OPTION].cap |=  SANE_CAP_INACTIVE
#define IS_ACTIVE(OPTION) (((s->opt[OPTION].cap) & SANE_CAP_INACTIVE) == 0)
#define NUM_GAMMA_ENTRIES  65536

#define	RTS8801_GREYSCALE	1
#define	RTS8801_COLOUR		2
#define	RTS8801_BW		0

typedef enum
	{
		BLACK_WHITE = 0,
		GRAY,       /*1*/
		COLOR       /*2*/
	}
BACKEND_MODE;

/* options enumerator */
typedef enum {
	optCount = 0,

	optGroupGeometry,
		optTLX, optTLY, optBRX, optBRY,
		optDPI,
		optGroupImage,
		optGammaTableRed,		/* Gamma Tables */
		optGammaTableGreen,
		optGammaTableBlue,
	optGroupMisc,
		OPT_MODE,
		optXPDA,
		optCCD,
		optBrightness,
		optGainR,
		optGainG,
		optGainB,
	optLast
} EOptionIndex;


typedef union {
	SANE_Word w;
	SANE_Word *wa;     /* word array */
	SANE_String s;
} TOptionValue;


typedef struct {
	SANE_Int		iDpi;         /* horizontal resolution */
	SANE_Int		iLpi;         /* vertical resolution */
	SANE_Int		iY;           /* iTop in HW coordinates */
	SANE_Int		iX;           /* iLeft in HW coordinates */
	SANE_Int		iWidth;       /* pixels per line */
	SANE_Int		iLenght;      /* iHeight pixel lines */
	SANE_Int		iSkipLines;   /* Steps to pos. for scann */
	SANE_Int		iLinesLeft;   /* Lines witch left over to scan */
	SANE_Int		fCalib;       /* if TRUE, disable backtracking? */
	SANE_Int		brightness;
	SANE_Int		mode;         /* B/W; color; Grayscale */
	SANE_Int		optXPA;       /* 0=normal; 1 = XPA */
	SANE_Int		oCCD_Type;    /* 0/1 */
	SANE_Int		GainR;
	SANE_Int		GainG;
	SANE_Int		GainB;
	#ifdef		DEBUG_FILE
	FILE			*FD_r;            /* red  test pnm file*/
	FILE			*FD_g;            /* green test pnm file*/
	FILE			*FD_b;            /* blue  test pnm file*/
	SANE_Int		DebugOpen;
	SANE_Int		DebugSeek0;
	#endif
} TScanParams;


typedef struct {
	/* transfer buffer */
	SANE_Byte		*pabXferBuf;
	SANE_Int		iCurLine, iBytesPerLine, iLinesPerXferBuf;
	SANE_Int		iLastLine;
	SANE_Int		iScanned;     /* Lines witch have scanned */
	SANE_Int		iLinesLeft;   /* Lines witch left over to scan */
	/* circular buffer */
	SANE_Byte		*pabCircBuf;
	SANE_Int		iLinesPerCircBuf;
	SANE_Int		iLinesInCircBuf;
	SANE_Int		iMisAlignment;
	SANE_Int		iRedLine, iGrnLine, iBluLine;
	/* current line buffer */
	SANE_Byte		*pabLineBuf;
	SANE_Int		iBytesLeft;
} TDataPipe;


typedef struct {
	SANE_Int		ScannerModel;
	SANE_Int		iXferHandle;    /* handle used for data transfer to HW */
	SANE_Int		iTopLeftX;      /* in mm */
	SANE_Int		iTopLeftY;      /* in mm */
	SANE_Int		iMainBoardID;   /*  */
	SANE_Bool		iReversedHead;  /* Head is reversed */
	SANE_Bool		lamp_warm;      /* TRUE = the lamp is warm */
	SANE_Byte		regs[0xff];
} THWParams;


typedef struct {
	SANE_Option_Descriptor	aOptions[optLast];
	TOptionValue						aValues[optLast];

	TScanParams							ScanParams;
	THWParams								HWParams;
	TDataPipe								DataPipe;

	SANE_Int								*aGammaTableR;	/* a 16-to-16 bit color lookup table */
	SANE_Int								*aGammaTableG;	/* a 16-to-16 bit color lookup table */
	SANE_Int								*aGammaTableB;	/* a 16-to-16 bit color lookup table */

	SANE_Bool								fScanning;    /* TRUE if actively scanning */
	SANE_Bool								fCanceled;
} TScanner;

static SANE_Device dev =
{
		" HP ScanJet",/* unique device name */
		/*"HP ScanJet 44x0C", unique device name */
		"Hewlett-Packard", /* device vendor string */
		"SANE_HP_RTS88XX ",   /* device model name */
		"flatbed scanner"  /* device type (e.g., "flatbed scanner") */
};

/* for now only one scanner at a time is allowed */
static TScanner Scanner;

/* option constraints */
static SANE_Bool OPT_CCD = SANE_TRUE;
static SANE_Bool OPT_COLOR = SANE_FALSE;
static const SANE_Range rangeGammaTable = {0, 65535, 1};
static const SANE_Int   Hp44x0c_setResolutions[] = {1,300}; /* only one DPI for test */
/*static const SANE_Int   Hp44x0c_setResolutions[] = {3,150,300,600};*/
static const SANE_Int   Hp35x0c_setResolutions[] = {3,150,300,600};

#ifndef WITH_TSTBACKEND
static const SANE_Range rangeXmm       = {0, 220, 1}; /* max. mm */
/*static const SANE_Range rangeYmm       = {0, 40, 1}; * max. mm */
static const SANE_Range rangeYmm       = {0, 295, 1}; /* max. mm */
#endif
#ifdef WITH_TSTBACKEND
static const SANE_Range rangeXmm       = {0, 70, 1}; /* max. mm */
static const SANE_Range rangeYmm       = {0, 70, 1}; /* max. mm */
#endif
static const SANE_Range rangeBrightness     = {0, 0x40, 1};
#if 0
static const SANE_Range rangeLampBrightness = {0xa1, 0xaf, 1};
#endif

static SANE_String_Const mode_list[5];
static SANE_String_Const scan_option_list[3];
static SANE_String_Const ccd_list[3];

/* Device filename for USB access */
SANE_Char * usb_devfile = "/dev/usb/scanner0";

SANE_Status Hp_rts_Init(THWParams *pHWParams, TScanParams *pParams);
void Hp_rts_Exit(THWParams *pHWParams);
void FinishScan     (SANE_Handle h);
#endif
