 /* sane - Scanner Access Now Easy.
   Copyright (C) 2003 Johannes Hub (JohannesHub@foni.net)

   This file was initially copied from the hp3300 backend.
   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an exutable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
*/

/*
    Concept for a backend for scanners based on the RTS88xx chipset,
    such as HP4400C, HP4470C.
    Parts of this source were inspired by other backends.

    History:

    Version 0.17g 18.04.04 10.alpha, little fixes
    Version 0.17e 07.04.04 10.alpha, little fixes
    Version 0.17b 30.03.04 10.alpha, little fixes and libusb implemented
    Version 0.17a 11.03.04 10.alpha, little fixes
    Version 0.17  08.03.04 9. alpha, HP3500 included
    Version 0.16  06.02.04 8. alpha, wait counting on LCD
    Version 0.15a 29.01.04 7. alpha, CCD switch moved to config file
    Version 0.15  11.01.04 6. alpha, a second CCD implemented
    Version 0.14  21/11/22 5. alpha
    Version 0.13a 21.11.04 4. alpha, an little fix included
    Version 0.13  13.11.04 4. alpha
    Version 0.12  22.10.03 third alpha, Backend name changed to HP_RTS88xx
    Version 0.11  30.08.03 second alpha
    Version 0.10  19.07.03 first alpha
*/

/*
    Core HP44x0c functions.
*/


#ifndef _HP_RTS_HP44x0C_H_
#define _HP_RTS_HP44x0C_H_

#include <unistd.h>

#define XFER_BUF_SIZE  0xFF00


#define HW_PIXELS   2000   /* number of pixels supported by hardware */
#define HW_DPI      300    /* horizontal resolution of hardware */
#define HW_LPI      300    /* vertical resolution of hardware */

/* thise rts8891 registers are known */
#define LEDSTATUS            0x10
#define LIGHT_SOURCE         0x11
#define TAP                  0x14
#define LCD_CONTROL1         0x20
#define LCD_CONTROL2         0x21
#define LCD_CONTROL3         0x22
#define BUTTON_1             0x25
#define BUTTON_2             0x1a
#define MICROSWITCH          0x1d
#define MOVEMENT_DIRECTION   0x36
#define SCAN_OR_QUICK_MOVE   0x3a
#define CHECK_SCANNER_LINKED 0xb0
#define MAINBOARD_ID         0xb1
#define MOVEMENT_REG_1       0xb2
#define MOVE_START_STOP      0xb3
#define LAMPREG              0xd9
#define LAMP_INTENSITY       0xda
#define STEP_SIZE            0xe1

struct	Hp44x0c_resolution_parameters
{
	SANE_Int	resolution;
	SANE_Byte		reg_10_value;
	SANE_Byte		reg_11_value;
	SANE_Byte		reg_35_value;
	SANE_Byte		reg_36_value;
	SANE_Byte		reg_3A_value;
	SANE_Byte		reg_72_value;
	SANE_Byte		reg_73_value;
	SANE_Byte		reg_74_value;
	SANE_Byte		reg_BF_value;
	SANE_Byte		reg_C0_value;
	SANE_Byte		reg_C4_value;
	SANE_Byte		reg_C5_value;
	SANE_Byte		reg_CB_value;
	SANE_Byte		reg_CC_value;
	SANE_Byte		reg_CD_value;
	SANE_Byte		reg_CE_value;
	SANE_Byte		reg_CF_value;
	SANE_Byte		reg_D0_value;
	SANE_Byte		reg_D1_value;
	SANE_Byte		reg_D2_value;
	SANE_Byte		reg_D3_value;
	SANE_Byte		reg_D5_value;
	SANE_Byte		reg_D7_value;
	SANE_Byte		step_size;
	SANE_Byte		reg_E4_value;
	SANE_Byte		reg_E5_value;
};

static struct Hp44x0c_resolution_parameters Hp44x0c_resparms[] =
{
/*res. 10   11   35   36   3a   72   73   74   bf   c0   c4   c5   cb   cc   cd   ce   cf   d0   d1   d2   d3   d5   d7 Step   e4  e5*/
{600,0x28,0x3b,0x1b,0x2C,0x1b,0xe1,0x14,0x62,0xf8,0x7f,0x00,0xf8,0x07,0x80,0xff,0xf2,0xf4,0xe7,0x08,0x0e,0x10,0x0f,0x52,0x01,0xbd,0x0a},
{300,0x20,0x3f,0x0e,0x29,0x0e,0xe1,0x14,0x18,0xff,0x0f,0xf0,0x00,0x00,0xf0,0xff,0xf5,0xf7,0xea,0x0b,0x03,0x05,0xab,0xf6,0x02,0xbd,0x0a},
{200,0x20,0x3f,0x0e,0x29,0x0e,0xe1,0x14,0x18,0xff,0x0f,0xf0,0x00,0x00,0xf0,0xff,0xf5,0xf7,0xea,0x0b,0x03,0x05,0xab,0xf6,0x01,0xbd,0x0a},
{150,0x20,0x3f,0x1b,0x29,0x1b,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01},
{0,  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};


SANE_Byte Hp44x0_switch_on_regs[] = {
/*0    1    2    3    4    5    6    7    8    9    a    b    c    d    e    f*/
0xe5,0x41,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x0a,0x0a,0x0a,0x70,0x00,0x00,0x00,0x00,
/*10   11   12   13   14   15   16   17   18   19   1a   1b   1c   1d   1e   1f*/
0x28,0x28,0xff,0x20,0xf8,0x28,0x07,0x00,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
/*20   21   22   23   24   25   26   27   28   29   2a   2b   2c   2d   2e   2f*/
0x3a,0xf2,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*30   31   32   33   34   35   36   37   38   39   3a   3b   3c   3d   3e   3f*/
0x00,0x00,0x00,0x00,0x10,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*40 41   42   43   44   45   46   47   48   49   4a   4b   4c   4d   4e   4f*/
0x20,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*50   51   52   53   54   55   56   57   58   59   5a   5b   5c  5d   5e   5f*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*60   61   62   63   64   65   66   67   68   69   6a   6b   6c   6d   6e   6f*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*70   71   72   73   74   75   76   77   78   79   7a   7b   7c   7d   7e   7f*/
0x00,0x00,0xe1,0x14,0x18,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*80   81   82   83   84   85   86   87   88   89   8a   8b   8c   8d   8e   8f*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x3f,0x80,0x68,0x00,
/*90   91   92   93   94   95   96   97   98   99   9a   9b   9c   9d   9e   9f*/
0x00,0x00,0x00,0x01,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*a0   a1   a2   a3   a4   a5   a6   a7   a8   a9   aa   ab   ac   ad   ae   af*/
0x00,0x00,0x00,0xcc,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*b0   b1   b2   b3   b4   b5   b6   b7   b8   b9   ba   bb   bc   bd   be   bf*/
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
/*c0   c1   c2   c3   c4   c5   c6   c7   c8   c9   ca   cb   cc   cd   ce   cf*/
0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0e,0x00,0x00,0xf0,0xff,0xf5,0xf7,
/*d0   d1   d2   d3   d4   d5   d6   d7   d8   d9   da   db   dc   dd   de   df*/
0xea,0x0b,0x03,0x05,0x86,0x1b,0x30,0xf6,0xad,0x27,0x00,0x00,0x00,0x00,0x00,0x00,
/*e0   e1   e2   e3   e4   e5   e6   e7   e8   e9   ea   eb   ec   ed   ee   ef*/
0x00,0x01,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*f0   f1   f2*/
0x00,0x00,0x00};

SANE_Byte Hp44x0_move_back[] = {
0xf5,0x41,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x10,0x10,0x10,0x70,0x00,0x00,0x00,0x00,
0x20,0x28,0xff,0x20,0xf8,0x28,0x07,0x00,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x3a,0xf2,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x80,0x81,0x10,0x10,0x24,0x00,0x00,0x02,0x0e,0x00,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x1f,0x41,0x1f,0x01,0x20,0x64,0x00,0x00,0x00,0x00,0x00,0xc8,0x00,0x00,0x00,
0x00,0x00,0xe1,0x14,0x18,0x15,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x00,0x00,
0x32,0x00,0x33,0x00,0x00,0x00,0x06,0x00,0x06,0x34,0x00,0xff,0x3f,0x80,0x68,0x00,
0x1c,0x00,0x00,0x01,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xcc,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x86,0x6b,0x00,0x00,0x80,0x27,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x17,0x0d,0x06,0xf9,0x00,0x53,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00};

SANE_Byte Hp44x0_init_1[] = {
0xe5,0x41,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x0a,0x0a,0x0a,0x70,0x00,0x00,0x00,0x00,
0x60,0x3b,0x00,0x20,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x3a,0xf2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x10,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x68,0x00,
0x00,0x00,0x00,0x02,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xcc,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x86,0x1b,0x00,0xff,0x00,0x27,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00};

SANE_Byte Hp44x0_init_5[] = {
0xe5,0x41,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x0a,0x0a,0x0a,0x70,0x00,0x00,0x00,0x00,
0x28,0x28,0xff,0x20,0xf8,0x28,0x07,0x00,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x3a,0xf2,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x10,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xe1,0x14,0x18,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x68,0x00,
0x00,0x00,0x00,0x01,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xcc,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0e,0x00,0x00,0xf0,0xff,0xf5,0xf7,
0xea,0x0b,0x03,0x05,0x86,0x1b,0x30,0xf6,0x80,0x27,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00};

SANE_Byte Hp44x0_myinit33[] = {
/*0    1    2    3    4    5    6    7    8    9    a    b    c    d    e    f*/
0xe5,0x41,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x10,0x10,0x10,0x70,0x00,0x00,0x00,0x00,
/*10   11   12   13   14   15   16   17   18   19   1a   1b   1c   1d   1e   1f*/
0x20,0x3f,0xff,0x20,0xf8,0x28,0x07,0x00,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
/*20   21   22   23   24   25   26   27   28   29   2a   2b   2c   2d   2e   2f*/
0x3a,0xf2,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*30   31   32   33   34   35   36   37   38   39   3a   3b   3c   3d   3e   3f*/
0x00,0x00,0x80,0x81,0x10,0x1b,0x29,0x00,0x00,0x02,0x1b,0x00,0x00,0x00,0x00,0x00,
/*40   41   42   43   44   45   46   47   48   49   4a   4b   4c   4d   4e   4f*/
0x20,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*50   51   52   53   54   55   56   57   58   59   5a   5b   5c  5d   5e   5f*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*60   61   62   63   64   65   66   67   68   69   6a   6b   6c   6d   6e   6f*/
0x12,0x00,0xc6,0x00,0x01,0x20,0x2c,0x01,0x00,0x00,0x00,0x00,0xdc,0x05,0x00,0x00,
/*70   71   72   73   74   75   76   77   78   79   7a   7b   7c   7d   7e   7f*/
0x00,0x00,0xe1,0x14,0x18,0x15,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x00,0x00,
/*80   81   82   83   84   85   86   87   88   89   8a   8b   8c   8d   8e   8f*/
0x32,0x00,0x33,0x00,0x00,0x00,0x06,0x00,0x06,0x34,0x00,0xff,0x3f,0x80,0x68,0x00,
/*90   91   92   93   94   95   96   97   98   99   9a   9b   9c   9d   9e   9f*/
0x1c,0x00,0x00,0x01,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*a0   a1   a2   a3   a4   a5   a6   a7   a8   a9   aa   ab   ac   ad   ae   af*/
0x00,0x00,0x00,0xcc,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*b0   b1   b2   b3   b4   b5   b6   b7   b8   b9   ba   bb   bc   bd   be   bf*/
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
/*c0   c1   c2   c3   c4   c5   c6   c7   c8   c9   ca   cb   cc   cd   ce   cf*/
0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0e,0x00,0x00,0xf0,0xff,0xf5,0xf7,
/*d0   d1   d2   d3   d4   d5   d6   d7   d8   d9   da   db   dc   dd   de   df*/
0xea,0x0b,0x03,0x05,0x86,0xab,0x30,0xf6,0xad,0xa7,0x00,0x00,0x00,0x00,0x00,0x00,
/*e0   e1   e2   e3   e4   e5   e6   e7   e8   e9   ea   eb   ec   ed   ee   ef*/
0x00,0x01,0x00,0x00,0x1c,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*f0   f1   f2*/
0x00,0x00,0x00};

SANE_Byte Hp44x0_300_true_1_3[]  = {
0xe5,0x41,0x7f,0x7f,0x7f,0x7f,0x7f,0x7f,0x10,0x10,0x10,0x70,0x00,0x00,0x00,0x00,
0x20,0x3b,0xff,0x20,0xf8,0x28,0x07,0x00,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x3a,0xf2,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x80,0x81,0x10,0x1b,0x29,0x00,0x00,0x02,0x1b,0x00,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x12,0x00,0xc6,0x00,0x01,0x20,0x2c,0x01,0x00,0x00,0x00,0x00,0xdc,0x05,0x00,0x00,
0x00,0x00,0xe1,0x14,0x18,0x15,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x00,0x00,
0x2b,0x02,0x2c,0x02,0x00,0x18,0x1b,0x30,0x30,0x2d,0x02,0xff,0x3f,0x21,0x60,0x00,
0x1c,0x00,0x00,0x01,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xcc,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x0f,0x00,0x00,0xf0,0xff,0xff,0x0f,0x00,0xff,0xf1,0xff,0x00,0xf0,0xff,0xf5,0xf7,
0xea,0x0b,0x03,0x05,0x86,0xab,0x10,0xf6,0xad,0xa7,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0x1c,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00};

SANE_Byte Hp44x0_300_BW_1[]  = {
/*0    1    2    3    4    5    6    7    8    9    a    b    c    d    e    f*/
0xe5,0x41,0x82,0x86,0x81,0x82,0x86,0x81,0x07,0x05,0x0f,0x70,0x00,0x00,0x00,0x00,
/*10   11   12   13   14   15   16   17   18   19   1a   1b   1c   1d   1e   1f*/
0x20,0x3f,0xff,0x20,0xf8,0x28,0x07,0x00,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
/*20   21   22   23   24   25   26   27   28   29   2a   2b   2c   2d   2e   2f*/
0x3a,0xf2,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*30   31   32   33   34   35   36   37   38   39   3a   3b   3c   3d   3e   3f*/
0x00,0x00,0x80,0x81,0x10,0x1b,0x29,0x00,0x00,0x02,0x1b,0x00,0x00,0x00,0x00,0x00,
/*0x00,0x00,0x20,0x83,0x10,0x0e,0x2c,0x00,0x00,0x02,0x0e,0x00,0x00,0x00,0x00,0x00,*/
/*40   41   42   43   44   45   46   47   48   49   4a   4b   4c   4d   4e   4f*/
0x20,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*50   51   52   53   54   55   56   57   58   59   5a   5b   5c  5d   5e   5f*/
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*60   61   62   63   64   65   66   67   68   69   6a   6b   6c   6d   6e   6f*/
0x01,0x00,0x43,0x00,0x01,0x20,0x5e,0x00,0x00,0x00,0x00,0x00,0x54,0x0a,0x00,0x00,
/*70   71   72   73   74   75   76   77   78   79   7a   7b   7c   7d   7e   7f*/
0x00,0x00,0xe1,0x14,0x18,0x15,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x00,0x00,
/*80   81   82   83   84   85   86   87   88   89   8a   8b   8c   8d   8e   8f*/
0x32,0x00,0x33,0x00,0x00,0x00,0x06,0x00,0x06,0x34,0x00,0xff,0x3f,0x00,0x60,0x00,
/*90   91   92   93   94   95   96   97   98   99   9a   9b   9c   9d   9e   9f*/
0x1c,0x00,0x00,0x01,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*a0   a1   a2   a3   a4   a5   a6   a7   a8   a9   aa   ab   ac   ad   ae   af*/
0x00,0x00,0x00,0xcc,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*b0   b1   b2   b3   b4   b5   b6   b7   b8   b9   ba   bb   bc   bd   be   bf*/
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
/*c0   c1   c2   c3   c4   c5   c6   c7   c8   c9   ca   cb   cc   cd   ce   cf*/
0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0e,0x00,0x00,0xf0,0xff,0xf5,0xf7,
/*d0   d1   d2   d3   d4   d5   d6   d7   d8   d9   da   db   dc   dd   de   df*/
0xea,0x0b,0x17,0x01,0x86,0x0f,0x30,0x52,0xad,0xa7,0x00,0x00,0x00,0x00,0x00,0x00,
/*e0   e1   e2   e3   e4   e5   e6   e7   e8   e9   ea   eb   ec   ed   ee   ef*/
0x00,0x05,0x00,0x00,0xc9,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/*f0   f1   f2*/
0x00,0x00,0x00};

SANE_Byte Hp44x0_200_BW_1[]  = {
0xe5,0x41,0x82,0x86,0x81,0x82,0x86,0x81,0x07,0x05,0x0f,0x70,0x00,0x00,0x00,0x00,
0x20,0x3f,0xff,0x20,0xf8,0x28,0x01,0x00,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x3a,0xf2,0x00,0x80,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x20,0x83,0x10,0x0e,0x2c,0x00,0x00,0x02,0x0e,0x00,0x00,0x00,0x00,0x00,
0x2c,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x2d,0x00,0xef,0x0d,0x01,0x20,0x5e,0x00,0x00,0x00,0x00,0x00,0x54,0x0a,0x00,0x00,
0x00,0x00,0xe1,0x14,0x18,0x15,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x00,0x00,
0x2b,0x02,0x2c,0x02,0x00,0x18,0x1b,0x30,0x30,0x2d,0x02,0xff,0x3f,0xef,0x60,0x00,
0x18,0x00,0x00,0x01,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xcc,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0e,0x00,0x00,0xf0,0xff,0xf5,0xf7,
0xea,0x0b,0x17,0x01,0x86,0x0f,0x30,0x52,0xad,0xa7,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x07,0x00,0x00,0x56,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00};

SANE_Byte Hp44x0_200_BW_2[]  = {
0xe5,0x41,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,
0x20,0x3f,0xff,0x20,0xf8,0x28,0x07,0x00,0xff,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x3a,0xf2,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x03,0x10,0x0e,0x22,0x00,0x00,0x02,0x0e,0x00,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x8c,0x76,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x00,0x02,0x00,0x01,0x20,0x0d,0x00,0x00,0x00,0x00,0x00,0xfb,0x02,0x00,0x00,
0x00,0x00,0xe1,0x14,0x18,0x15,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x00,0x00,
0x32,0x00,0x33,0x00,0x00,0x00,0x06,0x00,0x06,0x34,0x00,0xff,0x3f,0x00,0x60,0x00,
0x1c,0x00,0x00,0x01,0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xcc,0x27,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x0f,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x0e,0x00,0x00,0xf0,0xff,0xf5,0xf7,
0xea,0x0b,0x17,0x01,0x86,0x0f,0x30,0x52,0xad,0xa7,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x07,0x00,0x00,0x56,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00};

/* CCD CHANGES to CCD1  80,81,82,83,85,86,87,88,89,8a,8d,8e,c2,c3,c6,c7,c8,c9,ca,d6 */

SANE_Byte Hp44x0_patch_2[] = {
0x12,0x8,0x16,0x8,0x1d,0x20,0xb0,0x0,0xce,0xe0,0xd4,0x86,
0xd5,0x1b,0xd6,0x0,0xd7,0xff,0xd8,0x0,0xd9,0x27,0xda,0x0,
0xe1,0x1,0xe2,0x0,0xe4,0x14,0xe5,0x0,0xf4,0x0,0xf5,0x0,
0xf6,0x0,0xf7,0x0,0xf8,0x0,0xf9,0x0,0xfa,0x0,0xfb,0x0,
0xfc,0x0,0xfd,0x0,0xfe,0x0,0x0,0x0};

SANE_Byte Hp44x0_patch_3[] = {
0x1d,0x20,0xb0,0x0,0xd4,0x86,0xd5,0x1b,0xd6,0x0,0xd7,0xff,
0xd8,0x0,0xd9,0x27,0xda,0x0,0xe1,0x1,0xe2,0x0,0xe4,0x14,
0xe5,0x0,0xf4,0x0,0xf7,0x0,0xf8,0x0,0xf9,0x0,0xfa,0x0,
0xfb,0x0,0xfc,0x0,0xfd,0x0,0xfe,0x0,0x0,0x0};

SANE_Byte Hp44x0_patch_4[] = {
0x10,0x28,0x11,0x28,0x12,0xff,0x14,0xf8,0x15,0x28,0x16,0x7,
0x18,0xff,0x1a,0x0,0x1d,0x20,0x23,0xff,0x24,0xff,0x72,0xe1,
0x73,0x14,0x74,0x18,0x75,0x15,0xb0,0x0,0xbf,0xff,0xc0,0xf,
0xc2,0xff,0xc3,0xff,0xc4,0xff,0xc5,0xff,0xc6,0xff,0xc7,0xff,
0xc9,0xe,0xcc,0xf0,0xcd,0xff,0xce,0xf5,0xcf,0xf7,0xd0,0xea,
0xd1,0xb,0xd2,0x3,0xd3,0x5,0xd4,0x86,0xd5,0x1b,0xd6,0x30,
0xd7,0xf6,0xd8,0x80,0xd9,0x27,0xda,0x0,0xe1,0x1,0xe2,0x0,
0xe4,0x14,0xe5,0x0,0xf7,0x0,0xf8,0x0,0xf9,0x0,0xfa,0x0,
0xfb,0x0,0xfc,0x0,0xfd,0x0,0xfe,0x0,0x0,0x0};

SANE_Byte Hp44x0_patch_600[] = {
0x10,0x28, 0x11,0x3b, 0x36,0x2c,
0xe4,0xbd, 0xe5,0x0a,

0x72,0x3a, 0x73,0x15, 0x74,0x62,
0xbf,0xf8, 0xc0,0x7f,
0xc4,0x00, 0xc5,0xf8,
0xcb,0x07, 0xcc,0x80, 0xce,0xf2,
0xcf,0xf4, 0xd0,0xe7, 0xd1,0x08, 0xd2,0x0e, 0xd3,0x10,
0xd5,0x0f, 0xd7,0x52,
0x60,0x01, 0x62,0x02, 0x66,0x2b, 0x67,0x00, 0x6c,0x19, 0x6d,0x03
};

SANE_Byte callibration_buffer[0x818+4];
SANE_Byte registers[0xff];
SANE_Byte read_buffer[0xff];

void Hp44x0_Wakeup(THWParams *pHWParams,TScanParams *pParams);
void Hp44x0_Down(SANE_Int iHandle);

void patch_and_send_values (SANE_Int iHandle, SANE_Byte *my_values);
void patch_regs            (THWParams *pHWParams,SANE_Byte *my_values);
void Hp44x0_set_display    ( SANE_Int iHandle, SANE_Byte val );

void write_cal_bytes       (THWParams *pHWParams, SANE_Byte b );
SANE_Bool Hp44x0_cal_scanner      (THWParams *pHWParams, TScanParams *pParams);
SANE_Int Hp44x0_park_to_home      (THWParams *pHWParams);

SANE_Int Hp44x0_move_to_pos (THWParams *pHWParams, TScanParams *pParams);
SANE_Int Hp44x0_wait_for_WarmUp   (SANE_Int iHandle, THWParams *pHWParams);
SANE_Bool Hp44x0_start_scan       (THWParams *pHWParams,TScanParams *pParams,
                            TDataPipe *pDataPipe);
SANE_Bool Hp44x0_init_scan        (THWParams *pHWParams, TScanParams *pParams,
                            TDataPipe *pDataPipe);
SANE_Status XferBufferInit (SANE_Handle h, TDataPipe *p);

SANE_Bool Hp44x0_GetLamp   (SANE_Int iHandle, SANE_Bool *pfLampIsOn);
SANE_Bool Hp44x0_SetLamp   (SANE_Int iHandle, SANE_Bool fLampOn);

SANE_Bool InitScan         (TScanParams *pParams,
                            THWParams *pHWParams, TDataPipe *pDataPipe);
SANE_Int  Hp44x0c_nvram_enable_controller(SANE_Int iHandle,SANE_Int enable);

SANE_Bool XferBufferGetLine(SANE_Handle h,
                            TDataPipe *p, SANE_Byte *pabLine);

void XferBufferExit        (SANE_Handle h);

void _UnscrambleLine       (SANE_Handle h,SANE_Byte *pabLine,
                            SANE_Byte *pabRed, SANE_Byte *pabGrn, SANE_Byte *pabBlu,
                            SANE_Int iWidth, SANE_Bool iReversedHead);

SANE_Status CircBufferInit (SANE_Handle h, TDataPipe *p, SANE_Int iBytesPerLine,
                            SANE_Int iMisAlignment, SANE_Bool mode);

void CircBufferGetLine     (SANE_Handle h, TDataPipe *p, SANE_Byte *pabLine,
                            SANE_Bool mode);

void CircBufferExit        (SANE_Handle h);

#endif /* NO _HP_RTS__H_ */

