#! /bin/sh
# Remember that bash is compatible with sh
# Copyright (C) 2002 Ricardo Martins <rmartins@dcc.online.pt>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# This script patches SANE source tree to add the NIASH backend
#
# $Id: patch-sane.sh,v 1.1 2003/12/13 22:08:29 bertrik Exp $

# Tests for number of arguments
if [ $# -ne 1 ]
    then
    echo "Usage: $0 [PATH_TO_SANE_DIR]"
    exit
fi

sane=$1

evaluate_retval()
{
    if [ $? = 0 ]
        then
	echo -e "\\033[50G"DONE
    else
	echo -e "\\033[50G"FAILED
	exit 1
    fi
}

# Files that belong to the NIASH backend
niash_files="niash.c \
niash.conf \
niash_core.c \
niash_core.h \
niash.desc \
niash_types.h \
niash_xfer.c \
niash_xfer.h"

# Sees if SANE was already patched
if [ -e $sane/.niash ]
    then
    echo "ERROR: $1 appears to have already been patched..."
    exit 1
fi

# Adds niash files to sane tree
echo -n "Adding new files to the SANE source tree..."
touch $sane/.niash # to mark SANE as patched

for file in $niash_files
  do
  cp ./$file $sane/backend/ >/dev/null 2>&1
done
cp ./sane-niash.man $sane/doc/
evaluate_retval

# Modifies the Makefile.in files (this is hairy stuff)
echo -n "Modifying doc/Makefile.in..."
sed "s/sane-dll.5/& sane-niash.5/g" $sane/doc/Makefile.in | \
    sed "s/sane-dll.man/& sane-niash.man/g" > $sane/doc/tmp~
evaluate_retval

echo -n "Modifying backend/Makefile.in..."
sed "s/PRELOADABLE_BACKENDS =/& niash /" $sane/backend/Makefile.in | \
    sed "s/DISTFILES = Makefile.in /& $niash_files/" | \
    sed 's%libsane-abaton.la: ../sanei/sanei_scsi.lo%& \
libsane-niash.la: ../sanei/sanei_config2.lo \
libsane-niash.la: ../sanei/sanei_constrain_value.lo \
libsane-niash.la: ../sanei/sanei_usb.lo%' >  $sane/backend/tmp~
evaluate_retval

echo -n "Relocating files..."
mv $sane/doc/tmp~ $sane/doc/Makefile.in
mv $sane/backend/tmp~ $sane/backend/Makefile.in
evaluate_retval

# Adds a line with 'niash' to dll.conf
echo -n "Modifying backend/dll.conf..."
if [ -z $(grep niash $sane/backend/dll.conf) ]
    then
    echo "niash" >> $sane/backend/dll.conf
fi
evaluate_retval

echo "SANE patched with success!"
exit 0

