#! /bin/sh

#linux commands
#ipcs -m
#ipcs -ml
#ipcrm shm <shmid>
#echo '67108864' > /proc/sys/kernel/shmmax

KillIt () {
    i=1
    while [ "$i" -le 15 ]
    do
        sleep 1
        if [ `xpaaccess ds9` = yes ]
        then
	    sleep 1
	    xpaset -p ds9 quit
	    break
        fi

        i=`expr $i + 1`
    done
}

DoCmd () {
    echo "$1"
    shmid=`shmload -q $2`
    ../ds9 -zscale -shm $3 shmid $shmid $4 &
    KillIt
    ipcrm -m $shmid
}

DoSCmd () {
    echo "$1"
    shmid1=`shmload -q $2`
    shmid2=`shmload -q $3`
    ../ds9 -zscale -shm $4 shmid $shmid1 $shmid2 $5 &
    KillIt
    ipcrm -m $shmid1
    ipcrm -m $shmid2
}

DoXPA () {
    echo "$1"
    shmid=`shmload -q $2`
    xpaset -p ds9 shm $3 shmid $shmid $4
    sleep 1
    xpaset -p ds9 frame clear
    ipcrm -m $shmid
}

DoSXPA () {
    echo "$1"
    shmid1=`shmload -q $2`
    shmid2=`shmload -q $3`
    xpaset -p ds9 shm $4 shmid $shmid1 $shmid2 $5
    sleep 1
    xpaset -p ds9 frame clear
    ipcrm -m $shmid1
    ipcrm -m $shmid2
}

echo "Current shm limits"
ipcs -lm

if [ "$1" = "command" -o  -z "$1" ]; then
echo "Command Line Shm Tests"

# basics
DoCmd "..fits" img16.fits fits foo
DoSCmd "..sfits" sfits.hdr sfits.arr sfits foo
DoCmd "..table" table.fits "" foo
DoCmd "..table filter" table.fits "" 'foo[bin=rawx,rawy]'

# mosaic
DoCmd "..mosaic image iraf" mosaicimage.fits "mosaicimage iraf" foo
DoCmd "..mosaic image wcs" mosaicimage.fits "mosaicimage wcs" foo
DoCmd "..mosaic image wcsp" ds9_8amp_2x2.fits "mosaicimage wcsp" foo
DoCmd "..mosaic image wfpc2" hst.fits "mosaicimage wfpc2" foo
DoCmd "..mosaic iraf" mosaicimage.fits "mosaic iraf" foo
DoCmd "..mosaic wcs" mosaicimage.fits "mosaic wcs" foo
DoCmd "..mosaic wcsp" ds9_8amp_2x2.fits "mosaic wcsp" foo
DoSCmd "..mosaic wcs sfits" sfits.hdr sfits.arr "smosaic wcs" foo

# backward compatibility
DoCmd "..mosaic image iraf(bc)" mosaicimage.fits mosaicimageiraf foo
DoCmd "..mosaic image wcs(bc)" mosaicimage.fits mosaicimagewcs foo
DoCmd "..mosaic image wfpc2(bc)" hst.fits mosaicimagewfpc2 foo
DoCmd "..mosaic iraf(bc)" mosaicimage.fits mosaiciraf foo
DoCmd "..mosaic wcs(bc)" mosaicimage.fits mosaicwcs foo

# rgb
DoCmd "..rgbcube" rgbcube.fits rgbcube foo
DoSCmd "..rgbcube sfits" rgb.hdr rgb.arr srgbcube foo
DoCmd "..rgbimage" rgbimage.fits rgbimage foo

# array
DoCmd "..array" array.arr array 'foo[dim=512,bitpix=-32,arch=bigendian]'
DoCmd "..array cube" cube.arr array 'foo[dim=512,zdim=3,bitpix=-32,arch=bigendian]'

echo "PASSED"
fi

if [ "$1" = "xpa" -o  -z "$1" ]; then
echo "XPA Shm Tests"

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]
then
    ../ds9&
fi

i=1
while [ "$i" -le 15 ]
do
    sleep 1
    if [ `xpaaccess ds9` = yes ]
    then
	break
    fi

    i=`expr $i + 1`
done

xpaset -p ds9 scale zscale

# basics
DoXPA "..fits" img16.fits fits foo
DoSXPA "..split fits" sfits.hdr sfits.arr sfits foo
DoXPA "..table" table.fits "" foo
DoXPA "..table filter" table.fits "" 'foo[bin=rawx,rawy]'

# mosaics
DoXPA "..mosaic image iraf" mosaicimage.fits "mosaicimage iraf" foo
DoXPA "..mosaic image wcs" mosaicimage.fits "mosaicimage wcs" foo
DoXPA "..mosaic image wcsp" ds9_8amp_2x2.fits "mosaicimage wcs" foo
DoXPA "..mosaic image wfpc2" hst.fits "mosaicimage wfpc2" foo
DoXPA "..mosaic iraf" mosaicimage.fits "mosaic iraf" foo
DoXPA "..mosaic wcs" mosaicimage.fits "mosaic wcs" foo
DoXPA "..mosaic wcsp" ds9_8amp_2x2.fits "mosaicimage wcs" foo
DoSXPA "..sfits mosaic wcs" sfits.hdr sfits.arr "smosaic wcs" foo

# backward compatibility
DoXPA "..mosaic image iraf(bc)" mosaicimage.fits mosaicimageiraf foo
DoXPA "..mosaic image wcs(bc)" mosaicimage.fits mosaicimagewcs foo
DoXPA "..mosaic image wfpc2(bc)" hst.fits mosaicimagewfpc2 foo
DoXPA "..mosaic iraf(bc)" mosaicimage.fits mosaiciraf foo
DoXPA "..mosaic wcs(bc)" mosaicimage.fits mosaicwcs foo

# rgb
xpaset -p ds9 scale minmax
xpaset -p ds9 rgb
DoXPA "..rgbcube" rgbcube.fits rgbcube foo
DoSXPA "..sfits rgbcube" rgb.hdr rgb.arr srgbcube foo
DoXPA "..rgbimage" rgbimage.fits rgbimage foo

# array
DoXPA "..array" array.arr array 'foo[dim=512,bitpix=-32,arch=bigendian]'
DoXPA "..array cube" cube.arr array 'foo[dim=512,bitpix=-32,zdim=3,arch=bigendian]'

xpaset -p ds9 quit
echo "PASSED"
fi

echo "DONE"



