// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "fitsimage.h"

#include "smooth.h"

int FitsImage::smooth()
{
  // radius
  int r = parent->smoothRadius_;

  // src
  double* src = new double[width()*height()];
  if (!src)
    return 0;

  double* ptr = src;
  for (long jj=0; jj<height(); jj++)
    for (long ii=0; ii<width(); ii++, ptr++)
      *ptr = basedata_->getValueDouble(jj*width()+ii);

  // dest
  double* dest = (double*)smooth_->data();

  // kernel
  // create kernel
  int rr = 2*r+1;
  double* kernel = new double[rr*rr];
  if (!kernel)
    return 0;
  memset(kernel, 0, rr*rr*sizeof(double));

  switch (smoothFunction_) {
  case BOXCAR:
    boxcar(kernel,r);
    break;
  case TOPHAT:
    tophat(kernel,r);
    break;
  case GAUSSIAN:
    gaussian(kernel,r);
    break;
  }

  // convolve
  convolve(kernel,src,dest,width(),height(),r);
  
  // clean up
  delete [] kernel;
  delete [] src;

  return 1;
}
