#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerAnalysisPlot3dDialog {varname} {
    upvar #0 $varname var
    global $varname
    global marker

    set id $var(id)
    set frame $var(frame)

    # plot already?
    # set var(plot3d) $marker(plot3d)
    set vvarname proj${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname
    set var(plot3d) [APPing $vvarname]

    # init
    set var(pcoord) $var(system)
    set var(method) [$var(frame) get marker $var(id) analysis param]

    $var(mb).analysis add checkbutton -label [msgcat::mc {Plot 3D}] \
	-variable ${varname}(plot3d) \
	-command "MarkerAnalysisPlot3dCmd $varname"
    $var(mb).analysis add separator
    $var(mb).analysis add cascade -label [msgcat::mc {Method}] \
	-menu $var(mb).analysis.method
    $var(mb).analysis add cascade -label [msgcat::mc {Coordinate}] \
	-menu $var(mb).analysis.coord

    menu $var(mb).analysis.method
    $var(mb).analysis.method add radiobutton -label [msgcat::mc {Average}] \
	-variable ${varname}(method) -value average \
	-command "MarkerAnalysisPlot3dMethod $varname"
    $var(mb).analysis.method add radiobutton -label [msgcat::mc {Sum}] \
	-variable ${varname}(method) -value sum \
	-command "MarkerAnalysisPlot3dMethod $varname"

    CoordMenu $var(mb).analysis.coord $varname pcoord 2 {} {} \
	[list MarkerAnalysisPlot3dSystem $varname]
    CoordMenuEnable $var(mb).analysis.coord $varname pcoord 2 {} {}
}

# support

proc MarkerAnalysisPlot3dCmd {varname} {
    upvar #0 $varname var
    global $varname

    MarkerAnalysisPlot3d $var(frame) $var(id) $var(plot3d)
}

proc MarkerAnalysisPlot3d {frame id plot} {
    $frame marker $id analysis plot3d $plot
    if {$plot} {
	MarkerAnalysisPlot3dCB $frame $id

	set vvarname proj${id}${frame}
	upvar #0 $vvarname vvar
	global $vvarname

	APRaise $vvarname
    } else {
	MarkerAnalysisPlot3dDeleteCB $frame $id
    }
}

proc MarkerAnalysisPlot3dMethod {varname} {
    upvar #0 $varname var
    global $varname

    $var(frame) marker $var(id) analysis param $var(method)
    if {$var(plot3d)} {
	MarkerAnalysisPlot3dCB $var(frame) $var(id)
    }
}

proc MarkerAnalysisPlot3dSystem {varname} {
    upvar #0 $varname var
    global $varname

    $var(frame) marker $var(id) analysis system $var(pcoord)
    if {$var(plot3d)} {
	MarkerAnalysisPlot3dCB $var(frame) $var(id)
	MarkerAnalysisPlot3dXAxisTitle $var(frame) $var(id)
    }
}

# hardcoded marker.C
proc MarkerAnalysisPlot3dCB {frame id} {
    set varname proj${id}${frame}
    upvar #0 $varname var
    global $varname

    set tt proj${id}${frame}
    set xx proj${id}${frame}x
    set yy proj${id}${frame}y
    set xe proj${id}${frame}xe
    set ye proj${id}${frame}ye

    global $xx $yy $xe $ye
    if {[APPing $varname]} {
	$frame get marker $id analysis plot3d $xx $yy
	APStats $varname
    } else {
	global ed
	set rr [$frame get wcs]
	set ed(system) [lindex $rr 0]
	set ed(sky) [lindex $rr 1]
	AdjustCoordSystem ed system

	set tt [string totitle [$frame get marker $id type]]
	APDialog $varname $tt $tt $ed(system) Counts

	set var(xdata) $xx
	set var(ydata) $yy
	set var(xedata) $xe
	set var(yedata) $ye

	blt::vector create $xx $yy $xe $ye
	$frame marker $id analysis system $ed(system)
	$frame get marker $id analysis plot3d $xx $yy

	APExternal $varname
	MarkerAnalysisPlot3dXAxisTitle $frame $id
    }
}

# hardcoded marker.C
proc MarkerAnalysisPlot3dDeleteCB {frame id} {
    set varname proj${id}${frame}
    upvar #0 $varname var
    global $varname

    # clear any errors
    global errorInfo
    set errorInfo {}

    APDestroy $varname
}

proc MarkerAnalysisPlot3dXAxisTitle {frame id} {
    set varname proj${id}${frame}
    upvar #0 $varname var
    global $varname

    set sys [lindex [$frame get marker $id analysis system] 0]
    switch -- $sys {
	image -
	physical -
	amplifier -
	detector {set title "$sys"}
	default {
	    set w [string range $sys 3 3]
	    set tt [string trim [$frame get fits header 1 keyword \{CTYPE3$w\}]]
	    if {$tt != {}} {
		set title "$tt"
	    } else {
		set title "$sys"
	    }
	}
    }
    $var(graph) xaxis configure -title $title
}
