// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "iis.h"

FitsIIS::FitsIIS(int width, int height)
{
  // new header
  head_ = new FitsHead(width, height, 1, 8);
  if (!head_->isValid())
    return;

  // alloc memory
  size_t size = (size_t)width*height;
  data_ = new char[size];
  if (!data_)
    return;

  // clear memory
  memset(data_, '\0', size);

  // made it this far, must be valid
  valid_ = 1;
}

FitsIIS::~FitsIIS()
{
  if (data_)
    delete [] (char*)data_;
}

void FitsIIS::erase()
{
  // clear memory
  FitsImageHDU* hdu = (FitsImageHDU*)head_->hdu();
  memset(data_, '\0', hdu->realbytes());
}

const char* FitsIIS::get(int x, int y)
{
  if (head_)
    return (const char*)data_+(y*head_->naxis(1)+x);
  else
    return NULL;
}

void FitsIIS::set(int x, int y, const char* ptr, int length)
{
  // we have to make sure we don't overwrite our buffer
  FitsImageHDU* hdu = (FitsImageHDU*)head_->hdu();

  int start = (y*head_->naxis(1)+x);
  if (head_ && (start+length <= hdu->imgbytes()))
    memcpy((char*)data_+start, ptr, length);
}

