// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fitsstream_h__
#define __fitsstream_h__

#include "file.h"
#include "zlib.h"

#define GZBUFSIZE 4096
#define STRMREADSIZE 1048576 // 1Mb

typedef struct gzStream_ {
  z_stream zstream;
  int id;
  int transparent;
  unsigned char header[2];
  int useHeader;
  unsigned char buf[GZBUFSIZE];
} *gzStream;

template<class T>
class FitsStream : public FitsFile {
 protected:
  T stream_;
  size_t dataSize_;           // size of data memory segment
  int dataManage_;           // flag, true if we manage data
  FitsFile::FlushMode flush_;

  FitsHead* headRead();
  int dataRead(size_t);
  void dataSkip(size_t);
  void dataSkipBlock(size_t);
  void skipEnd();

  size_t read(char*, size_t);
  void close();
  void found();
  void error();

public:
  FitsStream();
  virtual ~FitsStream();

  void done() {close();}
  T stream() {return stream_;}
};

template<class T>
class FitsFitsStream : public virtual FitsStream<T> {
protected:
  void processExact();
  void processRelax();

public:
  FitsFitsStream(FitsFile::ScanMode, FitsFile::FlushMode);
};

template<class T>
class FitsFitsNextStream : public FitsStream<T> {
public:
  FitsFitsNextStream(FitsFile* prev);
};

template<class T>
class FitsArrStream : public virtual FitsStream<T> {
public:
  FitsArrStream(FitsFile::FlushMode);
};

template<class T>
class FitsMosaicStream : public virtual FitsStream<T> {
public:
  FitsMosaicStream(FitsFile::FlushMode);
};

template<class T>
class FitsMosaicNextStream : public FitsStream<T> {
public:
  FitsMosaicNextStream(FitsFile* prev, FitsFile::FlushMode);
};

#endif
