// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __frame3d_h__
#define __frame3d_h__

#include "context.h"
#include "frame3dbase.h"
#include "colorscale.h"

typedef struct {
  Frame3dBase::RenderMethod renderMethod;
  int width;
  Coord::InternalSystem sys;
  float** zbuf;
  unsigned char** mkzbuf;
  Context* context;

  int* xid;
  int* yid;
  int start;
  int stop;
  int zstart;
  int zstop;

  int rays;
  int abort;
  int done;
} t_arg;

class Frame3d : public virtual Frame3dBase {
 protected:
  float** zbuf;
  unsigned char** mkzbuf;

  int cmapID;                // current colormap id
  float bias;                // current colormap bias
  float contrast;            // current colormap contrast

  int colorCount;            // number of dynamic colors
  ColorScale* colorScale;    // current color scale
  unsigned char* colorCells; // current color values
  unsigned short* indexCells; // current color indices

  pthread_t* thread;
  t_arg* targ;
  int nrays;
  int* xid;
  int* yid;
  Tcl_TimerToken timer;

 private:
  BBox3d imageBounds(int, int, Coord::InternalSystem);
  void cancelImage();
  unsigned char* fillImageColor(int, int);
  unsigned char* fillImageJoin(int, int, Coord::InternalSystem);
  unsigned char* fillImageDetach(int, int, Coord::InternalSystem);

  void reset();

  void setKeyFits() {}

  void pushMatrices();
  void pushMagnifierMatrices();
  void pushPannerMatrices();
  void pushPSMatrices(float, int, int);

  void unloadFits();

 protected:
  int isFrame3d() {return 1;}

  unsigned char* fillImage(int width, int height, Coord::InternalSystem);

  void updateColorCells(unsigned short*, unsigned char*, int);
  int validColorScale() {return colorScale ? 1 : 0;}

 public:
  Frame3d(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~Frame3d();

  void setTimer(Tcl_TimerToken tt) {timer = tt;}
  int updateImage();

  void getColorbarCmd();
  void getRGBChannelCmd();
  void getRGBSystemCmd();
  void getRGBViewCmd();
  void getTypeCmd();
};

#endif
