#! /bin/sh

KillIt () {
    i=1
    while [ "$i" -le 15 ]; do
      sleep 1
      if [ `xpaaccess ds9` = yes ]; then
	  if [ $slow = "1" ]; then
	      sleep 1
	  fi
	  xpaset -p ds9 quit
	  break
      fi
      
      i=`expr $i + 1`
    done
}

DoXPA () {
    echo "$1"
    xpaset -p ds9 scale $4
    xpaset -p ds9 scale mode $5
    xpaset -p ds9 file $2 $3
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

DoSXPA () {
    echo "$1"
    xpaset -p ds9 scale $5
    xpaset -p ds9 scale mode $6
    xpaset -p ds9 file $2 $3 $4
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

DoXPA2 () {
    echo "$1"
    xpaset -p ds9 scale $5
    xpaset -p ds9 scale mode $6
    cat $3 | xpaset ds9 $2 $4
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

StartDS9 () {
    if [ `xpaaccess ds9` = no ]; then
	ds9&

	i=1
	while [ "$i" -le 30 ]
	    do
	    sleep 2
	    if [ `xpaaccess ds9` = yes ]; then
		break
	    fi

	    i=`expr $i + 1`
	done
    fi
}

# slow down?
slow=0
if [ "$1" = "slow" ]; then
    slow=1
    shift
fi

# Fits

if [ "$1" = "fits" -o  -z "$1" ]; then
echo "Testing Fits"

StartDS9
xpaset -p ds9 scale linear
xpaset -p ds9 scale mode zscale

echo "..Bitpix = 8"
xpaset -p ds9 file fits img8.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..Bitpix = 16"
xpaset -p ds9 file fits img16.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..Bitpix = 32"
xpaset -p ds9 file fits img32.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..Bitpix = -32"
xpaset -p ds9 file fits img-32.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..Bitpix = -32 quantize=0"
xpaset -p ds9 file fits img-32q0.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..Bitpix = -64"
xpaset -p ds9 file fits img-64.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..BSCALE"
xpaset -p ds9 file fits imgbscale.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..BLANK"
xpaset -p ds9 file fits imgblank.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..NaN"
xpaset -p ds9 file fits imgnan.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

echo "..INF"
xpaset -p ds9 file fits imginf.gzip.fz
if [ $slow = "1" ]; then
    sleep 1
fi
xpaset -p ds9 frame clear

xpaset -p ds9 quit
echo "PASSED"

fi

# Command Line

if [ "$1" = "command" -o  -z "$1" ]; then
echo "Testing Command Line File"

echo "..fits"
ds9 -zscale -fits img16.gzip.fz &
KillIt

echo "..multiple extension data cube"
ds9 -zscale -medatacube mosaicimage.gzip.fz &
KillIt

echo "..multiple extension multiple frame"
ds9 -zscale -multiframe mosaicimage.gzip.fz &
KillIt

echo "..mosaic image iraf"
ds9 -zscale -mosaicimage iraf mosaicimage.gzip.fz &
KillIt

echo "..mosaic image iraf datacube"
ds9 -zscale -mosaicimage iraf naxis4.gzip.fz &
KillIt

echo "..mosaic image wcs"
ds9 -zscale -mosaicimage wcs mosaicimage.gzip.fz &
KillIt

echo "..mosaic image wfpc2"
ds9 -zscale -mosaicimage wfpc2 hst.gzip.fz &
KillIt

echo "..mosaic iraf"
ds9 -zscale -mosaic iraf mosaicimage.gzip.fz &
KillIt

echo "..mosaic iraf datacube"
ds9 -zscale -mosaic iraf naxis4.gzip.fz &
KillIt

echo "..mosaic wcs"
ds9 -zscale -mosaic wcs mosaicimage.gzip.fz &
KillIt

echo "..rgb cube"
ds9 -rgbcube rgbcube.gzip.fz &
KillIt

echo "..rgb image"
ds9 -rgbimage rgbimage.gzip.fz &
KillIt

echo "PASSED"
fi

# Stdin

if [ "$1" = "stdin" -o  -z "$1" ]; then
echo "Testing Stdin File"

echo "..fits"
cat img16.gzip.fz | ds9 -zscale - &
KillIt

echo "..multiple extension data cube"
cat mosaicimage.gzip.fz | ds9 -zscale -medatacube - &
KillIt

echo "..mosaic image iraf"
cat mosaicimage.gzip.fz | ds9 -zscale -mosaicimage iraf - &
KillIt

echo "..mosaic image iraf datacube"
cat naxis4.gzip.fz | ds9 -zscale -mosaicimage iraf - &
KillIt

echo "..mosaic image wcs"
cat mosaicimage.gzip.fz | ds9 -zscale -mosaicimage wcs - &
KillIt

echo "..mosaic image wfpc2"
cat hst.gzip.fz | ds9 -zscale -mosaicimage wfpc2 - &
KillIt

echo "..mosaic iraf"
cat mosaicimage.gzip.fz | ds9 -zscale -mosaic iraf - &
KillIt

echo "..mosaic iraf datacube"
cat naxis4.gzip.fz | ds9 -zscale -mosaic iraf - &
KillIt

echo "..mosaic wcs"
cat mosaicimage.gzip.fz | ds9 -zscale -mosaic wcs - &
KillIt

echo "..rgb cube"
cat rgbcube.gzip.fz | ds9 -rgbcube - &
KillIt

echo "..rgb image"
cat rgbimage.gzip.fz | ds9 -rgbimage - &
KillIt

echo "PASSED"
fi

# XPA File
if [ "$1" = "xpa" -o  -z "$1" ]; then
echo "Testing XPA File"

StartDS9

DoXPA "..fits" fits img16.gzip.fz linear zscale
DoXPA "..multiple extension data cube" medatacube mosaicimage.gzip.fz linear zscale
DoXPA "..multiple extension multiple frame" multiframe mosaicimage.gzip.fz linear zscale
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 frame delete
xpaset -p ds9 single
DoXPA "..mosaic image iraf" "mosaicimage iraf" mosaicimage.gzip.fz linear zscale

DoXPA "..mosaic image iraf datacube" "mosaicimage iraf" naxis4.gzip.fz linear zscale
DoXPA "..mosaic image wcs" "mosaicimage wcs" mosaicimage.gzip.fz linear zscale
DoXPA "..mosaic image wfpc2" "mosaicimage wfpc2" hst.gzip.fz linear zscale
DoXPA "..mosaic iraf" "mosaic iraf" mosaicimage.gzip.fz linear zscale
DoXPA "..mosaic wcs" "mosaic wcs" mosaicimage.gzip.fz linear zscale
DoXPA "..mosaic iraf datacube" "mosaic iraf" naxis4.gzip.fz linear zscale

xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p ds9 rgb
DoXPA "..rgb cube" rgbcube rgbcube.gzip.fz linear minmax
DoXPA "..rgb image" rgbimage rgbimage.gzip.fz linear minmax
xpaset -p ds9 frame delete

xpaset -p ds9 quit
echo "PASSED"
fi

# XPA Fits
if [ "$1" = "xpa2" -o  -z "$1" ]; then
echo "Testing XPA Fits"

StartDS9

echo "Testing Fits"
DoXPA2 "..fits" fits img16.gzip.fz foo linear zscale
DoXPA2 "..multiple extension data cube" "fits medatacube" mosaicimage.gzip.fz foo linear zscale
DoXPA2 "..mosaic image iraf" "fits mosaicimage iraf" mosaicimage.gzip.fz foo linear zscale
DoXPA2 "..mosaic image iraf datacube" "fits mosaicimage iraf" naxis4.gzip.fz foo linear zscale
DoXPA2 "..mosaic image wcs" "fits mosaicimage wcs" mosaicimage.gzip.fz foo linear zscale
DoXPA2 "..mosaic image wfpc2" "fits mosaicimage wfpc2" hst.gzip.fz foo linear zscale
DoXPA2 "..mosaic iraf" "fits mosaic iraf" mosaicimage.gzip.fz foo linear zscale
DoXPA2 "..mosaic wcs" "fits mosaic wcs" mosaicimage.gzip.fz foo linear zscale
DoXPA2 "..mosaic iraf datacube" "fits mosaic iraf" naxis4.gzip.fz foo linear zscale

xpaset -p ds9 scale linear
xpaset -p ds9 scale mode minmax
xpaset -p ds9 rgb
DoXPA2 "..rgb cube" "fits rgbcube" rgbcube.gzip.fz foo linear minmax
DoXPA2 "..rgb image" "fits rgbimage" rgbimage.gzip.fz foo linear minmax
xpaset -p ds9 frame delete

xpaset -p ds9 quit
echo "PASSED"
fi

echo "DONE"
