// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __frame3d_h__
#define __frame3d_h__

#include "context.h"
#include "frame3dbase.h"
#include "colorscale.h"

typedef struct {
  Frame3dBase::RenderMethod renderMethod;
  int width;
  float* zbuf;
  unsigned char* mkzbuf;
  Context* context;

  Matrix3d matrix;

  int* xid;
  int* yid;
  int start;
  int stop;
  int zstart;
  int zstop;

  int rays;
  int abort;
  int done;
} t_arg;

class Frame3d : public virtual Frame3dBase {
 protected:
  int cmapID;                // current colormap id
  float bias;                // current colormap bias
  float contrast;            // current colormap contrast

  int colorCount;            // number of dynamic colors
  ColorScale* colorScale;    // current color scale
  unsigned char* colorCells; // current color values
  unsigned short* indexCells; // current color indices

  pthread_t* thread_;
  int status_;
  t_arg* targ_;
  int nrays_;
  int* xid_;
  int* yid_;
  Tcl_TimerToken timer_;
  RayTrace* rt_;
  RayTrace* rtb_;
  int rtbcnt_;

 private:
  BBox3d imageBounds(int, int, Matrix3d);
  int fillImageJoin(int, int, Coord::InternalSystem, float**, unsigned char**);
  int fillImageDetach(float, float, float**, unsigned char**);
  unsigned char* fillImageColor(int, int, float*, unsigned char*);
  void cancelDetach();
  RayTrace* findInCache(double, double);
  void cacheIt(RayTrace**);

  void reset();

  void setKeyFits() {}

  void pushMatrices();
  void pushMagnifierMatrices();
  void pushPannerMatrices();
  void pushPSMatrices(float, int, int);

  void unloadFits();

  int bkgDetach(double az, double el);

 protected:
  int isFrame3d() {return 1;}

  unsigned char* fillImage(int width, int height, Coord::InternalSystem);

  void updateColorCells(unsigned short*, unsigned char*, int);
  int validColorScale() {return colorScale ? 1 : 0;}

 public:
  Frame3d(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~Frame3d();

  void setTimer(Tcl_TimerToken tt) {timer_ = tt;}
  int processDetach();

  void getColorbarCmd();
  void getRGBChannelCmd();
  void getRGBSystemCmd();
  void getRGBViewCmd();
  void getTypeCmd();

  void savePhotoCmd(const char*);
};

#endif
