/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@brturbo.com
 */

#include "include/conf.h"

void squidguard_report(const char *dirname, int debug, const char *outdir, int userip, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *Ip2Name, char *TopuserSortField, char *TopuserSortOrder, char *UserAgentLog, char *DateFormat)
{

   FILE *fp_in = NULL, *fp_ou = NULL;
      
   char url[MAXLEN];
   char html[MAXLEN];
   char html2[MAXLEN];
   char squidguard_in[MAXLEN];
   char squidguard_ou[MAXLEN];
   char per[MAXLEN];
   char report[MAXLEN];
   char periodo[100];
   char ip[MAXLEN];
   char rule[255];
   char oip[MAXLEN];
   char user[MAXLEN];
   char ouser[MAXLEN];
   char data[15];
   char data2[15];
   char hora[15];
   char ftime[128];
   char *str;
   int  z=0;

   ouser[0]='\0';

   sprintf(squidguard_in,"%s/squidguard.log",dirname);
   if(!squidguard_count) {
      unlink(squidguard_in);
      return;
   }

   sprintf(per,"%s/periodo",dirname);
   sprintf(report,"%s/squidguard.html",dirname);

   if ((fp_in = fopen(per, "r")) == 0) {
      fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[45],per);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

   if((fp_in=fopen(squidguard_in,"r"))==NULL) {
     fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[8],squidguard_in);
     exit(1);
   }

   if((fp_ou=fopen(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[8],report);
     exit(1);
   }

   fputs("<html>\n",fp_ou);
   fputs("<head>\n",fp_ou);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_ou);
   fputs("</head>\n",fp_ou);

   if(strlen(FontFace) > 0) {
      sprintf(url,"<font face=%s>\n",FontFace);
      fputs(url,fp_ou);
   }

   sprintf(url,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
   fputs(url,fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

   if(strlen(LogoImage) > 0) {
      sprintf(url,"<tr><th><img src='%s' border=0 align=absmiddle width=%s height=%s> \
         <font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(url,fp_ou);
   }

   sprintf(url,"<tr><th align=center><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
   fputs(url,fp_ou);

   sprintf(url,"<tr><td align=center bgcolor=%s><font size=%s color=%s>%s: %s</font></td></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[89],periodo);
   fputs(url,fp_ou);
   sprintf(url,"<tr><th bgcolor=%s align=center><font size=%s color=red>%s</font>	\
		 <font size=%s>%s</font></th></tr>\n",	\
		HeaderBgColor,FontSize,text[120],FontSize,text[55]);
   fputs(url,fp_ou);
   fputs("</table></center>\n",fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=2>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   sprintf(url,"<tr><th bgcolor=%s><font size=%s color=%s>%s</font></th>      \
		<th bgcolor=%s><font size=%s color=%s>%s</font></th>	      \
		<th bgcolor=%s><font size=%s color=%s>%s</font></th>	      \
		<th bgcolor=%s><font size=%s color=%s>%s</font></th>          \
		<th bgcolor=%s><font size=%s color=%s>%s</font></th></tr>\n", \
		HeaderBgColor,FontSize,HeaderColor,text[98],	\
		HeaderBgColor,FontSize,HeaderColor,text[111],	\
		HeaderBgColor,FontSize,HeaderColor,text[110],	\
		HeaderBgColor,FontSize,HeaderColor,text[91],    \
		HeaderBgColor,FontSize,HeaderColor,text[121]);
   fputs(url,fp_ou);

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(user,buf,' ');
      getword(data2,buf,' ');
      getword(hora,buf,' ');
      getword(ip,buf,' ');
      getword(url,buf,' ');
      getword(rule,buf,'\n');

      if(strcmp(UserIp,"yes") == 0)
           strcpy(user,ip);

      bzero(data, 15);
      if(strncmp(df,"u",1) != 0) {
         strncpy(data,data2+6,2);
         strcat(data,"/");
         strncat(data,data2+4,2);
         strcat(data,"/");
         strncat(data,data2,4);
      } else {
         strncpy(data,data2+4,2);
         strcat(data,"/");
         strncat(data,data2+6,2);
         strcat(data,"/");
         strncat(data,data2,4);
      }

      if((str=(char *) strstr(user, "_")) != (char *) NULL ) {
         if((str=(char *) strstr(str+1, "_")) != (char *) NULL )
            fixip(user);
      }

      if(strcmp(Ip2Name,"yes") == 0) 
         ip2name(ip);

      if(!z) {
         strcpy(ouser,user);
         strcpy(oip,ip);
         z++;
      } else {
         if(strcmp(ouser,user) == 0)
            user[0]='\0';
         if(user[0] != '\0')
            strcpy(ouser,user);
         if(strcmp(oip,ip) == 0) 
            ip[0]='\0';
         if(ip[0] != '\0')
            strcpy(oip,ip);
      }

      if(UserTabFile[0] != '\0') {
         sprintf(warea,":%s:",user);
         if((str=(char *) strstr(userfile,warea)) != (char *) NULL ) {
            z1=0;
            str2=(char *) strstr(str+1,":");
            str2++;
            bzero(name, MAXLEN);
            while(str2[z1] != ':') {
               name[z1]=str2[z1];
               z1++;
            }
         } else strcpy(name,user);
      } else strcpy(name,user);

      sprintf(html2,"<tr><td bgcolor=%s><font size=%s>%s</font></td> \
		<td bgcolor=%s><font size=%s>%s</font></td> \
		<td bgcolor=%s><font size=%s>%s-%s</font></td> \
		<td bgcolor=%s><font size=%s><a href=\"http://%s\">%s</a></font></td> \
		<td bgcolor=%s><font size=%s>%s</font></td></th>\n",
			TxBgColor,FontSize,name,
			TxBgColor,FontSize,ip,
			TxBgColor,FontSize,data,hora,
			TxBgColor,FontSize,url,url,
			TxBgColor,FontSize,rule);
      fputs(html2,fp_ou);
   }

   fputs("</table>\n",fp_ou);

   if(strcmp(ShowSargInfo,"yes") == 0) {
      zdate(ftime, DateFormat);
      sprintf(html,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n", text[108],URL,PGM,VERSION,text[109],ftime);
      fputs(html,fp_ou);
   }
   fputs("</html>\n",fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   unlink(squidguard_in);

   return;
}
