#include "include/conf.h"

static char mtab1[12][4]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
static char mtab2[12][3]={"01","02","03","04","05","06","07","08","09","10","11","12"};

void getword(char *word, char *line, int stop)
{
  int x = 0,y;
  int loop=0;
  int limit=10000;
  char wline[MAXLEN];

  strcpy(wline,line);

  if(strlen(line) < 3) {
     word[0]='\0';
     return;
  }

  for(x=0;((line[x]) && (line[x] != stop ));x++) {
     loop++;
     if(loop>=limit) {
        printf("SARG: getword loop detected.\n");
        printf("SARG: Record=\"%s\"\n",wline);
        printf("SARG: searching for \'x%x\'\n",stop);
        printf("SARG: Maybe you have a broken record or garbage in your access.log file.\n");
        word[0]='\0';
        exit(1);
     }
     word[x] = line[x];
  }

  word[x] = '\0';
  if(line[x]) ++x;
    y=0;

  while((line[y++] = line[x++]));
}

// BMG (bguillory@email.com)
// 3 August 1999
long long int my_atoll (const char *nptr)
#define MAXLLL 30 //maximum number of digits in long long (a guess)
{
  int offset=0, x;
  long long int returnval=0;
  char one_digit[2];

  one_digit[1]='\0';

  // Soak up all the white space
  while (isspace(nptr[offset])) {
    offset++;
  } //while

  //For each character left to right
  //change the character to a single digit
  //multiply what we had before by 10 and add the new digit
  for(x=offset; x<=MAXLLL+offset && isdigit(nptr[x]); x++) {
    sprintf(one_digit, "%c", nptr[x]); //I don't know how else to do this
    returnval = (returnval * 10) + atoi(one_digit);
  } //for

  return returnval;

} //my_atoll


void my_lltoa(unsigned long long int n, char s[], int len)
{
  int i = 0;
  int x = 0;
  char ww[50];
  do {
    s[i++] = (n % 10) + '0';
  } while ((n /= 10) > 0);
  s[i] = '\0';
  {
    int c,i,j;
    for (i = 0, j = strlen(s)-1; i<j; i++, j--)
      {
        c = s[i];
        s[i] = s[j];
        s[j] = c;
      }
  }
  
  if(len) {
     bzero(ww,50);
     i=len-strlen(s)-1;
     for(x=0; x<=i; x++)
        ww[x]='0';
     strncat(ww,s,strlen(s));
     strcpy(s,ww);
  }
    
}


void builddia(char *dia, char *mes, char *ano, char *df, char *wdata)
{
   char ndia[9];
   char nmes[3];
   int  x;

   ndia[0]='\0';
   nmes[0]='\0';

   for(x=0; x<=12; x++) {
      if(strcmp(mtab1[x],mes) == 0)
         strcpy(nmes,mtab2[x]);
   }

   sprintf(wdata,"%s%s%s",ano,nmes,dia);

   if(strncmp(df,"u",1) != 0)
      sprintf(ndia,"%s/%s/%s",dia,nmes,ano);
    else
      sprintf(ndia,"%s/%s/%s",nmes,dia,ano);

   strcpy(dia,ndia);

   return;

}


void buildymd(char *dia, char *mes, char *ano, char *wdata)
{
   char nmes[3];
   int  x;

   nmes[0]='\0';

   for(x=0; x<=12; x++) {
      if(strcmp(mtab1[x],mes) == 0)
         strcpy(nmes,mtab2[x]);
   }

   sprintf(wdata,"%s%s%s",ano,nmes,dia);

   return;

}


void conv_month(char *month)
{
   int  x;

   for(x=0; x<=12; x++) {
      if(strcmp(mtab1[x],month) == 0)
         strcpy(month,mtab2[x]);
   }

   return;

}


void fixper(char *tbuf, char *periodo, char *duntil)
{

   char warea[50];
   char dia[3];
   char mes[3];
   char ano[5];
   int  x;

   warea[0]='\0';

   strncpy(dia,duntil+6,2);
   dia[2]='\0';
   strncpy(mes,duntil+4,2);
   mes[2]='\0';
   strncpy(ano,duntil,4);
   ano[4]='\0';

   for(x=0; x<=12; x++) {
      if(strcmp(mtab2[x],mes) == 0)
         strcpy(mes,mtab1[x]);
   }

   if(strcmp(df,"e") == 0)
      sprintf(warea,"%s%s%s",dia,mes,ano);
   if(strcmp(df,"u") == 0)
      sprintf(warea,"%s%s%s",ano,mes,dia);

   strcat(periodo,warea);
   return;
}


void debuga(char *msg)
{
  fprintf(stderr, "SARG: %s\n",msg);

  return;
}


void debugaz(char *head, char *msg)
{
  fprintf(stderr, "SARG: (util) %s=%s\n",head, msg);

  return;
}


void fixip(char *ip)
{
   char n1[MAXLEN], n2[MAXLEN], n3[MAXLEN];
   char wip[MAXLEN];
   char sep[2]=".";
   int iflag=0;

   strcpy(wip,ip);

   if(strstr(ip,".") != 0) {
      strcpy(sep,"_");
      iflag++;
   }

   if(iflag) {
      getword(n1,wip,'.');
      getword(n2,wip,'.');
      getword(n3,wip,'.');
   } else {
      getword(n1,wip,'_');
      getword(n2,wip,'_');
      getword(n3,wip,'_');
   }
   ip[0]='\0';
   sprintf(ip,"%s%s%s%s%s%s%s",n1,sep,n2,sep,n3,sep,wip);

   return;
}


char *fixnum(long long int inteiro)
#define MAXIMO 1024
{
   char num[MAXIMO];
   char buf[MAXIMO * 2];
   char *pbuf;
   char ret[MAXIMO * 2];
   char *pret;
   float perc=0;
   register int i, j, k;
   static char abbrev[30];
      
   my_lltoa(inteiro, num, 0);

   if(strcmp(DisplayedValues,"abbreviation") == 0) {
      if(inteiro < 1000) {
         perc=inteiro;
         sprintf(abbrev,"%3.0f",perc);
      }
      if(inteiro > 999 && inteiro <= 999999) {
         perc=inteiro / 1000;
         if((inteiro % 1000) >= 500) perc++;
         sprintf(abbrev,"%3.0f K",perc);
      }
      if(inteiro >999999 && inteiro <= 999999999) {
         perc=inteiro / 1000000;
         if((inteiro % 1000000) >= 500) perc++;
         sprintf(abbrev,"%3.0f M",perc);
      }
      if(inteiro > 999999999 && inteiro <= 999999999999) {
         perc=inteiro / 1000000000;
         if((inteiro % 1000000000) >= 500) perc++;
         sprintf(abbrev,"%3.0f G",perc);
      }
      if(inteiro > 999999999999) {
         perc=inteiro / 1000000000000;
         if((inteiro % 1000000000000) >= 500) perc++;
         sprintf(abbrev,"%3.0f T",perc);
      }

      return(abbrev);
   }

   bzero(buf, MAXIMO*2);

   pbuf = buf;
   pret = ret;
   k = 0;

   for ( i = strlen(num) - 1, j = 0 ; i > -1; i--) {
      if ( k == 2 && i != 0 )  {
         k = 0;
         pbuf[j++] = num[i];
         if(strcmp(UseComma,"yes") == 0)
            pbuf[j++] = ',';
         else pbuf[j++] = '.';
         continue;
      }
      pbuf[j] = num[i];
      j++;
      k++;
   }

   pret[0]='\0';

   for ( i = strlen(pbuf) - 1, j = 0 ; i > -1; i--, j++)
      pret[j] = pbuf[i];

      pret[j] = '\0';

      return pret;
}


void buildhref(char * href)
{
   char whref[MAXLEN];

   if(strcmp(href,"./") == 0){
      href[0]='\0';
      strcat(href,"<a href='");
      return;
   }

   href[strlen(href)-1]='\0';
   sprintf(whref,"%s",strrchr(href,'/'));

   strcpy(href,"<a href='");
   strcat(href,whref);
   strcat(href,"/");

   return;

}


char *buildtime(long long int elap)
{

   int num = elap / 1000;
   int hor = 0;
   int min = 0;
   int sec = 0;
   static char buf[12];

   buf[0]='\0';

   hor=num / 3600;
   min=(num % 3600) / 60;
   sec=num % 60;
   sprintf(buf,"%02d:%02d:%02d",hor,min,sec);

   return(buf);

}


void obtdate(char *dirname, char *name, char *data)
{

   FILE *fp_in;
   char wdir[MAXLEN];

   sprintf(wdir,"%s%s/date",dirname,name);
   if ((fp_in = fopen(wdir, "r")) == 0) {
      data[0]='\0';
      return;
   }

   fgets(data,80,fp_in);
   fclose(fp_in);
   data[strlen(data)-1]='\0';

   return;

}


void obtuser(char *dirname, char *name, char *tuser)
{

   FILE *fp_in;
   char wdir[MAXLEN];

   sprintf(wdir,"%s%s/usuarios",dirname,name);
   if((fp_in=fopen(wdir,"r"))==NULL){    
      tuser[0]='\0';
      return;
   }

   fgets(tuser,20,fp_in);
   tuser[strlen(tuser)-1]='\0';
   fclose(fp_in);

   return;

}


void obttotal(char *dirname, char *name, char *tbytes, char *tuser, char *media)
{

   FILE *fp_in;
   char wdir[MAXLEN];
   long long int med=0;
   long long int wtuser=0;

   sprintf(wdir,"%s%s/geral",dirname,name);

   if ((fp_in = fopen(wdir, "r")) == 0) {
      tbytes=0;
      return;
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(warea,buf,' ');
      if(strcmp(warea,"TOTAL") != 0)
         continue;
      getword(warea,buf,' ');
      getword(warea,buf,' ');
      twork=my_atoll(warea);
      sprintf(tbytes,"%s",fixnum(twork));
   }
   fclose(fp_in);

   if(tuser[0] == '\0') {
      wtuser=0;
      sprintf(media,"%s","0");
      return;
   }
   
   wtuser=my_atoll(tuser);
   med=my_atoll(warea) / wtuser;
   sprintf(media,"%s",fixnum(med));

   return;

}


void gperiodo(char *dirname, const char *periodo, int debug)
{
 
   FILE *fp_ou;
 
   char wdirname[MAXLEN];

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,"periodo");
 
   if((fp_ou=fopen(wdirname,"w"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }
 
   fputs(periodo,fp_ou);
   fclose(fp_ou);

   if(debug)
      debuga((char *)text[50]);
 
   return;
 
}

void vrfydir(char *dir, char *dirname, char *per1, char *addr, char *site, char *us, int debug, char *form)
{
   int  num=1, count=0;
   char wdir[MAXLEN];
   char per2[MAXLEN];

   if(strcmp(OverwriteReport,"no") == 0) {
      while(num) {
         if(access(dirname,R_OK) == 0) {
            sprintf(dirname,"%s.%d",dir,num);
            sprintf(per2,"%s.%d",per1,num);
            num++;
            count++;
         } else
            break;
      }
   
      if(count > 0) {
         if(debug)
            fprintf(stderr, "SARG: %s: %s %s %s\n",text[51],dir,text[52],dirname);
         rename(dir,dirname);
      }
   } else {
      if(access(dir,R_OK) == 0) {
         sprintf(wdir,"rm -r %s",dir);
         system(wdir);
      }
   }

   sprintf(wdir,"mkdir -p %s",dir);
   if(strlen(us) > 0) {
      strcat(wdir,"-");
      strcat(wdir,us);
   }
   if(strlen(addr) > 0) {
      strcat(wdir,"-");
      strcat(wdir,addr);
   }
   if(strlen(site) > 0) {
      strcat(wdir,"-");
      strcat(wdir,site);
   }

   system(wdir);

   sprintf(dirname,"%s",wdir+9);

   sprintf(wdir,"date >%s/%s",dirname,"date");
   system(wdir);

   return;

}


void strip_latin(char *line)
{
   char buf[255];
   char warea[255];

   while(strstr(line,"&") != 0){
      getword(warea,line,'&');
      strncat(warea,line,1);
      getword(buf,line,';');
      strcat(warea,line);
      strcpy(line,warea);
   }

   return;

}

void zdate(char *ftime, char *DateFormat)
{

   time_t t;
   struct tm *local;

   t = time(NULL);
   local = localtime(&t);
   if(strcmp(DateFormat,"u") == 0)
      strftime(ftime, 127, "%b/%d/%Y %H:%M", local);
   if(strcmp(DateFormat,"e") == 0)
      strftime(ftime, 127, "%d/%b/%Y-%H:%M", local);
   if(strcmp(DateFormat,"w") == 0)
      strftime(ftime, 127, "%V-%H-%M", local);

   return;
}


char *fixtime(long int elap)
{

   int num = elap / 1000;
   int hor = 0;
   int min = 0;
   int sec = 0;
   static char buf[12];

   if(strcmp(datetimeby,"bytes") == 0) {
      sprintf(buf,"%s",fixnum(elap));
      return buf;
   }

   buf[0]='\0';

   if(num<1) {
      sprintf(buf,"00:00:%02ld",elap);
      return buf;
   }

   hor=num / 3600;
   min=(num % 3600) / 60;
   sec=num % 60;

   sprintf(buf,"%01d:%02d:%02d",hor,min,sec);

   if(strcmp(buf,"0:00:00") == 0)
      strcpy(buf,"0");

   return buf;

}


void date_from(char *date, char *dfrom, char *duntil)
{

   char diaf[10];
   char mesf[10];
   char anof[10];
   char diau[10];
   char mesu[10];
   char anou[10];
   static char wdate[50];


   strcpy(wdate,date);
   if(strstr(wdate,"-") == 0) {
      strcat(wdate,"-");
      strcat(wdate,date);
      strcpy(date,wdate);
   }

   getword(diaf,wdate,'/');
   getword(mesf,wdate,'/');
   getword(anof,wdate,'-');
   getword(diau,wdate,'/');
   getword(mesu,wdate,'/');
   strcpy(anou,wdate);

   sprintf(dfrom,"%s%s%s",anof,mesf,diaf);
   sprintf(duntil,"%s%s%s",anou,mesu,diau);
   return;
}


char *strlow(char *string)
{
      char *s;

      if (string)
      {
            for (s = string; *s; ++s)
                  *s = tolower(*s);
      }

      return string;
}




char *strup(char *string)
{
      char *s;

      if (string)
      {
            for (s = string; *s; ++s)
                  *s = toupper(*s);
      }

      return string;
}


char *subs(char *str, char *from, char *to)
{
   char *tmp;
   char *ret;
   unsigned int ss, st;

   if(strstr(str,from) == 0)
      return (char *) str;

    ss = strlen(str); st = strlen(to);
    ret = (char *) malloc(ss + st);
    bzero(ret,ss+st);

    tmp = strstr(str, from);
    if ( tmp == (char *) NULL )
       return (char *) NULL;
    strncpy(ret, str, ss - strlen(tmp));
    strcat(ret, to);
    strcat(ret, (tmp+strlen(from)));
    return (char *) ret;
}


void removetmp(char *outdir, int debug)
{

   FILE *fp_in;
   char warea[256];

   if(strcmp(RemoveTempFiles,"yes") != 0) {
      return;
   } else {
      if(debug) {
         sprintf(msg,"%s: geral, periodo",text[82]);
         debuga(msg);
      }
      sprintf(warea,"%s/geral",outdir);
      if((fp_in=fopen(warea,"r"))==NULL){
         fprintf(stderr, "SARG: (removetmp) %s: %s\n",text[45],warea);
         exit(1);
      }
      while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
         if(strncmp(buf,"TOTAL",5) == 0)
            break;
      }
      fclose(fp_in);
      if((fp_in=fopen(warea,"w"))==NULL){
         fprintf(stderr, "SARG: (removetmp) %s: %s\n",text[45],warea);
         exit(1);
      }
      fputs(buf,fp_in);
      fclose(fp_in);
      sprintf(warea,"%s/periodo",outdir);
      unlink(warea);
   }
  
   return;
}

void load_excludecodes()
{

   FILE *fp_in;
   char data[80];

   if((fp_in=fopen(ExcludeCodes,"r"))==NULL) {
     fprintf(stderr, "SARG: (util) Cannot open file: %s (exclude_codes)\n",ExcludeCodes);
     exit(1);
   }

   while(fgets(data,80,fp_in)!=NULL) {
      data[strlen(data)-1]='\0';
      strcat(excludecode,data);
      strcat(excludecode,";");
      excode++;
   }

   fclose(fp_in);
   return;

}

int vercode(char *code)
{
   char warea[1024];
   char cod[80];
   int z;

   strcpy(warea,excludecode);
   for(z=0; z<=excode-1; z++) {
      getword(cod,warea,';');
      if(strcmp(code,cod) == 0) 
         return 1;
   }
   return 0;
}

void fixnone(char *str)
{
   if(strstr(str,"\n") != 0)
      str[strlen(str)-1]='\0';
   if(strcmp(str,"none") == 0)
      str[0]='\0';

   return;
}

int testvaliduserchar(char *user)
{

   int x=0;
   int y=0;

   for (y=0; y<strlen(UserInvalidChar); y++) {
      for (x=0; x<strlen(user); x++) {
         if(user[x] == UserInvalidChar[y])
            return 1;
      }
   }
   return 0;
}

int compar( const void *a, const void *b )
{ if( *(int *)a > *(int *)b ) return 1;
  if( *(int *)a < *(int *)b ) return -1;
  return 0;
}

int getnumlist( char *buf, numlist *list, const int len, const int maxvalue )
{ int i, j, d, flag, r1, r2;
  char *pbuf, **bp, *strbufs[ 24 ];
  
  bp = strbufs;
  strtok( buf, " \t" );
  for( *bp = strtok( NULL, "," ), list->len = 0; *bp; *bp = strtok( NULL, "," ) )
   { if( ++bp >= &strbufs[ 24 ] )
       break;
     list->len++;
   }
  if( ! list->len )      
     return -1;
  d = 0;
  for( i = 0; i < list->len; i++ )  
   { if( strstr( strbufs[ i ], "-" ) != 0 )
      { pbuf = strbufs[ i ];
        strtok( pbuf, "-" );
        pbuf = strtok( NULL, "\0" );
        r1 = atoi( strbufs[ i ] );
        if( ( r2 = atoi( pbuf ) ) >= maxvalue || r1 >= r2 )
          return -1;
        if( i + d + ( r2 - r1 ) + 1 <= len )
         { for( j = r1; j <= r2; j++ )
             list->list[ i + d++ ] = j;
           d--;
         }
      }
     else
       if( ( list->list[ i + d ] = atoi( strbufs[ i ] ) ) >= maxvalue )
          return 1;
   }
  list->len += d;
  qsort( list->list, list->len, sizeof( int ), compar );
  do
   { flag = 0;
     for( i = 0; i < list->len - 1; i++ )
       if( list->list[ i ] == list->list[ i + 1 ] )
        { for( j = i + 1; j < list->len; j++ )
            list->list[ j - 1 ] = list->list[ j ];
          list->len--;
          flag = 1;
          break;
        }
   } while( flag );
  return 0;
}
