/*
 * AUTHOR: Pedro Lineu Orso                          orso@brturbo.com.br
 *                                                            1998, 2005
 * SARG Squid Analysis Report Generator            http://sarg-squid.org
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"

void geraindex()
{

   FILE *fp_ou, *fp_tmp, *tp_tmp2;
   DIR *dirp;
   struct dirent *direntp;
   char html[MAXLEN];
   char wdir[MAXLEN];
   char wdir_tmp[MAXLEN];
   char wdir_tmp2[MAXLEN];
   char newname[512];
   char month[4];
   char period[80];
   char data[80];
   char tuser[20];
   char tbytes[20];
   char media[20];
   char ftime[128];
   char day[4], mon[4], year[6], hour[10];
   char h[3], m[3], s[3];

   if(LastLog[0] != '\0')
      mklastlog(outdir,debug);

   sprintf(wdir,"%sindex.html",outdir);
   sprintf(wdir_tmp,"%sindex.unsort",outdir);
   sprintf(wdir_tmp2,"%sindex.sort",outdir);
   strcpy(hbc1,"class=\"header\"");

   if(strcmp(Index,"no") == 0) {
      if(access(wdir, R_OK) == 0)
         unlink(wdir);
      return;
   }

   if(debug)
      debuga(text[53]);

   if((fp_ou=fopen(wdir,"w"))==NULL) {
      fprintf(stderr, "SARG: (index) %s: %s\n",text[45],wdir);
      exit(1);
   }

   if((fp_tmp=fopen(wdir_tmp,"w"))==NULL) {
      fprintf(stderr, "SARG: (index) %s: %s\n",text[45],wdir_tmp);
      exit(1);
   }

   dirp = opendir(outdir);
   while ( (direntp = readdir( dirp )) != NULL ){
      if(strstr(direntp->d_name,"-") == 0)
         continue;

      bzero(newname, 512);
      strncat(newname,direntp->d_name,4);
      strncpy(month,direntp->d_name+4,3);
      month[3]='\0';
      conv_month(month);
      strcat(newname,month);
      strncat(newname,direntp->d_name+7,2);

      obtdate(outdir,direntp->d_name,data);
      obtuser(outdir,direntp->d_name,tuser);
      obttotal(outdir,direntp->d_name,tbytes,tuser,media);
     
      strcpy(html,data);
      getword(mon,html,' ');
      getword(mon,html,' ');
      getword(day,html,' ');
      getword(hour,html,' ');
      getword(year,html,' ');
      getword(year,html,' ');
      strcpy(html,hour);
      getword(h,html,':');
      getword(m,html,':');
      strcpy(s,html);
      buildymd(day,mon,year,ftime);
      
      sprintf(html,"%s%s%s%s;%s;%s;%s;%s;%s;%s\n",ftime, h, m, s, direntp->d_name, data, tuser, tbytes, media,
			newname);
      fputs(html, fp_tmp);
   }

   fclose(fp_tmp);
   (void)rewinddir( dirp );
   (void)closedir( dirp );

   if(strcmp(IndexSortOrder,"A") == 0)
//      sprintf(html,"sort -t';' -k 7,7 %s -o %s", wdir_tmp, wdir_tmp2);
      sprintf(html,"sort -t';' +6.5n +6.2M +6.0n '%s' -o '%s'", wdir_tmp, wdir_tmp2);
   else
//      sprintf(html,"sort -t';' -r -k 7,7 %s -o %s", wdir_tmp, wdir_tmp2);
      sprintf(html,"sort -t';' +6.5nr +6.2Mr +6.0nr '%s' -o '%s'", wdir_tmp, wdir_tmp2);

   system(html);

   unlink(wdir_tmp);

   fputs("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"",fp_ou);
   fputs(" \"http://www.w3.org/TR/html4/loose.dtd\">\n",fp_ou);
   fputs("<html>\n",fp_ou);
   fputs("<head>\n",fp_ou);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_ou);
   fputs("</head>\n",fp_ou);
   css(fp_ou);

   sprintf(buf,"<body style=\"font-family:%s;font-size:%s;background-color:%s; \
	background-image:url(%s)\">\n",FontFace,TitleFontSize,BgColor,BgImage);
   fputs(buf,fp_ou);

   sprintf(buf,"<center><table cellpadding=\"0\" cellspacing=\"0\">\n");
   fputs(buf,fp_ou);
   if(strlen(LogoImage) > 0) {
      sprintf(html,"<tr><th align=\"center\"><img src=\"%s\" border=0 align=absmiddle width=%s height=%s> \
	<font color=%s>%s</font></th></tr>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(html,fp_ou);
   }
   show_sarg(fp_ou, ".");
   sprintf(html,"<tr><th class=\"title\">%s</th></tr>\n",Title);
   fputs(html,fp_ou);
   fputs("</table></center>\n",fp_ou);

   fputs("<center><table cellpadding=\"1\" cellspacing=\"2\">\n",fp_ou);
   fputs("<tr><td></td><td></td></tr>\n",fp_ou);

   sprintf(html,"<tr><th %s>%s</th><th %s>%s</th><th %s>%s \
	</th><th %s>%s</th><th %s>%s</th></tr>\n", \
	hbc1,text[101],hbc1,text[102],hbc1,text[103],hbc1,text[93],hbc1,text[96]);
   fputs(html,fp_ou);

   if((fp_tmp=fopen(wdir_tmp2,"r"))==NULL) {
      fprintf(stderr, "SARG: (index) %s: %s\n",text[45],wdir_tmp2);
      exit(1);
   }

   while(fgets(buf,MAXLEN,fp_tmp)!=NULL) {
      getword(period,buf,';');
      getword(period,buf,';');
      getword(data,buf,';');
      getword(tuser,buf,';');
      getword(tbytes,buf,';');
      getword(media,buf,';');

      sprintf(html,"<tr><td class=\"data2\"><a href='%s/%s'>%s</a></td><td class=\"data2\">%s</td> \
	<td class=\"data\">%s</td><td class=\"data\">%s</td><td class=\"data\">%s</td></tr>\n", \
	period,ReplaceIndex,period,data,tuser,tbytes,media);
      fputs(html,fp_ou);
   }

   strcpy(html,"</table></center>");
   fputs(html,fp_ou);

   zdate(ftime, DateFormat);

   show_info(fp_ou);

   strcpy(html,"</body>\n</html>\n");
   fputs(html,fp_ou);

   fclose(fp_ou);
   fclose(fp_tmp);

   unlink(wdir_tmp2);
   return;
}
