/*
 * AUTHOR: Pedro Lineu Orso                          orso@brturbo.com.br
 *                                                            1998, 2005
 * SARG Squid Analysis Report Generator            http://sarg-squid.org
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"

void topsites()
{

   FILE *fp_in, *fp_ou;
      
   char url[MAXLEN];
   char ourl[MAXLEN];
   char nacc[20];
   char nbytes[20];
   char ntime[20];
   char ntemp[20];
   char ttnacc[20];
   char ttnbytes[20];
   char ttntime[20];
   char csort[255];
   char geral[MAXLEN];
   char geral2[MAXLEN];
   char geral3[MAXLEN];
   char per[MAXLEN];
   char sites[MAXLEN];
   char report[MAXLEN];
   char periodo[100];
   char ftime[128];
   char sortf[10];
   char sortt[10];
   long long int tnacc=0;
   long long int tnbytes=0;
   long long int tntime=0;
   long long int twork1=0, twork2=0, twork3=0;
   int regs=0;


   sprintf(geral,"%s/geral",dirname);
   sprintf(sites,"%s/sites",dirname);
   sprintf(geral2,"%s/geral2",dirname);
   sprintf(geral3,"%s/geral3",dirname);
   sprintf(per,"%s/periodo",dirname);
   sprintf(report,"%s/topsites.html",dirname);

   if ((fp_in = fopen(per, "r")) == 0) {
      fprintf(stderr, "SARG: (topuser) %s: %s\n",text[45],per);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

   sprintf(csort,"sort -k 4,4 -o %s %s",geral2,geral);
   system(csort);

   if((fp_in=fopen(geral2,"r"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],geral2);
     exit(1);
   }

   if((fp_ou=fopen(geral3,"w"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],geral3);
     exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(url,buf,' ');
      if(strcmp(url,"TOTAL") == 0) {
         getword(ttnacc,buf,' ');
         getword(ttnbytes,buf,' ');
         getword(ttntime,buf,' ');
         continue;
      }
      getword(nacc,buf,' ');
      getword(nbytes,buf,' ');
      getword(url,buf,' ');
      getword(ntemp,buf,' ');
      getword(ntemp,buf,' ');
      getword(ntemp,buf,' ');
      getword(ntime,buf,' ');

      if(!regs) {
         strcpy(ourl,url);
         regs++;
      }

      if(strcmp(url,ourl) != 0) {
         my_lltoa(tnacc,val1,15);
         my_lltoa(tnbytes,val2,15);
         my_lltoa(tntime,val3,15);
         sprintf(buf,"%s %s %s %s\n",val1,val2,val3,ourl);
         fputs(buf, fp_ou);
         strcpy(ourl,url);
         tnacc=0;
         tnbytes=0;
         tntime=0;
      }

      tnacc+=my_atoll(nacc);
      tnbytes+=my_atoll(nbytes);
      tntime+=my_atoll(ntime);
   }

   my_lltoa(tnacc,val1,15);
   my_lltoa(tnbytes,val2,15);
   my_lltoa(tntime,val3,15);
   sprintf(buf,"%s %s %s %s\n",val1,val2,val3,ourl);
   fputs(buf, fp_ou);

   fclose(fp_in);
   fclose(fp_ou);
   unlink(geral2);

   strlow(TopsitesSortField);
   strlow(TopsitesSortType);

   if(strcmp(TopsitesSortField,"connect") == 0)
      strcpy(sortf,"1,1");
   if(strcmp(TopsitesSortField,"bytes") == 0)
      strcpy(sortf,"2,2");
   if(strcmp(TopsitesSortType,"a") == 0)
      strcpy(sortt," ");
   if(strcmp(TopsitesSortType,"d") == 0)
      strcpy(sortt,"-r");

   sprintf(csort,"sort %s -k %s -o %s %s",sortt,sortf,sites,geral3);
   system(csort);

   unlink(geral2);
   unlink(geral3);

   if((fp_in=fopen(sites,"r"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],sites);
     exit(1);
   }

   if((fp_ou=fopen(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (topsite) %s: %s\n",text[8],report);
     exit(1);
   }

   regs=0;

   fputs("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"",fp_ou);
   fputs(" \"http://www.w3.org/TR/html4/loose.dtd\">\n",fp_ou);
   fputs("<html>\n",fp_ou);
   fputs("<head>\n",fp_ou);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_ou);
   css(fp_ou);
   fputs("</head>\n",fp_ou);

   sprintf(url,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
   fputs(url,fp_ou);

   if(strlen(LogoImage) > 0) {
      fputs("<center><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);
      sprintf(url,"<tr><th align=\"center\"><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(url,fp_ou);
      fputs("</table>\n",fp_ou);
   }

   show_sarg(fp_ou,"..");
   fputs("<center><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);
   sprintf(url,"<tr><th class=\"title\">%s</th></tr>\n",Title);
   fputs(url,fp_ou);

   sprintf(url,"<tr><td class=\"header3\">%s: %s</td></tr>\n",text[89],periodo);
   fputs(url,fp_ou);
   sprintf(url,"<tr><td class=\"header3\">%s %s %s</td></tr>\n",text[83],TopSitesNum,text[84]);
   fputs(url,fp_ou);
   fputs("</table></center>\n",fp_ou);

   fputs("<center><table cellpadding=\"1\" cellspacing=\"2\">\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   sprintf(url,"<tr><td class=\"header\">%s</td><th class=\"header\">%s</th> \
		<th class=\"header\">%s</th><th class=\"header\">%s</th> \
		<th class=\"header\">%s</th></tr>\n", \
		text[100],text[91],text[92],text[93],text[99]);
   fputs(url,fp_ou);

   regs=1;

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if(regs>atoi(TopSitesNum))
         break;
      getword(nacc,buf,' ');
      getword(nbytes,buf,' ');
      getword(ntime,buf,' ');
      getword(url,buf,' ');

      twork1=my_atoll(nacc);
      twork2=my_atoll(nbytes);
      twork3=my_atoll(ntime);

      sprintf(wwork1,"%s",fixnum(twork1,1));
      sprintf(wwork2,"%s",fixnum(twork2,1));
      sprintf(wwork3,"%s",fixnum(twork3,1));

      if(strlen(BlockIt) > 0)
         sprintf(BlockImage,"<a href=\"%s%s?url=%s\"><img src=\"../images/sarg-squidguard-block.png\" border=\"0\"></a>&nbsp;",wwwDocumentRoot,BlockIt,url);
      else BlockImage[0]='\0';


      sprintf(ourl,"<tr><td class=\"data\">%d</td><td class=\"data2\">%s<a href=\"http://%s\"><font class=\"link\">%s</font></td><td class=\"data\">%s</td><td class=\"data\">%s</td><td class=\"data\">%s</td></tr>\n",regs,BlockImage,url,url,wwork1,wwork2,wwork3);
      fputs(ourl,fp_ou);
      regs++;
   }


   fputs("</table></center>\n",fp_ou);

   show_info(fp_ou);

   fputs("</body>\n</html>\n",fp_ou);
   
   fclose(fp_in);
   fclose(fp_ou);

   return;

}
