/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void decomp(char *arq, char *zip, const char *tmp)
{
   char cmd[1024];
   int cstatus;
   int arqlen;

   if(access(arq, R_OK) != 0) {
      debuga("%s: %s",text[64],arq);
      exit(1);
   }

   arqlen=strlen(arq);
   if(arqlen>3 && strcmp(arq+arqlen-3,".gz") == 0) {
      debuga("%s: %s > %s/sarg/sarg-file.in (zcat)",text[62],arq,tmp);
      if (snprintf(cmd,sizeof(cmd),"zcat \"%s\" > \"%s/sarg/sarg-file.in\"",arq,tmp)>=sizeof(cmd)) {
         fprintf(stderr,"SARG: decompression command too long for log file %s\n",arq);
         exit(1);
      }
      cstatus=system(cmd);
      if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
         fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
         fprintf(stderr, "SARG: command: %s\n",cmd);
         exit(1);
      }
      strcpy(zip,"zcat");
      sprintf(arq,"%s/sarg/sarg-file.in",tmp);
      return;
   }

   if(arqlen>4 && strcmp(arq+arqlen-4,".bz2") == 0) {
      debuga("%s: %s > %s/sarg/sarg-file.in (bzcat)",text[62],arq,tmp);
      if (snprintf(cmd,sizeof(cmd),"bzcat \"%s\" > \"%s/sarg/sarg-file.in\"",arq,tmp)>=sizeof(cmd)) {
         fprintf(stderr,"SARG: decompression command too long for log file %s\n",arq);
         exit(1);
      }
      cstatus=system(cmd);
      if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
         fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
         fprintf(stderr, "SARG: command: %s\n",cmd);
         exit(1);
      }
      strcpy(zip,"zcat");
      sprintf(arq,"%s/sarg/sarg-file.in",tmp);
      return;
   }

   if(arqlen>2 && strcmp(arq+arqlen-2,".Z") == 0) {
      debuga("%s: %s (uncompress)",text[62],arq);
      if (snprintf(cmd,sizeof(cmd),"zcat \"%s\" > \"%s/sarg/sarg-file.in\"",arq,tmp)>=sizeof(cmd)) {
         fprintf(stderr,"SARG: decompression command too long for log file %s\n",arq);
         exit(1);
      }
      cstatus=system(cmd);
      if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
         fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
         fprintf(stderr, "SARG: command: %s\n",cmd);
         exit(1);
      }
      strcpy(zip,"zcat");
      sprintf(arq,"%s/sarg/sarg-file.in",tmp);
   }

   return;

}


void recomp(const char *arq, const char *zip) 
{
   char cmd[1024];
   int cstatus;

   if(access(arq, R_OK) != 0) {
      debuga("%s: %s",text[64],arq);
      exit(1);
   }

   if((strcmp(zip,"gzip") != 0) &&
      (strcmp(zip,"compress") != 0))
      return;

   debuga("%s: %s",text[63],arq);

   if (snprintf(cmd,sizeof(cmd),"%s \"%s\"",zip,arq)>=sizeof(cmd)) {
      fprintf(stderr,"SARG: compression command too long for log file %s\n",arq);
      exit(1);
   }
   cstatus=system(cmd);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: command: %s\n",cmd);
      exit(1);
   }
   return;

}
