/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void gen_denied_report(void)
{

   FILE *fp_in = NULL, *fp_ou = NULL;
      
   char url[MAXLEN];
   char denied_in[MAXLEN];
   char per[MAXLEN];
   char report[MAXLEN];
   char period[100];
   char ip[MAXLEN];
   char oip[MAXLEN];
   char user[MAXLEN];
   char ouser[MAXLEN];
   char ouser2[MAXLEN];
   char data[15];
   char hora[15];
   char *str;
   int  z=0;
   int  count=0;

   ouser[0]='\0';
   ouser2[0]='\0';

   sprintf(denied_in,"%s/sarg/denied.log",TempDir);
   if(!denied_count) {
      unlink(denied_in);
      return;
   }

   sprintf(per,"%s/sarg-period",dirname);
   sprintf(report,"%s/denied.html",dirname);

   if ((fp_in = fopen(per, "r")) == 0) {
      fprintf(stderr, "SARG: (denied) %s: %s\n",text[45],per);
      exit(1);
   }

   if (!fgets(period,sizeof(period),fp_in)) {
      fprintf(stderr,"SARG: (denied) read error in %s\n",per);
      exit(1);
   }
   fclose(fp_in);

   if((fp_in=MY_FOPEN(denied_in,"r"))==NULL) {
     fprintf(stderr, "SARG: (denied) %s: %s\n",text[8],denied_in);
     exit(1);
   }

   if((fp_ou=MY_FOPEN(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (denied) %s: %s\n",text[8],report);
     exit(1);
   }

   fprintf(fp_ou, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   css(fp_ou);
   fputs("</head>\n",fp_ou);
   fprintf(fp_ou,"<body bgcolor=\"%s\" text=\"%s\" background=\"%s\">\n",BgColor,TxColor,BgImage);
   write_logo_image(fp_ou);

   if(strcmp(IndexTree,"date") == 0)
      show_sarg(fp_ou, "../../..");
   else
      show_sarg(fp_ou, "..");

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"title\">%s</b></th></tr>\n",Title);

   fprintf(fp_ou,"<tr><td class=\"header\">%s: %s</td></tr>\n",text[89],period);
   fprintf(fp_ou,"<tr><th class=\"header3\">%s</th></tr>\n",text[46]);
   fputs("</table></div>\n",fp_ou);

   fputs("<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"2\">\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fprintf(fp_ou,"<tr><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th></tr>\n",text[98],text[111],text[110],text[91]);

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if (getword(data,sizeof(data),buf,' ')<0 || getword(hora,sizeof(hora),buf,' ')<0 ||
          getword(user,sizeof(user),buf,' ')<0 || getword(ip,sizeof(ip),buf,' ')<0 ||
          getword(url,sizeof(url),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",denied_in);
         exit(1);
      }

      if((str=(char *) strstr(user, "_")) != (char *) NULL ) {
         if((str=(char *) strstr(str+1, "_")) != (char *) NULL )
            fixip(user);
      }

      if(strcmp(Ip2Name,"yes") == 0) 
         ip2name(ip,sizeof(ip));

      if(!z) {
         strcpy(ouser,user);
         strcpy(oip,ip);
         z++;
      } else {
         if(strcmp(ouser,user) == 0)
            user[0]='\0';
         if(user[0] != '\0')
            strcpy(ouser,user);
         if(strcmp(oip,ip) == 0) 
            ip[0]='\0';
         if(ip[0] != '\0')
            strcpy(oip,ip);
      }

      get_usertab_name(user,name,sizeof(name));

      if(dotinuser && strchr(name,'_')) {
         subs(name,sizeof(name),"_",".");
      }

      if(DeniedReportLimit) {
         if(strcmp(ouser2,name) == 0) {
            count++; 
         } else {
            count=1;
            strcpy(ouser2,name);
         }
         if(count >= DeniedReportLimit)
            continue;
      }

      if(strlen(BlockIt) > 0)
         sprintf(BlockImage,"<a href=\"%s%s?url=%s\"><img src=\"%s/sarg-squidguard-block.png\" border=\"0\"></a>&nbsp;",wwwDocumentRoot,BlockIt,url,ImageFile);
      else BlockImage[0]='\0';

      fprintf(fp_ou,"<tr><td class=\"data\">%s</td><td class=\"data\">%s</td><td class=\"data\">%s-%s</td><td class=\"data2\">%s<a href=\"%s\">%s</a></td></th>\n",name,ip,data,hora,BlockImage,url,url);
   }

   fputs("</table>\n",fp_ou);

   show_info(fp_ou);
   fputs("</body></html>\n",fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   unlink(denied_in);

   return;
}
