/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void mklastlog(const char *outdir)
{

   FILE *fp_in, *fp_ou;
   DIR *dirp;
   struct dirent *direntp;
   char temp[MAXLEN];
   char warea[MAXLEN];
   char ftime[128];
   int  ftot=0;
   time_t t;
   struct tm *local;
   struct stat statb;
   int cstatus;

   if(strcmp(LastLog,"0") == 0)
      return;

   sprintf(temp,"%slastlog1",outdir);
   if((fp_ou=fopen(temp,"w"))==NULL) {
     fprintf(stderr, "SARG: (lastlog) %s: %s\n",text[9],temp);        
     exit(1);
   }

   dirp = opendir(outdir);
   while ((direntp = readdir( dirp )) != NULL ){
      if(strstr(direntp->d_name,"-") == 0)
         continue;

      sprintf(warea,"%s%s",outdir,direntp->d_name);
      stat(warea,&statb);
      t=statb.st_ctime;
      local = localtime(&t);
      strftime(ftime, 127, "%Y%m%d%H%M%S", local);
      fprintf(fp_ou,"%s %s\n",ftime,direntp->d_name);
      ftot++;
   }

   (void)rewinddir( dirp );
   (void)closedir( dirp );
   fclose(fp_ou);
   
   sprintf(buf,"sort -n -k 1,1 -o \"%slastlog\" \"%s\"",outdir,temp);
   cstatus=system(buf);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",buf);
      exit(1);
   }

   unlink(temp);

   if(ftot<=atoi(LastLog)) {
      sprintf(temp,"%slastlog",outdir);
      if(access(temp, R_OK) == 0)
         unlink(temp);
      return;
   }

   ftot-=atoi(LastLog);

   sprintf(temp,"%slastlog",outdir);
   if((fp_in=fopen(temp,"r"))==NULL) {
     fprintf(stderr, "SARG: (lastlog) %s: %s\n",text[9],temp);        
     exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if (getword(warea,sizeof(warea),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",temp);
         exit(1);
      }
      buf[strlen(buf)-1]='\0';
     
      if(ftot) {
         if(debug)
            debuga("%s: %s",text[81],buf);
//         sprintf(temp,"%s%s",outdir,buf);
         if (snprintf(temp,sizeof(temp),"rm -r \"%s%s\"",outdir,buf)>=sizeof(temp)) {
            fprintf(stderr,"SARG: Directory name too long: %s%s\n",outdir,buf);
            exit(1);
         }
         cstatus=system(temp);
         if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
            fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
            fprintf(stderr, "SARG: command: %s\n",temp);
            exit(1);
         }
         unlink(temp);
         ftot--;
      }
   }

   fclose(fp_in);
   sprintf(temp,"%slastlog",outdir);
   unlink(temp);
 
   return;
}
