#!/usr/local/bin/ruby

require 'sary'

filename = ARGV.shift
arrayname = filename + ".ary"

text = open(filename, "r")
array = open(arrayname, "w")

print "Indexing...\n"
offset = 0
text.each {|line|
  array.print [offset].pack('N')
  offset += line.length
}
text.close
array.close

print "Sorting...\n"
builder = Sary::Builder.new(filename, arrayname)
builder.block_sort { |task, current, total, is_finished|
  printf "%s:\t%d %% is done.%s", task, current * 100 / total,
    if is_finished then "\n" else "\r" end
  $stdout.flush
}
