#! /bin/zsh
test -z $1 && echo "Usage gendata.sh [OPTION] <text>" && exit

option=$1
target=$2

plotdata=`basename $target .txt`$option.dat
mksary=../../src/mksary

echo // Out: $plotdata

$mksary -q -i -a index-points $target

cp index-points reference
$mksary -a reference -s $target > log
echo "merge: Time: 00:00:00"   >> log  # dummy line
single_block_sort_time=`perl format-log.pl log |awk '{print $4}'`
echo // Single Block: $single_block_sort_time sec

rm -f log
for bsize in `perl xscale.pl $target`
do
    cp index-points $target.ary
    echo = $bsize | tee -a log
    $mksary $option -b$bsize -s $target | tee -a log
    cmp reference $target.ary || exit 1
done

perl format-log.pl -$single_block_sort_time log > $plotdata
