/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.io.RandomDataCollectorTimeStamped;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterNumber;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DAxisSwap;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import javax.swing.JFrame;

public final class AdvancedDynamicChart {
    public static void main(String[] args) {
        Chart2D chart = new Chart2D();
        AxisLinear yAxis = new AxisLinear();
        AxisLinear xAxis = new AxisLinear();
        yAxis.setFormatter(new LabelFormatterDate(new SimpleDateFormat("HH:mm:ss")));
        chart.setAxisYLeft(yAxis, 0);
        DecimalFormat format = new DecimalFormat("#");
        ((NumberFormat)format).setMaximumIntegerDigits(3);
        xAxis.setFormatter(new LabelFormatterNumber(format));
        chart.setAxisXBottom(xAxis, 0);
        xAxis.setRangePolicy(new RangePolicyMinimumViewport(new Range(-10.0, 10.0)));
        Trace2DLtd trace = new Trace2DLtd(400);
        trace.setColor(Color.RED);
        BasicStroke stroke = new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{15.0f, 10.0f}, 5.0f);
        trace.setStroke(stroke);
        chart.addTrace(trace);
        JFrame frame = new JFrame("AdvancedDynamicChart");
        frame.getContentPane().add(new ChartPanel(chart));
        frame.setSize(400, 300);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
        RandomDataCollectorTimeStamped collector = new RandomDataCollectorTimeStamped((ITrace2D)new Trace2DAxisSwap(trace), 50);
        collector.start();
    }

    private AdvancedDynamicChart() {
    }
}

