#!/usr/bin/python
#
# Simple Backup suit
#
# Running this command will upgrade a backup directory to latest format.
# This is also a backend for simple-restore-gnome GUI.
#
# Author: Aigars Mahinovs <aigarius@debian.org>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import tarfile, sys, re, os, os.path, shutil, datetime, filecmp, gzip, tempfile, zlib
import cPickle as pickle
try:
    import gnomevfs
except ImportError:
    import gnome.vfs as gnomevfs


class SBUpgrade:
	def upgrade_target( self, target ):
		r = re.compile(r"^(\d{4})-(\d{2})-(\d{2})_(\d{2})[\:\.](\d{2})[\:\.](\d{2})\.\d+\..*?\.(.+)$")

		if self.islocal( target ):
		    listing = os.listdir( target )
		    listing = filter( r.search, listing )
		else:
		    d = gnomevfs.open_directory( target )
		    listing = []
		    for f in d:
		        if f.type == 2 and f.name != "." and f.name != ".." and r.search( f.name ):
		            listing.append( f.name )
		
		listing.sort()
		listing.reverse()

		for adir in listing:
			if adir.find( ":" ):
				if self.islocal( target ):
					print "I: Renaming directory: '"+adir+"' to '"+adir.replace( ":", "." )"'"
					shutil.move( target+"/"+adir, target+"/"+adir.replace( ":", "." ) )
					adir = adir.replace( ":", "." )
			self.upgrade_tdir( target+"/"+adir )

	def upgrade_tdir( self, tdir ):
		if self.exists( tdir+"/flist" ):
			print "I: Up to date directory at: ", tdir
			return

		if self.exists( tdir+"/tree"):
			print "I: Upgrading from v1.0 to v1.2: ", tdir
			self.upgrade_v1( tdir )
			return

		print "W: Unknown or incomplete directory format at: ", tdir

	def upgrade_v1( self, tdir ):
		i = self.openfile(tdir+"/tree" )
		bfiles = pickle.load( i )
		n = self.openfile( tdir+"/flist", True )
		p = self.openfile( tdir+"/fprops", True )
		for item in bfiles:
			n.write( str(item[0])+"\n" )
			p.write( str(item[1])+str(item[2])+str(item[3])+str(item[4])+str(item[5])+"\n" )
		p.close()
		n.close()
		i.close()
		v = self.openfile( tdir+"/ver", True )
		v.write("1.2\n")
		v.close()

	def exists( self, uri ):
		if self.islocal(uri):
			return os.access( uri, os.F_OK )
		else:
			return gnomevfs.exists( uri )

	def islocal( self, uri ):
                local = True
                try:
                    if not gnomevfs.URI( uri ).is_local:
                        local = False
                except:
                    pass
		return local

	def openfile( self, uri, write=False ):
		if self.islocal( uri ):
			if write:
				return open( uri, "w" )
			else:
				return open( uri, "r" )
		else:
			if write:
				if self.exists( uri ):
					return gnomevfs.open( uri, 2 )
				else:
					return gnomevfs.create( uri, 2 )
			else:
				return gnomevfs.open( uri, 1 )


if __name__ == "__main__":
        if not len(sys.argv) in [2]:
                print "Simple Backup suit command line backup format upgrade"
                print " Usage: upgrade-backup backup-target-url"
                print " Note: backup-target-url must not include the snapshot subdirectory name, for example:"
                print "  /var/backup/"
                print " Use simple-restore-gnome for more ease of use."
                sys.exit(1)

	u = SBUpgrade()
        u.upgrade_target( sys.argv[1] )

