;;; -*- Lisp -*-

;;; This isn't really lisp, but it's definitely a source file.

;;; first, the headers necessary to find definitions of everything
(#||#
 "sys/types.h"
 "unistd.h"
 "sys/stat.h"
 
 "sys/socket.h" "sys/un.h" "netinet/in.h" "netinet/in_systm.h"
 "netinet/ip.h" "net/if.h" "netdb.h" "errno.h" "netinet/tcp.h"
 "fcntl.h" "sys/mman.h"
 "dirent.h" "signal.h"

 "termios.h")

;;; then the stuff we're looking for
((:integer af-inet "AF_INET" "IP Protocol family")

 (:type uid-t "uid_t")
 (:type gid-t "gid_t")

 (:type pid-t "pid_t")
 (:type ino-t "ino_t")

 (:type nlink-t "nlink_t")
 (:type time-t "time_t")
 (:type dev-t "dev_t")
 
 ;; signals
 (:integer SIGHUP "SIGHUP" #+sb-doc "terminal line hangup.")
 (:integer SIGINT "SIGINT" #+sb-doc "interrupt program.")
 (:integer SIGQUIT "SIGQUIT" #+sb-doc "quit program.")
 (:integer SIGILL "SIGILL" #+sb-doc "illegal instruction.")
 (:integer SIGTRAP "SIGTRAP" #+sb-doc "trace trap.")
 (:integer SIGABRT "SIGABRT" #+sb-doc "abort program (formerly SIGIOT).")
 (:integer SIGEMT "SIGEMT" #+sb-doc "emulate instruction executed.")
 (:integer SIGFPE "SIGFPE" #+sb-doc "floating-point exception.")
 (:integer SIGKILL "SIGKILL" #+sb-doc "kill program.")
 (:integer SIGBUS "SIGBUS" #+sb-doc "bus error.")
 (:integer SIGSEGV "SIGSEGV" #+sb-doc "segmentation violation.")
 (:integer SIGSYS "SIGSYS" #+sb-doc "non-existent system call invoked.")
 (:integer SIGPIPE "SIGPIPE" #+sb-doc "write on a pipe with no reader.")
 (:integer SIGALRM "SIGALRM" #+sb-doc "real-time timer expired.")
 (:integer SIGTERM "SIGTERM" #+sb-doc "software termination signal.")
 (:integer SIGURG "SIGURG" #+sb-doc "urgent condition present on socket.")
 (:integer SIGSTOP "SIGSTOP" #+sb-doc "stop (cannot be caught or ignored).")
 (:integer SIGTSTP "SIGTSTP" #+sb-doc "stop signal generated from keyboard.")
 (:integer SIGCONT "SIGCONT" #+sb-doc "continue after stop.")
 (:integer SIGCHLD "SIGCHLD" #+sb-doc "child status has changed.")
 (:integer SIGTTIN "SIGTTIN"
           #+sb-doc "background read attempted from control terminal.")
 (:integer SIGTTOU "SIGTTOU"
           #+sb-doc "background write attempted to control terminal.")
 (:integer SIGIO "SIGIO"
           #+sb-doc "I/O is possible on a descriptor (see fcntl(2)).")
 (:integer SIGXCPU "SIGXCPU"
           #+sb-doc "cpu time limit exceeded (see setrlimit(2)).")
 (:integer SIGXFSZ "SIGXFSZ"
           #+sb-doc "file size limit exceeded (see setrlimit(2)).")
 (:integer SIGVTALRM "SIGVTALRM"
           #+sb-doc "virtual time alarm (see setitimer(2)).")
 (:integer SIGPROF "SIGPROF"
           #+sb-doc "profiling timer alarm (see setitimer(2)).")
 (:integer SIGWINCH "SIGWINCH" #+sb-doc "Window size change.")
 (:integer SIGINFO "SIGINFO" #+sb-doc "status request from keyboard.")
 (:integer SIGUSR1 "SIGUSR1" #+sb-doc "User defined signal 1.")
 (:integer SIGUSR2 "SIGUSR2" #+sb-doc "User defined signal 2.")
 (:integer SIGRTMIN "SIGRTMIN" #+sb-doc "Smallest real-time signal number.")
 (:integer SIGRTMAX "SIGRTMAX" #+sb-doc "Largest real-time signal number.")

 ;; error numbers
 (:integer eperm "EPERM")
 (:integer enoent "ENOENT")
 (:integer esrch "ESRCH")
 (:integer eintr "EINTR")
 (:integer eio "EIO")
 (:integer enxio "ENXIO")
 (:integer e2big "E2BIG")
 (:integer enoexec "ENOEXEC")
 (:integer ebadf "EBADF")
 (:integer echild "ECHILD")
 (:integer eagain "EAGAIN")
 (:integer enomem "ENOMEM")
 (:integer eacces "EACCES")
 (:integer efault "EFAULT")
 (:integer enotblk "ENOTBLK")
 (:integer ebusy "EBUSY")
 (:integer eexist "EEXIST")
 (:integer exdev "EXDEV")
 (:integer enodev "ENODEV")
 (:integer enotdir "ENOTDIR")
 (:integer eisdir "EISDIR")
 (:integer einval "EINVAL")
 (:integer enfile "ENFILE")
 (:integer emfile "EMFILE")
 (:integer enotty "ENOTTY")
 (:integer etxtbsy "ETXTBSY")
 (:integer efbig "EFBIG")
 (:integer enospc "ENOSPC")
 (:integer espipe "ESPIPE")
 (:integer erofs "EROFS")
 (:integer emlink "EMLINK")
 (:integer epipe "EPIPE")
 (:integer edom "EDOM")
 (:integer erange "ERANGE")
 (:integer edeadlk "EDEADLK")
 (:integer enametoolong "ENAMETOOLONG")
 (:integer enolck "ENOLCK")
 (:integer enosys "ENOSYS")
 (:integer enotempty "ENOTEMPTY")
 (:integer eloop "ELOOP")
 (:integer ewouldblock "EWOULDBLOCK")
 (:integer enomsg "ENOMSG")
 (:integer eidrm "EIDRM")
 (:integer echrng "ECHRNG")
 (:integer el2nsync "EL2NSYNC")
 (:integer el3hlt "EL3HLT")
 (:integer el3rst "EL3RST")
 (:integer elnrng "ELNRNG")
 (:integer eunatch "EUNATCH")
 (:integer enocsi "ENOCSI")
 (:integer el2hlt "EL2HLT")
 (:integer ebade "EBADE")
 (:integer ebadr "EBADR")
 (:integer exfull "EXFULL")
 (:integer enoano "ENOANO")
 (:integer ebadrqc "EBADRQC")
 (:integer ebadslt "EBADSLT")
 (:integer edeadlock "EDEADLOCK")
 (:integer ebfont "EBFONT")
 (:integer enostr "ENOSTR")
 (:integer enodata "ENODATA")
 (:integer etime "ETIME")
 (:integer enosr "ENOSR")
 (:integer enonet "ENONET")
 (:integer enopkg "ENOPKG")
 (:integer eremote "EREMOTE")
 (:integer enolink "ENOLINK")
 (:integer eadv "EADV")
 (:integer esrmnt "ESRMNT")
 (:integer ecomm "ECOMM")
 (:integer eproto "EPROTO")
 (:integer emultihop "EMULTIHOP")
 (:integer edotdot "EDOTDOT")
 (:integer ebadmsg "EBADMSG")
 (:integer eoverflow "EOVERFLOW")
 (:integer enotuniq "ENOTUNIQ")
 (:integer ebadfd "EBADFD")
 (:integer eremchg "EREMCHG")
 (:integer elibacc "ELIBACC")
 (:integer elibbad "ELIBBAD")
 (:integer elibscn "ELIBSCN")
 (:integer elibmax "ELIBMAX")
 (:integer elibexec "ELIBEXEC")
 (:integer eilseq "EILSEQ")
 (:integer erestart "ERESTART")
 (:integer estrpipe "ESTRPIPE")
 (:integer eusers "EUSERS")
 (:integer enotsock "ENOTSOCK")
 (:integer edestaddrreq "EDESTADDRREQ")
 (:integer emsgsize "EMSGSIZE")
 (:integer eprototype "EPROTOTYPE")
 (:integer enoprotoopt "ENOPROTOOPT")
 (:integer eprotonosupport "EPROTONOSUPPORT")
 (:integer esocktnosupport "ESOCKTNOSUPPORT")
 (:integer eopnotsupp "EOPNOTSUPP")
 (:integer epfnosupport "EPFNOSUPPORT")
 (:integer eafnosupport "EAFNOSUPPORT")
 (:integer eaddrinuse "EADDRINUSE")
 (:integer eaddrnotavail "EADDRNOTAVAIL")
 (:integer enetdown "ENETDOWN")
 (:integer enetunreach "ENETUNREACH")
 (:integer enetreset "ENETRESET")
 (:integer econnaborted "ECONNABORTED")
 (:integer econnreset "ECONNRESET")
 (:integer enobufs "ENOBUFS")
 (:integer eisconn "EISCONN")
 (:integer enotconn "ENOTCONN")
 (:integer eshutdown "ESHUTDOWN")
 (:integer etoomanyrefs "ETOOMANYREFS")
 (:integer etimedout "ETIMEDOUT")
 (:integer econnrefused "ECONNREFUSED")
 (:integer ehostdown "EHOSTDOWN")
 (:integer ehostunreach "EHOSTUNREACH")
 (:integer ealready "EALREADY")
 (:integer einprogress "EINPROGRESS")
 (:integer estale "ESTALE")
 (:integer euclean "EUCLEAN")
 (:integer enotnam "ENOTNAM")
 (:integer enavail "ENAVAIL")
 (:integer eremoteio "EREMOTEIO")
 (:integer edquot "EDQUOT")
 (:integer enomedium "ENOMEDIUM")
 (:integer emediumtype "EMEDIUMTYPE")
 
 ;; mode_t
 (:type mode-t "mode_t")
 (:integer s-isuid "S_ISUID")
 (:integer s-isgid "S_ISGID")
 (:integer s-isvtx "S_ISVTX")
 (:integer s-irusr "S_IRUSR")
 (:integer s-iwusr "S_IWUSR")
 (:integer s-ixusr "S_IXUSR")
 (:integer s-iread "S_IRUSR")
 (:integer s-iwrite "S_IWUSR")
 (:integer s-iexec "S_IXUSR")
 (:integer s-irgrp "S_IRGRP")
 (:integer s-iwgrp "S_IWGRP")
 (:integer s-ixgrp "S_IXGRP")
 (:integer s-iroth "S_IROTH")
 (:integer s-iwoth "S_IWOTH")
 (:integer s-ixoth "S_IXOTH")

 ;; access()
 (:integer r-ok "R_OK")
 (:integer w-ok "W_OK")
 (:integer x-ok "X_OK")
 (:integer f-ok "F_OK")

 ;; mmap()
 (:type off-t "off_t")
 (:integer prot-none "PROT_NONE" #+sb-doc "mmap: no protection")
 (:integer prot-read "PROT_READ" #+sb-doc "mmap: read protection")
 (:integer prot-write "PROT_WRITE" #+sb-doc "mmap: write protection")
 (:integer prot-exec "PROT_EXEC" #+sb-doc "mmap: execute protection")
 (:integer map-shared "MAP_SHARED" #+sb-doc "mmap: shared memory")
 (:integer map-private "MAP_PRIVATE" #+sb-doc "mmap: private mapping")
 (:integer map-fixed "MAP_FIXED" #+sb-doc "mmap: map at given location")

 ;; msync()
 (:integer ms-async "MS_ASYNC" #+sb-doc "msync: return immediately")
 (:integer ms-sync "MS_SYNC" #+sb-doc "msync: perform synchronous writes")
 (:integer ms-invalidate "MS_INVALIDATE"
           #+sb-doc "msync: invalidate all cached data")

 ;; opendir()
 (:structure dirent
	     ("struct dirent"
	      (:c-string name "char *" "d_name"
			 :distrust-length #+sunos t #-sunos nil)))

 (:structure stat
	     ("struct stat"
	      (mode-t mode "mode_t" "st_mode")
	      (ino-t ino "ino_t" "st_ino")
	      (dev-t dev "dev_t" "st_dev")
	      (nlink-t nlink "nlink_t" "st_nlink")
	      (uid-t uid "uid_t" "st_uid")
	      (gid-t gid "gid_t" "st_gid")
	      (off-t size "off_t" "st_size")
	      (time-t atime "time_t" "st_atime")
	      (time-t mtime "time_t" "st_mtime")
	      (time-t ctime "time_t" "st_ctime")))

 ;; open()
 (:integer o-rdonly "O_RDONLY")
 (:integer o-wronly "O_WRONLY")
 (:integer o-rdwr "O_RDWR")
 (:integer o-creat "O_CREAT")
 (:integer o-excl "O_EXCL")
 (:integer o-noctty "O_NOCTTY")
 (:integer o-trunc "O_TRUNC")
 (:integer o-append "O_APPEND")
 (:integer o-nonblock "O_NONBLOCK")
 (:integer o-ndelay "O_NDELAY")
 (:integer o-sync "O_SYNC")
 (:integer o-nofollow "O_NOFOLLOW")
 (:integer o-directory "O_DIRECTORY")
 (:integer o-direct "O_DIRECT")
 (:integer o-async "O_ASYNC")
 (:integer o-largefile "O_LARGEFILE")	; hmm...
 (:integer o-dsync "O_DSYNC")
 (:integer o-rsync "O_RSYNC")

 ;; lseek()
 (:integer seek-set "SEEK_SET")
 (:integer seek-cur "SEEK_CUR")
 (:integer seek-end "SEEK_END")

 ;; fcntl()
 (:integer f-dupfd "F_DUPFD")
 (:integer f-getfd "F_GETFD")
 (:integer f-setfd "F_SETFD")
 (:integer f-getfl "F_GETFL")
 (:integer f-setfl "F_SETFL")
 (:integer f-getlk "F_GETLK")
 (:integer f-setlk "F_SETLK")
 (:integer f-setlkw "F_SETLKW")
 (:integer f-getown "F_GETOWN")
 (:integer f-setown "F_SETOWN")

 ;; tcgetattr(), tcsetattr()
 (:type cc-t "cc_t")
 (:type speed-t "speed_t")
 (:type tcflag-t "tcflag_t")
 (:integer nccs "NCCS")
 
 (:structure termios
	     ("struct termios"
	      (tcflag-t iflag "tcflag_t" "c_iflag")
	      (tcflag-t oflag "tcflag_t" "c_oflag")
	      (tcflag-t cflag "tcflag_t" "c_cflag")
	      (tcflag-t lflag "tcflag_t" "c_lflag")
	      ;; Uh, so what's the point of grovelling CC-T if I can't
	      ;; use it here?  the c_cc field is an array of NCCS
	      ;; elements of type cc_t.  FIXME
	      ((array (unsigned 8)) cc "cc_t" "c_cc")))
 
 (:integer veof "VEOF")
 (:integer veol "VEOL")
 (:integer verase "VERASE")
 (:integer vintr "VINTR")
 (:integer vkill "VKILL")
 (:integer vmin "VMIN")
 (:integer vquit "VQUIT")
 (:integer vstart "VSTART")
 (:integer vstop "VSTOP")
 (:integer vsusp "VSUSP")
 (:integer vtime "VTIME")

 (:integer brkint "BRKINT")
 (:integer icrnl "ICRNL")
 (:integer ignbrk "IGNBRK")
 (:integer igncr "IGNCR")
 (:integer ignpar "IGNPAR")
 (:integer inlcr "INLCR")
 (:integer inpck "INPCK")
 (:integer istrip "ISTRIP")
 #+xsi				     ; FIXME: an extension, apparently
 (:integer ixany "IXANY")
 (:integer ixoff "IXOFF")
 (:integer ixon "IXON")
 (:integer parmrk "PARMRK")

 (:integer opost "OPOST")
 #+xsi
 (:integer onlcr "ONLCR")
 (:integer ocrnl "OCRNL")
 (:integer onlret "ONLRET")
 (:integer ofill "OFILL")
 (:integer nldly "NLDLY")
 (:integer nl0 "NL0")
 (:integer nl1 "NL1")
 (:integer crdly "CRDLY")
 (:integer cr0 "CR0")
 (:integer cr1 "CR1")
 (:integer cr2 "CR2")
 (:integer cr3 "CR3")
 (:integer tabdly "TABDLY")
 (:integer tab0 "TAB0")
 (:integer tab1 "TAB1")
 (:integer tab2 "TAB2")
 (:integer tab3 "TAB3")
 (:integer bsdly "BSDLY")
 (:integer bs0 "BS0")
 (:integer bs1 "BS1")
 (:integer vtdly "VTDLY")
 (:integer vt0 "VT0")
 (:integer vt1 "VT1")
 (:integer ffdly "FFDLY")
 (:integer ff0 "FF0")
 (:integer ff1 "FF1")

 (:integer b0 "B0")
 (:integer b50 "B50")
 (:integer b75 "B75")
 (:integer b110 "B110")
 (:integer b134 "B134")
 (:integer b150 "B150")
 (:integer b200 "B200")
 (:integer b300 "B300")
 (:integer b600 "B600")
 (:integer b1200 "B1200")
 (:integer b1800 "B1800")
 (:integer b2400 "B2400")
 (:integer b4800 "B4800")
 (:integer b9600 "B9600")
 (:integer b19200 "B19200")
 (:integer b38400 "B38400")

 (:integer csize "CSIZE")
 (:integer cs5 "CS5")
 (:integer cs6 "CS6")
 (:integer cs7 "CS7")
 (:integer cs8 "CS8")
 (:integer cstopb "CSTOPB")
 (:integer cread "CREAD")
 (:integer parenb "PARENB")
 (:integer parodd "PARODD")
 (:integer hupcl "HUPCL")
 (:integer clocal "CLOCAL")

 (:integer echo "ECHO")
 (:integer echoe "ECHOE")
 (:integer echok "ECHOK")
 (:integer echonl "ECHONL")
 (:integer icanon "ICANON")
 (:integer iexten "IEXTEN")
 (:integer isig "ISIG")
 (:integer noflsh "NOFLSH")
 (:integer tostop "TOSTOP")

 (:integer tcsanow "TCSANOW")
 (:integer tcsadrain "TCSADRAIN")
 (:integer tcsaflush "TCSAFLUSH")

 (:integer tciflush "TCIFLUSH")
 (:integer tcioflush "TCIOFLUSH")
 (:integer tcoflush "TCOFLUSH")
 (:integer tcioff "TCIOFF")
 (:integer tcion "TCION")
 (:integer tcooff "TCOOFF")
 (:integer tcoon "TCOON")
 
 )
