/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.ScalaObject;
import scala.ScalaObject$class;

public class SocketConnection
implements ScalaObject {
    private String errorMessage;
    private BufferedReader in;
    private PrintWriter out;
    private Socket socket;
    private int port;
    private String hostname;

    public SocketConnection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public void close() {
        this.in().close();
        this.out().close();
        this.socket().close();
    }

    public boolean open() {
        boolean bl;
        try {
            this.socket_$eq(new Socket(this.hostname, this.port));
            this.out_$eq(new PrintWriter(this.socket().getOutputStream(), true));
            this.in_$eq(new BufferedReader(new InputStreamReader(this.socket().getInputStream())));
            bl = true;
        }
        catch (IOException iOException) {
            this.errorMessage_$eq("Couldn't get I/O for the connection to: " + this.hostname + ".");
            bl = false;
        }
        catch (UnknownHostException unknownHostException) {
            this.errorMessage_$eq("Don't know about host: " + this.hostname + ".");
            bl = false;
        }
        return bl;
    }

    public void errorMessage_$eq(String x$1) {
        this.errorMessage = x$1;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public void in_$eq(BufferedReader x$1) {
        this.in = x$1;
    }

    public BufferedReader in() {
        return this.in;
    }

    public void out_$eq(PrintWriter x$1) {
        this.out = x$1;
    }

    public PrintWriter out() {
        return this.out;
    }

    private void socket_$eq(Socket x$1) {
        this.socket = x$1;
    }

    private Socket socket() {
        return this.socket;
    }

    public SocketConnection(int port) {
        this(InetAddress.getLocalHost().getHostName(), port);
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

