/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kssl;

import com.sun.ksecurity.KeyStore;
import com.sun.kssl.Handshake;
import com.sun.kssl.HandshakeListener;
import com.sun.kssl.In;
import com.sun.kssl.Out;
import com.sun.kssl.Record;
import com.sun.kssl.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class SSLStreamConnection
implements StreamConnection {
    private static KeyStore trustedKeyStore = null;
    private static boolean trustedKeyStoreLocked = false;
    private static boolean trustedKeyStoreInitialized = false;
    private Record rec = null;
    private In uin = null;
    private Out uout = null;
    private InputStream sin = null;
    private OutputStream sout = null;
    private String host = null;
    private int port = 0;
    private boolean copen = false;
    boolean isopen = false;
    boolean osopen = false;

    public static synchronized void setTrustedKeyStore(KeyStore ks) {
        if (trustedKeyStoreLocked) {
            return;
        }
        trustedKeyStore = ks;
        trustedKeyStoreInitialized = true;
    }

    public static synchronized KeyStore getTrustedKeyStore() {
        if (!trustedKeyStoreInitialized) {
            try {
                trustedKeyStore = (KeyStore)Class.forName("com.sun.kssl.KSImpl").newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            trustedKeyStoreInitialized = true;
        }
        return trustedKeyStore;
    }

    public static synchronized void lockTrustedKeyStore() {
        if (trustedKeyStore == null) {
            return;
        }
        trustedKeyStoreLocked = true;
    }

    public SSLStreamConnection(String host, int port) throws IOException {
        this.setUp(host, port, null, null, null);
    }

    public SSLStreamConnection(String host, int port, HandshakeListener h) throws IOException {
        this.setUp(host, port, null, null, h);
    }

    public SSLStreamConnection(String host, int port, InputStream in, OutputStream out) throws IOException {
        this.setUp(host, port, in, out, null);
    }

    public SSLStreamConnection(String host, int port, InputStream in, OutputStream out, HandshakeListener h) throws IOException {
        this.setUp(host, port, in, out, h);
    }

    public synchronized InputStream openInputStream() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        if (this.isopen) {
            throw new IOException("Input stream already opened");
        }
        this.isopen = true;
        return this.uin;
    }

    public synchronized OutputStream openOutputStream() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        if (this.osopen) {
            throw new IOException("Output stream already opened");
        }
        this.osopen = true;
        return this.uout;
    }

    public DataInputStream openDataInputStream() {
        return new DataInputStream(this.uin);
    }

    public DataOutputStream openDataOutputStream() {
        return new DataOutputStream(this.uout);
    }

    public synchronized void close() throws IOException {
        if (this.copen) {
            this.copen = false;
            this.cleanupIfNeeded();
        }
    }

    private void setUp(String host, int port, InputStream in, OutputStream out, HandshakeListener h) throws IOException {
        this.host = host;
        this.port = port;
        if (in == null || out == null) {
            try {
                StreamConnection s = (StreamConnection)Connector.open((String)("socket://" + host + ":" + port));
                this.sin = s.openInputStream();
                this.sout = s.openOutputStream();
                s.close();
            }
            catch (IOException e) {
                this.cleanupIfNeeded();
                throw new IOException("Could not establish TCP connection with " + host + ":" + port);
            }
        } else {
            this.sin = in;
            this.sout = out;
        }
        this.rec = new Record(1, this.sin, this.sout);
        this.uin = new In(this.rec, this);
        this.uout = new Out(this.rec, this);
        Handshake hndshk = null;
        try {
            hndshk = new Handshake(host, port, this.rec, h);
            hndshk.doHandShake((byte)1);
            hndshk.destroy();
        }
        catch (IOException e) {
            if (hndshk != null) {
                hndshk.destroy();
            }
            this.cleanupIfNeeded();
            throw e;
        }
        this.copen = true;
    }

    void cleanupIfNeeded() throws IOException {
        if (this.copen || this.isopen || this.osopen || this.rec == null) {
            return;
        }
        try {
            this.rec.alert((byte)1, (byte)0);
        }
        catch (IOException e) {
            Utils.logln((byte)3, "Could not send close_notify");
        }
        this.rec.destroy();
        this.rec = null;
        this.uin = null;
        this.uout = null;
        this.copen = false;
        this.host = null;
        this.sin.close();
        this.sin = null;
        this.sout.close();
        this.sout = null;
    }
}

