/* NSC -- new Scala compiler
 * Copyright 2005-2007 LAMP/EPFL
 * @author Martin Odersky
 */
// $Id: SyntaxAnalyzer.scala 12914 2007-09-20 08:15:36Z mcdirmid $

package scala.tools.nsc.ast.parser

/** An nsc sub-component.
 */ 
abstract class SyntaxAnalyzer extends SubComponent with Parsers with MarkupParsers with NewScanners {

  val phaseName = "parser"

  def newPhase(prev: Phase): StdPhase = new ParserPhase(prev)

  class ParserPhase(prev: scala.tools.nsc.Phase) extends StdPhase(prev) {
    def apply(unit: global.CompilationUnit) {
      global.informProgress("parsing " + unit)
      val parser = new UnitParser(unit)
      unit.body = parser.parse()
    }
  }
}

