/*
  neg.cc, copyright (c) 2006 by Vincent Fourmond: 
  The class implemenation for negation.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

#include <calc_internals.hh>

namespace SCalc {

  std::string Neg::pretty_print()
  {
    std::string retval = "-";
    retval += neg->pretty_print();
    return retval;
  }

  Expression * Neg::simplify()
  {
    Expression * sub = neg->simplify();
    if(sub->is_null())
      {
	delete sub;
	return new Null(session());
      }
    if(sub->is_const())
      {
	double val = sub->evaluate(NULL, NULL);
	delete sub;
	return new Const(session(), - val);
      }
    return new Neg(session(), sub);
  }

};
