# scamper Makefile for use with GNU make
# $Id: Makefile.gnu,v 1.54 2007/03/06 03:08:49 mjl Exp $

CFLAGS+=		-Wall
LDFLAGS+=		-Wall
OBJS=			scamper.o \
			scamper_list.o scamper_tlv.o \
			utils.o \
			scamper_do_trace.o scamper_trace.o \
			scamper_do_ping.o scamper_ping.o \
			scamper_addresslist.o \
			scamper_debug.o \
			scamper_udp4.o scamper_udp6.o \
			scamper_icmp4.o scamper_icmp6.o scamper_icmp_resp.o \
			scamper_tcp4.o scamper_tcp6.o \
			scamper_ip6.o \
			scamper_rtsock.o scamper_dl.o scamper_addr2mac.o \
			scamper_fds.o scamper_linepoll.o scamper_writebuf.o \
			scamper_privsep.o scamper_getsrc.o \
			mjl_list.o mjl_splaytree.o mjl_heap.o \
			scamper_file.o scamper_file_traceroute.o \
			scamper_file_warts.o scamper_file_arts.o \
			scamper_control.o \
			scamper_outfiles.o scamper_addr.o scamper_probe.o \
			scamper_target.o scamper_task.o scamper_queue.o \
			scamper_cyclemon.o scamper_options.o

HDRS=			scamper.h scamper_addr.h utils.h

LIBSCAMPERFILE_OBJS=	scamper_file.o scamper_trace.o scamper_file_arts.o \
			scamper_file_warts.o scamper_file_traceroute.o \
			mjl_splaytree.o utils.o scamper_addr.o \
			scamper_list.o scamper_ping.o scamper_tlv.o

ifdef WITH_DEBUG
CFLAGS+=		-g
else
CFLAGS+=		-DNDEBUG
endif

ifdef WITHOUT_PRIVSEP
CFLAGS+=		-DWITHOUT_PRIVSEP
endif

all:			scamper libscamperfile.a warts-dump sc_analysis_dump \
			warts2traceroute sc_sorter warts-cat

scamper:		${OBJS}
			${CC} -o scamper ${LDFLAGS} ${OBJS} 

libscamperfile.a:	${LIBSCAMPERFILE_OBJS}
			rm -f $@
			ar cq $@ ${LIBSCAMPERFILE_OBJS}
			ranlib $@

warts-cat:		warts-cat.o mjl_heap.o libscamperfile.a
			${CC} -o warts-cat ${LDFLAGS} \
				warts-cat.o mjl_heap.o -L./ -lscamperfile

warts-dump:		warts-dump.o libscamperfile.a
			${CC} -o warts-dump ${LDFLAGS} \
				warts-dump.o -L./ -lscamperfile

sc_analysis_dump:	sc_analysis_dump.o libscamperfile.a
			${CC} -o sc_analysis_dump ${LDFLAGS} \
				sc_analysis_dump.o -L./ -lscamperfile

sc_sorter:		sc_sorter.o libscamperfile.a
			${CC} -o sc_sorter ${LDFLAGS} \
				sc_sorter.o -L./ -lscamperfile

warts2traceroute:	warts2traceroute.o libscamperfile.a
			${CC} -o warts2traceroute ${LDFLAGS} \
				warts2traceroute.o -L./ -lscamperfile

clean:
			rm -f scamper ${OBJS} *~ \
				warts-dump warts-dump.o warts-dump.core \
				sc_analysis_dump sc_analysis_dump.o \
				sc_analysis_dump.core \
				warts2traceroute warts2traceroute.o \
				warts2traceroute.core \
				sc_sorter sc_sorter.o sc_sorter.core \
				warts-cat warts-cat.o warts-cat.core \
				libscamperfile.a scamper.core

install:		all
			mv scamper scamper.bin
			install -m 4755 -o root scamper.bin scamper
			rm scamper.bin
