/*
 * scamper_dlhdr.h
 *
 * $Id: scamper_dlhdr.h,v 1.2 2009/07/13 10:00:13 mjl Exp $
 *
 * Copyright (C) 2003-2009 The University of Waikato
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __SCAMPER_DLHDR_H
#define __SCAMPER_DLHDR_H

/*
 * scamper_dlhdr
 *
 * this struct holds appropriate layer-2 headers to prepend on a packet
 * to be transmitted with a datalink socket.
 */
typedef struct scamper_dlhdr
{
  uint8_t  *buf;
  uint16_t  len;
} scamper_dlhdr_t;

/*
 * scamper_dlhdr_get:
 *
 * given a datalink socket and a gateway address, form a datalink header
 * to use when framing a packet.
 */
int scamper_dlhdr_get(scamper_task_t *task, scamper_fd_t *fd,
		      scamper_addr_t *dst, scamper_addr_t *gw,
		      void (*cb)(scamper_task_t *, scamper_dlhdr_t *));

/*
 * scamper_dl_hdr_free:
 *
 * don't need the dl_hdr any longer.
 */
void scamper_dlhdr_free(scamper_dlhdr_t *dlhdr);

#endif /* __SCAMPER_DLHDR_H */
