/*
 * Schism Tracker - a cross-platform Impulse Tracker clone
 * copyright (c) 2003-2005 Storlek <storlek@rigelseven.com>
 * copyright (c) 2005-2008 Mrs. Brisby <mrs.brisby@nimh.org>
 * copyright (c) 2009 Storlek & Mrs. Brisby
 * copyright (c) 2010 Storlek
 * URL: http://schismtracker.org/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef SCHISM_VERSION_H
#define SCHISM_VERSION_H

#ifdef __cplusplus
extern "C" {
#endif

/* various boilerplate defined in version.c */
extern const char *ver_short_copyright;
extern const char *ver_short_based_on;
extern short ver_cwtv; /* lower 12 bits of the IT/S3M cwtv field */

extern const char *schism_banner(int classic)
        __attribute__((pure));

/* little hack, need to call this at startup */
void ver_init(void);

/* get yyyy-mm-dd or 0.nn version from cwtv (buf should be >=11 chars) */
void ver_decode_cwtv(uint16_t cwtv, char *buf);

#ifdef __cplusplus
}
#endif

#endif

