module Schleuder
  class Member < Storage
    attr_accessor :email
    attr_accessor :mime
    # only send encrypted mail to this member 
    attr_accessor :encrypted_only
    attr_accessor :key

    def initialize(config_file, fromfile=true)
      super config_file, fromfile
    end

    def to_hash
      h = {}
      instance_variables.each { |iv|
        h[iv[1..-1]] = instance_variable_get(iv) unless instance_variable_get(iv).nil? or instance_variable_get(iv).empty?
      }
      h['key'] = h['key'].subkeys.first.fpr[32..-1] if h['key']
      h
    end
  end
end
