/* gtkplotart - libart driver
 * Copyright 1999-2001  Adrian E. Feiguin <feiguin@ifir.edu.ar>
 */

#ifndef __GTK_PLOT_ART_H__
#define __GTK_PLOT_ART_H__

#ifdef WITH_LIBART

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <libart_lgpl/libart.h>
#include <gtkextra/gtkplotgdk.h>


#define GTK_PLOT_ART(obj)        GTK_CHECK_CAST (obj, gtk_plot_art_get_type (), GtkPlotArt)
#define GTK_TYPE_PLOT_ART   (gtk_plot_art_get_type ())

#define GTK_PLOT_ART_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, gtk_plot_art_get_type(), GtkPlotArtClass)
#define GTK_IS_PLOT_ART(obj)     GTK_CHECK_TYPE (obj, gtk_plot_art_get_type ())


typedef struct _GtkPlotArt GtkPlotArt;
typedef struct _GtkPlotArtClass GtkPlotArtClass;

struct _GtkPlotArt
{
   GtkPlotGdk pc;

   art_u8 *buf;

   gint orientation;

   gint units;
   gint page_size;
   gint width, height;

   gint page_width;
   gint page_height;

   gdouble scalex, scaley;

   GdkLineStyle line_style;
   gfloat line_width;
   ArtPathStrokeJoinType join_style;
   ArtPathStrokeCapType cap_style;
   ArtVpathDash dash;
};

struct _GtkPlotArtClass
{
   GtkPlotGdkClass parent_class;
};

GtkType    gtk_plot_art_get_type                        (void);
GtkObject *gtk_plot_art_new                             (GdkDrawable *drawable);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* WITH_LIBART */

#endif /* __GTK_PLOT_ART_H__ */

