#ifndef __PYTHON_SHEET_H__
#define __PYTHON_SHEET_H__

#include <glib.h>
#include <gtk/gtk.h>
#include "../sg_worksheet.h"
#include "python_main.h"

typedef struct _SGmod_py SGmod_py;
typedef struct _SGfunc_py SGfunc_py;



struct _SGmod_py
{
  gchar *mod, *name, *desc;

  GSList *funcs;

};

struct _SGfunc_py
{
  gchar *func, *name, *desc;

  GSList *args;

};


int python_insert_object(SGworksheet *worksheet,gint row, gint col,
                         PyObject *object,GtkOrientation orient,
                         gboolean link,gboolean as_is);

int python_sheet(SGworksheet *worksheet,
                 gint row, gint col,
                 gchar *command,
                 GtkOrientation orient);

PyObject *python_eval_expr(gchar *command);

int python_array	(SGworksheet *worksheet,
			 gint row,
			 gint col,
			 PyArrayObject *object,
			 GtkOrientation orient,
			 gboolean link);
 
int python_sequence	(SGworksheet *worksheet,
			 gint row, gint col,
			 PyObject *object,
			 GtkOrientation orient,
			 gboolean link,
			 gboolean as_is);
			 
int python_singleton	(SGworksheet *worksheet,
			 gint row, gint col,
			 PyObject *object,
			 gboolean link,
			 gboolean as_is);

#endif /*__PYTHON_SHEET_H__ */
