/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_worksheet_tools.h"
#include "sg.h"
#include "sg_dialogs.h"
#include "sg_formula_dialog.h"
#include "sg_worksheet.h"
#include "sg_clipboard.h"
#include "sg_menu.h"
#include "../pixmaps/pixmaps.h"

static void worksheet_import		(GtkWidget *widget, gpointer data);
static void worksheet_export		(GtkWidget *widget, gpointer data);
static void worksheet_add_column 	(GtkWidget *widget, gpointer data);
static void worksheet_set_column 	(GtkWidget *widget, gpointer data);
static void worksheet_cut	 	(GtkWidget *widget, gpointer data);
static void worksheet_copy	 	(GtkWidget *widget, gpointer data);
static void worksheet_paste	 	(GtkWidget *widget, gpointer data);
static void worksheet_recalc	 	(GtkWidget *widget, gpointer data);

GtkWidget *
sg_worksheet_build_toolbar(SGworksheet *worksheet)
{
  GnomeUIInfo worksheet_toolbar[] =
  {
      GNOMEUIINFO_ITEM_DATA("Import", "Import file", worksheet_import,
                             worksheet,
                             open_xpm),
      GNOMEUIINFO_ITEM_DATA("Save", "Save worksheet", worksheet_export,
                             worksheet,
                             save_xpm),
      GNOMEUIINFO_SEPARATOR,
      GNOMEUIINFO_ITEM_DATA("Cut", "Cut", worksheet_cut,
                             worksheet,
                             cut_xpm),
      GNOMEUIINFO_ITEM_DATA("Copy", "Copy", worksheet_copy,
                             worksheet,
                             copy_xpm),
      GNOMEUIINFO_ITEM_DATA("Paste", "Paste", worksheet_paste,
                             worksheet,
                             paste_xpm),
      GNOMEUIINFO_SEPARATOR,
      GNOMEUIINFO_ITEM_DATA("Column", "Add new column", worksheet_add_column,
                             worksheet,
                            add_column_xpm),
      GNOMEUIINFO_ITEM_DATA("Values", "Set column values", worksheet_set_column,
                             worksheet,
                            set_column_xpm),
      GNOMEUIINFO_ITEM_DATA("Recalc", "Recalculate selected cells", worksheet_recalc,
                             worksheet,
                             reload_xpm),

      GNOMEUIINFO_END
  };

#ifdef WITH_GNOME
  gnome_app_create_toolbar(GNOME_APP(worksheet) , worksheet_toolbar);
#else
  sg_ui_create_toolbar(GTK_BIN(worksheet)->child , worksheet_toolbar);
#endif /* WITH_GNOME */
  return NULL;
}

static void
worksheet_import (GtkWidget *widget, gpointer data)
{
  active_worksheet = (SGworksheet *) data;
  sg_worksheet_import();
}

static void
worksheet_export (GtkWidget *widget, gpointer data)
{
  active_worksheet = (SGworksheet *) data;
  sg_worksheet_export();
}

static void
worksheet_add_column (GtkWidget *widget, gpointer data)
{
  active_worksheet = (SGworksheet *) data;
  sg_worksheet_add_columns(active_worksheet, 1);
  gtk_sheet_select_column(GTK_SHEET(active_worksheet->sheet), 
			  GTK_SHEET(active_worksheet->sheet)->maxcol);
}

static void
worksheet_set_column (GtkWidget *widget, gpointer data)
{
  GtkSheet *sheet;
  active_worksheet = (SGworksheet *) data;
  sheet = GTK_SHEET(active_worksheet->sheet);

  if(sheet->state == GTK_SHEET_COLUMN_SELECTED)
     sg_formula_dialog(active_worksheet, sheet->range.col0);

}

static void
worksheet_cut (GtkWidget *widget, gpointer data)
{
  active_worksheet = (SGworksheet *) data;
  sg_clipboard_copy(active_worksheet,TRUE);
}

static void
worksheet_copy (GtkWidget *widget, gpointer data)
{
  active_worksheet = (SGworksheet *) data;
  sg_clipboard_copy(active_worksheet,FALSE);
}

static void
worksheet_paste (GtkWidget *widget, gpointer data)
{
  active_worksheet = (SGworksheet *) data;
  sg_clipboard_paste(active_worksheet);
}

static void
worksheet_recalc (GtkWidget *widget, gpointer data)
{ 
  GtkSheet *sheet;
  active_worksheet = (SGworksheet *) data;
  sheet=GTK_SHEET(active_worksheet->sheet);
  
  sg_worksheet_unupdate_exp_range(active_worksheet,
               sheet->range.row0,sheet->range.rowi,
               sheet->range.col0,sheet->range.coli);

  sg_worksheet_update_exp_range(active_worksheet,
               sheet->range.row0,sheet->range.rowi,
               sheet->range.col0,sheet->range.coli);
}
