/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <Python.h>
#include "sg_stock.h"
#include "sg_xy_formula_dialog.h"
#include "python/python_main.h"

static GtkWidget *name_entry;
static GtkWidget *from_row_spin;
static GtkWidget *to_row_spin;
static GtkWidget *from_col_spin;
static GtkWidget *to_col_spin;
static GtkSheet  *the_sheet;
static GtkWidget *window;


static void
update_worksheet(GtkWidget *widget,gpointer data)
{
  gchar *text;
  gint from_row, to_row;
  gint from_col, to_col;
  gint i;
  SGworksheet *worksheet;
  
  worksheet=(SGworksheet *)data;
  text = gtk_entry_get_text(GTK_ENTRY(name_entry));
  if(worksheet->matrix.exp)
    g_free(worksheet->matrix.exp);
  worksheet->matrix.exp=g_strdup(text);
  from_row = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(from_row_spin));
  to_row = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(to_row_spin));
  from_col = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(from_col_spin));
  to_col = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(to_col_spin));

  sg_worksheet_update_matrix_exp(worksheet,text,
                                   from_col, to_col,
                                   from_row, to_row);

  gtk_widget_destroy(window);
}


void
sg_xy_formula_dialog (SGworksheet *worksheet)
{
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *ok_button, *cancel_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkWidget *label;
  GtkAdjustment *adj;

  the_sheet = GTK_SHEET(worksheet->sheet);

  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW(window),"Matrix values");

  gtk_window_set_modal (GTK_WINDOW(window),TRUE);

  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (main_box), frame, FALSE, FALSE, 0);

  table = gtk_table_new(4, 4, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  label = gtk_label_new("From Row"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 0, 1);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., the_sheet->maxrow, 1., 1., 0.);
  from_row_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(from_row_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(from_row_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), from_row_spin, 1, 2, 0, 1);

  label = gtk_label_new("To Row"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 0, 1);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., the_sheet->maxrow, 1., 1., 0.);
  to_row_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(to_row_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(to_row_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), to_row_spin, 3, 4, 0, 1);

  label = gtk_label_new("From Column"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 1, 2);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., the_sheet->maxcol, 1., 1., 0.);
  from_col_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(from_col_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(from_col_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), from_col_spin, 1, 2, 1, 2);

  label = gtk_label_new("To Column"),
  gtk_misc_set_alignment(GTK_MISC(label), 1., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            2, 3, 1, 2);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., the_sheet->maxcol, 1., 1., 0.);
  to_col_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(to_col_spin), TRUE);
  gtk_spin_button_set_digits(GTK_SPIN_BUTTON(to_col_spin), 0);
  gtk_table_attach_defaults(GTK_TABLE(table), to_col_spin, 3, 4, 1, 2);

  gtk_table_attach(GTK_TABLE(table), gtk_hseparator_new(), 0, 4, 2, 3,
                   (GtkAttachOptions)0,
                   (GtkAttachOptions)(GTK_FILL|GTK_EXPAND), 0, 0);

  name_entry = gtk_entry_new();   

  label = gtk_label_new("Matrix(x,y)=");
  gtk_misc_set_alignment(GTK_MISC(label), 0.5, .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 3, 4);
  gtk_table_attach_defaults(GTK_TABLE(table), name_entry, 1, 4, 3, 4);

  /* Action Area */
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = sg_stock_button ("Button_Ok");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);

  cancel_button = sg_stock_button ("Button_Cancel");
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (window));

  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (update_worksheet),
                             (gpointer)worksheet);
  gtk_signal_connect (GTK_OBJECT (name_entry), "activate",
                             GTK_SIGNAL_FUNC (update_worksheet),
                             (gpointer)worksheet);


/*  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),NULL);*/

  if(worksheet->matrix.exp)
    gtk_entry_set_text(GTK_ENTRY(name_entry),worksheet->matrix.exp);
  else
    gtk_entry_set_text(GTK_ENTRY(name_entry), "");

  gtk_editable_select_region(GTK_EDITABLE(name_entry),0,-1);
  gtk_editable_set_position(GTK_EDITABLE(name_entry),-1);

  /* Show widgets */

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(from_row_spin), 0);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(to_row_spin), the_sheet->maxrow);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(from_col_spin), 0);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(to_col_spin), the_sheet->maxcol);
  gtk_widget_grab_focus(name_entry);
  gtk_widget_show_all (window);

  return;
}
