//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function [dv,anv]=CL__man_raps(rman,a1,a2,mu)


// Declarations:


// Code:

N = size(rman,2);
dv = zeros(3,N);
anv = zeros(1,N);

//velocity first impulsion
vit1 = sqrt(mu.*(2.0./rman - 1.0./a1));

//velocity second impulsion
vit2 = sqrt(mu.*(2.0./rman - 1.0./a2));

//true anomaly of maneuver execution point
i3 = find(rman./a1<1);
i4 = find(~(rman./a1<1));
anv(i3) = 0;  //maneuver at periapsis
anv(i4) = %pi;  //maneuver at apoapsis

//maneuver in spheric coordinates in qsw
dv(3,:) = vit2-vit1;
i5 = find(dv(3,:)>0);
i6 = find(~(dv(3,:)>0));
dv(1,i5) = %pi/2;
dv(1,i6) = %pi/2 + %pi;
dv(2,:) = 0;
dv(3,:) = abs(dv(3,:));

endfunction

