//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function [x_deg] = CL_rad2deg(x_rad)
// radians to degrees unit conversion 
//
// Calling Sequence
// [x_deg] = CL_rad2deg(x_rad)
//
// Description
// <itemizedlist><listitem>
// Conversion from radians to degrees. 
// <para>Note: %CL_rad2deg can also be used</para>
// </listitem></itemizedlist>
//
// Parameters
// x_rad: Quantity expressed in radians (PxNxK)
// x_deg: Quantity expressed in degrees (PxNxK)
//
// Authors
// CNES - DCT/SB
//
// See also
// CL_deg2rad
//
// Examples
// CL_rad2deg(%pi/4)

// Declarations:
if(~exists('%CL_rad2deg')) then global %CL_rad2deg; end;

// Code:

x_deg = x_rad * %CL_rad2deg;

endfunction

