//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.



// Demo file for Clohessy-Wiltshire functions
// CW propagation

//input data
tini = 0;
tpv_ini = [-35000,0,6000,10.070665,0,0]';
alt_ci = 450000;
area_ch = 50;
area_ci = 200;
mass_ch = 20000;
mass_ci = 400000;
cdrag_ch = 1;
cdrag_ci = 1;
bal_coef_ch = area_ch*cdrag_ch/mass_ch;
bal_coef_ci = area_ci*cdrag_ci/mass_ci;
tfin = 10000;
pv_closing = [-250,0,0,0,0,0]';
pv_homing = [-3500,0,0,0,0,0]';

[Hl_imp,Hl_cont] = CL_cw_hohmannLine();
periode = CL_kp_params('per',%CL_eqRad+alt_ci);

//CHOISIR LE TYPE DE POUSSEE IMPULSIONNELLE (imp) CONTINUE (cont)
choice = list()
choice(1) = list('Type of maneuver',1,['Two_impulse transfer','Continuous burn transfer'])
rep = x_choices('CW propagation demo',choice)

select rep
case 1 //two_impulse transfer

  d = tpv_ini(3)/tan(Hl_imp)+3500;
  [xp] = CL_cw_circularDrift(alt_ci,tpv_ini(3));
  tdeb = (tpv_ini(1)+d)/xp;

  //Derive jusqu'au debut du homing
  [mat_M] = CL_cw_Mmatrix(alt_ci,tini-tdeb);
  posvit_ini = mat_M*tpv_ini;
  //Calcul du debut des manoeuvvres pour viser pv_homing et pv_closing
  [delta_vi_ho,delta_vf_ho] = CL_cw_twoImpulse(posvit_ini,pv_homing,alt_ci,periode/2);
  [delta_vi_cl,delta_vf_cl] = CL_cw_twoImpulse(pv_homing,pv_closing,alt_ci,periode/2);

  mant = [];
  mant(1) = [abs(tdeb)];
  mant(2) = [abs(tdeb)+periode/2];
  mant(3) = [6000];
  mant(4) = [6000+periode/2];
  mant = mant'

  man = [];
  man(1,:) = [delta_vi_ho'];
  man(2,:) = [delta_vf_ho'];
  man(3,:) = [delta_vi_cl'];
  man(4,:) = [delta_vi_cl'];
  man = man'

  CW_traj = [];

  [CW_dates,CW_traj] = CL_cw_impulPropa(tini,tpv_ini,mant,man,alt_ci,tfin,ballistic_coef_chaser=bal_coef_ch,ballistic_coef_target=bal_coef_ci);
  CW_traj = CW_traj';
  CW_dates = CW_dates';

case 2 //continuous burn transfer

  //Derive jusqu'au debut du homing
  d = tpv_ini(3)/tan(Hl_cont)+3500;
  [xp] = CL_cw_circularDrift(alt_ci,tpv_ini(3));
  tfin_bal = (-tpv_ini(1)-d)/xp;

  [CW_dates,CW_traj] = CL_cw_ballisticPropa(tini,tpv_ini,alt_ci,tfin_bal,ballistic_coef_chaser=bal_coef_ch,ballistic_coef_target=bal_coef_ci);
  [moyen_mvt] = CL_op_paramsJ2('mm',%CL_eqRad+alt_ci,0.0001,CL_deg2rad(51.6));

  //Homing
  acc_diff = tpv_ini(3)*moyen_mvt**2/(4*%pi); //Gx = w2/4pi*Dz
  gama = [acc_diff,0,0]';
  tfin = periode;
  [CW_dat,CW_ephem] = CL_cw_contPropa(CW_dates(1,$),CW_traj(:,$),gama,alt_ci,periode+tfin_bal,ballistic_coef_chaser=bal_coef_ch,ballistic_coef_target=bal_coef_ci);

  CW_traj = [CW_traj CW_ephem];
  CW_dates = [ CW_dates CW_dat ];
  //Closing
  acc_diff = (CW_traj(1,$)+250)*moyen_mvt**2/(4*%pi); //Gx = w2/4pi*Dx
  gama = [0,0,-acc_diff]';

  CW_ephem = [];
  [CW_dat,CW_ephem] = CL_cw_contPropa(CW_dates(1,$),CW_traj(:,$),gama,alt_ci,tfin_bal+2*periode,ballistic_coef_chaser=bal_coef_ch,ballistic_coef_target=bal_coef_ci);

  CW_traj = [CW_traj CW_ephem];
  CW_traj = CW_traj';
  CW_dates = [ CW_dates CW_dat ];
  CW_dates = CW_dates';

end

if rep > 0

// Trac des courbes
f1=scf();
f1.visible="off";

plot2d(CW_traj(:,1)/1000,CW_traj(:,3)/1000,2);
a = gca();
a.title.text = "Relative position";
a.x_label.text = "x (km)";
a.x_location  =  "bottom";
a.y_label.text = "z (km)";
a.y_location  =  "right";
a.axes_reverse  =  ["off","on","off"];
a.children.children.thickness=2;
a.box="on"; 
a.grid=[0,0];
a.sub_ticks=[0,0];


f2=scf();
f2.visible="off";

subplot(2,2,1);
plot2d(CW_traj(:,1)/1000,CW_traj(:,2)/1000,2);
a = gca();
a.box="on"; 
a.grid=[0,0];
a.sub_ticks=[0,0];
a.title.text = "Relative position";
a.x_label.text = "x (km)";
a.x_location  =  "bottom";
a.y_label.text = "y (km)";
a.y_location  =  "right";

subplot(2,2,2);
plot2d(CW_dates(:,1)/60,CW_traj(:,4),2);
a = gca();
a.title.text = "Relative velocity (Vx)";
a.x_label.text = "t (min)";
a.x_location  =  "bottom";
a.y_label.text = "Vx (m/s)";
a.y_location  =  "right";

subplot(2,2,3);
plot2d(CW_dates(:,1)/60,CW_traj(:,5),2);
a = gca();
a.title.text = "Relative velocity (Vy)";
a.x_label.text = "t (min)";
a.x_location  =  "bottom";
a.y_label.text = "Vy (m/s)";
a.y_location  =  "right";

subplot(2,2,4);
plot2d(CW_dates(:,1)/60,CW_traj(:,6),2);
a = gca();
a.title.text = "Relative velocity (Vz)";
a.x_label.text = "t (min)";
a.x_location  =  "bottom";
a.y_label.text = "Vz (m/s)";
a.y_location  =  "right";

for k=1:4 
  subplot(2,2,k);
  a=gca();
  a.margins = [0.1,0.15,0.2,0.2];
  a.box="on"; 
  a.grid=[0,0];
  a.sub_ticks=[0,0];
  a.children.children.thickness=2;
end


f1.visible="on";
f2.visible="on";

end

