//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function [means,cov]=CL_stat(samples)
// Statistics on a matrix of samples
//
// Calling Sequence
// [means,cov] = CL_stat(samples)
//
// Description
// <itemizedlist><listitem>
// <p>Computes the mean and the covariance matrix from samples.</p> 
// </listitem>
// </itemizedlist>
//
// Parameters
// samples: Matrix of sample values. Each column vector is a different sample. Each sample contains the values of P (random) variables. (PxN)
// means: Estimated mean values (Px1)
// cov: Estimated covariance matrix (PxP)
//
// Authors
// CNES - DCT/SB
//
// See also
// CL_cor2cov
//
// Examples
// // given correlation in cartesian orbital elements, 
// // compute correlation in adapted circular 
// // orbital elements with Monte Carlo process
// bul = [-1877901 -3909428 -5026025 7428.157 -1541.857 -1576.532]'; 
// cor = [1 -0.467016 -0.447601 0.960396 0.987145 0.995826;...
//      0 1 -0.088751 -0.359696 -0.412472 -0.540655;...
//      0 0 1 -0.248472 -0.582834 -0.431908;...
//      0 0 0 1 0.915197 0.943178;...
//      0 0 0 0 1 0.980679;...
//      0 0 0 0 0 1]; //upper triangle of correlation matrix
// cor = cor+cor'-eye(cor); // correlation matrix (symetrical)
// // standard deviations
// sd = [15939.68154 2912.099353 3079.494708 6.81910416 9.50017639 12.14624495]'; 
// cov = CL_cor2cov(cor,sd);
// // Draw 10000 samples following correlation :
// drawn_car = CL_covDraw(bul,cov,10000);  
// // Convert samples to adapted circular :
// drawn_cir = CL_oe_car2cir(drawn_car(1:3,:),drawn_car(4:6,:));  
// [mean_cir,cov_cir] = CL_stat(drawn_cir);
//

// Declarations:


// Code:

means = mean(samples,2);
cov = mvvacov(samples');

endfunction
