#include "ScilabJavaObject.hxx"
/* Generated by GIWS (version 2.0.0) with command:
giws -e -r -g -f ScilabObjects.giws.xml 
*/
/*

Copyright 2007-2008 INRIA
Copyright 2008-2011 DIGITEO
Copyright 2011-2012 Scilab Enterprises

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_forge_jims {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * ScilabJavaObject::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

ScilabJavaObject::~ScilabJavaObject() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
ScilabJavaObject::ScilabJavaObject(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jintinvokejintintjstringjava_lang_StringjintArray_intintID=NULL;
voidinitScilabJavaObjectID=NULL;
voidgarbageCollectID=NULL;
jstringgetRepresentationjintintID=NULL;
jbooleanisValidJavaObjectjintintID=NULL;
voidenableTracejstringjava_lang_StringID=NULL;
voiddisableTraceID=NULL;
voidsetFieldjintintjstringjava_lang_StringjintintID=NULL;
jintgetFieldjintintjstringjava_lang_StringID=NULL;
jintgetFieldTypejintintjstringjava_lang_StringID=NULL;
jintjavaCastjintintjstringjava_lang_StringID=NULL;
jintjavaCastjintintjintintID=NULL;
jstringgetClassNamejintintID=NULL;
jintgetArrayElementjintintjintArray_intintID=NULL;
voidsetArrayElementjintintjintArray_intintjintintID=NULL;
voidremoveScilabJavaObjectjintintID=NULL;
voidlimitDirectBufferjintintID=NULL;
jintisUnwrappablejintintID=NULL;
jintwrapDoublejdoubledoubleID=NULL;
jintwrapDoublejdoubleArray_doubledoubleID=NULL;
jintwrapDoublejobjectArray__doubledoubleID=NULL;
jintwrapIntjintintID=NULL;
jintwrapIntjintArray_intintID=NULL;
jintwrapIntjobjectArray__intintID=NULL;
jintwrapUIntjlonglongID=NULL;
jintwrapUIntjlongArray_longlongID=NULL;
jintwrapUIntjobjectArray__longlongID=NULL;
jintwrapBytejbytebyteID=NULL;
jintwrapBytejbyteArray_bytebyteID=NULL;
jintwrapBytejobjectArray__bytebyteID=NULL;
jintwrapUBytejshortshortID=NULL;
jintwrapUBytejshortArray_shortshortID=NULL;
jintwrapUBytejobjectArray__shortshortID=NULL;
jintwrapShortjshortshortID=NULL;
jintwrapShortjshortArray_shortshortID=NULL;
jintwrapShortjobjectArray__shortshortID=NULL;
jintwrapUShortjintintID=NULL;
jintwrapUShortjintArray_intintID=NULL;
jintwrapUShortjobjectArray__intintID=NULL;
jintwrapStringjstringjava_lang_StringID=NULL;
jintwrapStringjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintwrapStringjobjectArray__java_lang_Stringjava_lang_StringID=NULL;
jintwrapBooleanjbooleanbooleanID=NULL;
jintwrapBooleanjbooleanArray_booleanbooleanID=NULL;
jintwrapBooleanjobjectArray__booleanbooleanID=NULL;
jintwrapCharjcharcharID=NULL;
jintwrapCharjcharArray_charcharID=NULL;
jintwrapCharjobjectArray__charcharID=NULL;
jintwrapFloatjfloatfloatID=NULL;
jintwrapFloatjfloatArray_floatfloatID=NULL;
jintwrapFloatjobjectArray__floatfloatID=NULL;
jintwrapLongjlonglongID=NULL;
jintwrapLongjlongArray_longlongID=NULL;
jintwrapLongjobjectArray__longlongID=NULL;


}

ScilabJavaObject::ScilabJavaObject(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        jintinvokejintintjstringjava_lang_StringjintArray_intintID=NULL;
voidinitScilabJavaObjectID=NULL;
voidgarbageCollectID=NULL;
jstringgetRepresentationjintintID=NULL;
jbooleanisValidJavaObjectjintintID=NULL;
voidenableTracejstringjava_lang_StringID=NULL;
voiddisableTraceID=NULL;
voidsetFieldjintintjstringjava_lang_StringjintintID=NULL;
jintgetFieldjintintjstringjava_lang_StringID=NULL;
jintgetFieldTypejintintjstringjava_lang_StringID=NULL;
jintjavaCastjintintjstringjava_lang_StringID=NULL;
jintjavaCastjintintjintintID=NULL;
jstringgetClassNamejintintID=NULL;
jintgetArrayElementjintintjintArray_intintID=NULL;
voidsetArrayElementjintintjintArray_intintjintintID=NULL;
voidremoveScilabJavaObjectjintintID=NULL;
voidlimitDirectBufferjintintID=NULL;
jintisUnwrappablejintintID=NULL;
jintwrapDoublejdoubledoubleID=NULL;
jintwrapDoublejdoubleArray_doubledoubleID=NULL;
jintwrapDoublejobjectArray__doubledoubleID=NULL;
jintwrapIntjintintID=NULL;
jintwrapIntjintArray_intintID=NULL;
jintwrapIntjobjectArray__intintID=NULL;
jintwrapUIntjlonglongID=NULL;
jintwrapUIntjlongArray_longlongID=NULL;
jintwrapUIntjobjectArray__longlongID=NULL;
jintwrapBytejbytebyteID=NULL;
jintwrapBytejbyteArray_bytebyteID=NULL;
jintwrapBytejobjectArray__bytebyteID=NULL;
jintwrapUBytejshortshortID=NULL;
jintwrapUBytejshortArray_shortshortID=NULL;
jintwrapUBytejobjectArray__shortshortID=NULL;
jintwrapShortjshortshortID=NULL;
jintwrapShortjshortArray_shortshortID=NULL;
jintwrapShortjobjectArray__shortshortID=NULL;
jintwrapUShortjintintID=NULL;
jintwrapUShortjintArray_intintID=NULL;
jintwrapUShortjobjectArray__intintID=NULL;
jintwrapStringjstringjava_lang_StringID=NULL;
jintwrapStringjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
jintwrapStringjobjectArray__java_lang_Stringjava_lang_StringID=NULL;
jintwrapBooleanjbooleanbooleanID=NULL;
jintwrapBooleanjbooleanArray_booleanbooleanID=NULL;
jintwrapBooleanjobjectArray__booleanbooleanID=NULL;
jintwrapCharjcharcharID=NULL;
jintwrapCharjcharArray_charcharID=NULL;
jintwrapCharjobjectArray__charcharID=NULL;
jintwrapFloatjfloatfloatID=NULL;
jintwrapFloatjfloatArray_floatfloatID=NULL;
jintwrapFloatjobjectArray__floatfloatID=NULL;
jintwrapLongjlonglongID=NULL;
jintwrapLongjlongArray_longlongID=NULL;
jintwrapLongjobjectArray__longlongID=NULL;


}

// Generic methods

void ScilabJavaObject::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "ScilabJavaObject");
}
}

void ScilabJavaObject::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "ScilabJavaObject");
}
}
// Method(s)

int ScilabJavaObject::invoke (JavaVM * jvm_, int id, char const* methodName, int const* args, int argsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintinvokejintintjstringjava_lang_StringjintArray_intintID = curEnv->GetStaticMethodID(cls, "invoke", "(ILjava/lang/String;[I)I" ) ;
if (jintinvokejintintjstringjava_lang_StringjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "invoke");
}

jstring methodName_ = curEnv->NewStringUTF( methodName );
if (methodName != NULL && methodName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jintArray args_ = curEnv->NewIntArray( argsSize ) ;

if (args_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( args_, 0, argsSize, (jint*)(args) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintinvokejintintjstringjava_lang_StringjintArray_intintID ,id, methodName_, args_));
                        curEnv->DeleteLocalRef(methodName_);
curEnv->DeleteLocalRef(args_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void ScilabJavaObject::initScilabJavaObject (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidinitScilabJavaObjectID = curEnv->GetStaticMethodID(cls, "initScilabJavaObject", "()V" ) ;
if (voidinitScilabJavaObjectID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "initScilabJavaObject");
}

                         curEnv->CallStaticVoidMethod(cls, voidinitScilabJavaObjectID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::garbageCollect (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidgarbageCollectID = curEnv->GetStaticMethodID(cls, "garbageCollect", "()V" ) ;
if (voidgarbageCollectID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "garbageCollect");
}

                         curEnv->CallStaticVoidMethod(cls, voidgarbageCollectID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char* ScilabJavaObject::getRepresentation (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetRepresentationjintintID = curEnv->GetStaticMethodID(cls, "getRepresentation", "(I)Ljava/lang/String;" ) ;
if (jstringgetRepresentationjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getRepresentation");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetRepresentationjintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

bool ScilabJavaObject::isValidJavaObject (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisValidJavaObjectjintintID = curEnv->GetStaticMethodID(cls, "isValidJavaObject", "(I)Z" ) ;
if (jbooleanisValidJavaObjectjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isValidJavaObject");
}

                        jboolean res =  static_cast<jboolean>( curEnv->CallStaticBooleanMethod(cls, jbooleanisValidJavaObjectjintintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void ScilabJavaObject::enableTrace (JavaVM * jvm_, char const* filename){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidenableTracejstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "enableTrace", "(Ljava/lang/String;)V" ) ;
if (voidenableTracejstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "enableTrace");
}

jstring filename_ = curEnv->NewStringUTF( filename );
if (filename != NULL && filename_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidenableTracejstringjava_lang_StringID ,filename_);
                        curEnv->DeleteLocalRef(filename_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::disableTrace (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiddisableTraceID = curEnv->GetStaticMethodID(cls, "disableTrace", "()V" ) ;
if (voiddisableTraceID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "disableTrace");
}

                         curEnv->CallStaticVoidMethod(cls, voiddisableTraceID );
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::setField (JavaVM * jvm_, int id, char const* fieldName, int idarg){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFieldjintintjstringjava_lang_StringjintintID = curEnv->GetStaticMethodID(cls, "setField", "(ILjava/lang/String;I)V" ) ;
if (voidsetFieldjintintjstringjava_lang_StringjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setField");
}

jstring fieldName_ = curEnv->NewStringUTF( fieldName );
if (fieldName != NULL && fieldName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidsetFieldjintintjstringjava_lang_StringjintintID ,id, fieldName_, idarg);
                        curEnv->DeleteLocalRef(fieldName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int ScilabJavaObject::getField (JavaVM * jvm_, int id, char const* fieldName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFieldjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "getField", "(ILjava/lang/String;)I" ) ;
if (jintgetFieldjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getField");
}

jstring fieldName_ = curEnv->NewStringUTF( fieldName );
if (fieldName != NULL && fieldName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetFieldjintintjstringjava_lang_StringID ,id, fieldName_));
                        curEnv->DeleteLocalRef(fieldName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::getFieldType (JavaVM * jvm_, int id, char const* fieldName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFieldTypejintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "getFieldType", "(ILjava/lang/String;)I" ) ;
if (jintgetFieldTypejintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getFieldType");
}

jstring fieldName_ = curEnv->NewStringUTF( fieldName );
if (fieldName != NULL && fieldName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetFieldTypejintintjstringjava_lang_StringID ,id, fieldName_));
                        curEnv->DeleteLocalRef(fieldName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::javaCast (JavaVM * jvm_, int id, char const* objName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintjavaCastjintintjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "javaCast", "(ILjava/lang/String;)I" ) ;
if (jintjavaCastjintintjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "javaCast");
}

jstring objName_ = curEnv->NewStringUTF( objName );
if (objName != NULL && objName_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintjavaCastjintintjstringjava_lang_StringID ,id, objName_));
                        curEnv->DeleteLocalRef(objName_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::javaCast (JavaVM * jvm_, int id, int classId){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintjavaCastjintintjintintID = curEnv->GetStaticMethodID(cls, "javaCast", "(II)I" ) ;
if (jintjavaCastjintintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "javaCast");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintjavaCastjintintjintintID ,id, classId));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

char* ScilabJavaObject::getClassName (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetClassNamejintintID = curEnv->GetStaticMethodID(cls, "getClassName", "(I)Ljava/lang/String;" ) ;
if (jstringgetClassNamejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getClassName");
}

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringgetClassNamejintintID ,id));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

int ScilabJavaObject::getArrayElement (JavaVM * jvm_, int id, int const* index, int indexSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetArrayElementjintintjintArray_intintID = curEnv->GetStaticMethodID(cls, "getArrayElement", "(I[I)I" ) ;
if (jintgetArrayElementjintintjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "getArrayElement");
}

jintArray index_ = curEnv->NewIntArray( indexSize ) ;

if (index_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( index_, 0, indexSize, (jint*)(index) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintgetArrayElementjintintjintArray_intintID ,id, index_));
                        curEnv->DeleteLocalRef(index_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

void ScilabJavaObject::setArrayElement (JavaVM * jvm_, int id, int const* index, int indexSize, int idArg){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetArrayElementjintintjintArray_intintjintintID = curEnv->GetStaticMethodID(cls, "setArrayElement", "(I[II)V" ) ;
if (voidsetArrayElementjintintjintArray_intintjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setArrayElement");
}

jintArray index_ = curEnv->NewIntArray( indexSize ) ;

if (index_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( index_, 0, indexSize, (jint*)(index) ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetArrayElementjintintjintArray_intintjintintID ,id, index_, idArg);
                        curEnv->DeleteLocalRef(index_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::removeScilabJavaObject (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveScilabJavaObjectjintintID = curEnv->GetStaticMethodID(cls, "removeScilabJavaObject", "(I)V" ) ;
if (voidremoveScilabJavaObjectjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeScilabJavaObject");
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveScilabJavaObjectjintintID ,id);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabJavaObject::limitDirectBuffer (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidlimitDirectBufferjintintID = curEnv->GetStaticMethodID(cls, "limitDirectBuffer", "(I)V" ) ;
if (voidlimitDirectBufferjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "limitDirectBuffer");
}

                         curEnv->CallStaticVoidMethod(cls, voidlimitDirectBufferjintintID ,id);
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

int ScilabJavaObject::isUnwrappable (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintisUnwrappablejintintID = curEnv->GetStaticMethodID(cls, "isUnwrappable", "(I)I" ) ;
if (jintisUnwrappablejintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "isUnwrappable");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintisUnwrappablejintintID ,id));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapDouble (JavaVM * jvm_, double x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapDoublejdoubledoubleID = curEnv->GetStaticMethodID(cls, "wrapDouble", "(D)I" ) ;
if (jintwrapDoublejdoubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapDouble");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapDoublejdoubledoubleID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapDouble (JavaVM * jvm_, double const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapDoublejdoubleArray_doubledoubleID = curEnv->GetStaticMethodID(cls, "wrapDouble", "([D)I" ) ;
if (jintwrapDoublejdoubleArray_doubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapDouble");
}

jdoubleArray x_ = curEnv->NewDoubleArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( x_, 0, xSize, (jdouble*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapDoublejdoubleArray_doubledoubleID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapDouble (JavaVM * jvm_, double const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapDoublejobjectArray__doubledoubleID = curEnv->GetStaticMethodID(cls, "wrapDouble", "([[D)I" ) ;
if (jintwrapDoublejobjectArray__doubledoubleID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapDouble");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[D"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jdoubleArray xLocal = curEnv->NewDoubleArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( xLocal, 0, xSizeCol, (jdouble*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapDoublejobjectArray__doubledoubleID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapInt (JavaVM * jvm_, int x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapIntjintintID = curEnv->GetStaticMethodID(cls, "wrapInt", "(I)I" ) ;
if (jintwrapIntjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapInt");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapIntjintintID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapInt (JavaVM * jvm_, int const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapIntjintArray_intintID = curEnv->GetStaticMethodID(cls, "wrapInt", "([I)I" ) ;
if (jintwrapIntjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapInt");
}

jintArray x_ = curEnv->NewIntArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( x_, 0, xSize, (jint*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapIntjintArray_intintID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapInt (JavaVM * jvm_, int const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapIntjobjectArray__intintID = curEnv->GetStaticMethodID(cls, "wrapInt", "([[I)I" ) ;
if (jintwrapIntjobjectArray__intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapInt");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[I"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jintArray xLocal = curEnv->NewIntArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( xLocal, 0, xSizeCol, (jint*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapIntjobjectArray__intintID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUInt (JavaVM * jvm_, long long x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUIntjlonglongID = curEnv->GetStaticMethodID(cls, "wrapUInt", "(J)I" ) ;
if (jintwrapUIntjlonglongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUInt");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUIntjlonglongID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUInt (JavaVM * jvm_, long long const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUIntjlongArray_longlongID = curEnv->GetStaticMethodID(cls, "wrapUInt", "([J)I" ) ;
if (jintwrapUIntjlongArray_longlongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUInt");
}

jlongArray x_ = curEnv->NewLongArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( x_, 0, xSize, (jlong*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUIntjlongArray_longlongID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUInt (JavaVM * jvm_, long long const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUIntjobjectArray__longlongID = curEnv->GetStaticMethodID(cls, "wrapUInt", "([[J)I" ) ;
if (jintwrapUIntjobjectArray__longlongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUInt");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[J"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jlongArray xLocal = curEnv->NewLongArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( xLocal, 0, xSizeCol, (jlong*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUIntjobjectArray__longlongID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapByte (JavaVM * jvm_, byte x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBytejbytebyteID = curEnv->GetStaticMethodID(cls, "wrapByte", "(B)I" ) ;
if (jintwrapBytejbytebyteID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapByte");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBytejbytebyteID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapByte (JavaVM * jvm_, byte const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBytejbyteArray_bytebyteID = curEnv->GetStaticMethodID(cls, "wrapByte", "([B)I" ) ;
if (jintwrapBytejbyteArray_bytebyteID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapByte");
}

jbyteArray x_ = curEnv->NewByteArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetByteArrayRegion( x_, 0, xSize, (jbyte*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBytejbyteArray_bytebyteID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapByte (JavaVM * jvm_, byte const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBytejobjectArray__bytebyteID = curEnv->GetStaticMethodID(cls, "wrapByte", "([[B)I" ) ;
if (jintwrapBytejobjectArray__bytebyteID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapByte");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[B"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jbyteArray xLocal = curEnv->NewByteArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetByteArrayRegion( xLocal, 0, xSizeCol, (jbyte*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBytejobjectArray__bytebyteID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUByte (JavaVM * jvm_, short x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUBytejshortshortID = curEnv->GetStaticMethodID(cls, "wrapUByte", "(S)I" ) ;
if (jintwrapUBytejshortshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUByte");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUBytejshortshortID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUByte (JavaVM * jvm_, short const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUBytejshortArray_shortshortID = curEnv->GetStaticMethodID(cls, "wrapUByte", "([S)I" ) ;
if (jintwrapUBytejshortArray_shortshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUByte");
}

jshortArray x_ = curEnv->NewShortArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( x_, 0, xSize, (jshort*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUBytejshortArray_shortshortID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUByte (JavaVM * jvm_, short const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUBytejobjectArray__shortshortID = curEnv->GetStaticMethodID(cls, "wrapUByte", "([[S)I" ) ;
if (jintwrapUBytejobjectArray__shortshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUByte");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[S"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jshortArray xLocal = curEnv->NewShortArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( xLocal, 0, xSizeCol, (jshort*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUBytejobjectArray__shortshortID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapShort (JavaVM * jvm_, short x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapShortjshortshortID = curEnv->GetStaticMethodID(cls, "wrapShort", "(S)I" ) ;
if (jintwrapShortjshortshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapShort");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapShortjshortshortID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapShort (JavaVM * jvm_, short const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapShortjshortArray_shortshortID = curEnv->GetStaticMethodID(cls, "wrapShort", "([S)I" ) ;
if (jintwrapShortjshortArray_shortshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapShort");
}

jshortArray x_ = curEnv->NewShortArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( x_, 0, xSize, (jshort*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapShortjshortArray_shortshortID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapShort (JavaVM * jvm_, short const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapShortjobjectArray__shortshortID = curEnv->GetStaticMethodID(cls, "wrapShort", "([[S)I" ) ;
if (jintwrapShortjobjectArray__shortshortID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapShort");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[S"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jshortArray xLocal = curEnv->NewShortArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( xLocal, 0, xSizeCol, (jshort*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapShortjobjectArray__shortshortID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUShort (JavaVM * jvm_, int x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUShortjintintID = curEnv->GetStaticMethodID(cls, "wrapUShort", "(I)I" ) ;
if (jintwrapUShortjintintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUShort");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUShortjintintID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUShort (JavaVM * jvm_, int const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUShortjintArray_intintID = curEnv->GetStaticMethodID(cls, "wrapUShort", "([I)I" ) ;
if (jintwrapUShortjintArray_intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUShort");
}

jintArray x_ = curEnv->NewIntArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( x_, 0, xSize, (jint*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUShortjintArray_intintID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapUShort (JavaVM * jvm_, int const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapUShortjobjectArray__intintID = curEnv->GetStaticMethodID(cls, "wrapUShort", "([[I)I" ) ;
if (jintwrapUShortjobjectArray__intintID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapUShort");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[I"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jintArray xLocal = curEnv->NewIntArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( xLocal, 0, xSizeCol, (jint*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapUShortjobjectArray__intintID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapString (JavaVM * jvm_, char const* x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapStringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "wrapString", "(Ljava/lang/String;)I" ) ;
if (jintwrapStringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapString");
}

jstring x_ = curEnv->NewStringUTF( x );
if (x != NULL && x_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapStringjstringjava_lang_StringID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapString (JavaVM * jvm_, char const* const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapStringjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "wrapString", "([Ljava/lang/String;)I" ) ;
if (jintwrapStringjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapString");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray x_ = curEnv->NewObjectArray( xSize, stringArrayClass, NULL);
if (x_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < xSize; i++)
{
jstring TempString = curEnv->NewStringUTF( x[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( x_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapStringjobjectArray_java_lang_Stringjava_lang_StringID ,x_));
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapString (JavaVM * jvm_, char const* const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapStringjobjectArray__java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "wrapString", "([[Ljava/lang/String;)I" ) ;
if (jintwrapStringjobjectArray__java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapString");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");
// create java array of array of strings.
jobjectArray x_ = curEnv->NewObjectArray( xSize, curEnv->FindClass("[Ljava/lang/String;"), NULL);
if (x_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

for ( int i = 0; i < xSize; i++)
{
jobjectArray xLocal = curEnv->NewObjectArray( xSizeCol, stringArrayClass, NULL);
// convert each char * to java strings and fill the java array.
for ( int j = 0; j < xSizeCol; j++) {
jstring TempString = curEnv->NewStringUTF( x[i][j] );

if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( xLocal, j, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);

}
                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapStringjobjectArray__java_lang_Stringjava_lang_StringID ,x_));
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapBoolean (JavaVM * jvm_, bool x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBooleanjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "wrapBoolean", "(Z)I" ) ;
if (jintwrapBooleanjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapBoolean");
}

jboolean x_ = (static_cast<bool>(x) ? JNI_TRUE : JNI_FALSE);

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBooleanjbooleanbooleanID ,x_));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapBoolean (JavaVM * jvm_, bool const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBooleanjbooleanArray_booleanbooleanID = curEnv->GetStaticMethodID(cls, "wrapBoolean", "([Z)I" ) ;
if (jintwrapBooleanjbooleanArray_booleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapBoolean");
}

jbooleanArray x_ = curEnv->NewBooleanArray( xSize ) ;
curEnv->SetBooleanArrayRegion( x_, 0, xSize, (jboolean*)x ) ;

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBooleanjbooleanArray_booleanbooleanID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapBoolean (JavaVM * jvm_, bool const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapBooleanjobjectArray__booleanbooleanID = curEnv->GetStaticMethodID(cls, "wrapBoolean", "([[Z)I" ) ;
if (jintwrapBooleanjobjectArray__booleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapBoolean");
}

jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[Z"),NULL);
for (int i=0; i<xSize; i++){
                        jbooleanArray xLocal = curEnv->NewBooleanArray( xSizeCol ) ;
                        curEnv->SetBooleanArrayRegion( xLocal, 0, xSizeCol, (jboolean*)(x[i]) ) ;
                        curEnv->SetObjectArrayElement(x_, i, xLocal);
                        curEnv->DeleteLocalRef(xLocal);
                        }

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapBooleanjobjectArray__booleanbooleanID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapChar (JavaVM * jvm_, unsigned short x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapCharjcharcharID = curEnv->GetStaticMethodID(cls, "wrapChar", "(C)I" ) ;
if (jintwrapCharjcharcharID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapChar");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapCharjcharcharID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapChar (JavaVM * jvm_, unsigned short const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapCharjcharArray_charcharID = curEnv->GetStaticMethodID(cls, "wrapChar", "([C)I" ) ;
if (jintwrapCharjcharArray_charcharID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapChar");
}

jcharArray x_ = curEnv->NewCharArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetCharArrayRegion( x_, 0, xSize, (jchar*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapCharjcharArray_charcharID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapChar (JavaVM * jvm_, unsigned short const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapCharjobjectArray__charcharID = curEnv->GetStaticMethodID(cls, "wrapChar", "([[C)I" ) ;
if (jintwrapCharjobjectArray__charcharID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapChar");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[C"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jcharArray xLocal = curEnv->NewCharArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetCharArrayRegion( xLocal, 0, xSizeCol, (jchar*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapCharjobjectArray__charcharID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapFloat (JavaVM * jvm_, float x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapFloatjfloatfloatID = curEnv->GetStaticMethodID(cls, "wrapFloat", "(F)I" ) ;
if (jintwrapFloatjfloatfloatID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapFloat");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapFloatjfloatfloatID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapFloat (JavaVM * jvm_, float const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapFloatjfloatArray_floatfloatID = curEnv->GetStaticMethodID(cls, "wrapFloat", "([F)I" ) ;
if (jintwrapFloatjfloatArray_floatfloatID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapFloat");
}

jfloatArray x_ = curEnv->NewFloatArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetFloatArrayRegion( x_, 0, xSize, (jfloat*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapFloatjfloatArray_floatfloatID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapFloat (JavaVM * jvm_, float const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapFloatjobjectArray__floatfloatID = curEnv->GetStaticMethodID(cls, "wrapFloat", "([[F)I" ) ;
if (jintwrapFloatjobjectArray__floatfloatID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapFloat");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[F"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jfloatArray xLocal = curEnv->NewFloatArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetFloatArrayRegion( xLocal, 0, xSizeCol, (jfloat*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapFloatjobjectArray__floatfloatID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapLong (JavaVM * jvm_, long long x){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapLongjlonglongID = curEnv->GetStaticMethodID(cls, "wrapLong", "(J)I" ) ;
if (jintwrapLongjlonglongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapLong");
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapLongjlonglongID ,x));
                        curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapLong (JavaVM * jvm_, long long const* x, int xSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapLongjlongArray_longlongID = curEnv->GetStaticMethodID(cls, "wrapLong", "([J)I" ) ;
if (jintwrapLongjlongArray_longlongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapLong");
}

jlongArray x_ = curEnv->NewLongArray( xSize ) ;

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( x_, 0, xSize, (jlong*)(x) ) ;


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapLongjlongArray_longlongID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

int ScilabJavaObject::wrapLong (JavaVM * jvm_, long long const* const* x, int xSize, int xSizeCol){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintwrapLongjobjectArray__longlongID = curEnv->GetStaticMethodID(cls, "wrapLong", "([[J)I" ) ;
if (jintwrapLongjobjectArray__longlongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "wrapLong");
}

 jobjectArray x_ = curEnv->NewObjectArray(xSize, curEnv->FindClass("[J"),NULL);

if (x_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<xSize; i++){

jlongArray xLocal = curEnv->NewLongArray( xSizeCol ) ;

if (xLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(x_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( xLocal, 0, xSizeCol, (jlong*)(x[i]) ) ;
curEnv->SetObjectArrayElement(x_, i, xLocal);
curEnv->DeleteLocalRef(xLocal);
}

                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintwrapLongjobjectArray__longlongID ,x_));
                        curEnv->DeleteLocalRef(x_);
curEnv->DeleteLocalRef(cls);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

}
