// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ????-2008 - INRIA
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

funcprot(0);

//maple code
//writeto("erf.ref"):interface(prettyprint=0):
//for i from 0 to 40 do print(evalf[30](erf(10^(-(200-i*5))),30)): od:
//for i from 2 to 1000 do print(evalf[30](erf(i/1000),30)): od:
//for i from 1 to 1000 do print(evalf[30](erf(i/100),30)): od:
//writeto(terminal):

x1=10.^(-[200:-5:0])';
y1ref=[
    .112837916709551257389615890312e-199
    .112837916709551257389615890312e-194
    .112837916709551257389615890312e-189
    .112837916709551257389615890312e-184
    .112837916709551257389615890312e-179
    .112837916709551257389615890312e-174
    .112837916709551257389615890312e-169
    .112837916709551257389615890312e-164
    .112837916709551257389615890312e-159
    .112837916709551257389615890312e-154
    .112837916709551257389615890312e-149
    .112837916709551257389615890312e-144
    .112837916709551257389615890312e-139
    .112837916709551257389615890312e-134
    .112837916709551257389615890312e-129
    .112837916709551257389615890312e-124
    .112837916709551257389615890312e-119
    .112837916709551257389615890312e-114
    .112837916709551257389615890312e-109
    .112837916709551257389615890312e-104
    .112837916709551257389615890312e-99
    .112837916709551257389615890312e-94
    .112837916709551257389615890312e-89
    .112837916709551257389615890312e-84
    .112837916709551257389615890312e-79
    .112837916709551257389615890312e-74
    .112837916709551257389615890312e-69
    .112837916709551257389615890312e-64
    .112837916709551257389615890312e-59
    .112837916709551257389615890312e-54
    .112837916709551257389615890312e-49
    .112837916709551257389615890312e-44
    .112837916709551257389615890312e-39
    .112837916709551257389615890312e-34
    .112837916709551257389615890312e-29
    .112837916709551257389615890312e-24
    .112837916709551257389615890312e-19
    .112837916709551257389615890312e-14
    .112837916709551257389239763923e-9
    .112837916705789993499410352983e-4
    .842700792949714869341220635083];
e1=max(norm((y1ref-erf(x1))./abs(y1ref),1), norm((y1ref+erf(-x1))./ abs(y1ref),1));

x2=(2:1000)'/1000;
y2ref=[
    .225675532518352370298795922215e-2
    .338512734590145341707952022198e-2
    .451349259640869784451966922964e-2
    .564184882003155028059818457701e-2
    .677019376015046468604940310558e-2
    .789852516021359483790362455711e-2
    .902684076375033280335287750282e-2
    .101551383143848466012547703272e-1
    .112834155558496169159095235481e-1
    .124116702319989727277585474628e-1
    .135399000868226257256680915256e-1
    .146681028644592033654785487036e-1
    .157962763092097804395189490317e-1
    .169244181655514090218070213381e-1
    .180525261781506466536779402757e-1
    .191805980918770826346095069538e-1
    .203086316518168622830380351834e-1
    .214366246032862090319876311448e-1
    .225645746918449442243658616474e-1
    .236924796633100044728110045373e-1
    .248203372637689564490101636349e-1
    .259481452395935089674435092390e-1
    .270759013374530222285477730715e-1
    .282036033043280140863318828730e-1
    .293312488875236632055192659808e-1
    .304588358346833089733348823753e-1
    .315863618938019480311004650920e-1
    .327138248132397272908487487350e-1
    .338412223417354333022166542569e-1
    .349685522284199778349284692926e-1
    .360958122228298795422330172412e-1
    .372230000749207415707136440182e-1
    .383501135350807249819465679760e-1
    .394771503541440178515417348807e-1
    .406041082834042999111607949913e-1
    .417309850746282025991691721275e-1
    .428577784800687643856434240017e-1
    .439844862524788812375211978909e-1
    .451111061451247520897490647292e-1
    .462376359117993191883533667015e-1
    .473640733068357031714309371520e-1
    .484904160851206327541301457967e-1
    .496166620021078688837681855281e-1
    .507428088138316232313078481610e-1
    .518688542769199708854962339035e-1
    .529947961486082571160489017238e-1
    .541206321867524980723458936601e-1
    .552463601498427752841908539982e-1
    .563719777970166238312711126020e-1
    .574974828880724140480451089565e-1
    .586228731834827266308738980885e-1
    .597481464444077210143056998442e-1
    .608733004327084968835165273606e-1
    .619983329109604486900058572858e-1
    .631232416424666130377440816518e-1
    .642480243912710088070681075355e-1
    .653726789221719698837229439541e-1
    .664972030007354703605504340230e-1
    .676215943933084420794314523912e-1
    .687458508670320843811948914741e-1
    .698699701898551659313156031098e-1
    .709939501305473184893341430109e-1
    .721177884587123224900436817830e-1
    .732414829448013843046037963214e-1
    .743650313601264050498570370102e-1
    .754884314768732408142421772665e-1
    .766116810681149541688178904557e-1
    .777347779078250568320322629267e-1
    .788577197708907433569970386680e-1
    .799805044331261157101507986716e-1
    .811031296712853986103224042538e-1
    .822255932630761454973349760337e-1
    .833478929871724349994214367141e-1
    .844700266232280577688552138814e-1
    .855919919518896935553340763737e-1
    .867137867548100783867912619510e-1
    .878354088146611617274460425829e-1
    .889568559151472534830456641906e-1
    .900781258410181607233921876161e-1
    .911992163780823139923911444225e-1
    .923201253132198830760041022638e-1
    .934408504343958820986342074190e-1
    .945613895306732638186225340128e-1
    .956817403922260029936836177841e-1
    .968019008103521686872608843203e-1
    .979218685774869853869367947095e-1
    .990416414872158828061884228229e-1
    .100161217334287534240936845130
    .101280593914626883352498163244
    .102399769025348159248705188429
    .103518740464767879735131793231
    .104637506032417842608516675214
    .105756063529058104864649778652
    .106874410756689949693152878886
    .107992545518568841131755847897
    .109110465619217366252841885494
    .110228168864438164755208515206
    .111345653061326845834166404456
    .112462916018284892203275071744
    .113579955545032551141193286152
    .114696769452621712437302443397
    .115813355553448773109943414610
    .116929711661267488771291305743
    .118045835591201811513078233776
    .119161725159758714187561617329
    .120277378184841000958324590572
    .121392792485760103995685977039
    .122507965883248866191689800778
    .123622896199474309769838562628
    .124737581258050390664930465980
    .125852018884050738548558435529
    .126966206904021382376028130830
    .128080143145993461330653210288
    .129193825439495921041588847016
    .130307251615568194951568932125
    .131420419506772870711118519834
    .132533326947208341476020868641
    .133645971772521441985027909921
    .134758351819920069295014126058
    .135870464928185788050986640719
    .136982308937686420168578810414
    .138093881690388618806870755184
    .139205181029870426509598073327
    .140316204801333817393029446522
    .141426950851617223259014953752
    .142537417029208043511929671067
    .143647601184255138758461535421
    .144757501168581307969418490748
    .145867114835695749082957608895
    .146976440040806502928868183049
    .148085474640832880353771722828
    .149194216494417872427334334021
    .150302663461940543609821138069
    .151410813405528407761558172469
    .152518664189069786875104609291
    .153626213678226152411177130592
    .154733459740444449119608902510
    .155840400244969401226867789928
    .156947033062855800871902246476
    .158053356066980778672328696035
    .159159367132056056303221187342
    .160265064134640180971012648487
    .161370444953150741665267188607
    .162475507467876567071334585375
    .163580249560989905027151354671
    .164684669116558583407707618401
    .165788764020558152320955363463
    .166892532160884007499191614654
    .167995971427363494770209522381
    .169099079711767995492771387748
    .170201854907824992841220208277
    .171304294911230118824310422633
    .172406397619659181923604157410
    .173508160932780175237046428784
    .174609582752265265013601421761
    .175710660981802759465102155146
    .176811393527109057741737536462
    .177911778295940578957874013014
    .179011813198105671155183728287
    .180111496145476500090327292039
    .181210825052000917734716962929
    .182309797833714310374165219313
    .183408412408751426196504352140
    .184506666697358182255544848596
    .185604558621903450700023941342
    .186702086106890824156480770895
    .187799247078970360155281142791
    .188896039466950304489302851639
    .189992461201808793395081985931
    .191088510216705534446511515379
    .192184184446993466051475791495
    .193279481830230395442098356938
    .194374400306190615049575654659
    .195468937816876497154865848814
    .196563092306530066706800010673
    .197656861721644552199482378895
    .198750244010975914501147269500
    .199843237125554353526942481134
    .200935839018695792648412710622
    .202028047646013340732761556921
    .203119860965428731705277143022
    .204211276937183741528614219801
    .205302293523851582492934827727
    .206392908690348274711220176435
    .207483120403943994714378352792
    .208572926634274401041085779949
    .209662325353351936717615017287
    .210751314535577108523217508732
    .211839892157749742936947248988
    .212928056199080218662130038306
    .214015804641200675625003030835
    .215103135468176200344370643752
    .216190046666515987569445578678
    .217276536225184478083367707573
    .218362602135612472570218886790
    .219448242391708221443678379492
    .220533454989868490535791482464
    .221618237928989602544653162754
    .222702589210478454140139006800
    .223786506838263508627147563906
    .224869988818805764066151221320
    .225953033161109696751187073958
    .227035637876734179945754842090
    .228117800979803377777425739191
    .229199520487017614192304293845
    .230280794417664216870824478032
    .231361620793628336006702083504
    .232441997639403737851207112268
    .233521922982103572925263000421
    .234601394851471118802223770857
    .235680411279890497364525703498
    .236758970302397366437756815855
    .237837069956689585706035355647
    .238914708283137856812937615025
    .239991883324796337552565676388
    .241068593127413230055697186875
    .242144835739441342876311926156
    .243220609212048626884143774016
    .244295911599128684869261694261
    .245370740957311254765039523457
    .246445095345972666396231680828
    .247518972827246271659230392926
    .248592371466032848041939647378
    .249665289330010975391061847668
    .250737724489647385834955029471
    .251809675018207286770581511985
    .252881138991764656823432988930
    .253952114489212514689682306890
    .255022599592273160770178527263
    .256092592385508391506269315783
    .257162090956329686327803244085
    .258231093395008367124034214682
    .259299597794685730148520927583
    .260367602251383150269486087224
    .261435104864012157477472895885
    .262502103734384485562510287987
    .263568596967222092873373321999
    .264634582670167155071901156734
    .265700058953792029795712090025
    .266765023931609193143033223681
    .267829475720081147893741432557
    .268893412438630303381092451180
    .269956832209648826928996041894
    .271019733158508466770077367432
    .272082113413570346360147851628
    .273143971106194730005092967908
    .274205304370750759716569539751
    .275266111344626163213291263768
    .276326390168236932985068267765
    .277386138985036976337154586483
    .278445355941527736332846469941
    .279504039187267783552664426735
    .280562186874882378588842840604
    .281619797160073005194242876267
    .282676868201626874005197203266
    .283733398161426396758188807567
    .284789385204458630920660823172
    .285844827498824694656649893238
    .286899723215749152048332055369
    .287954070529589368494967532014
    .289007867617844836211129087532
    .290061112661166469746497781516
    .291113803843365871449909996686
    .292165939351424566800740542106
    .293217517375503209531108421842
    .294268536108950756462794508591
    .295318993748313611983163864260
    .296368888493344742084789798283
    .297418218547012757893881942436
    .298466982115510968613026641360
    .299515177408266403804154803865
    .300562802637948804938060024401
    .301609856020479586137198259998
    .302656335775040764038909628367
    .303702240124083856706612970899
    .304747567293338751516934692846
    .305792315511822541951145045159
    .306836483011848333219687441169
    .307880068029034016648999599572
    .308923068802311012760239265926
    .309965483573932982969941981133
    .311007310589484509843053829992
    .312048548097889745829198308894
    .313089194351421030413453392003
    .314129247605707475613332542690
    .315168706119743519754081804554
    .316207568155897449454824206895
    .317245831979919889758502525945
    .318283495860952262338991948381
    .319320558071535211719175380496
    .320357016887616999434196027782
    .321392870588561866074524428430
    .322428117457158361143900353202
    .323462755779627640667633876197
    .324496783845631732487174468920
    .325530199948281769177282166753
    .326563002384146188522560695094
    .327595189453258901490538915000
    .328626759459127427638914047867
    .329657710708740997894997858344
    .330688041512578624645835307097
    .331717750184617139077894122957
    .332746835042339195705653280262
    .333775294406741244028848494496
    .334803126602341467258563560514
    .335830329957187688052787645400
    .336856902802865241202490505117
    .337882843474504813209700013326
    .338908150310790248699499364816
    .339932821653966323608294837599
    .340956855849846485091139059664
    .341980251247820558091329321347
    .343003006200862418515935594979
    .344025119065537632961348562643
    .345046588202011064933374103222
    .346067411974054447506837344119
    .347087588749053922370096533856
    .348107116898017545200304631788
    .349125994795582757315694633242
    .350144220820023823551603245050
    .351161793353259236307386590473
    .352178710780859085711821146555
    .353194971492052395855023093683
    .354210573879734427035359679213
    .355225516340473943970267057176
    .356239797274520449920330356881
    .357253415085811386676423447487
    .358266368181979300360147995779
    .359278654974358972988253953358
    .360290273877994519752166549660
    .361301223311646451964188201496
    .362311501697798705622387470669
    .363321107462665635546631301428
    .364330039036198975038661241611
    .365338294852094761019559188058
    .366345873347800224598393390774
    .367352772964520647026280994141
    .368358992147226180990549279761
    .369364529344658637204123996972
    .370369383009338236245719716303
    .371373551597570325606854010795
    .372377033569452061902154452815
    .373379827388879058199874902398
    .374381931523551996429985349878
    .375383344444983204827647653264
    .376384064628503200370337872085
    .377384090553267196167324536980
    .378383420702261573760661100638
    .379382053562310320297299983619
    .380379987624081430532385050578
    .381377221382093273624229021176
    .382373753334720924681932228207
    .383369581984202461027049275616
    .384364705836645223131160514087
    .385359123402032040191655834008
    .386352833194227420308489067906
    .387345833730983705225112289154
    .388338123533947189597250483835
    .389329701128664204753628450550
    .390320565044587166913213341425
    .391310713815080589823987989205
    .392300145977427061788722062826
    .393288860072833187043660149798
    .394276854646435491456498070861
    .395264128247306292510471083312
    .396250679428459533541830116734
    .397236506746856582198434801429
    .398221608763411993087644788109
    .399205984042999234582143710203
    .400189631154456379752783100028
    .401172548670591761397986629808
    .402154735168189591139708200719
    .403136189228015542556390640563
    .404116909434822298323825085919
    .405096894377355061335264510446
    .406076142648357029772598310083
    .407054652844574836100848360944
    .408032423566763949958700519367
    .409009453419694044918239128676
    .409985741012154329087505726312
    .410961284956958839529956800997
    .411936083870951700475349125007
    .412910136375012345297034874415
    .413883441094060702231102442847
    .414855996657062343813252544770
    .415827801697033600009752885237
    .416798854851046635019268337191
    .417769154760234487722817207548
    .418738700069796075759557782169
    .419707489429001163206562910243
    .420675521491195291841193913267
    .421642794913804675965138575623
    .422609308358341060769631385315
    .423575060490406544221827537783
    .424540049979698362452755485397
    .425504275500013638627726003289
    .426467735729254095280528841247
    .427430429349430730093201034421
    .428392355046668455103603845320
    .429353511511210699323498098904
    .430313897437423974750260344311
    .431273511523802405755834823790
    .432232352472972221836968644542
    .433190418991696213711229825359
    .434147709790878152743760019982
    .435104223585567173690165695927
    .436059959094962120741403364013
    .437014915042415856856966102873
    .437969090155439536373130097283
    .438922483165706840873471202079
    .439875092809058178309312647689
    .440826917825504845358215911881
    .441777956959233153009077488080
    .442728208958608515362844776544
    .443677672576179501638314603798
    .444626346568681851372927930937
    .445574229697042452808924135708
    .446521320726383284455667839750
    .447467618426025319819410593897
    .448413121569492395292198824121
    .449357828934515041192088271529
    .450301739303034275947273724889
    .451244851461205363417191136380
    .452187164199401533344097223910
    .453128676312217664929079389249
    .454069386598473933526896213666
    .455009293861219420454495924721
    .455948396907735685908507052460
    .456886694549540304987442003670
    .457824185602390366814800472097
    .458760868886285936759705463859
    .459696743225473481752150243769
    .460631807448449258690379693113
    .461566060387962665938374405786
    .462499500881019557911850330725
    .463432127768885522751630887567
    .464363939897089123083692232491
    .465294936115425099865625725624
    .466225115277957539319704643377
    .467154476243023002953184781846
    .468083017873233620666910804303
    .469010739035480146953741990042
    .469937638600934980188752436698
    .470863715445055145013601746990
    .471788968447585237817912786929
    .472713396492560335320933229157
    .473636998468308866257197285720
    .474559773267455446170343282424
    .475481719786923675319681525460
    .476402836927938899704545253535
    .477323123596030935211895348765
    .478242578701036754893086890383
    .479161201157103139376142570462
    .480078989882689290420314443641
    .480995943800569407620151446832
    .481912061837835228266725593494
    .482827342925898530374104713797
    .483741786000493598879594070340
    .484655390001679655026703122572
    .485568153873843248940227135191
    .486480076565700615403266220168
    .487391157030299992846436762113
    .488301394225023905559961996196
    .489210787111591409139759780182
    .490119334656060299179076321089
    .491027035828829283217644776043
    .491933889604640115960777239809
    .492839894962579697781227651809
    .493745050886082136517091596899
    .494649356362930772579436830493
    .495552810385260167383785623387
    .496455411949558055119996688692
    .497357160056667257875520516323
    .498258053711787564127427393194
    .499158091924477570619032223565
    .500057273708656487637364477468
    .500955598082605907708155179823
    .501853064068971537725435802339
    .502749670694764894533266228628
    .503645416991364963977530623855
    .504540301994519823446161047603
    .505434324744348227916568996447
    .506327484285341159529484744730
    .507219779666363340708823362306
    .508111209940654710847614620447
    .509001774165831866580451645610
    .509891471403889465663330139428
    .510780300721201594482166245993
    .511668261188523099211696708386
    .512555351880990880646879809369
    .513441571878125152729329730417
    .514326920263830664791730382735
    .515211396126397887543587457780
    .516094998558504162822089407175
    .516977726657214817132259286868
    .517859579523984239000989882114
    .518740556264656920169964262550
    .519620655989468460652872894389
    .520499877813046537682746653892
    .521378220854411838575632536941
    .522255684236978957537245537976
    .523132267088557256439636072111
    .524007968541351689595317431092
    .524882787731963592556702091291
    .525756723801391434969099224430
    .526629775895031537505928493550
    .527501943162678752915207142232
    .528373224758527111206768498669
    .529243619841170429010070312239
    .530113127573602883132850813155
    .530981747123219548351289030107
    .531849477661816899462723710888
    .532716318365593277632382161425
    .533582268415149321065966443855
    .534447326995488360040339648837
    .535311493296016776324949375743
    .536174766510544327027019111257
    .537037145837284432893930886874
    .537898630478854431106614413389
    .538759219642275792598148830370
    .539618912538974303932173265474
    .540477708384780213776091566929
    .541335606399928344004444847318
    .542192605809058165468212852659
    .543048705841213838466191642397
    .543903905729844217954980628123
    .544758204712802823534496666343
    .545611602032347774246316628299
    .546464096935141688222532672455
    .547315688672251547223186317745
    .548166376499148526100728352785
    .549016159675707787230331613038
    .549865037466208239945262709135
    .550713009139332265016896890255
    .551560073968165404219337371584
    .552406231230196015018976639360
    .553251480207314890429712465912
    .554095820185814844074905615457
    .554939250456390260497539494224
    .555781770314136610760414290860
    .556623379058549933378579460143
    .557464075993526280626578719833
    .558303860427361130263451052270
    .559142731672748762718799524176
    .559980689046781603783607055279
    .560817731870949532849844574008
    .561653859471139156743282291908
    .562489071177633049194279102823
    .563323366325108955991688363557
    .564156744252638965865380535022
    .564989204303688647143244352067
    .565820745826116150228888341670
    .566651368172171275946623618347
    .567481070698494509800666947821
    .568309852766116022195860080716
    .569137713740454634667557312708
    .569964652991316752168688121623
    .570790669892895261462355560977
    .571615763823768395668683848890
    .572439934166898565014980276741
    .573263180309631153838627168906
    .574085501643693283892469149095
    .574906897565192544002809405719
    .575727367474615686130475994074
    .576546910776827287885765462595
    .577365526881068381548416239647
    .578183215200955049644108262081
    .578999975154476987129328262797
    .579815806163996030236781957527
    .580630707656244652033875076933
    .581444679062324424747124774541
    .582257719817704448905701399974
    .583069829362219749357637956239
    .583881007140069638212580755299
    .584691252599816044765289843857
    .585500565194381812454431687019
    .586308944381048962911539367318
    .587116389621456927155347176485
    .587922900381600743987036943270
    .588728476131829225642262748718
    .589533116346843090756148826575
    .590336820505693064697782427007
    .591139588091777947331049232814
    .591941418592842648258983554811
    .592742311500976189609128993255
    .593542266312609676417727531378
    .594341282528514234670876121353
    .595139359653798917061109728718
    .595936497197908576518188514610
    .596732694674621707573184352505
    .597527951602048255615278193734
    .598322267502627394100994910321
    .599115641903125269775916150949
    .599908074334632715969224442549
    .600699564332562934021743252590
    .601490111436649142908447991969
    .602279715190942197116731982112
    .603068375143808172842019228795
    .603856090847925922562622436057
    .604642861860284598056050052705
    .605428687742181141919270268149
    .606213568059217747655742760019
    .606997502381299288392330640085
    .607780490282630714289505443851
    .608562531341714418708557159761
    .609343625141347573199819192718
    .610123771268619431376214800534
    .610902969314908601736726927617
    .611681218875880289504687484527
    .612458519551483507546074981850
    .613234870945948256433301018885
    .614010272667782673720256448952
    .614784724329770152494677090466
    .615558225548966429274176623294
    .616330775946696641312580800283
    .617102375148552353383482311142
    .617873022784388554108219557146
    .618642718488320621895765227442
    .619411461898721260562291908088
    .620179252658217404698462000490
    .620946090413687094852767973758
    .621711974816256322599526422715
    .622476905521295845560405547192
    .623240882188417972448640505877
    .624003904481473318205364626701
    .624765972068547529297756672732
    .625527084621957979248975265062
    .626287241818250434470121149635
    .627046443338195690464736260557
    .627804688866786178476615475642
    .628561978093232542651972578113
    .629318310710960187787266228877
    .630073686417605797734254714174
    .630828104915013824534109861020
    .631581565909232948352680805280
    .632334069110512508289257251951
    .633085614233298904131439481817
    .633836200996231969128978630682
    .634585829122141313859705694454
    .635334498338042641260921293117
    .636082208375134032899870456753
    .636828958968792206557177574857
    .637574749858568745197366174122
    .638319580788186297400836357185
    .639063451505534749331919543470
    .639806361762667368317875600932
    .640548311315796918113941542043
    .641289299925291745929783676667
    .642029327355671841292946466331
    .642768393375604866825131306828
    .643506497757902161007377076930
    .644243640279514713010451528250
    .644979820721529109666998452972
    .645715038869163454662220050216
    .646449294511763260020107016376
    .647182587442797309962460607803
    .647914917459853497218181263899
    .648646284364634631860527333147
    .649376687962954222750275011925
    .650106128064732231662936784382
    .650834604483990800178420439389
    .651562117038849949411734135807
    .652288665551523252663564988350
    .653014249848313481069779251444
    .653738869759608222329111385968
    .654462525119875472588527102026
    .655185215767659201565961878239
    .655906941545574890990351462919
    .656627702300305046439084463282
    .657347497882594682653219324036
    .658066328147246782411018784758
    .658784192953117729040564284893
    .659501092163112712652420754555
    .660217025644181110173528787160
    .660931993267311839263706334790
    .661645994907528686196345797781
    .662359030443885607785094694932
    .663071099759462007438508998644
    .663782202741357985424867698915
    .664492339280689563429535220141
    .665201509272583883487454953926
    .665909712616174381373552388256
    .666616949214595934534020107376
    .667323218974979984641649306263
    .668028521808449634858563407625
    .668732857630114721889898886751
    .669436226359066862912166499224
    .670138627918374477460212767382
    .670840062235077784356886812532
    .671540529240183773769701420168
    .672240028868661154478959593993
    .672938561059435276441998790259
    .673636125755383028738384526124
    .674332722903327712981063123252
    .675028352454033892278659980092
    .675723014362202215834284962182
    .676416708586464219266380258696
    .677109435089377100737318374481
    .677801193837418472975628809244
    .678491984800981091277901418654
    .679181807954367557576582455153
    .679870663275785000660045848647
    .680558550747339732631487408182
    .681245470355031881693353304720
    .681931422088750001344176431540
    .682616405942265656074855031999
    .683300421913227983651567333987
    .683983470003158234072673835693
    .684665550217444285287115347973
    .685346662565335135761969914042
    .686026807059935373986985297084
    .686705983718199625004055850223
    .687384192560926974049763260722
    .688061433612755367399249891003
    .688737706902155990499841222665
    .689413012461427623482980245912
    .690087350326690974143181525345
    .690760720537882988472856113740
    .691433123138751138842000477908
    .692104558176847689911883144904
    .692775025703523942372001872526
    .693444525773924454589721795002
    .694113058446981242262141193042
    .694780623785407956159866286724
    .695447221855694038052509750184
    .696112852728098854905859498451
    .696777516476645811440794699291
    .697441213179116441144154916377
    .698103942917044475821895794653
    .698765705775709893784990754436
    .699426501844132946758662767674
    .700086331215068165605653448004
    .700745193984998344954358395933
    .701403090254128506822778001790
    .702060020126379843329351722249
    .702715983709383638581861211446
    .703370981114475169835703605200
    .704025012456687588012950726926
    .704678077854745777673723006755
    .705330177431060196531518481496
    .705981311311720694604247372720
    .706631479626490313092831423788
    .707280682508799063079334414508
    .707928920095737684136696064670
    .708576192528051382942245885465
    .709222499950133551987276441190
    .709867842510019468475056943187
    .710512220359379973499768114176
    .711155633653515131598937834591
    .711798082551347870772054213765
    .712439567215417603058128418424
    .713080087811873825765073839641
    .713719644510469703443860987706
    .714358237484555630700498873044
    .714995866911072775938983561058
    .715632532970546606128443080246
    .716268235847080392687794916979
    .716902975728348698581317947638
    .717536752805590846718624840203
    .718169567273604369752603703738
    .718801419330738441368979076298
    .719432309178887289161222220521
    .720062237023483589184619142444
    .720691203073491842283381763797
    .721319207541401732284763262193
    .721946250643221466154212748101
    .722572332598471096205677173388
    .723197453630175824461229664484
    .723821613964859289254273344891
    .724444813832536834170638157977
    .725067053466708759421955222738
    .725688333104353555745758853730
    .726308652985921120926830552639
    .726928013355325959034362034333
    .727546414459940362469575685712
    .728163856550587576918500772587
    .728780339881534949304662209372
    .729395864710487058836495789806
    .730010431298578831244359445487
    .730624039910368636302064354135
    .731236690813831368727902562319
    .731848384280351512560199219452
    .732459120584716189102467542392
    .733068900005108188533293244486
    .733677722823098985276122370700
    .734285589323641737224172283103
    .734892499795064268915729939830
    .735498454529062038755144607287
    .736103453820691090374863741184
    .736707497968360988233900968689
    .737310587273827737548163902976
    .737912722042186688648106924386
    .738513902581865425859210070911
    .739114129204616641000819796318
    .739713402225510991598920578687
    .740311721962929943908438197062
    .740909088738558600840705940997
    .741505502877378514891754078748
    .742100964707660486167110586503
    .742695474560957345598827434970
    .743289032772096723450471642865
    .743881639679173803205843840915
    .744473295623544060937209246921
    .745064000949815990248846734014
    .745653756005843812891741082281
    .746242561142720175145261540423
    .746830416714768830061686490919
    .747417323079537305669449311195
    .748003280597789559230994456548
    .748588289633498617651145360028
    .749172350553839204131896952069
    .749755463729180351169555450501
    .750337629533077999990156561615
    .750918848342267586519100367335
    .751499120536656613980946954275
    .752078446499317212225321269733
    .752656826616478683874878769508
    .753234261277520037391285155052
    .753810750874962507155163885040
    .754386295804462060655964191056
    .754960896464801892887700031150
    .755534553257884908046506780498
    .756107266588726188625957487784
    .756679036865445452006074221302
    .757249864499259494631962392577
    .757819749904474623877986979711
    .758388693498479077693399280116
    .758956695701735432125311205081
    .759523756937772996814901189110
    .760089877633180198562721527576
    .760655058217596953058961379379
    .761219299123707024874502779341
    .761782600787230375808588800548
    .762344963646915501688903492167
    .762906388144531757719842395942
    .763466874724861672474730317103
    .764026423835693250627719595335
    .764585035927812264521077391287
    .765142711454994534663544476447
    .765699450873998199255420691604
    .766255254644555972836003624225
    .766810123229367394148977150442
    .767364057094091063321315295694
    .767917056707336868451234391995
    .768469122540658201700692751992
    .769020255068544164987902043191
    .769570454768411765375278232567
    .770119722120598100248222385093
    .770668057608352532380082742179
    .771215461717828854978609380413
    .771761934938077446809171360174
    .772307477761037417489963620301
    .772852090681528743054386962118
    .773395774197244391875739296275
    .773938528808742441049309902232
    .774480355019438183326920775414
    .775021253335596224698910214140
    .775561224266322572718503630266
    .776100268323556715663465156947
    .776638386022063692629870977059
    .777175577879426154652791409495
    .777711844416036416948613670847
    .778247186155088502373680879777
    .778781603622570176193865293833
    .779315097347254972259634966444
    .779847667860694210681112988562
    .780379315697209007097567237789
    .780910041393882273635706101082
    .781439845490550711651091968238
    .781968728529796796346919415537
    .782496691056940753364338915222
    .783023733620032527438439620101
    .783549856769843743213936286678
    .784075061059859658314535717899
    .784599347046271108759887231220
    .785122715287966446823949592321
    .785645166346523471428533602695
    .786166700786201351165705093813
    .786687319173932540042657464765
    .787207022079314686042586107616
    .787725810074602532595019098301
    .788243683734699813048979394250
    .788760643637151138242273476170
    .789276690362133877260119904023
    .789791824492450031476248629500
    .790306046613518101969518122577
    .790819357313364950409012431450
    .791331757182617653500494206637
    .791843246814495351087002484785
    .792353826804801087996295649071
    .792863497751913649727750464551
    .793372260256779392071237431775
    .793880114922904064750400914003
    .794387062356344629182679575809
    .794893103165701070448308627321
    .795398237962108203560450202305
    .795902467359227474128501913247
    .796405791973238753506536226119
    .796908212422832128518724785142
    .797409729329199685853502197138
    .797910343316027291218123059645
    .798410055009486363345164190322
    .798908865038225642942421091050
    .799406774033362956677543662005
    .799903782628476976288651072642
    .800399891459598972912059501423
    .800895101165204566718149178141
    .801389412386205471946288805293
    .801882825765941237429626001964
    .802375341950170982700441908732
    .802866961587065129766656518933
    .803357685327197130649958663914
    .803847513823535190775920881437
    .804336447731433988306344640896
    .804824487708626389503965590211
    .805311634415215160219531631008
    .805797888513664673591148724651
    .806283250668792614045670385808
    .806767721547761677691786836134
    .807251301820071269194348772355
    .807733992157549195219338654161
    .808215793234343354538779341910
    .808696705726913424884745815872
    .809176730314022546641520591630
    .809655867676729003464807314046
    .810134118498377899916789868877
    .810611483464592836205696200515
    .811087963263267580118396870413
    .811563558584557736234438237354
    .812038270120872412509778991886
    .812512098566865884318366636791
    .812985044619429256039557377455
    .813457108977682120279248774283
    .813928292342964214812459418004
    .814398595418827077334953821616
    .814868018911025698111373684001
    .815336563527510170607198673799
    .815804229978417340191720911979
    .816271018976062450999077401764
    .816736931234930791034243769145
    .817201967471669335610750840183
    .817666128405078389206742796745
    .818129414756103225825851924291
    .818591827247825727949220297850
    .819053366605456024164853149568
    .819514033556324125560342127159
    .819973828829871560964849191434
    .820432753157643011126093516843
    .820890807273277941907934455841
    .821347991912502236593993409938
    .821804307813119827382606321655
    .822259755715004326158246466500
    .822714336360090654624404286499
    .823168050492366673882757171114
    .823620898857864813543307361532
    .824072882204653700450010534642
    .824524001282829787106261117596
    .824974256844508979884442996980
    .825423649643818267103596022362
    .825872180436887347059089566681
    .826319849981840256088034399716
    .826766659038786996754003259964
    .827212608369815166234468778931
    .827657698738981584994204824273
    .828101930912303925827733888722
    .828545305657752343353738864471
    .828987823745241104044192412029
    .829429485946620216870791162635
    .829870293035667064651115188528
    .830310245788078036176765539890
    .830749344981460159205564185475
    .831187591395322734399731410012
    .831624985811068970291785619843
    .832061529011987619359739593076
    .832497221783244615292995486255
    .832932064911874711530168380418
    .833366059186773121149894819739
    .833799205398687158195508670080
    .834231504340207880514291707117
    .834662956805761734191830638413
    .835093563591602199661835775472
    .835523325495801439571599304523
    .835952243318241948483093063161
    .836380317860608204489526918139
    .836807549926378322827009262107
    .837233940320815711560770808216
    .837659489850960729425231765626
    .838084199325622345897010630522
    .838508069555369803579790230530
    .838931101352524282979773319975
    .839353295531150569750275943468
    .839774652907048724483821970402
    .840195174297745755129916657377
    .840614860522487292116490823818
    .841033712402229266252820232530
    .841451730759629589491537056010
    .841868916419039838627161885494
    .842285270206496942008395607368
    .842700792949714869341220635083];
y2=erf(x2);
e2=max( norm((y2ref-y2)./abs(y2ref),1),  norm((y2ref+erf(-x2))./abs(y2ref),1));

x3=(1:1000)'/100;
y3ref=[
    .112834155558496169159095235481e-1
    .225645746918449442243658616474e-1
    .338412223417354333022166542569e-1
    .451111061451247520897490647292e-1
    .563719777970166238312711126020e-1
    .676215943933084420794314523912e-1
    .788577197708907433569970386680e-1
    .900781258410181607233921876161e-1
    .101280593914626883352498163244
    .112462916018284892203275071744
    .123622896199474309769838562628
    .134758351819920069295014126058
    .145867114835695749082957608895
    .156947033062855800871902246476
    .167995971427363494770209522381
    .179011813198105671155183728287
    .189992461201808793395081985931
    .200935839018695792648412710622
    .211839892157749742936947248988
    .222702589210478454140139006800
    .233521922982103572925263000421
    .244295911599128684869261694261
    .255022599592273160770178527263
    .265700058953792029795712090025
    .276326390168236932985068267765
    .286899723215749152048332055369
    .297418218547012757893881942436
    .307880068029034016648999599572
    .318283495860952262338991948381
    .328626759459127427638914047867
    .338908150310790248699499364816
    .349125994795582757315694633242
    .359278654974358972988253953358
    .369364529344658637204123996972
    .379382053562310320297299983619
    .389329701128664204753628450550
    .399205984042999234582143710203
    .409009453419694044918239128676
    .418738700069796075759557782169
    .428392355046668455103603845320
    .437969090155439536373130097283
    .447467618426025319819410593897
    .456886694549540304987442003670
    .466225115277957539319704643377
    .475481719786923675319681525460
    .484655390001679655026703122572
    .493745050886082136517091596899
    .502749670694764894533266228628
    .511668261188523099211696708386
    .520499877813046537682746653892
    .529243619841170429010070312239
    .537898630478854431106614413389
    .546464096935141688222532672455
    .554939250456390260497539494224
    .563323366325108955991688363557
    .571615763823768395668683848890
    .579815806163996030236781957527
    .587922900381600743987036943270
    .595936497197908576518188514610
    .603856090847925922562622436057
    .611681218875880289504687484527
    .619411461898721260562291908088
    .627046443338195690464736260557
    .634585829122141313859705694454
    .642029327355671841292946466331
    .649376687962954222750275011925
    .656627702300305046439084463282
    .663782202741357985424867698915
    .670840062235077784356886812532
    .677801193837418472975628809244
    .684665550217444285287115347973
    .691433123138751138842000477908
    .698103942917044475821895794653
    .704678077854745777673723006755
    .711155633653515131598937834591
    .717536752805590846718624840203
    .723821613964859289254273344891
    .730010431298578831244359445487
    .736103453820691090374863741184
    .742100964707660486167110586503
    .748003280597789559230994456548
    .753810750874962507155163885040
    .759523756937772996814901189110
    .765142711454994534663544476447
    .770668057608352532380082742179
    .776100268323556715663465156947
    .781439845490550711651091968238
    .786687319173932540042657464765
    .791843246814495351087002484785
    .796908212422832128518724785142
    .801882825765941237429626001964
    .806767721547761677691786836134
    .811563558584557736234438237354
    .816271018976062450999077401764
    .820890807273277941907934455841
    .825423649643818267103596022362
    .829870293035667064651115188528
    .834231504340207880514291707117
    .838508069555369803579790230530
    .842700792949714869341220635083
    .846810496228276697886304168608
    .850838017700942042052443797678
    .854784211454148381612389223130
    .858649946526651453191924862667
    .862436106090096697765225802369
    .866143586635108082774536825816
    .869773297163586659132689545761
    .873326158387889589649984139486
    .876803101937538279856830082636
    .880205069574081699771867766322
    .883533012414718050732088822843
    .886787890165254649549837295827
    .889970670362962317254717716140
    .893082327629856715369184913907
    .896123842936915012419506280749
    .899096202879712030000041279757
    .902000398965935653353894127360
    .904837426915216837567544967696
    .907608285971685037790484905145
    .910313978229635380238405775715
    .912955507972669409081355862097
    .915533881026646830667192778601
    .918050104126761367892733003921
    .920505184299029669863949485264
    .922900128256458230136523481197
    .925235941810129484510735701213
    .927513629295424719100127785559
    .929734193013578152514172319937
    .931898632688733592554242962899
    .934007944940652436603893327504
    .936063122773199513379509123921
    .938065155078711378050908607034
    .940015026158330197754594721551
    .941913715258365323657306592595
    .943762196122724061065830197376
    .945561436561433041323207220960
    .947312398035251987699776423971
    .949016035256362570111835075789
    .950673295805096476827758302413
    .952285119762648810516482691533
    .953852439359705454847226275613
    .955376178640896168788291303906
    .956857253144968859850496783450
    .958296569600564774513511293169
    .959695025637459232377442841965
    .961053509513118027313720864175
    .962372899854405729886810572718
    .963654065414268855166142007980
    .964897864843204212102907237564
    .966105146475310727066976261646
    .967276748128711635913825991249
    .968413496920123165931303771472
    .969516209093335679948252100952
    .970585689861363727448926556465
    .971622733262012538372566218848
    .972628122026600200033798766967
    .973602627461567070965915933850
    .974547009342696901235480736712
    .975462015821667639794133856309
    .976348383344644007774283447142
    .977206836582618593554778863365
    .978038088373203471420329149739
    .978842839673570150500482990249
    .979621779524232013515386782363
    .980375585023360294162452056584
    .981104921311322055650338501742
    .981810441565126558280197511885
    .982492787002464827943095818625
    .983152586895026146341339142860
    .983790458590774563626242588122
    .984407007544868370574911769514
    .985002827358905745666562259787
    .985578499828180497431188071400
    .986134594996632938939331448608
    .986671671219182443772211100129
    .987190275231130125566791385785
    .987690942224322340437040798990
    .988174195929768317289393751016
    .988640548706408159263283944287
    .989090501635730714183732810756
    .989524544621944366953582063504
    .989943156497407646205094917059
    .990346805133030645297761617229
    .990735947553362618000490567051
    .991111030056085706155209611037
    .991472488335639574649460683136
    .991820747610706752658708197512
    .992156222755293694076721035182
    .992479318433147959270641806759
    .992790429235257469948357539303
    .993089939820183484438217176392
    .993378225056984767759469410979
    .993655650170496375504198387176
    .993922570888732519066543703907
    .994179333592189118776835823032
    .994426275464827868000969423733
    .994663724646529912575485409079
    .994892000386813583757222594664
    .995111413199616997238347240473
    .995322265018952734162069256367
    .995524849355248241312063095812
    .995719451452192015978667962525
    .995906348443912066070672206288
    .996085809512319547895015186555
    .996258096044456873132539403263
    .996423461789695933775340133868
    .996582153016638410456032750651
    .996734408669576397404103730037
    .996880460524377788338765083357
    .997020533343667014496114983359
    .997154845031177801648947935145
    .997283606785160610778704424574
    .997407023250733340776017430629
    .997525292671069695356701128080
    .997638607037325344858750510486
    .997747152237207641699492752613
    .997851108202100171372238604809
    .997950649052658834678792689617
    .998045943242801457529123598681
    .998137153702018108556548243971
    .998224437975934368814823456418
    .998307948365064739107358899411
    .998387832061698186549948381543
    .998464231284862520615844968012
    .998537283413318848302089203627
    .998607121116541786642636179664
    .998673872483645407328130841341
    .998737661150219051712021176125
    .998798606423041184302074966729
    .998856823402643348534652540619
    .998912423103700050040183186321
    .998965512573224019809695702911
    .999016195006549802974102506547
    .999064569861091978842035580567
    .999110732967867545150889457574
    .999154776640775095111631875309
    .999196789783626380902110236962
    .999236857994928693095373816179
    .999275063670419193575791325720
    .999311486103354921430255067829
    .999346201582564648884855889296
    .999379283488271099505730786095
    .999410802385694255639232279065
    .999440826116448578590455613973
    .999469419887748945596553592536
    .999496646359441974605567857956
    .999522565728881163674247158931
    .999547235813665918980235727034
    .999570712132266086606322840203
    .999593047982555041060435784260
    .999614294518275720661920525512
    .999634500823465239215586949345
    .999653713984864847611602181550
    .999671979162343070964281585399
    .999689339657360809492885128231
    .999705836979508067426713308202
    .999721510911142766670000652366
    .999736399570162813678909351557
    .999750539470943221871743838747
    .999763965583470650796008996792
    .999776711390708210081765550549
    .999788808944223793772524050934
    .999800288918115561773567671981
    .999811180661268472697859895005
    .999821512247975999096039245139
    .999831310526961324669729427063
    .999840601168832436289035175306
    .999849408712005584127086981217
    .999857756607131593604098286620
    .999865667260059475670859881280
    .999873162073371699777588724418
    .999880261486525369137320906902
    .999886985014633373018310896415
    .999893351285919388145981320942
    .999899378077880363163095608025
    .999905082352189848729209758969
    .999910480288375233419033074670
    .999915587316301614224693273483
    .999920418147494672237462812221
    .999924986805334540975776754752
    .999929306654152248770470340745
    .999933390427259889483440616000
    .999937250253945229426788983291
    .999940897685460994406321233484
    .999944343720038601012541387426
    .999947598826955602236751136866
    .999950672969685610748981162883
    .999953575628158945224766772600
    .999956315820161717373450749551
    .999958902121900541164316132511
    .999961342687759502470105416051
    .999963645269275478192029159049
    .999965817233357340078774458885
    .999967865579774021028779347453
    .999969796957935861737625829429
    .999971617682993094132438878915
    .999973333751274756079605293012
    .999974950855090770264458608094
    .999976474396919359773183773153
    .999977909503001414558627223870
    .999979261036362867394040426859
    .999980533609285585815045302128
    .999981731595246738576624671730
    .999982859140346051919801542932
    .999983920174239833019164107976
    .999984918420600105892450039369
    .999985857407116679281055505040
    .999986740475059447000170883915
    .999987570788417709415870356510
    .999988351342632800403966293837
    .999989084972939807716761399466
    .999989774362333686430314532983
    .999990422049174585335565365967
    .999991030434446735009890260323
    .999991601788684784070190825728
    .999992138258581016945168598578
    .999992641873286442566995483560
    .999993114550418308799710348013
    .999993558101786172297789983350
    .999993974238848237905028257637
    .999994364577909275721057139761
    .999994730645071027620087574688
    .999995073880945628324028274273
    .999995395645142189112254826297
    .999995697220536324878169524105
    .999995979817332047487635384467
    .999996244576925100210857162634
    .999996492575576469327953008413
    .999996724827904479777092287035
    .999996942290203561838538196597
    .999997145863597465233101167206
    .999997336397034395554134612132
    .999997514690131255533767551989
    .999997681495873890143583639601
    .999997837523179959816750326118
    .999997983439330800015058664371
    .999998119872278367806604007120
    .999998247412833126918516822639
    .999998366616738481729929719677
    .999998478006637137714638242862
    .999998582073934540768368551870
    .999998679280564330496741742403
    .999998770060660532728832182400
    .999998854822141014087435215358
    .999998933948206526218905503710
    .999999007798759479089598360193
    .999999076711746401418634470684
    .999999141004427871663589193713
    .999999200974579534832405212782
    .999999256901627658587254476316
    .999999309047722526460750589923
    .999999357658752816349254991422
    .999999402965303968610621548877
    .999999445183563409904602391610
    .999999484516175366204968200593
    .999999521153047871016724875387
    .999999555272114452585246711416
    .999999587040052866624547428960
    .999999616612963128659530455453
    .999999644137006992314701184444
    .999999669749010916634964353452
    .999999693577034466641036818617
    .999999715740905996653837826725
    .999999736352727375323111211250
    .999999755517349424622675552567
    .999999773332819662188394430113
    .999999789890803857138683454022
    .999999805276982833797808638200
    .999999819571425885409309834693
    .999999832848942090853797625924
    .999999845179410761448597354666
    .999999856628092181986012402275
    .999999867255919750145399560419
    .999999877119774561178120406869
    .999999886272743430203346740923
    .999999894764361292459492770171
    .999999902640838872326778435481
    .999999909945276464770342238222
    .999999916717864627952816999842
    .999999922996072543035871301802
    .999999928814824756540487444583
    .999999934206666981977303113488
    .999999939201921600705773558932
    .999999943828833467051722383598
    .999999948113706589527419217230
    .999999952081032228479841109489
    .999999955753608920567184625380
    .999999959152654912059634443601
    .999999962297913456009131347825
    .999999965207751402768257721692
    .999999967899251489096718973094
    .999999970388298708114035029833
    .999999972689661120580136629049
    .999999974817065447355070745065
    .999999976783267763350692539111
    .999999978600119594788977794192
    .999999980278629704073471565005
    .999999981829021830014495012629
    .999999983260788635479156623334
    .999999984582742099719981147840
    .999999985803060578628973811310
    .999999986929332742926880683289
    .999999987968598591791737966987
    .999999988927387727619660545652
    .999999989811755066458969764928
    .999999990627314148132540129413
    .999999991379268200130507554931
    .999999992072439099985541182296
    .999999992711294372006455502990
    .999999993299972345915101627273
    .999999993842305597079599254842
    .999999994341842780638678614115
    .999999994801868964843020600827
    .999999995225424562376994050149
    .999999995615322952246179748760
    .999999995974166879001692277508
    .999999996304363710601732706064
    .999999996608139631065173452552
    .999999996887552839233372260657
    .999999997144505820407811384251
    .999999997380756753356393392959
    .999999997597930111164948394378
    .999999997797526510638153870829
    .999999997980931861411820942592
    .999999998149425862613257479944
    .999999998304189891785759031526
    .999999998446314327865433847648
    .999999998576805347252389970251
    .999999998696591229443243860141
    .999999998806528206277958696049
    .999999998907405886591730810310
    .999999998999952285943070625742
    .999999999084838489103912519130
    .999999999162682971138541822782
    .999999999234055601157792481190
    .999999999299481351206209929341
    .999999999359443731215952324699
    .999999999414387969535758671457
    .999999999464723957210342368592
    .999999999510828972939411158204
    .999999999553050204480829840790
    .999999999591707081174196866309
    .999999999627093431244556363867
    .999999999659479476596644416418
    .999999999689113676923763682342
    .999999999716224434128131400491
    .999999999741021667277623092956
    .999999999763698267603729136774
    .999999999784431442373953599011
    .999999999803383955845711252372
    .999999999820705274925102741430
    .999999999836532626610028664238
    .999999999850991973790366257485
    .999999999864198915505959672120
    .999999999876259517323696760115
    .999999999887271077085831737278
    .999999999897322830900965564833
    .999999999906496603894840018641
    .999999999914867409908579731433
    .999999999922504004025581681081
    .999999999929469391523360046216
    .999999999935821296581860068320
    .999999999941612593833703413425
    .999999999946891705613251788340
    .999999999951702967549088757474
    .999999999956086964947411723804
    .999999999960080842230858548658
    .999999999963718587527495376468
    .999999999967031294347156301432
    .999999999970047402136203396795
    .999999999972792917366274934705
    .999999999975291616686970292862
    .999999999977565233555991084915
    .999999999979633629652374485489
    .999999999981514952278514689113
    .999999999983225778864110488445
    .999999999984781249599477465139
    .999999999986195189146334073036
    .999999999987480218300756940077
    .999999999988647856415078039045
    .999999999989708615322670025486
    .999999999990672085451468209992
    .999999999991547014758365897407
    .999999999992341381066975482692
    .999999999993062458345374197899
    .999999999993716877418074910249
    .999999999994310681567322356423
    .999999999994849377442675180285
    .999999999995337981664472470081
    .999999999995781063475994218570
    .999999999996182783770716950599
    .999999999996546930794861023726
    .999999999996876952801259878530
    .999999999997175987908300720353
    .999999999997446891397148719442
    .999999999997692260661541069459
    .999999999997914458007000963805
    .999999999998115631480261460748
    .999999999998297733894900324134
    .999999999998462540205571965150
    .999999999998611663370691457092
    .999999999998746568831894794398
    .999999999998868587727991854116
    .999999999998978928951372376787
    .999999999999078690145854538527
    .999999999999168867736719118814
    .999999999999250366076093262174
    .999999999999324005779884039855
    .999999999999390531326065053131
    .999999999999450617978244470040
    .999999999999504878093048843929
    .999999999999553866864905673402
    .999999999999598087557263701516
    .999999999999637996265120898687
    .999999999999674006249905918680
    .999999999999706491884251872353
    .999999999999735792240985991292
    .999999999999762214357711603317
    .999999999999786036205658104257
    .999999999999807509389000276403
    .999999999999826861598581937643
    .999999999999844298841903523956
    .999999999999860007469333172102
    .999999999999874156014761780234
    .999999999999886896867331128461
    .999999999999898367789408243565
    .999999999999908693294647572811
    .999999999999917985898764872331
    .999999999999926347254533528257
    .999999999999933869181496592017
    .999999999999940634599958109874
    .999999999999946718377967996920
    .999999999999952188099238983211
    .999999999999957104759225833219
    .999999999999961523395950406804
    .999999999999965493661565956818
    .999999999999969060340115542622
    .999999999999972263816448174868
    .999999999999975140500808254347
    .999999999999977723213205322052
    .999999999999980041531298703032
    .999999999999982122105192191147
    .999999999999983988942224634412
    .999999999999985663664560529668
    .999999999999987165742128129508
    .999999999999988512703218914430
    .999999999999989720324849585256
    .999999999999990802804794151544
    .999999999999991772917017553673
    .999999999999992642152082025602
    .999999999999993420843951679358
    .999999999999994118284488289052
    .999999999999994742826810799941
    .999999999999995301978581616314
    .999999999999995802486183252850
    .999999999999996250410658574798
    .999999999999996651196205787507
    .999999999999997009731944821516
    .999999999999997330407604116545
    .999999999999997617163715416982
    .999999999999997873536848487795
    .999999999999998102700367128162
    .999999999999998307501142030855
    .999999999999998490492614480613
    .999999999999998653964567214376
    .999999999999998799969924625156
    .999999999999998930348873555947
    .999999999999999046750567905987
    .999999999999999150652654890572
    .999999999999999243378837813750
    .999999999999999326114669408407
    .999999999999999399921750968712
    .999999999999999465750495461908
    .999999999999999524451597393236
    .999999999999999576786338257426
    .999999999999999623435843805072
    .999999999999999665009397956809
    .999999999999999702051907899012
    .999999999999999735050605588257
    .999999999999999764441062484356
    .999999999999999790612586738276
    .999999999999999813913065204374
    .999999999999999834653306456241
    .999999999999999853110935398287
    .999999999999999869533885023630
    .999999999999999884143526320489
    .999999999999999897137473226909
    .999999999999999908692095834299
    .999999999999999918964771705183
    .999999999999999928095902164495
    .999999999999999936210717714908
    .999999999999999943420894286201
    .999999999999999949825999830484
    .999999999999999955514788795568
    .999999999999999960566360226603
    .999999999999999965051193641935
    .999999999999999969032075385547
    .999999999999999972564926859643
    .999999999999999975699544872679
    .999999999999999978480263287501
    .999999999999999980946544209704
    .999999999999999983133506107170
    .999999999999999985072395488763
    .999999999999999986791008084481
    .999999999999999988314064853606
    .999999999999999989663547594210
    .999999999999999990858998430876
    .999999999999999991917787011636
    .999999999999999992855348845106
    .999999999999999993685397849806
    .999999999999999994420115865639
    .999999999999999995070321588691
    .999999999999999995645621131572
    .999999999999999996154542179352
    .999999999999999996604653503085
    .999999999999999997002671406493
    .999999999999999997354554514356
    .999999999999999997665588161544
    .999999999999999997940459507718
    .999999999999999998183324382762
    .999999999999999998397866760705
    .999999999999999998587351663832
    .999999999999999998754672212757
    .999999999999999998902391461365
    .999999999999999999032779586812
    .999999999999999999147846943312
    .999999999999999999249373433521
    .999999999999999999338934602234
    .999999999999999999417924813275
    .999999999999999999487577831260
    .999999999999999999548985094960
    .999999999999999999603111937724
    .999999999999999999650811982582
    .999999999999999999692839914702
    .999999999999999999729862811754
    .999999999999999999762470192844
    .999999999999999999791182929090
    .999999999999999999816461143107
    .999999999999999999838711210662
    .999999999999999999858291965233
    .999999999999999999875520195052
    .999999999999999999890675512287
    .999999999999999999904004665169
    .999999999999999999915725355977
    .999999999999999999926029620812
    .999999999999999999935086820804
    .999999999999999999943046288882
    .999999999999999999950039671274
    .999999999999999999956182998499
    .999999999999999999961578516729
    .999999999999999999966316306896
    .999999999999999999970475715854
    .999999999999999999974126621137
    .999999999999999999977330548427
    .999999999999999999980141658686
    .999999999999999999982607619952
    .999999999999999999984770377140
    .999999999999999999986666831608
    .999999999999999999988329440957
    .999999999999999999989786748321
    .999999999999999999991063849316
    .999999999999999999992182803924
    .999999999999999999993162999725
    .999999999999999999994021472148
    .999999999999999999994773186779
    .999999999999999999995431288155
    .999999999999999999996007318998
    .999999999999999999996511413336
    .999999999999999999996952466602
    .999999999999999999997338285424
    .999999999999999999997675719485
    .999999999999999999997970777604
    .999999999999999999998228729881
    .999999999999999999998454197563
    .999999999999999999998651232111
    .999999999999999999998823384717
    .999999999999999999998973767448
    .999999999999999999999105106983
    .999999999999999999999219791852
    .999999999999999999999319913943
    .999999999999999999999407304972
    .999999999999999999999483568506
    .999999999999999999999550108100
    .999999999999999999999608151990
    .999999999999999999999658774772
    .999999999999999999999702916432
    .999999999999999999999741399036
    .999999999999999999999774941378
    .999999999999999999999804171825
    .999999999999999999999829639581
    .999999999999999999999851824560
    .999999999999999999999871146047
    .999999999999999999999887970276
    .999999999999999999999902617084
    .999999999999999999999915365725
    .999999999999999999999926459976
    .999999999999999999999936112595
    .999999999999999999999944509236
    .999999999999999999999951811861
    .999999999999999999999958161744
    .999999999999999999999963682079
    .999999999999999999999968480280
    .999999999999999999999972649977
    .999999999999999999999976272771
    .999999999999999999999979419766
    .999999999999999999999982152904
    .999999999999999999999984526136
    .999999999999999999999986586443
    .999999999999999999999988374729
    .999999999999999999999989926597
    .999999999999999999999991273035
    .999999999999999999999992441002
    .999999999999999999999993453952
    .999999999999999999999994332284
    .999999999999999999999995093736
    .999999999999999999999995753729
    .999999999999999999999996325667
    .999999999999999999999996821200
    .999999999999999999999997250449
    .999999999999999999999997622205
    .999999999999999999999997944106
    .999999999999999999999998222780
    .999999999999999999999998463985
    .999999999999999999999998672716
    .999999999999999999999998853310
    .999999999999999999999999009528
    .999999999999999999999999144634
    .999999999999999999999999261456
    .999999999999999999999999362450
    .999999999999999999999999449743
    .999999999999999999999999525177
    .999999999999999999999999590352
    .999999999999999999999999646650
    .999999999999999999999999695272
    .999999999999999999999999737256
    .999999999999999999999999773500
    .999999999999999999999999804783
    .999999999999999999999999831779
    .999999999999999999999999855070
    .999999999999999999999999875161
    .999999999999999999999999892489
    .999999999999999999999999907430
    .999999999999999999999999920310
    .999999999999999999999999931412
    .999999999999999999999999940978
    .999999999999999999999999949221
    .999999999999999999999999956321
    .999999999999999999999999962436
    .999999999999999999999999967701
    .999999999999999999999999972234
    .999999999999999999999999976135
    .999999999999999999999999979492
    .999999999999999999999999982381
    .999999999999999999999999984865
    .999999999999999999999999987002
    .999999999999999999999999988839
    .999999999999999999999999990419
    .999999999999999999999999991776
    .999999999999999999999999992943
    .999999999999999999999999993945
    .999999999999999999999999994806
    .999999999999999999999999995546
    .999999999999999999999999996181
    .999999999999999999999999996726
    .999999999999999999999999997194
    .999999999999999999999999997595
    .999999999999999999999999997940
    .999999999999999999999999998235
    .999999999999999999999999998488
    .999999999999999999999999998706
    .999999999999999999999999998892
    .999999999999999999999999999052
    .999999999999999999999999999188
    .999999999999999999999999999306
    .999999999999999999999999999406
    .999999999999999999999999999492
    .999999999999999999999999999566
    .999999999999999999999999999629
    .999999999999999999999999999683
    .999999999999999999999999999729
    .999999999999999999999999999768
    .999999999999999999999999999802
    .999999999999999999999999999831
    .999999999999999999999999999856
    .999999999999999999999999999877
    .999999999999999999999999999895
    .999999999999999999999999999910
    .999999999999999999999999999923
    .999999999999999999999999999935
    .999999999999999999999999999944
    .999999999999999999999999999952
    .999999999999999999999999999959
    .999999999999999999999999999965
    .999999999999999999999999999971
    .999999999999999999999999999975
    .999999999999999999999999999979
    .999999999999999999999999999982
    .999999999999999999999999999985
    .999999999999999999999999999987
    .999999999999999999999999999989
    .999999999999999999999999999990
    .999999999999999999999999999992
    .999999999999999999999999999993
    .999999999999999999999999999994
    .999999999999999999999999999995
    .999999999999999999999999999996
    .999999999999999999999999999996
    .999999999999999999999999999997
    .999999999999999999999999999997
    .999999999999999999999999999998
    .999999999999999999999999999998
    .999999999999999999999999999998
    .999999999999999999999999999999
    .999999999999999999999999999999
    .999999999999999999999999999999
    .999999999999999999999999999999
    .999999999999999999999999999999
    .999999999999999999999999999999
    .999999999999999999999999999999
    1.00000000000000000000000000000
    1.00000000000000000000000000000
    1.00000000000000000000000000000
    1.00000000000000000000000000000
    1.00000000000000000000000000000
    1.00000000000000000000000000000
    1.00000000000000000000000000000
    1.00000000000000000000000000000
    1.00000000000000000000000000000
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.
    1.];
y3=erf(x3);
e3=max( norm((y3ref-y3)./abs(y3ref),1),  norm((y3ref+erf(-x3))./abs(y3ref),1));

if or([e1 e2 e3]>1d-12) then pause,end

if (abs(erf(0))>1d-15) then pause,end

if (abs(erf(%inf)-1)>1d-15) then pause,end

x4=0.46875;
w4=0.47;
z4=0.46;
deff("y=f(t)","y=exp(-t^2)");
if (abs(erf(x4)-2/sqrt(%pi)*intg(0,x4,f))>10*%eps) then pause,end
if (abs(erf(w4)-2/sqrt(%pi)*intg(0,w4,f))>10*%eps) then pause,end
if (abs(erf(z4)-2/sqrt(%pi)*intg(0,z4,f))>10*%eps) then pause,end

x5=-0.001; 
w5=-0.25;
z5=-0.5;
deff("y=f(t)","y=exp(-t^2)");
if (abs(erf(x5)-2/sqrt(%pi)*intg(0,x5,f))>10*%eps) then pause,end
if (abs(erf(w5)-2/sqrt(%pi)*intg(0,w5,f))>10*%eps) then pause,end
if (abs(erf(z5)-2/sqrt(%pi)*intg(0,z5,f))>10*%eps) then pause,end

funcprot(1);

