// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) INRIA/ENPC
// 
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at    
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
function ilib_gen_loader(name,tables,libs)

  [lhs,rhs]=argn(0);

  if rhs < 3 then 
    libs = [];
  end 

  if ( typeof(tables) <> 'list') then 
    tables = list(tables);
  end
  
  L = length(tables); 
  for it = 1:L 
    [mt,nt] = size(tables(it));
    if ((mt == 0) & (nt == 0)) then
       break;
    end
    if ( (nt <> 3) & ( nt <> 2) ) then 
      error(msprintf(gettext("%s: Wrong size for input argument #%d.\n"),"ilib_gen_loader",2));
    end 
  end
  
  if length(name) + length('_path') > 24 then
    name_path = part(name,1:(24 - length('_path')));
  else
    name_path = name;
  end
  
  fd=mopen('loader.sce',"wt");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"// generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"\n");
  mfprintf(fd,"%s_path = get_file_path(''loader.sce'');\n",name_path);

  nl = size(libs,'*');
  for i=1:nl 
    // Add the relative path only if the lib has a relative path
    isabspath = is_absolute_path(libs(i));
    ext = getdynlibext();
    libfile = libs(i);
    if isabspath then
      data = "link(''%s%s'');\n";
      mfprintf(fd,data,libfile,ext);
    else
      data = "link(%s_path+''/%s%s'');\n";
      mfprintf(fd,data,name_path,libfile,ext);
    end
  end 

  if L == 1 then 
    // direct call to addinter 
    table = tables(1);
    
    mfprintf(fd,"list_functions = [ ");
    for x = table(1:$,1)' 
      mfprintf(fd,"            ''%s'';\n",x);
    end
    mfprintf(fd,"];\n");

    mfprintf(fd,"addinter(%s_path+''/%s%s'',''%s'',list_functions);\n",name_path, ..
	              name,getdynlibext(),name);
  else
    // on link then a set of addinter 
    mfprintf(fd,"ilib = link(%s_path+filesep()+''%s%s'');\n",name_path, ..
                name,getdynlibext());
    for itable=1:L 
      // loop on a list of tables 
      table = tables(itable);
      
      mfprintf(fd,"list_functions = [ ''%s'';\n",table(1,1));
      for x=table(2:$,1)' 
        mfprintf(fd,"            ''%s'';\n",x);
      end
      mfprintf(fd,"];\n");
      
      mfprintf(fd,"addinter(ilib,''%s'',list_functions);\n", ..
                  name+ string(itable));
     end
  end
  
  mfprintf(fd,"// remove temp. variables on stack\n");
  mfprintf(fd,"clear %s_path;\n",name_path);
  mfprintf(fd,"clear list_functions;\n");
  mfprintf(fd,"clear get_file_path;\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mclose(fd);
  
endfunction
//==========================================
