// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Pierre MARECHAL <pierre.marechal@inria.fr>
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- JVM NOT MANDATORY -->

// Tests 1
// =============================================================================

// test 1.1

A = [0 1 0 1];
B = [0 0 1 1];
C = [0 0 0 1];

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.2

A = uint8([0 1 0 1]);
B = uint8([0 0 1 1]);
C = uint8([0 0 0 1]);

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.3

A = uint16([0 1 0 1]);
B = uint16([0 0 1 1]);
C = uint16([0 0 0 1]);

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.4

A = uint32([0 1 0 1]);
B = uint32([0 0 1 1]);
C = uint32([0 0 0 1]);

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.5

A = [0 1 ; 0 1];
B = [0 0 ; 1 1];
C = [0 0 ; 0 1];

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.6

A = uint8([0 1 ; 0 1]);
B = uint8([0 0 ; 1 1]);
C = uint8([0 0 ; 0 1]);

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.7

A = uint16([0 1 ; 0 1]);
B = uint16([0 0 ; 1 1]);
C = uint16([0 0 ; 0 1]);

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.8

A = uint32([0 1 ; 0 1]);
B = uint32([0 0 ; 1 1]);
C = uint32([0 0 ; 0 1]);

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.9

A = [0 ; 1 ; 0 ; 1];
B = [0 ; 0 ; 1 ; 1];
C = [0 ; 0 ; 0 ; 1];

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.6

A = uint8([0 ; 1 ; 0 ; 1]);
B = uint8([0 ; 0 ; 1 ; 1]);
C = uint8([0 ; 0 ; 0 ; 1]);

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.7

A = uint16([0 ; 1 ; 0 ; 1]);
B = uint16([0 ; 0 ; 1 ; 1]);
C = uint16([0 ; 0 ; 0 ; 1]);

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.8

A = uint32([0 ; 1 ; 0 ; 1]);
B = uint32([0 ; 0 ; 1 ; 1]);
C = uint32([0 ; 0 ; 0 ; 1]);

if or(bitand(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end


// Tests 2
// =============================================================================

// test 2.1

A = [0 1 0 1];
B = uint8([0 0 1 1]);

if execstr("bitand(A, B);","errcatch") == 0 then pause, end

// test 2.1

A = uint8([0 1 0 1]);
B = uint16([0 0 1 1]);

if execstr("bitand(A, B);","errcatch") == 0 then pause, end

// test 2.1

A = uint16([0 1 0 1]);
B = uint32([0 0 1 1]);

if execstr("bitand(A, B);","errcatch") == 0 then pause, end

// test 2.1

A = uint32([0 1 0 1]);
B = [0 0 1 1];

if execstr("bitand(A, B);","errcatch") == 0 then pause, end


// Tests 3
// =============================================================================

// test 3.1

A = abs(floor(1000 * rand(100,20)));
B = abs(floor(1000 * rand(100,20)));
C = bitand(A,B);

if or( size(A)<>size(B) ) then pause, end

// test 3.2

A = uint8(abs(floor(1000 * rand(100,20))));
B = uint8(abs(floor(1000 * rand(100,20))));
C = bitand(A,B);

if or( size(A)<>size(B) ) then pause, end

// test 3.3

A = uint16(abs(floor(1000 * rand(100,20))));
B = uint16(abs(floor(1000 * rand(100,20))));
C = bitand(A,B);

if or( size(A)<>size(B) ) then pause, end

// test 3.4

A = uint32(abs(floor(1000 * rand(100,20))));
B = uint32(abs(floor(1000 * rand(100,20))));
C = bitand(A,B);

if or( size(A)<>size(B) ) then pause, end

// Test 4
// =============================================================================

A = [ ..
    299.    258.    314.    359.    616.    152.    834.    68.     175.    734.    749.    976.    261.    214.    94.     217.    754.    245.    693.    557.  ; ..
    409.    783.    234.    932.    811.    552.    272.    375.    551.    373.    477.    784.    736.    15.     712.    419.    204.    949.    12.     682.  ; ..
    261.    273.    627.    652.    209.    280.    855.    221.    243.    720.    430.    936.    767.    48.     191.    731.    896.    18.     372.    527.  ; ..
    646.    848.    629.    446.    624.    194.    89.     948.    217.    786.    873.    374.    400.    215.    302.    766.    804.    442.    285.    476.  ; ..
    654.    127.    42.     559.    679.    811.    872.    769.    604.    453.    47.     220.    447.    333.    385.    915.    418.    270.    85.     583.  ; ..
    560.    432.    600.    158.    280.    327.    874.    625.    689.    178.    600.    19.     444.    423.    303.    128.    653.    420.    394.    99.   ; ..
    161.    739.    408.    134.    775.    955.    86.     133.    207.    589.    276.    644.    312.    819.    190.    996.    999.    969.    776.    353.  ; ..
    765.    53.     958.    530.    658.    567.    665.    447.    672.    549.    132.    651.    4.      114.    379.    941.    971.    713.    490.    395.  ; ..
    697.    613.    118.    798.    627.    430.    475.    538.    286.    324.    750.    550.    701.    298.    567.    106.    189.    483.    25.     793.  ; ..
    89.     809.    27.     587.    151.    393.    839.    811.    452.    286.    304.    23.     501.    770.    658.    467.    482.    771.    246.    464.  ; ..
    198.    192.    364.    532.    417.    391.    730.    442.    274.    992.    529.    85.     786.    984.    805.    23.     867.    843.    185.    994.  ; ..
    259.    541.    18.     303.    656.    875.    990.    0.      347.    357.    376.    801.    735.    490.    643.    878.    319.    587.    287.    152.  ; ..
    509.    415.    752.    82.     540.    526.    638.    658.    966.    193.    488.    221.    473.    160.    131.    80.     627.    399.    464.    959.  ; ..
    167.    286.    292.    201.    715.    985.    230.    174.    792.    303.    914.    245.    945.    427.    225.    920.    110.    401.    873.    999.  ; ..
    340.    511.    379.    221.    206.    132.    488.    450.    888.    4.      664.    41.     652.    387.    620.    998.    2.      873.    998.    347.  ; ..
    895.    767.    977.    562.    323.    323.    165.    765.    843.    849.    546.    963.    938.    980.    650.    195.    653.    131.    503.    220.  ; ..
    667.    378.    74.     594.    248.    601.    77.     723.    984.    815.    6.      21.     240.    909.    668.    987.    357.    587.    33.     127.  ; ..
    25.     934.    150.    336.    74.     154.    443.    790.    951.    998.    174.    670.    292.    482.    672.    424.    340.    202.    314.    513.  ; ..
    31.     488.    191.    944.    278.    751.    925.    113.    495.    689.    377.    76.     653.    665.    141.    868.    811.    725.    582.    886.  ; ..
    427.    998.    456.    225.    892.    31.     275.    852.    313.    652.    564.    34.     993.    246.    407.    45.     764.    445.    354.    343.  ; ..
    108.    593.    580.    61.     718.    140.    942.    652.    683.    265.    647.    444.    449.    771.    627.    649.    29.     372.    573.    579.  ; ..
    767.    892.    475.    334.    514.    573.    668.    396.    876.    24.     506.    323.    509.    899.    448.    58.     395.    648.    715.    774.  ; ..
    373.    995.    364.    956.    981.    351.    157.    269.    143.    430.    484.    356.    377.    915.    403.    238.    629.    11.     91.     145.  ; ..
    151.    481.    266.    111.    930.    313.    117.    979.    997.    273.    556.    689.    92.     986.    587.    992.    953.    294.    152.    792.  ; ..
    721.    77.     478.    875.    541.    562.    820.    835.    301.    650.    504.    355.    300.    207.    115.    255.    500.    605.    84.     53.   ; ..
    539.    68.     214.    955.    98.     536.    11.     867.    752.    733.    815.    298.    978.    631.    768.    114.    800.    714.    995.    136.  ; ..
    145.    567.    792.    271.    225.    858.    442.    355.    681.    444.    94.     318.    786.    911.    234.    507.    84.     713.    310.    822.  ; ..
    745.    599.    365.    664.    288.    836.    28.     930.    794.    749.    46.     83.     931.    575.    589.    469.    336.    233.    728.    53.   ; ..
    257.    106.    548.    68.     115.    204.    609.    511.    922.    248.    823.    262.    976.    691.    320.    29.     835.    587.    676.    306.  ; ..
    770.    381.    844.    771.    219.    382.    9.      531.    351.    276.    557.    505.    146.    903.    742.    790.    853.    837.    521.    654.  ; ..
    997.    259.    58.     886.    395.    969.    997.    454.    871.    307.    393.    61.     41.     727.    498.    93.     134.    389.    864.    331.  ; ..
    845.    6.      504.    575.    678.    609.    267.    800.    331.    11.     584.    214.    770.    298.    903.    748.    395.    210.    46.     920.  ; ..
    646.    810.    600.    729.    615.    937.    384.    948.    593.    645.    756.    781.    405.    875.    670.    467.    226.    760.    617.    627.  ; ..
    720.    266.    563.    265.    318.    59.     756.    76.     436.    716.    295.    882.    114.    379.    853.    192.    874.    640.    22.     402.  ; ..
    674.    124.    517.    290.    650.    84.     915.    23.     282.    854.    893.    784.    485.    87.     175.    82.     635.    489.    632.    163.  ; ..
    354.    187.    518.    781.    840.    296.    931.    485.    497.    427.    773.    403.    830.    635.    764.    916.    747.    97.     968.    466.  ; ..
    327.    112.    124.    957.    342.    503.    810.    555.    205.    975.    61.     382.    163.    225.    300.    234.    409.    241.    82.     382.  ; ..
    23.     664.    936.    844.    491.    38.     344.    243.    922.    383.    447.    270.    844.    446.    513.    898.    986.    644.    451.    205.  ; ..
    593.    145.    411.    132.    974.    78.     500.    146.    292.    278.    476.    121.    102.    310.    625.    147.    762.    635.    721.    900.  ; ..
    924.    430.    751.    807.    771.    799.    864.    389.    914.    513.    174.    867.    514.    588.    543.    816.    603.    129.    643.    844.  ; ..
    672.    614.    228.    945.    547.    181.    239.    481.    205.    849.    836.    22.     590.    727.    936.    320.    684.    801.    680.    194.  ; ..
    484.    216.    206.    500.    208.    312.    864.    40.     21.     168.    461.    674.    244.    314.    918.    768.    617.    671.    15.     514.  ; ..
    641.    968.    900.    371.    797.    247.    871.    646.    56.     797.    91.     714.    323.    178.    865.    88.     148.    194.    832.    203.  ; ..
    594.    663.    567.    914.    981.    590.    538.    815.    312.    252.    56.     856.    392.    491.    864.    427.    873.    710.    485.    412.  ; ..
    106.    519.    458.    287.    327.    848.    45.     827.    772.    79.     884.    754.    732.    752.    784.    546.    129.    379.    373.    843.  ; ..
    808.    867.    999.    316.    852.    684.    656.    680.    90.     994.    127.    139.    812.    166.    914.    255.    452.    178.    97.     639.  ; ..
    516.    287.    322.    770.    554.    275.    196.    909.    769.    697.    440.    880.    499.    574.    216.    824.    72.     10.     365.    652.  ; ..
    61.     143.    418.    27.     254.    767.    369.    13.     275.    17.     448.    319.    445.    304.    901.    638.    399.    572.    219.    129.  ; ..
    16.     187.    588.    110.    674.    63.     317.    50.     515.    773.    802.    897.    196.    684.    519.    7.      101.    734.    853.    491.  ; ..
    509.    619.    630.    558.    308.    73.     52.     977.    395.    177.    243.    944.    88.     72.     93.     901.    64.     222.    285.    54.   ; ..
    469.    217.    542.    54.     17.     567.    365.    760.    83.     137.    493.    687.    904.    240.    157.    193.    547.    620.    109.    749.  ; ..
    528.    445.    451.    915.    864.    283.    429.    348.    335.    544.    478.    559.    522.    828.    832.    910.    283.    731.    943.    703.  ; ..
    33.     408.    985.    108.    295.    241.    496.    641.    309.    911.    395.    874.    501.    390.    967.    563.    616.    310.    10.     313.  ; ..
    711.    636.    740.    559.    312.    44.     314.    408.    519.    888.    365.    351.    607.    884.    846.    262.    928.    288.    226.    2.    ; ..
    790.    497.    722.    600.    728.    794.    480.    237.    9.      518.    190.    325.    598.    489.    735.    399.    640.    799.    866.    952.  ; ..
    623.    739.    101.    588.    735.    343.    47.     566.    868.    947.    452.    867.    477.    829.    912.    768.    765.    234.    706.    451.  ; ..
    799.    0.      631.    93.     262.    521.    49.     703.    353.    992.    488.    304.    41.     136.    576.    949.    704.    932.    537.    135.  ; ..
    42.     428.    478.    116.    784.    302.    998.    566.    623.    448.    840.    604.    598.    832.    580.    972.    41.     685.    524.    108.  ; ..
    867.    878.    372.    991.    411.    984.    990.    602.    153.    795.    155.    70.     1.      222.    367.    442.    888.    792.    833.    68.   ; ..
    345.    809.    666.    369.    506.    415.    235.    611.    776.    218.    663.    588.    976.    542.    146.    608.    644.    148.    533.    351.  ; ..
    798.    819.    405.    135.    124.    424.    764.    492.    51.     832.    761.    445.    235.    42.     260.    618.    337.    401.    314.    174.  ; ..
    372.    326.    944.    619.    861.    347.    448.    217.    286.    661.    868.    427.    124.    42.     828.    155.    868.    748.    405.    229.  ; ..
    186.    525.    12.     276.    670.    18.     807.    441.    635.    553.    781.    722.    521.    95.     383.    390.    131.    65.     116.    862.  ; ..
    505.    795.    299.    636.    965.    834.    435.    979.    413.    199.    368.    584.    406.    502.    13.     781.    682.    763.    405.    244.  ; ..
    342.    772.    709.    901.    545.    890.    787.    525.    795.    131.    671.    576.    961.    666.    730.    899.    10.     608.    624.    470.  ; ..
    582.    973.    114.    632.    856.    17.     656.    690.    136.    919.    778.    705.    895.    690.    463.    929.    841.    544.    359.    254.  ; ..
    92.     791.    288.    280.    840.    859.    269.    187.    524.    200.    522.    841.    71.     167.    158.    826.    620.    915.    185.    211.  ; ..
    639.    109.    423.    678.    825.    469.    543.    68.     732.    494.    936.    579.    893.    204.    225.    431.    993.    491.    128.    657.  ; ..
    328.    929.    42.     285.    76.     791.    965.    359.    266.    880.    69.     423.    880.    811.    885.    567.    589.    240.    823.    105.  ; ..
    103.    53.     971.    144.    842.    146.    191.    806.    999.    281.    277.    602.    472.    13.     742.    187.    111.    316.    492.    75.   ; ..
    671.    196.    899.    820.    334.    367.    270.    914.    139.    116.    739.    627.    841.    893.    166.    314.    746.    795.    650.    659.  ; ..
    850.    523.    3.      638.    312.    420.    678.    491.    112.    282.    605.    342.    874.    525.    985.    43.     846.    407.    582.    228.  ; ..
    830.    330.    611.    908.    150.    511.    599.    615.    328.    216.    614.    209.    726.    157.    366.    422.    497.    679.    540.    803.  ; ..
    438.    956.    51.     210.    112.    37.     432.    67.     780.    260.    844.    804.    73.     901.    392.    408.    790.    376.    787.    442.  ; ..
    587.    957.    164.    154.    309.    48.     414.    753.    62.     111.    939.    794.    136.    784.    806.    235.    218.    693.    167.    713.  ; ..
    561.    860.    672.    30.     534.    209.    672.    834.    842.    496.    842.    183.    195.    403.    705.    180.    894.    924.    310.    176.  ; ..
    141.    583.    570.    603.    900.    686.    218.    364.    111.    813.    553.    434.    169.    796.    867.    961.    853.    189.    16.     3.    ; ..
    384.    633.    128.    196.    196.    994.    803.    342.    793.    524.    38.     132.    715.    278.    458.    689.    388.    667.    13.     931.  ; ..
    228.    923.    585.    512.    29.     560.    544.    761.    201.    26.     761.    274.    657.    601.    349.    826.    52.     403.    846.    718.  ; ..
    636.    296.    160.    776.    95.     439.    744.    805.    733.    356.    760.    721.    213.    736.    668.    371.    258.    548.    923.    815.  ; ..
    355.    835.    985.    462.    883.    708.    432.    443.    393.    406.    988.    970.    338.    277.    296.    752.    643.    988.    661.    7.    ; ..
    168.    322.    262.    353.    689.    603.    250.    736.    761.    243.    893.    216.    887.    2.      141.    731.    677.    717.    484.    735.  ; ..
    991.    237.    239.    64.     731.    353.    461.    592.    750.    820.    537.    104.    46.     401.    833.    780.    200.    37.     989.    667.  ; ..
    846.    707.    6.      240.    926.    394.    326.    268.    813.    705.    558.    413.    863.    956.    589.    629.    465.    207.    273.    557.  ; ..
    73.     223.    120.    547.    316.    68.     497.    821.    856.    532.    202.    568.    600.    256.    379.    588.    523.    290.    429.    277.  ; ..
    235.    390.    915.    935.    583.    7.      665.    894.    206.    283.    151.    479.    499.    492.    325.    1.      687.    199.    401.    501.  ; ..
    61.     593.    348.    148.    369.    250.    216.    819.    392.    0.      790.    333.    47.     298.    277.    233.    176.    624.    501.    776.  ; ..
    143.    53.     16.     235.    803.    533.    517.    112.    584.    127.    467.    783.    157.    266.    550.    554.    688.    98.     884.    383.  ; ..
    339.    392.    130.    862.    903.    148.    656.    583.    309.    101.    157.    375.    692.    329.    802.    23.     348.    916.    110.    503.  ; ..
    880.    4.      366.    578.    334.    875.    480.    433.    445.    989.    535.    128.    308.    810.    40.     774.    64.     813.    986.    931.  ; ..
    525.    421.    877.    122.    63.     345.    784.    243.    579.    721.    495.    286.    122.    283.    21.     497.    510.    133.    833.    175.  ; ..
    714.    262.    438.    461.    519.    369.    122.    434.    820.    310.    161.    855.    92.     0.      277.    497.    275.    538.    598.    255.  ; ..
    389.    174.    762.    661.    867.    552.    863.    651.    497.    867.    738.    545.    791.    159.    481.    389.    16.     568.    125.    511.  ; ..
    463.    837.    142.    172.    381.    295.    151.    740.    916.    751.    786.    372.    544.    413.    545.    285.    501.    722.    126.    363.  ; ..
    164.    830.    488.    675.    596.    37.     483.    38.     249.    412.    463.    52.     885.    928.    577.    376.    382.    771.    777.    564.  ; ..
    288.    573.    325.    348.    180.    679.    758.    998.    345.    629.    101.    723.    430.    65.     231.    758.    14.     781.    901.    426.  ; ..
    320.    26.     161.    718.    258.    565.    985.    814.    556.    417.    854.    548.    625.    484.    57.     871.    726.    359.    921.    615.  ; ..
    421.    547.    679.    916.    334.    303.    749.    837.    44.     90.     688.    603.    959.    290.    287.    714.    468.    239.    754.    58.   ; ..
    758.    684.    708.    930.    819.    563.    980.    70.     806.    264.    677.    512.    160.    339.    797.    412.    280.    892.    985.    167.  ; ..
    650.    822.    51.     774.    588.    531.    988.    444.    791.    415.    785.    759.    317.    958.    470.    279.    128.    269.    909.    126.  ];

B = [ ..
    511.    299.    529.    766.    739.    39.     125.    996.    368.    699.    914.    155.    428.    455.    616.    283.    424.    803.    615.    922.  ; ..
    403.    223.    453.    985.    260.    337.    35.     632.    64.     113.    551.    688.    331.    580.    463.    859.    689.    839.    780.    362.  ; ..
    827.    66.     978.    614.    218.    678.    161.    20.     560.    768.    596.    890.    553.    53.     853.    856.    480.    429.    772.    419.  ; ..
    589.    677.    202.    42.     319.    256.    772.    61.     840.    507.    931.    68.     147.    638.    708.    406.    269.    599.    98.     105.  ; ..
    298.    994.    102.    50.     811.    524.    521.    618.    997.    538.    934.    439.    592.    754.    812.    889.    399.    300.    884.    943.  ; ..
    750.    321.    48.     310.    370.    948.    80.     245.    226.    670.    818.    373.    979.    272.    977.    20.     120.    839.    539.    242.  ; ..
    605.    885.    102.    86.     269.    308.    723.    151.    307.    253.    61.     463.    588.    379.    777.    270.    910.    368.    147.    532.  ; ..
    889.    20.     483.    246.    947.    795.    186.    755.    81.     768.    113.    88.     853.    511.    339.    190.    319.    312.    374.    662.  ; ..
    724.    518.    73.     894.    321.    922.    883.    758.    406.    470.    227.    179.    192.    567.    854.    768.    53.     626.    860.    333.  ; ..
    122.    726.    397.    287.    566.    459.    294.    34.     257.    61.     855.    504.    806.    761.    605.    73.     869.    799.    550.    568.  ; ..
    702.    915.    256.    290.    123.    780.    939.    129.    985.    639.    863.    33.     535.    680.    742.    203.    797.    457.    750.    890.  ; ..
    562.    646.    707.    169.    769.    226.    84.     970.    964.    322.    252.    971.    760.    240.    574.    836.    239.    469.    818.    351.  ; ..
    250.    477.    828.    368.    794.    940.    381.    978.    719.    681.    475.    998.    863.    319.    31.     551.    822.    570.    913.    43.   ; ..
    485.    2.      265.    453.    408.    613.    387.    298.    231.    101.    675.    471.    193.    689.    892.    701.    297.    835.    0.      390.  ; ..
    59.     763.    740.    509.    933.    443.    469.    678.    101.    757.    858.    193.    778.    385.    10.     915.    297.    213.    829.    602.  ; ..
    464.    368.    504.    384.    164.    290.    303.    505.    725.    900.    670.    738.    185.    477.    373.    457.    513.    458.    56.     130.  ; ..
    27.     748.    605.    327.    664.    860.    805.    229.    783.    334.    335.    607.    373.    898.    564.    739.    274.    976.    896.    785.  ; ..
    822.    203.    393.    286.    820.    856.    1.      856.    651.    735.    897.    974.    737.    489.    385.    907.    483.    719.    192.    307.  ; ..
    485.    963.    211.    267.    26.     905.    63.     266.    993.    875.    65.     625.    529.    379.    420.    953.    737.    473.    975.    100.  ; ..
    862.    5.      297.    449.    803.    679.    343.    818.    257.    94.     694.    717.    922.    623.    515.    97.     404.    265.    816.    470.  ; ..
    382.    72.     303.    20.     784.    533.    143.    609.    203.    458.    301.    204.    678.    959.    238.    267.    689.    937.    49.     233.  ; ..
    715.    389.    169.    756.    727.    788.    186.    267.    643.    929.    527.    430.    497.    189.    221.    100.    27.     120.    432.    738.  ; ..
    647.    819.    212.    895.    358.    713.    298.    260.    240.    712.    118.    350.    699.    857.    60.     981.    446.    584.    499.    55.   ; ..
    192.    133.    0.      22.     166.    403.    566.    520.    858.    848.    849.    904.    747.    928.    279.    444.    687.    694.    600.    943.  ; ..
    897.    99.     69.     333.    903.    197.    327.    123.    715.    40.     90.     269.    693.    775.    938.    811.    732.    926.    177.    356.  ; ..
    663.    854.    477.    8.      304.    187.    928.    77.     632.    990.    670.    266.    601.    550.    507.    947.    82.     46.     599.    822.  ; ..
    767.    541.    101.    94.     47.     704.    96.     452.    535.    500.    868.    705.    610.    593.    450.    716.    799.    385.    707.    773.  ; ..
    486.    204.    314.    298.    575.    404.    854.    43.     389.    61.     382.    374.    181.    588.    339.    497.    546.    456.    442.    621.  ; ..
    686.    965.    283.    749.    721.    203.    728.    552.    515.    403.    165.    819.    396.    768.    694.    945.    827.    974.    731.    983.  ; ..
    854.    259.    424.    411.    547.    831.    435.    292.    221.    576.    864.    325.    925.    746.    221.    207.    349.    701.    92.     182.  ; ..
    371.    538.    721.    326.    337.    877.    355.    779.    357.    946.    475.    910.    872.    490.    596.    836.    813.    842.    410.    945.  ; ..
    918.    17.     81.     719.    235.    392.    203.    474.    305.    289.    602.    729.    20.     814.    342.    123.    84.     105.    235.    261.  ; ..
    956.    2.      998.    638.    592.    246.    503.    6.      610.    455.    484.    746.    333.    287.    330.    752.    308.    466.    841.    172.  ; ..
    597.    418.    188.    671.    395.    833.    409.    798.    488.    80.     286.    95.     78.     307.    841.    263.    226.    487.    391.    266.  ; ..
    943.    194.    655.    391.    827.    136.    535.    617.    290.    430.    832.    561.    294.    742.    751.    180.    134.    665.    523.    49.   ; ..
    435.    988.    665.    431.    236.    357.    227.    998.    522.    999.    994.    41.     567.    335.    145.    994.    426.    281.    578.    727.  ; ..
    454.    671.    465.    947.    500.    200.    393.    272.    820.    927.    60.     304.    130.    737.    296.    959.    963.    675.    933.    508.  ; ..
    154.    937.    681.    253.    105.    707.    15.     962.    420.    629.    526.    982.    385.    549.    427.    574.    858.    359.    943.    479.  ; ..
    808.    984.    404.    12.     327.    736.    555.    452.    336.    292.    668.    896.    153.    449.    229.    104.    775.    774.    90.     296.  ; ..
    962.    209.    832.    459.    994.    745.    28.     950.    601.    367.    586.    261.    58.     299.    169.    864.    889.    232.    629.    637.  ; ..
    883.    315.    811.    905.    368.    144.    43.     535.    483.    168.    443.    357.    109.    649.    800.    214.    39.     604.    4.      892.  ; ..
    175.    421.    260.    805.    124.    888.    774.    110.    714.    405.    157.    351.    115.    199.    367.    774.    293.    256.    594.    827.  ; ..
    104.    260.    341.    802.    159.    786.    825.    301.    53.     544.    174.    173.    673.    46.     114.    316.    427.    921.    580.    432.  ; ..
    119.    747.    98.     71.     90.     751.    410.    912.    209.    57.     530.    564.    243.    59.     852.    657.    177.    88.     918.    691.  ; ..
    891.    823.    471.    824.    324.    670.    468.    578.    494.    607.    697.    483.    595.    796.    808.    577.    328.    247.    146.    938.  ; ..
    452.    490.    205.    820.    149.    920.    94.     123.    638.    518.    822.    542.    656.    441.    522.    616.    452.    830.    280.    304.  ; ..
    185.    569.    779.    424.    272.    647.    780.    720.    883.    851.    490.    15.     59.     371.    211.    57.     705.    356.    796.    241.  ; ..
    955.    164.    16.     293.    993.    706.    906.    848.    326.    978.    373.    603.    582.    787.    652.    334.    70.     847.    601.    660.  ; ..
    715.    801.    480.    591.    995.    83.     734.    54.     749.    472.    989.    508.    8.      926.    31.     839.    407.    850.    431.    561.  ; ..
    234.    295.    173.    250.    613.    34.     655.    847.    202.    132.    50.     594.    856.    109.    972.    501.    165.    188.    204.    718.  ; ..
    292.    821.    997.    318.    0.      567.    741.    726.    493.    134.    906.    42.     925.    724.    81.     949.    162.    844.    251.    120.  ; ..
    633.    724.    357.    46.     614.    24.     582.    735.    174.    473.    972.    125.    39.     411.    596.    9.      589.    550.    116.    488.  ; ..
    92.     342.    197.    953.    436.    566.    460.    911.    597.    853.    361.    591.    343.    234.    469.    746.    637.    277.    731.    854.  ; ..
    787.    779.    363.    286.    312.    329.    376.    562.    334.    81.     527.    887.    261.    224.    87.     798.    950.    864.    219.    192.  ; ..
    834.    186.    570.    810.    805.    409.    454.    510.    480.    625.    113.    671.    465.    762.    506.    374.    419.    893.    334.    529.  ; ..
    558.    249.    673.    876.    178.    677.    91.     658.    323.    915.    545.    943.    937.    823.    808.    278.    89.     607.    711.    492.  ; ..
    509.    987.    573.    176.    783.    917.    233.    582.    392.    717.    792.    428.    113.    140.    624.    736.    11.     67.     577.    842.  ; ..
    453.    376.    589.    29.     381.    286.    172.    202.    294.    688.    28.     421.    452.    616.    145.    681.    787.    744.    617.    54.   ; ..
    142.    22.     846.    976.    861.    794.    156.    246.    293.    731.    348.    386.    203.    569.    215.    708.    257.    537.    136.    700.  ; ..
    909.    106.    203.    747.    369.    674.    940.    848.    962.    167.    805.    705.    843.    839.    15.     240.    259.    751.    818.    126.  ; ..
    400.    979.    549.    186.    223.    948.    530.    17.     735.    953.    144.    689.    370.    489.    968.    264.    446.    277.    651.    214.  ; ..
    897.    393.    3.      268.    357.    824.    225.    565.    30.     994.    753.    955.    212.    842.    217.    695.    590.    160.    75.     335.  ; ..
    9.      721.    909.    77.     816.    528.    495.    873.    701.    535.    785.    355.    678.    752.    243.    277.    4.      521.    258.    415.  ; ..
    45.     277.    580.    861.    230.    496.    445.    615.    784.    899.    656.    454.    942.    873.    491.    168.    495.    580.    728.    263.  ; ..
    386.    391.    673.    771.    380.    139.    235.    165.    508.    47.     79.     271.    888.    751.    761.    338.    610.    708.    2.      622.  ; ..
    786.    772.    664.    87.     527.    614.    991.    222.    717.    137.    252.    718.    743.    110.    527.    771.    597.    876.    940.    592.  ; ..
    892.    775.    882.    934.    567.    633.    174.    171.    660.    302.    9.      716.    895.    897.    730.    351.    78.     212.    452.    223.  ; ..
    746.    994.    326.    974.    772.    977.    344.    659.    469.    201.    423.    427.    889.    801.    395.    300.    616.    158.    562.    488.  ; ..
    134.    234.    546.    949.    699.    645.    354.    988.    286.    489.    546.    458.    93.     320.    808.    322.    882.    602.    577.    641.  ; ..
    594.    462.    694.    511.    297.    888.    655.    348.    175.    80.     694.    920.    632.    442.    20.     921.    400.    174.    606.    275.  ; ..
    90.     942.    904.    58.     410.    848.    634.    992.    920.    802.    909.    397.    890.    236.    538.    46.     14.     106.    448.    921.  ; ..
    775.    905.    592.    183.    777.    586.    524.    725.    220.    484.    72.     74.     594.    974.    989.    731.    387.    650.    967.    350.  ; ..
    951.    130.    169.    94.     940.    240.    14.     607.    224.    495.    932.    597.    853.    513.    256.    636.    537.    415.    169.    990.  ; ..
    774.    115.    225.    921.    789.    436.    256.    185.    395.    421.    667.    775.    819.    789.    347.    311.    836.    776.    173.    360.  ; ..
    769.    829.    631.    918.    392.    925.    642.    968.    215.    826.    855.    784.    261.    871.    506.    462.    825.    261.    791.    654.  ; ..
    709.    235.    113.    646.    749.    577.    849.    62.     341.    123.    405.    768.    905.    858.    700.    858.    826.    453.    555.    48.   ; ..
    694.    648.    803.    906.    357.    303.    347.    678.    10.     135.    461.    364.    705.    346.    26.     421.    747.    741.    367.    93.   ; ..
    4.      334.    852.    448.    392.    31.     205.    371.    897.    492.    249.    254.    249.    308.    989.    944.    445.    801.    130.    460.  ; ..
    154.    756.    596.    144.    223.    570.    118.    572.    382.    711.    484.    113.    996.    383.    695.    903.    46.     496.    54.     473.  ; ..
    527.    914.    855.    207.    488.    989.    543.    667.    297.    827.    685.    157.    669.    264.    482.    355.    754.    792.    505.    532.  ; ..
    86.     898.    426.    831.    667.    437.    343.    577.    987.    475.    954.    230.    622.    703.    963.    779.    496.    3.      610.    595.  ; ..
    725.    176.    835.    70.     480.    992.    402.    840.    127.    482.    561.    289.    454.    535.    735.    675.    734.    496.    266.    144.  ; ..
    751.    224.    289.    51.     574.    384.    39.     834.    250.    241.    943.    907.    447.    198.    475.    528.    291.    711.    256.    695.  ; ..
    908.    143.    307.    394.    263.    949.    104.    777.    255.    179.    669.    652.    137.    638.    472.    148.    568.    254.    329.    460.  ; ..
    45.     472.    382.    8.      402.    801.    275.    502.    24.     816.    526.    207.    909.    966.    308.    667.    1.      986.    925.    904.  ; ..
    694.    141.    732.    629.    22.     99.     686.    517.    620.    775.    517.    655.    769.    666.    245.    763.    946.    936.    529.    673.  ; ..
    928.    852.    277.    299.    126.    629.    783.    600.    648.    748.    939.    312.    799.    522.    778.    274.    687.    163.    827.    911.  ; ..
    718.    361.    902.    758.    35.     261.    217.    573.    551.    347.    507.    998.    176.    383.    383.    360.    692.    225.    268.    15.   ; ..
    113.    326.    324.    361.    731.    779.    787.    86.     237.    628.    316.    484.    326.    727.    579.    57.     729.    816.    467.    374.  ; ..
    774.    364.    723.    487.    294.    590.    831.    531.    149.    261.    999.    228.    410.    655.    899.    692.    567.    443.    58.     868.  ; ..
    706.    112.    233.    47.     198.    175.    734.    642.    367.    771.    432.    669.    868.    210.    384.    387.    3.      45.     978.    985.  ; ..
    650.    86.     530.    24.     717.    739.    633.    571.    68.     404.    496.    411.    258.    674.    615.    682.    688.    701.    262.    20.   ; ..
    570.    708.    27.     903.    356.    43.     233.    597.    160.    261.    858.    32.     23.     652.    463.    437.    615.    477.    425.    204.  ; ..
    666.    225.    302.    36.     427.    453.    799.    154.    565.    795.    168.    861.    121.    370.    662.    472.    278.    907.    110.    347.  ; ..
    109.    708.    193.    443.    299.    468.    505.    484.    427.    111.    324.    181.    581.    408.    562.    426.    842.    213.    810.    880.  ; ..
    490.    602.    609.    21.     933.    256.    479.    675.    980.    250.    130.    240.    705.    747.    557.    157.    490.    439.    1.      336.  ; ..
    344.    706.    183.    867.    564.    631.    370.    345.    446.    57.     169.    774.    399.    103.    804.    259.    557.    455.    413.    661.  ; ..
    818.    97.     593.    788.    989.    726.    479.    194.    568.    565.    131.    581.    625.    503.    187.    141.    587.    755.    81.     832.  ; ..
    900.    954.    907.    786.    461.    861.    625.    273.    491.    623.    972.    993.    973.    305.    930.    52.     728.    401.    999.    674.  ; ..
    968.    950.    687.    858.    232.    981.    983.    341.    846.    588.    438.    629.    141.    119.    38.     835.    725.    922.    986.    10.   ];

 C  = [ ..
    299.    258.    16.     102.    608.    0.      64.     68.     32.     666.    640.    144.    260.    198.    72.     25.     160.    33.     549.    520.  ; ..
    401.    15.     192.    896.    256.    0.      0.      112.    0.      113.    5.      528.    64.     4.      200.    259.    128.    773.    12.     42.   ; ..
    257.    0.      594.    516.    208.    0.      1.      20.     48.     512.    4.      808.    553.    48.     21.     600.    384.    0.      260.    3.    ; ..
    516.    512.    64.     42.     48.     0.      0.      52.     72.     274.    801.    68.     144.    86.     4.      150.    260.    18.     0.      72.   ; ..
    10.     98.     34.     34.     547.    520.    520.    512.    580.    0.      38.     148.    16.     64.     256.    785.    386.    268.    84.     519.  ; ..
    544.    256.    16.     22.     272.    260.    64.     113.    160.    146.    528.    17.     400.    256.    257.    0.      8.      260.    10.     98.   ; ..
    1.      609.    0.      6.      261.    304.    82.     133.    3.      77.     20.     132.    8.      307.    8.      260.    902.    320.    0.      0.    ; ..
    633.    20.     418.    18.     658.    531.    152.    179.    0.      512.    0.      8.      4.      114.    339.    172.    267.    8.      354.    130.  ; ..
    656.    516.    64.     798.    65.     394.    339.    530.    278.    324.    226.    34.     128.    34.     534.    0.      53.     98.     24.     265.  ; ..
    88.     512.    9.      11.     22.     393.    262.    34.     256.    28.     272.    16.     292.    512.    528.    65.     352.    771.    38.     16.   ; ..
    134.    128.    256.    0.      33.     260.    650.    128.    272.    608.    529.    1.      530.    648.    548.    3.      769.    329.    168.    866.  ; ..
    2.      516.    2.      41.     512.    98.     84.     0.      320.    320.    120.    769.    728.    224.    514.    836.    47.     65.     274.    24.   ; ..
    248.    413.    560.    80.     536.    524.    124.    658.    710.    129.    456.    196.    345.    32.     3.      0.      562.    10.     400.    43.   ; ..
    165.    2.      256.    193.    136.    577.    130.    42.     0.      37.     642.    213.    129.    161.    96.     664.    40.     257.    0.      390.  ; ..
    16.     251.    96.     221.    132.    128.    448.    130.    96.     4.      536.    1.      520.    385.    8.      898.    0.      65.     804.    90.   ; ..
    336.    112.    464.    0.      0.      258.    37.     249.    577.    768.    514.    706.    168.    468.    0.      193.    513.    130.    48.     128.  ; ..
    27.     104.    72.     66.     152.    600.    5.      193.    776.    270.    6.      21.     112.    896.    532.    707.    256.    576.    0.      17.   ; ..
    16.     130.    128.    272.    0.      24.     1.      784.    643.    710.    128.    654.    32.     480.    128.    392.    320.    202.    0.      1.    ; ..
    5.      448.    147.    256.    18.     649.    29.     0.      481.    545.    65.     64.     513.    25.     132.    800.    545.    209.    582.    100.  ; ..
    266.    4.      264.    193.    800.    7.      275.    784.    257.    12.     564.    0.      896.    102.    3.      33.     148.    265.    288.    342.  ; ..
    108.    64.     4.      20.     512.    4.      142.    512.    139.    264.    5.      140.    128.    771.    98.     9.      17.     288.    49.     65.   ; ..
    715.    260.    137.    68.     514.    532.    152.    264.    512.    0.      10.     258.    497.    129.    192.    32.     11.     8.      128.    514.  ; ..
    5.      803.    68.     828.    324.    73.     8.      260.    128.    136.    100.    324.    57.     785.    16.     196.    52.     8.      83.     17.   ; ..
    128.    129.    0.      6.      162.    273.    52.     512.    832.    272.    512.    640.    72.     896.    3.      416.    681.    38.     24.     776.  ; ..
    641.    65.     68.     329.    517.    0.      260.    67.     9.      8.      88.     257.    36.     7.      34.     43.     212.    540.    16.     36.   ; ..
    531.    68.     212.    8.      32.     24.     0.      65.     624.    732.    526.    266.    592.    550.    256.    50.     0.      10.     579.    0.    ; ..
    145.    533.    0.      14.     33.     576.    32.     320.    513.    436.    68.     0.      514.    513.    194.    200.    20.     129.    2.      772.  ; ..
    224.    68.     296.    8.      32.     260.    20.     34.     256.    45.     46.     82.     161.    524.    65.     465.    0.      200.    152.    37.   ; ..
    0.      64.     0.      68.     81.     200.    576.    40.     514.    144.    37.     258.    384.    512.    0.      17.     771.    586.    640.    274.  ; ..
    770.    257.    264.    259.    3.      318.    1.      0.      93.     0.      544.    321.    144.    642.    196.    6.      341.    517.    8.      134.  ; ..
    353.    2.      16.     326.    257.    841.    353.    258.    357.    306.    393.    12.     40.     194.    80.     68.     4.      256.    256.    257.  ; ..
    772.    0.      80.     527.    162.    0.      11.     256.    257.    1.      584.    208.    0.      298.    262.    104.    0.      64.     42.     256.  ; ..
    644.    2.      576.    600.    576.    160.    384.    4.      576.    133.    228.    520.    261.    267.    10.     208.    32.     208.    585.    32.   ; ..
    592.    258.    48.     9.      266.    1.      144.    12.     416.    64.     262.    82.     66.     307.    833.    0.      98.     128.    6.      258.  ; ..
    674.    64.     517.    258.    522.    0.      531.    1.      258.    262.    832.    528.    292.    70.     175.    16.     2.      137.    520.    33.   ; ..
    290.    152.    512.    269.    72.     288.    163.    484.    0.      419.    768.    1.      566.    75.     144.    896.    170.    1.      576.    210.  ; ..
    326.    16.     80.     945.    340.    192.    264.    0.      4.      911.    60.     304.    130.    225.    296.    170.    385.    161.    0.      380.  ; ..
    18.     648.    680.    76.     105.    2.      8.      194.    384.    117.    14.     262.    256.    36.     1.      514.    858.    4.      387.    205.  ; ..
    512.    144.    400.    4.      326.    64.     32.     128.    256.    260.    156.    0.      0.      256.    97.     0.      514.    514.    80.     256.  ; ..
    896.    128.    576.    259.    770.    521.    0.      388.    528.    1.      10.     257.    2.      8.      9.      800.    601.    128.    513.    588.  ; ..
    544.    34.     32.     897.    32.     144.    43.     1.      193.    0.      256.    4.      76.     641.    800.    64.     36.     512.    0.      64.   ; ..
    164.    128.    4.      292.    80.     312.    768.    40.     0.      128.    141.    2.      112.    2.      262.    768.    33.     0.      2.      514.  ; ..
    0.      256.    260.    290.    29.     18.     801.    4.      48.     512.    10.     136.    1.      34.     96.     24.     128.    128.    576.    128.  ; ..
    82.     643.    34.     2.      80.     590.    26.     768.    16.     56.     16.     528.    128.    43.     832.    129.    33.     64.     388.    144.  ; ..
    106.    519.    450.    280.    324.    528.    4.      514.    260.    79.     560.    226.    592.    528.    768.    512.    0.      115.    16.     778.  ; ..
    256.    354.    197.    308.    20.     648.    16.     40.     90.     514.    54.     10.     512.    160.    514.    104.    452.    50.     0.      48.   ; ..
    0.      25.     258.    256.    0.      3.      4.      640.    769.    529.    424.    0.      51.     50.     208.    56.     64.     0.      268.    128.  ; ..
    57.     132.    0.      1.      224.    706.    256.    0.      258.    16.     320.    27.     4.      272.    644.    78.     6.      524.    89.     128.  ; ..
    0.      33.     64.     78.     674.    19.     28.     50.     513.    256.    768.    384.    0.      652.    7.      7.      5.      594.    261.    33.   ; ..
    232.    35.     36.     42.     36.     0.      4.      833.    138.    128.    50.     528.    88.     72.     76.     389.    0.      156.    12.     6.    ; ..
    260.    17.     516.    54.     0.      567.    101.    720.    65.     128.    392.    42.     904.    208.    17.     129.    34.     588.    105.    104.  ; ..
    528.    148.    321.    2.      608.    24.     4.      92.     14.     0.      460.    45.     2.      280.    576.    8.      9.      514.    36.     168.  ; ..
    0.      272.    193.    40.     292.    48.     448.    641.    21.     773.    265.    586.    341.    130.    453.    546.    616.    276.    10.     272.  ; ..
    515.    520.    96.     14.     312.    8.      312.    16.     6.      80.     13.     343.    5.      96.     70.     262.    928.    288.    194.    0.    ; ..
    770.    176.    530.    520.    512.    280.    448.    236.    0.      512.    48.     5.      80.     232.    218.    262.    128.    797.    322.    528.  ; ..
    558.    225.    33.     588.    146.    5.      11.     530.    320.    915.    0.      803.    393.    821.    768.    256.    89.     74.     706.    448.  ; ..
    285.    0.      565.    16.     262.    513.    33.     518.    256.    704.    264.    288.    33.     136.    576.    672.    0.      0.      513.    2.    ; ..
    0.      296.    76.     20.     272.    270.    164.    2.      38.     128.    8.      4.      68.     576.    0.      648.    1.      680.    520.    36.   ; ..
    2.      6.      324.    976.    281.    792.    156.    82.     1.      539.    24.     2.      1.      24.     71.     128.    256.    536.    0.      4.    ; ..
    265.    40.     138.    97.     368.    130.    168.    576.    768.    130.    517.    576.    832.    518.    2.      96.     0.      132.    528.    94.   ; ..
    272.    787.    5.      130.    92.     416.    528.    0.      19.     768.    144.    177.    98.     40.     256.    8.      272.    273.    10.     134.  ; ..
    256.    256.    0.      8.      325.    280.    192.    17.     30.     640.    608.    427.    84.     10.     24.     147.    580.    160.    1.      69.   ; ..
    8.      513.    12.     4.      528.    16.     295.    297.    569.    513.    769.    66.     512.    80.     115.    260.    0.      1.      0.      286.  ; ..
    41.     273.    0.      604.    196.    320.    433.    579.    272.    131.    16.     64.     390.    352.    9.      8.      170.    576.    144.    4.    ; ..
    258.    260.    641.    769.    32.     10.     3.      5.      280.    3.      15.     0.      832.    650.    728.    258.    2.      576.    0.      70.   ; ..
    514.    772.    16.     80.     520.    0.      656.    146.    136.    129.    8.      704.    615.    34.     15.     769.    577.    544.    292.    80.   ; ..
    92.     775.    288.    256.    512.    601.    12.     171.    516.    8.      8.      584.    71.     129.    154.    282.    76.     144.    128.    211.  ; ..
    618.    96.     262.    646.    768.    465.    24.     0.      212.    200.    416.    3.      889.    0.      129.    300.    608.    138.    0.      128.  ; ..
    0.      160.    34.     277.    8.      517.    320.    324.    266.    352.    0.      386.    80.     256.    800.    2.      576.    80.     513.    1.    ; ..
    66.     4.      642.    144.    264.    16.     143.    260.    167.    16.     20.     536.    88.     8.      4.      153.    0.      44.     76.     3.    ; ..
    26.     132.    896.    48.     266.    320.    10.     896.    136.    32.     641.    1.      840.    108.    2.      42.     10.     10.     128.    657.  ; ..
    770.    521.    0.      54.     264.    0.      516.    193.    80.     256.    72.     66.     578.    524.    985.    11.     258.    130.    582.    68.   ; ..
    822.    2.      33.     12.     132.    240.    6.      583.    64.     200.    548.    81.     596.    1.      256.    36.     17.     135.    8.      770.  ; ..
    262.    48.     33.     144.    16.     36.     256.    1.      264.    260.    520.    772.    1.      773.    264.    272.    772.    264.    1.      296.  ; ..
    513.    829.    36.     146.    256.    16.     130.    704.    22.     42.     771.    784.    0.      768.    290.    202.    24.     5.      7.      648.  ; ..
    513.    72.     32.     6.      516.    65.     512.    2.      320.    112.    256.    0.      129.    274.    640.    16.     826.    388.    34.     48.   ; ..
    132.    512.    546.    522.    260.    46.     90.     36.     10.     5.      9.      288.    129.    280.    2.      385.    577.    165.    0.      1.    ; ..
    0.      72.     0.      192.    128.    2.      1.      338.    769.    12.     32.     132.    201.    276.    456.    688.    388.    513.    0.      384.  ; ..
    128.    656.    576.    0.      29.     560.    32.     568.    72.     2.      224.    16.     640.    89.     21.     770.    36.     400.    6.      200.  ; ..
    524.    256.    0.      8.      72.     405.    520.    513.    9.      288.    680.    145.    149.    0.      128.    355.    2.      512.    409.    516.  ; ..
    66.     770.    392.    270.    531.    132.    272.    1.      393.    402.    920.    194.    66.     21.     256.    512.    128.    0.      512.    3.    ; ..
    128.    0.      258.    64.     160.    576.    146.    576.    121.    226.    561.    0.      326.    2.      141.    643.    644.    192.    256.    144.  ; ..
    719.    224.    33.     0.      538.    256.    5.      576.    234.    48.     521.    8.      46.     128.    321.    512.    0.      5.      256.    659.  ; ..
    780.    131.    2.      128.    262.    384.    64.     264.    45.     129.    524.    140.    9.      572.    72.     20.     16.     206.    257.    12.   ; ..
    9.      216.    120.    0.      272.    0.      273.    308.    24.     528.    10.     8.      520.    256.    304.    520.    1.      258.    397.    256.  ; ..
    162.    132.    656.    549.    6.      3.      648.    516.    76.     259.    5.      143.    257.    136.    69.     1.      674.    128.    17.     161.  ; ..
    32.     592.    276.    0.      112.    112.    8.      528.    136.    0.      770.    264.    15.     10.     256.    0.      160.    32.     305.    776.  ; ..
    142.    33.     0.      226.    35.     5.      1.      48.     512.    91.     467.    774.    144.    266.    38.     40.     688.    96.     260.    15.   ; ..
    81.     256.    0.      328.    643.    0.      528.    70.     37.     100.    28.     356.    4.      65.     514.    17.     88.     784.    66.     374.  ; ..
    768.    4.      66.     66.     262.    586.    288.    17.     149.    261.    519.    128.    272.    522.    0.      516.    0.      297.    26.     800.  ; ..
    512.    32.     105.    42.     6.      9.      528.    130.    67.     513.    416.    28.     96.     18.     0.      385.    2.      5.      832.    137.  ; ..
    650.    6.      18.     8.      517.    97.     120.    50.     4.      276.    160.    275.    0.      0.      5.      160.    16.     536.    6.      20.   ; ..
    0.      132.    26.     645.    352.    40.     73.     513.    160.    257.    578.    32.     23.     140.    449.    389.    0.      24.     41.     204.  ; ..
    138.    65.     14.     36.     297.    261.    23.     128.    532.    523.    0.      340.    32.     272.    512.    280.    276.    642.    110.    331.  ; ..
    36.     516.    192.    163.    0.      4.      481.    36.     169.    12.     324.    52.     581.    384.    512.    296.    330.    1.      776.    560.  ; ..
    288.    536.    65.     20.     164.    0.      214.    674.    336.    112.    0.      208.    128.    65.     37.     148.    10.     261.    1.      256.  ; ..
    320.    2.      161.    578.    0.      565.    336.    264.    44.     33.     0.      516.    1.      100.    32.     259.    516.    327.    409.    517.  ; ..
    288.    33.     513.    788.    332.    6.      205.    64.     40.     16.     128.    577.    561.    290.    27.     136.    64.     227.    80.     0.    ; ..
    644.    680.    640.    770.    257.    529.    592.    0.      290.    8.      644.    512.    128.    273.    768.    20.     24.     272.    961.    162.  ; ..
    648.    822.    35.     770.    72.     529.    980.    276.    774.    12.     272.    629.    13.     54.     6.      259.    128.    264.    904.    10.   ];

if or( bitand(A,B) <> C ) then pause, end
