#include "CallScilabBridge.hxx"
/* Generated by GIWS (version 1.0.1) */
/*

Copyright 2007-2008 INRIA

Author : Sylvestre Ledru & others

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_gui_bridge {

// Returns the current env

JNIEnv * CallScilabBridge::getCurrentEnv() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);
return curEnv;
}
// Destructor

CallScilabBridge::~CallScilabBridge() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors

CallScilabBridge::CallScilabBridge(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
std::cerr << "Could not get the Class " << this->className() <<  std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass) ;

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
std::cerr << "Could not create a Global Ref of " << this->className() <<  std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
std::cerr << "Could not retrieve the constructor of the class " << this->className() << " with the profile : " << construct << param << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
std::cerr << "Could not instantiate the object " << this->className() << " with the constructor : " << construct << param << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
std::cerr << "Could not create a new global ref of " << this->className() << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jintnewWindowID=NULL; 
jintnewMenuBarID=NULL; 
jintnewMenuID=NULL; 
jintnewPushButtonID=NULL; 
jintnewEditBoxID=NULL; 
jintnewLabelID=NULL; 
jintnewCheckBoxID=NULL; 
jintnewRadioButtonID=NULL; 
jintnewSliderID=NULL; 
jintnewPopupMenuID=NULL; 
jintnewListBoxID=NULL; 
jintnewFrameID=NULL; 
jstringnewContextMenujobjectArrayID=NULL; 
jintnewContextMenuID=NULL; 
voiddestroyWidgetjintID=NULL; 
voiddestroyFramejintID=NULL; 
jintnewWindowjintID=NULL; 
voidsetFigureAsParentjintjintID=NULL; 
voidsetMenuAsParentjintjintID=NULL; 
voidsetRootAsParentjintID=NULL; 
voidsetParentjintjintID=NULL; 
voidsetPushButtonParentjintjintID=NULL; 
voidremovePushButtonFromParentjintjintID=NULL; 
voidsetEditBoxParentjintjintID=NULL; 
voidremoveEditBoxFromParentjintjintID=NULL; 
voidsetLabelParentjintjintID=NULL; 
voidremoveLabelFromParentjintjintID=NULL; 
voidsetCheckBoxParentjintjintID=NULL; 
voidremoveCheckBoxFromParentjintjintID=NULL; 
voidsetRadioButtonParentjintjintID=NULL; 
voidremoveRadioButtonFromParentjintjintID=NULL; 
voidsetSliderParentjintjintID=NULL; 
voidremoveSliderFromParentjintjintID=NULL; 
voidsetPopupMenuParentjintjintID=NULL; 
voidremovePopupMenuFromParentjintjintID=NULL; 
voidsetListBoxParentjintjintID=NULL; 
voidremoveListBoxFromParentjintjintID=NULL; 
voidsetFrameParentjintjintID=NULL; 
voidremoveFrameFromParentjintjintID=NULL; 
voidsetWidgetTextjintjstringID=NULL; 
jstringgetWidgetTextjintID=NULL; 
voidsetFrameTextjintjstringID=NULL; 
jstringgetFrameTextjintID=NULL; 
voidsetWidgetBackgroundColorjintjintjintjintID=NULL; 
jintArraygetWidgetBackgroundColorjintID=NULL; 
voidsetWidgetForegroundColorjintjintjintjintID=NULL; 
jintArraygetWidgetForegroundColorjintID=NULL; 
voidsetFrameBackgroundColorjintjintjintjintID=NULL; 
jintArraygetFrameBackgroundColorjintID=NULL; 
voidsetFrameForegroundColorjintjintjintjintID=NULL; 
jintArraygetFrameForegroundColorjintID=NULL; 
voidsetWidgetFontNamejintjstringID=NULL; 
jstringgetWidgetFontNamejintID=NULL; 
voidsetWidgetFontWeightjintjstringID=NULL; 
voidsetWidgetFontSizejintjintID=NULL; 
jintgetWidgetFontSizejintID=NULL; 
voidsetWidgetFontAnglejintjstringID=NULL; 
voidsetFrameFontNamejintjstringID=NULL; 
jstringgetFrameFontNamejintID=NULL; 
voidsetFrameFontWeightjintjstringID=NULL; 
voidsetFrameFontSizejintjintID=NULL; 
jintgetFrameFontSizejintID=NULL; 
voidsetFrameFontAnglejintjstringID=NULL; 
voidsetWidgetPositionjintjintjintjintjintID=NULL; 
jintArraygetWidgetPositionjintID=NULL; 
voidsetFramePositionjintjintjintjintjintID=NULL; 
jintArraygetFramePositionjintID=NULL; 
voidsetWidgetCallbackjintjstringjintID=NULL; 
voidsetFrameCallbackjintjstringjintID=NULL; 
voidsetWidgetHorizontalAlignmentjintjstringID=NULL; 
voidsetWidgetVerticalAlignmentjintjstringID=NULL; 
voidsetSliderMinorTickSpacingjintjintID=NULL; 
voidsetSliderMajorTickSpacingjintjintID=NULL; 
voidsetListBoxSelectedIndicesjintjintArrayID=NULL; 
jintArraygetListBoxSelectedIndicesjintID=NULL; 
jintgetListBoxSelectionSizejintID=NULL; 
voidsetPopupMenuSelectedIndexjintjintID=NULL; 
jintgetPopupMenuSelectedIndexjintID=NULL; 
voidsetSliderValuejintjintID=NULL; 
jintgetSliderValuejintID=NULL; 
voidsetRadioButtonCheckedjintjbooleanID=NULL; 
jbooleanisRadioButtonCheckedjintID=NULL; 
voidsetCheckBoxCheckedjintjbooleanID=NULL; 
jbooleanisCheckBoxCheckedjintID=NULL; 
voidsetSliderMinValuejintjintID=NULL; 
voidsetSliderMaxValuejintjintID=NULL; 
voidsetSliderVerticaljintID=NULL; 
voidsetSliderHorizontaljintID=NULL; 
voidsetListBoxMultipleSelectionEnabledjintjbooleanID=NULL; 
jobjectArraygetListBoxAllItemsTextjintID=NULL; 
jintgetListBoxNumberOfItemsjintID=NULL; 
voidsetListBoxTextjintjobjectArrayID=NULL; 
jobjectArraygetPopupMenuAllItemsTextjintID=NULL; 
jintgetPopupMenuNumberOfItemsjintID=NULL; 
voidsetPopupMenuTextjintjobjectArrayID=NULL; 
voidsetWidgetReliefjintjstringID=NULL; 
voidsetFrameReliefjintjstringID=NULL; 
voidsetRootMenuEnabledjstringjbooleanID=NULL; 
voidsetRootSubMenuEnabledjstringjintjbooleanID=NULL; 
voidsetFigureMenuEnabledjintjstringjbooleanID=NULL; 
voidsetFigureSubMenuEnabledjintjstringjintjbooleanID=NULL; 
voidsetWidgetEnablejintjbooleanID=NULL; 
voidsetFrameEnablejintjbooleanID=NULL; 
jbooleanisWidgetEnablejintID=NULL; 
jbooleanisFrameEnablejintID=NULL; 
voidremoveRootMenujstringID=NULL; 
voidremoveFigureMenujintjstringID=NULL; 
jstringdisplayAndWaitContextMenujintID=NULL; 
jintnewMessageBoxID=NULL; 
voidsetMessageBoxTitlejintjstringID=NULL; 
voidsetMessageBoxMessagejintjstringID=NULL; 
voidsetMessageBoxMessagejintjobjectArrayID=NULL; 
voidmessageBoxDisplayAndWaitjintID=NULL; 
jintgetMessageBoxSelectedButtonjintID=NULL; 
voidsetMessageBoxDefaultSelectedButtonsjintjintArrayID=NULL; 
jintArraygetMessageBoxUserSelectedButtonsjintID=NULL; 
voidsetMessageBoxButtonsLabelsjintjobjectArrayID=NULL; 
voidsetMessageBoxInitialValuejintjobjectArrayID=NULL; 
jobjectArraygetMessageBoxValuejintID=NULL; 
jintgetMessageBoxValueSizejintID=NULL; 
voidsetMessageBoxListBoxItemsjintjobjectArrayID=NULL; 
jintgetMessageBoxSelectedItemjintID=NULL; 
voidsetMessageBoxLineLabelsjintjobjectArrayID=NULL; 
voidsetMessageBoxColumnLabelsjintjobjectArrayID=NULL; 
voidsetMessageBoxDefaultInputjintjobjectArrayID=NULL; 
voidsetMessageBoxModaljintjbooleanID=NULL; 
voidsetMessageBoxIconjintjstringID=NULL; 
jbooleanisToolbarVisiblejintID=NULL; 
voidsetToolbarVisiblejintjbooleanID=NULL; 
voidsetEventHandlerjintjstringID=NULL; 
voidsetEventHandlerEnabledjintjbooleanID=NULL; 
jintnewWaitBarID=NULL; 
voidsetWaitBarMessagejintjobjectArrayID=NULL; 
voidsetWaitBarValuejintjintID=NULL; 
voiddestroyWaitBarjintID=NULL; 
voidsetWaitBarIndeterminateModejintjbooleanID=NULL; 
voidlaunchHelpBrowserjobjectArrayjstringID=NULL; 
voidsearchKeywordjobjectArrayjstringjstringjbooleanID=NULL; 
voidsaveMainWindowSettingsID=NULL; 
jintnewExportFileChooserjintID=NULL; 
jintnewFontChooserID=NULL; 
voidfontChooserDisplayAndWaitjintID=NULL; 
voidsetFontChooserFontNamejintjstringID=NULL; 
voidsetFontChooserFontSizejintjintID=NULL; 
voidsetFontChooserBoldjintjbooleanID=NULL; 
voidsetFontChooserItalicjintjbooleanID=NULL; 
jstringgetFontChooserFontNamejintID=NULL; 
jintgetFontChooserFontSizejintID=NULL; 
jbooleangetFontChooserBoldjintID=NULL; 
jbooleangetFontChooserItalicjintID=NULL; 
jintnewColorChooserID=NULL; 
voidcolorChooserDisplayAndWaitjintID=NULL; 
voidsetColorChooserDefaultColorjintjintArrayID=NULL; 
jintArraygetColorChooserSelectedColorjintID=NULL; 
voidsetColorChooserTitlejintjstringID=NULL; 
voidsetWidgetVisiblejintjbooleanID=NULL; 
voidsetFrameVisiblejintjbooleanID=NULL; 
jbooleanisWidgetVisiblejintID=NULL; 
jbooleanisFrameVisiblejintID=NULL; 
jstringgetClipboardContentsID=NULL; 
voidpasteClipboardIntoConsoleID=NULL; 
voidcopyConsoleSelectionID=NULL; 
voidemptyClipboardID=NULL; 
voidsetClipboardContentsjstringID=NULL; 
voidcopyFigureToClipBoardjintID=NULL; 
jintgetScreenResolutionID=NULL; 
jdoublegetScreenWidthID=NULL; 
jdoublegetScreenHeightID=NULL; 
jintgetScreenDepthID=NULL; 
jbooleanprintFigurejintjbooleanjbooleanID=NULL; 
jbooleanprintFilejstringID=NULL; 
jbooleanprintStringjstringjstringID=NULL; 
jbooleanpageSetupID=NULL; 
voidrequestWidgetFocusjintID=NULL; 
voidrequestFrameFocusjintID=NULL; 
voidraiseWindowjintID=NULL; 
voiduseCanvasForDisplayjbooleanID=NULL; 
jbooleanuseCanvasForDisplayID=NULL; 


}

CallScilabBridge::CallScilabBridge(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass);
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {

std::cerr << "Could not create a Global Ref of " << this->className() <<  std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){

std::cerr << "Could not create a new global ref of " << this->className() << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
        }
        /* Methods ID set to NULL */
        jintnewWindowID=NULL; 
jintnewMenuBarID=NULL; 
jintnewMenuID=NULL; 
jintnewPushButtonID=NULL; 
jintnewEditBoxID=NULL; 
jintnewLabelID=NULL; 
jintnewCheckBoxID=NULL; 
jintnewRadioButtonID=NULL; 
jintnewSliderID=NULL; 
jintnewPopupMenuID=NULL; 
jintnewListBoxID=NULL; 
jintnewFrameID=NULL; 
jstringnewContextMenujobjectArrayID=NULL; 
jintnewContextMenuID=NULL; 
voiddestroyWidgetjintID=NULL; 
voiddestroyFramejintID=NULL; 
jintnewWindowjintID=NULL; 
voidsetFigureAsParentjintjintID=NULL; 
voidsetMenuAsParentjintjintID=NULL; 
voidsetRootAsParentjintID=NULL; 
voidsetParentjintjintID=NULL; 
voidsetPushButtonParentjintjintID=NULL; 
voidremovePushButtonFromParentjintjintID=NULL; 
voidsetEditBoxParentjintjintID=NULL; 
voidremoveEditBoxFromParentjintjintID=NULL; 
voidsetLabelParentjintjintID=NULL; 
voidremoveLabelFromParentjintjintID=NULL; 
voidsetCheckBoxParentjintjintID=NULL; 
voidremoveCheckBoxFromParentjintjintID=NULL; 
voidsetRadioButtonParentjintjintID=NULL; 
voidremoveRadioButtonFromParentjintjintID=NULL; 
voidsetSliderParentjintjintID=NULL; 
voidremoveSliderFromParentjintjintID=NULL; 
voidsetPopupMenuParentjintjintID=NULL; 
voidremovePopupMenuFromParentjintjintID=NULL; 
voidsetListBoxParentjintjintID=NULL; 
voidremoveListBoxFromParentjintjintID=NULL; 
voidsetFrameParentjintjintID=NULL; 
voidremoveFrameFromParentjintjintID=NULL; 
voidsetWidgetTextjintjstringID=NULL; 
jstringgetWidgetTextjintID=NULL; 
voidsetFrameTextjintjstringID=NULL; 
jstringgetFrameTextjintID=NULL; 
voidsetWidgetBackgroundColorjintjintjintjintID=NULL; 
jintArraygetWidgetBackgroundColorjintID=NULL; 
voidsetWidgetForegroundColorjintjintjintjintID=NULL; 
jintArraygetWidgetForegroundColorjintID=NULL; 
voidsetFrameBackgroundColorjintjintjintjintID=NULL; 
jintArraygetFrameBackgroundColorjintID=NULL; 
voidsetFrameForegroundColorjintjintjintjintID=NULL; 
jintArraygetFrameForegroundColorjintID=NULL; 
voidsetWidgetFontNamejintjstringID=NULL; 
jstringgetWidgetFontNamejintID=NULL; 
voidsetWidgetFontWeightjintjstringID=NULL; 
voidsetWidgetFontSizejintjintID=NULL; 
jintgetWidgetFontSizejintID=NULL; 
voidsetWidgetFontAnglejintjstringID=NULL; 
voidsetFrameFontNamejintjstringID=NULL; 
jstringgetFrameFontNamejintID=NULL; 
voidsetFrameFontWeightjintjstringID=NULL; 
voidsetFrameFontSizejintjintID=NULL; 
jintgetFrameFontSizejintID=NULL; 
voidsetFrameFontAnglejintjstringID=NULL; 
voidsetWidgetPositionjintjintjintjintjintID=NULL; 
jintArraygetWidgetPositionjintID=NULL; 
voidsetFramePositionjintjintjintjintjintID=NULL; 
jintArraygetFramePositionjintID=NULL; 
voidsetWidgetCallbackjintjstringjintID=NULL; 
voidsetFrameCallbackjintjstringjintID=NULL; 
voidsetWidgetHorizontalAlignmentjintjstringID=NULL; 
voidsetWidgetVerticalAlignmentjintjstringID=NULL; 
voidsetSliderMinorTickSpacingjintjintID=NULL; 
voidsetSliderMajorTickSpacingjintjintID=NULL; 
voidsetListBoxSelectedIndicesjintjintArrayID=NULL; 
jintArraygetListBoxSelectedIndicesjintID=NULL; 
jintgetListBoxSelectionSizejintID=NULL; 
voidsetPopupMenuSelectedIndexjintjintID=NULL; 
jintgetPopupMenuSelectedIndexjintID=NULL; 
voidsetSliderValuejintjintID=NULL; 
jintgetSliderValuejintID=NULL; 
voidsetRadioButtonCheckedjintjbooleanID=NULL; 
jbooleanisRadioButtonCheckedjintID=NULL; 
voidsetCheckBoxCheckedjintjbooleanID=NULL; 
jbooleanisCheckBoxCheckedjintID=NULL; 
voidsetSliderMinValuejintjintID=NULL; 
voidsetSliderMaxValuejintjintID=NULL; 
voidsetSliderVerticaljintID=NULL; 
voidsetSliderHorizontaljintID=NULL; 
voidsetListBoxMultipleSelectionEnabledjintjbooleanID=NULL; 
jobjectArraygetListBoxAllItemsTextjintID=NULL; 
jintgetListBoxNumberOfItemsjintID=NULL; 
voidsetListBoxTextjintjobjectArrayID=NULL; 
jobjectArraygetPopupMenuAllItemsTextjintID=NULL; 
jintgetPopupMenuNumberOfItemsjintID=NULL; 
voidsetPopupMenuTextjintjobjectArrayID=NULL; 
voidsetWidgetReliefjintjstringID=NULL; 
voidsetFrameReliefjintjstringID=NULL; 
voidsetRootMenuEnabledjstringjbooleanID=NULL; 
voidsetRootSubMenuEnabledjstringjintjbooleanID=NULL; 
voidsetFigureMenuEnabledjintjstringjbooleanID=NULL; 
voidsetFigureSubMenuEnabledjintjstringjintjbooleanID=NULL; 
voidsetWidgetEnablejintjbooleanID=NULL; 
voidsetFrameEnablejintjbooleanID=NULL; 
jbooleanisWidgetEnablejintID=NULL; 
jbooleanisFrameEnablejintID=NULL; 
voidremoveRootMenujstringID=NULL; 
voidremoveFigureMenujintjstringID=NULL; 
jstringdisplayAndWaitContextMenujintID=NULL; 
jintnewMessageBoxID=NULL; 
voidsetMessageBoxTitlejintjstringID=NULL; 
voidsetMessageBoxMessagejintjstringID=NULL; 
voidsetMessageBoxMessagejintjobjectArrayID=NULL; 
voidmessageBoxDisplayAndWaitjintID=NULL; 
jintgetMessageBoxSelectedButtonjintID=NULL; 
voidsetMessageBoxDefaultSelectedButtonsjintjintArrayID=NULL; 
jintArraygetMessageBoxUserSelectedButtonsjintID=NULL; 
voidsetMessageBoxButtonsLabelsjintjobjectArrayID=NULL; 
voidsetMessageBoxInitialValuejintjobjectArrayID=NULL; 
jobjectArraygetMessageBoxValuejintID=NULL; 
jintgetMessageBoxValueSizejintID=NULL; 
voidsetMessageBoxListBoxItemsjintjobjectArrayID=NULL; 
jintgetMessageBoxSelectedItemjintID=NULL; 
voidsetMessageBoxLineLabelsjintjobjectArrayID=NULL; 
voidsetMessageBoxColumnLabelsjintjobjectArrayID=NULL; 
voidsetMessageBoxDefaultInputjintjobjectArrayID=NULL; 
voidsetMessageBoxModaljintjbooleanID=NULL; 
voidsetMessageBoxIconjintjstringID=NULL; 
jbooleanisToolbarVisiblejintID=NULL; 
voidsetToolbarVisiblejintjbooleanID=NULL; 
voidsetEventHandlerjintjstringID=NULL; 
voidsetEventHandlerEnabledjintjbooleanID=NULL; 
jintnewWaitBarID=NULL; 
voidsetWaitBarMessagejintjobjectArrayID=NULL; 
voidsetWaitBarValuejintjintID=NULL; 
voiddestroyWaitBarjintID=NULL; 
voidsetWaitBarIndeterminateModejintjbooleanID=NULL; 
voidlaunchHelpBrowserjobjectArrayjstringID=NULL; 
voidsearchKeywordjobjectArrayjstringjstringjbooleanID=NULL; 
voidsaveMainWindowSettingsID=NULL; 
jintnewExportFileChooserjintID=NULL; 
jintnewFontChooserID=NULL; 
voidfontChooserDisplayAndWaitjintID=NULL; 
voidsetFontChooserFontNamejintjstringID=NULL; 
voidsetFontChooserFontSizejintjintID=NULL; 
voidsetFontChooserBoldjintjbooleanID=NULL; 
voidsetFontChooserItalicjintjbooleanID=NULL; 
jstringgetFontChooserFontNamejintID=NULL; 
jintgetFontChooserFontSizejintID=NULL; 
jbooleangetFontChooserBoldjintID=NULL; 
jbooleangetFontChooserItalicjintID=NULL; 
jintnewColorChooserID=NULL; 
voidcolorChooserDisplayAndWaitjintID=NULL; 
voidsetColorChooserDefaultColorjintjintArrayID=NULL; 
jintArraygetColorChooserSelectedColorjintID=NULL; 
voidsetColorChooserTitlejintjstringID=NULL; 
voidsetWidgetVisiblejintjbooleanID=NULL; 
voidsetFrameVisiblejintjbooleanID=NULL; 
jbooleanisWidgetVisiblejintID=NULL; 
jbooleanisFrameVisiblejintID=NULL; 
jstringgetClipboardContentsID=NULL; 
voidpasteClipboardIntoConsoleID=NULL; 
voidcopyConsoleSelectionID=NULL; 
voidemptyClipboardID=NULL; 
voidsetClipboardContentsjstringID=NULL; 
voidcopyFigureToClipBoardjintID=NULL; 
jintgetScreenResolutionID=NULL; 
jdoublegetScreenWidthID=NULL; 
jdoublegetScreenHeightID=NULL; 
jintgetScreenDepthID=NULL; 
jbooleanprintFigurejintjbooleanjbooleanID=NULL; 
jbooleanprintFilejstringID=NULL; 
jbooleanprintStringjstringjstringID=NULL; 
jbooleanpageSetupID=NULL; 
voidrequestWidgetFocusjintID=NULL; 
voidrequestFrameFocusjintID=NULL; 
voidraiseWindowjintID=NULL; 
voiduseCanvasForDisplayjbooleanID=NULL; 
jbooleanuseCanvasForDisplayID=NULL; 


}

// Generic methods


void CallScilabBridge::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
std::cerr << "Fail to enter monitor." << std::endl;
exit(EXIT_FAILURE);
}
}


void CallScilabBridge::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
std::cerr << "Fail to exit monitor." << std::endl;
exit(EXIT_FAILURE);
}
}

// Method(s)

int CallScilabBridge::newWindow (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewWindowID = curEnv->GetStaticMethodID(cls, "newWindow", "()I" ) ;
if (jintnewWindowID == NULL) {
std::cerr << "Could not access to the method " << "newWindow" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewWindowID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newMenuBar (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewMenuBarID = curEnv->GetStaticMethodID(cls, "newMenuBar", "()I" ) ;
if (jintnewMenuBarID == NULL) {
std::cerr << "Could not access to the method " << "newMenuBar" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewMenuBarID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newMenu (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewMenuID = curEnv->GetStaticMethodID(cls, "newMenu", "()I" ) ;
if (jintnewMenuID == NULL) {
std::cerr << "Could not access to the method " << "newMenu" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewMenuID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newPushButton (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewPushButtonID = curEnv->GetStaticMethodID(cls, "newPushButton", "()I" ) ;
if (jintnewPushButtonID == NULL) {
std::cerr << "Could not access to the method " << "newPushButton" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewPushButtonID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newEditBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewEditBoxID = curEnv->GetStaticMethodID(cls, "newEditBox", "()I" ) ;
if (jintnewEditBoxID == NULL) {
std::cerr << "Could not access to the method " << "newEditBox" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewEditBoxID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newLabel (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewLabelID = curEnv->GetStaticMethodID(cls, "newLabel", "()I" ) ;
if (jintnewLabelID == NULL) {
std::cerr << "Could not access to the method " << "newLabel" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewLabelID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newCheckBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewCheckBoxID = curEnv->GetStaticMethodID(cls, "newCheckBox", "()I" ) ;
if (jintnewCheckBoxID == NULL) {
std::cerr << "Could not access to the method " << "newCheckBox" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewCheckBoxID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newRadioButton (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewRadioButtonID = curEnv->GetStaticMethodID(cls, "newRadioButton", "()I" ) ;
if (jintnewRadioButtonID == NULL) {
std::cerr << "Could not access to the method " << "newRadioButton" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewRadioButtonID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newSlider (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewSliderID = curEnv->GetStaticMethodID(cls, "newSlider", "()I" ) ;
if (jintnewSliderID == NULL) {
std::cerr << "Could not access to the method " << "newSlider" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewSliderID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newPopupMenu (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewPopupMenuID = curEnv->GetStaticMethodID(cls, "newPopupMenu", "()I" ) ;
if (jintnewPopupMenuID == NULL) {
std::cerr << "Could not access to the method " << "newPopupMenu" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewPopupMenuID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newListBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewListBoxID = curEnv->GetStaticMethodID(cls, "newListBox", "()I" ) ;
if (jintnewListBoxID == NULL) {
std::cerr << "Could not access to the method " << "newListBox" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewListBoxID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newFrame (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewFrameID = curEnv->GetStaticMethodID(cls, "newFrame", "()I" ) ;
if (jintnewFrameID == NULL) {
std::cerr << "Could not access to the method " << "newFrame" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewFrameID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

char * CallScilabBridge::newContextMenu (JavaVM * jvm_, char ** menuLabels, int menuLabelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringnewContextMenujobjectArrayID = curEnv->GetStaticMethodID(cls, "newContextMenu", "([Ljava/lang/String;)Ljava/lang/String;" ) ;
if (jstringnewContextMenujobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "newContextMenu" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray menuLabels_ = curEnv->NewObjectArray( menuLabelsSize, stringArrayClass, NULL);
if (menuLabels_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < menuLabelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( menuLabels[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( menuLabels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringnewContextMenujobjectArrayID ,menuLabels_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(menuLabels_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

int CallScilabBridge::newContextMenu (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewContextMenuID = curEnv->GetStaticMethodID(cls, "newContextMenu", "()I" ) ;
if (jintnewContextMenuID == NULL) {
std::cerr << "Could not access to the method " << "newContextMenu" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewContextMenuID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::destroyWidget (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiddestroyWidgetjintID = curEnv->GetStaticMethodID(cls, "destroyWidget", "(I)V" ) ;
if (voiddestroyWidgetjintID == NULL) {
std::cerr << "Could not access to the method " << "destroyWidget" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voiddestroyWidgetjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::destroyFrame (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiddestroyFramejintID = curEnv->GetStaticMethodID(cls, "destroyFrame", "(I)V" ) ;
if (voiddestroyFramejintID == NULL) {
std::cerr << "Could not access to the method " << "destroyFrame" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voiddestroyFramejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::newWindow (JavaVM * jvm_, int figureIndex){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewWindowjintID = curEnv->GetStaticMethodID(cls, "newWindow", "(I)I" ) ;
if (jintnewWindowjintID == NULL) {
std::cerr << "Could not access to the method " << "newWindow" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewWindowjintID ,figureIndex);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setFigureAsParent (JavaVM * jvm_, int figureID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFigureAsParentjintjintID = curEnv->GetStaticMethodID(cls, "setFigureAsParent", "(II)V" ) ;
if (voidsetFigureAsParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setFigureAsParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFigureAsParentjintjintID ,figureID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setMenuAsParent (JavaVM * jvm_, int menuID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMenuAsParentjintjintID = curEnv->GetStaticMethodID(cls, "setMenuAsParent", "(II)V" ) ;
if (voidsetMenuAsParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setMenuAsParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetMenuAsParentjintjintID ,menuID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setRootAsParent (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRootAsParentjintID = curEnv->GetStaticMethodID(cls, "setRootAsParent", "(I)V" ) ;
if (voidsetRootAsParentjintID == NULL) {
std::cerr << "Could not access to the method " << "setRootAsParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetRootAsParentjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetParentjintjintID = curEnv->GetStaticMethodID(cls, "setParent", "(II)V" ) ;
if (voidsetParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setPushButtonParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetPushButtonParentjintjintID = curEnv->GetStaticMethodID(cls, "setPushButtonParent", "(II)V" ) ;
if (voidsetPushButtonParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setPushButtonParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetPushButtonParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removePushButtonFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremovePushButtonFromParentjintjintID = curEnv->GetStaticMethodID(cls, "removePushButtonFromParent", "(II)V" ) ;
if (voidremovePushButtonFromParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "removePushButtonFromParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidremovePushButtonFromParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setEditBoxParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetEditBoxParentjintjintID = curEnv->GetStaticMethodID(cls, "setEditBoxParent", "(II)V" ) ;
if (voidsetEditBoxParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setEditBoxParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetEditBoxParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removeEditBoxFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveEditBoxFromParentjintjintID = curEnv->GetStaticMethodID(cls, "removeEditBoxFromParent", "(II)V" ) ;
if (voidremoveEditBoxFromParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "removeEditBoxFromParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveEditBoxFromParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setLabelParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetLabelParentjintjintID = curEnv->GetStaticMethodID(cls, "setLabelParent", "(II)V" ) ;
if (voidsetLabelParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setLabelParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetLabelParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removeLabelFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveLabelFromParentjintjintID = curEnv->GetStaticMethodID(cls, "removeLabelFromParent", "(II)V" ) ;
if (voidremoveLabelFromParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "removeLabelFromParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveLabelFromParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setCheckBoxParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetCheckBoxParentjintjintID = curEnv->GetStaticMethodID(cls, "setCheckBoxParent", "(II)V" ) ;
if (voidsetCheckBoxParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setCheckBoxParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetCheckBoxParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removeCheckBoxFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveCheckBoxFromParentjintjintID = curEnv->GetStaticMethodID(cls, "removeCheckBoxFromParent", "(II)V" ) ;
if (voidremoveCheckBoxFromParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "removeCheckBoxFromParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveCheckBoxFromParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setRadioButtonParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRadioButtonParentjintjintID = curEnv->GetStaticMethodID(cls, "setRadioButtonParent", "(II)V" ) ;
if (voidsetRadioButtonParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setRadioButtonParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetRadioButtonParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removeRadioButtonFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveRadioButtonFromParentjintjintID = curEnv->GetStaticMethodID(cls, "removeRadioButtonFromParent", "(II)V" ) ;
if (voidremoveRadioButtonFromParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "removeRadioButtonFromParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveRadioButtonFromParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setSliderParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderParentjintjintID = curEnv->GetStaticMethodID(cls, "setSliderParent", "(II)V" ) ;
if (voidsetSliderParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setSliderParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removeSliderFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveSliderFromParentjintjintID = curEnv->GetStaticMethodID(cls, "removeSliderFromParent", "(II)V" ) ;
if (voidremoveSliderFromParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "removeSliderFromParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveSliderFromParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setPopupMenuParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetPopupMenuParentjintjintID = curEnv->GetStaticMethodID(cls, "setPopupMenuParent", "(II)V" ) ;
if (voidsetPopupMenuParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setPopupMenuParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetPopupMenuParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removePopupMenuFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremovePopupMenuFromParentjintjintID = curEnv->GetStaticMethodID(cls, "removePopupMenuFromParent", "(II)V" ) ;
if (voidremovePopupMenuFromParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "removePopupMenuFromParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidremovePopupMenuFromParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setListBoxParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetListBoxParentjintjintID = curEnv->GetStaticMethodID(cls, "setListBoxParent", "(II)V" ) ;
if (voidsetListBoxParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setListBoxParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetListBoxParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removeListBoxFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveListBoxFromParentjintjintID = curEnv->GetStaticMethodID(cls, "removeListBoxFromParent", "(II)V" ) ;
if (voidremoveListBoxFromParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "removeListBoxFromParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveListBoxFromParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFrameParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameParentjintjintID = curEnv->GetStaticMethodID(cls, "setFrameParent", "(II)V" ) ;
if (voidsetFrameParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setFrameParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removeFrameFromParent (JavaVM * jvm_, int parentID, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveFrameFromParentjintjintID = curEnv->GetStaticMethodID(cls, "removeFrameFromParent", "(II)V" ) ;
if (voidremoveFrameFromParentjintjintID == NULL) {
std::cerr << "Could not access to the method " << "removeFrameFromParent" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidremoveFrameFromParentjintjintID ,parentID, objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWidgetText (JavaVM * jvm_, int objID, char * text){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetTextjintjstringID = curEnv->GetStaticMethodID(cls, "setWidgetText", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetTextjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetText" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring text_ = curEnv->NewStringUTF( text );

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetTextjintjstringID ,objID, text_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char * CallScilabBridge::getWidgetText (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetWidgetTextjintID = curEnv->GetStaticMethodID(cls, "getWidgetText", "(I)Ljava/lang/String;" ) ;
if (jstringgetWidgetTextjintID == NULL) {
std::cerr << "Could not access to the method " << "getWidgetText" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetWidgetTextjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

void CallScilabBridge::setFrameText (JavaVM * jvm_, int objID, char * text){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameTextjintjstringID = curEnv->GetStaticMethodID(cls, "setFrameText", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameTextjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setFrameText" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring text_ = curEnv->NewStringUTF( text );

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameTextjintjstringID ,objID, text_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char * CallScilabBridge::getFrameText (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetFrameTextjintID = curEnv->GetStaticMethodID(cls, "getFrameText", "(I)Ljava/lang/String;" ) ;
if (jstringgetFrameTextjintID == NULL) {
std::cerr << "Could not access to the method " << "getFrameText" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetFrameTextjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

void CallScilabBridge::setWidgetBackgroundColor (JavaVM * jvm_, int objID, int red, int green, int blue){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetBackgroundColorjintjintjintjintID = curEnv->GetStaticMethodID(cls, "setWidgetBackgroundColor", "(IIII)V" ) ;
if (voidsetWidgetBackgroundColorjintjintjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetBackgroundColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetBackgroundColorjintjintjintjintID ,objID, red, green, blue);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int * CallScilabBridge::getWidgetBackgroundColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArraygetWidgetBackgroundColorjintID = curEnv->GetStaticMethodID(cls, "getWidgetBackgroundColor", "(I)[I" ) ;
if (jintArraygetWidgetBackgroundColorjintID == NULL) {
std::cerr << "Could not access to the method " << "getWidgetBackgroundColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jintArray res =  (jintArray) curEnv->CallObjectMethod(cls, jintArraygetWidgetBackgroundColorjintID ,objID);

jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myArray;

}

void CallScilabBridge::setWidgetForegroundColor (JavaVM * jvm_, int objID, int red, int green, int blue){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetForegroundColorjintjintjintjintID = curEnv->GetStaticMethodID(cls, "setWidgetForegroundColor", "(IIII)V" ) ;
if (voidsetWidgetForegroundColorjintjintjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetForegroundColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetForegroundColorjintjintjintjintID ,objID, red, green, blue);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int * CallScilabBridge::getWidgetForegroundColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArraygetWidgetForegroundColorjintID = curEnv->GetStaticMethodID(cls, "getWidgetForegroundColor", "(I)[I" ) ;
if (jintArraygetWidgetForegroundColorjintID == NULL) {
std::cerr << "Could not access to the method " << "getWidgetForegroundColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jintArray res =  (jintArray) curEnv->CallObjectMethod(cls, jintArraygetWidgetForegroundColorjintID ,objID);

jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myArray;

}

void CallScilabBridge::setFrameBackgroundColor (JavaVM * jvm_, int objID, int red, int green, int blue){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameBackgroundColorjintjintjintjintID = curEnv->GetStaticMethodID(cls, "setFrameBackgroundColor", "(IIII)V" ) ;
if (voidsetFrameBackgroundColorjintjintjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setFrameBackgroundColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameBackgroundColorjintjintjintjintID ,objID, red, green, blue);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int * CallScilabBridge::getFrameBackgroundColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArraygetFrameBackgroundColorjintID = curEnv->GetStaticMethodID(cls, "getFrameBackgroundColor", "(I)[I" ) ;
if (jintArraygetFrameBackgroundColorjintID == NULL) {
std::cerr << "Could not access to the method " << "getFrameBackgroundColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jintArray res =  (jintArray) curEnv->CallObjectMethod(cls, jintArraygetFrameBackgroundColorjintID ,objID);

jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myArray;

}

void CallScilabBridge::setFrameForegroundColor (JavaVM * jvm_, int objID, int red, int green, int blue){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameForegroundColorjintjintjintjintID = curEnv->GetStaticMethodID(cls, "setFrameForegroundColor", "(IIII)V" ) ;
if (voidsetFrameForegroundColorjintjintjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setFrameForegroundColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameForegroundColorjintjintjintjintID ,objID, red, green, blue);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int * CallScilabBridge::getFrameForegroundColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArraygetFrameForegroundColorjintID = curEnv->GetStaticMethodID(cls, "getFrameForegroundColor", "(I)[I" ) ;
if (jintArraygetFrameForegroundColorjintID == NULL) {
std::cerr << "Could not access to the method " << "getFrameForegroundColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jintArray res =  (jintArray) curEnv->CallObjectMethod(cls, jintArraygetFrameForegroundColorjintID ,objID);

jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myArray;

}

void CallScilabBridge::setWidgetFontName (JavaVM * jvm_, int objID, char * name){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetFontNamejintjstringID = curEnv->GetStaticMethodID(cls, "setWidgetFontName", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetFontNamejintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetFontName" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring name_ = curEnv->NewStringUTF( name );

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetFontNamejintjstringID ,objID, name_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char * CallScilabBridge::getWidgetFontName (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetWidgetFontNamejintID = curEnv->GetStaticMethodID(cls, "getWidgetFontName", "(I)Ljava/lang/String;" ) ;
if (jstringgetWidgetFontNamejintID == NULL) {
std::cerr << "Could not access to the method " << "getWidgetFontName" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetWidgetFontNamejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

void CallScilabBridge::setWidgetFontWeight (JavaVM * jvm_, int objID, char * weight){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetFontWeightjintjstringID = curEnv->GetStaticMethodID(cls, "setWidgetFontWeight", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetFontWeightjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetFontWeight" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring weight_ = curEnv->NewStringUTF( weight );

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetFontWeightjintjstringID ,objID, weight_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWidgetFontSize (JavaVM * jvm_, int objID, int size){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetFontSizejintjintID = curEnv->GetStaticMethodID(cls, "setWidgetFontSize", "(II)V" ) ;
if (voidsetWidgetFontSizejintjintID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetFontSize" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetFontSizejintjintID ,objID, size);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::getWidgetFontSize (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetWidgetFontSizejintID = curEnv->GetStaticMethodID(cls, "getWidgetFontSize", "(I)I" ) ;
if (jintgetWidgetFontSizejintID == NULL) {
std::cerr << "Could not access to the method " << "getWidgetFontSize" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetWidgetFontSizejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setWidgetFontAngle (JavaVM * jvm_, int objID, char * angle){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetFontAnglejintjstringID = curEnv->GetStaticMethodID(cls, "setWidgetFontAngle", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetFontAnglejintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetFontAngle" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring angle_ = curEnv->NewStringUTF( angle );

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetFontAnglejintjstringID ,objID, angle_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFrameFontName (JavaVM * jvm_, int objID, char * name){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameFontNamejintjstringID = curEnv->GetStaticMethodID(cls, "setFrameFontName", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameFontNamejintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setFrameFontName" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring name_ = curEnv->NewStringUTF( name );

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameFontNamejintjstringID ,objID, name_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char * CallScilabBridge::getFrameFontName (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetFrameFontNamejintID = curEnv->GetStaticMethodID(cls, "getFrameFontName", "(I)Ljava/lang/String;" ) ;
if (jstringgetFrameFontNamejintID == NULL) {
std::cerr << "Could not access to the method " << "getFrameFontName" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetFrameFontNamejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

void CallScilabBridge::setFrameFontWeight (JavaVM * jvm_, int objID, char * weight){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameFontWeightjintjstringID = curEnv->GetStaticMethodID(cls, "setFrameFontWeight", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameFontWeightjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setFrameFontWeight" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring weight_ = curEnv->NewStringUTF( weight );

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameFontWeightjintjstringID ,objID, weight_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFrameFontSize (JavaVM * jvm_, int objID, int size){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameFontSizejintjintID = curEnv->GetStaticMethodID(cls, "setFrameFontSize", "(II)V" ) ;
if (voidsetFrameFontSizejintjintID == NULL) {
std::cerr << "Could not access to the method " << "setFrameFontSize" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameFontSizejintjintID ,objID, size);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::getFrameFontSize (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFrameFontSizejintID = curEnv->GetStaticMethodID(cls, "getFrameFontSize", "(I)I" ) ;
if (jintgetFrameFontSizejintID == NULL) {
std::cerr << "Could not access to the method " << "getFrameFontSize" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetFrameFontSizejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setFrameFontAngle (JavaVM * jvm_, int objID, char * angle){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameFontAnglejintjstringID = curEnv->GetStaticMethodID(cls, "setFrameFontAngle", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameFontAnglejintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setFrameFontAngle" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring angle_ = curEnv->NewStringUTF( angle );

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameFontAnglejintjstringID ,objID, angle_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWidgetPosition (JavaVM * jvm_, int objID, int x, int y, int width, int height){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetPositionjintjintjintjintjintID = curEnv->GetStaticMethodID(cls, "setWidgetPosition", "(IIIII)V" ) ;
if (voidsetWidgetPositionjintjintjintjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetPosition" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetPositionjintjintjintjintjintID ,objID, x, y, width, height);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int * CallScilabBridge::getWidgetPosition (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArraygetWidgetPositionjintID = curEnv->GetStaticMethodID(cls, "getWidgetPosition", "(I)[I" ) ;
if (jintArraygetWidgetPositionjintID == NULL) {
std::cerr << "Could not access to the method " << "getWidgetPosition" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jintArray res =  (jintArray) curEnv->CallObjectMethod(cls, jintArraygetWidgetPositionjintID ,objID);

jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myArray;

}

void CallScilabBridge::setFramePosition (JavaVM * jvm_, int objID, int x, int y, int width, int height){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFramePositionjintjintjintjintjintID = curEnv->GetStaticMethodID(cls, "setFramePosition", "(IIIII)V" ) ;
if (voidsetFramePositionjintjintjintjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setFramePosition" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFramePositionjintjintjintjintjintID ,objID, x, y, width, height);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int * CallScilabBridge::getFramePosition (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArraygetFramePositionjintID = curEnv->GetStaticMethodID(cls, "getFramePosition", "(I)[I" ) ;
if (jintArraygetFramePositionjintID == NULL) {
std::cerr << "Could not access to the method " << "getFramePosition" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jintArray res =  (jintArray) curEnv->CallObjectMethod(cls, jintArraygetFramePositionjintID ,objID);

jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myArray;

}

void CallScilabBridge::setWidgetCallback (JavaVM * jvm_, int objID, char * text, int type){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetCallbackjintjstringjintID = curEnv->GetStaticMethodID(cls, "setWidgetCallback", "(ILjava/lang/String;I)V" ) ;
if (voidsetWidgetCallbackjintjstringjintID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetCallback" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring text_ = curEnv->NewStringUTF( text );

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetCallbackjintjstringjintID ,objID, text_, type);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFrameCallback (JavaVM * jvm_, int objID, char * text, int type){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameCallbackjintjstringjintID = curEnv->GetStaticMethodID(cls, "setFrameCallback", "(ILjava/lang/String;I)V" ) ;
if (voidsetFrameCallbackjintjstringjintID == NULL) {
std::cerr << "Could not access to the method " << "setFrameCallback" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring text_ = curEnv->NewStringUTF( text );

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameCallbackjintjstringjintID ,objID, text_, type);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWidgetHorizontalAlignment (JavaVM * jvm_, int objID, char * alignment){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetHorizontalAlignmentjintjstringID = curEnv->GetStaticMethodID(cls, "setWidgetHorizontalAlignment", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetHorizontalAlignmentjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetHorizontalAlignment" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring alignment_ = curEnv->NewStringUTF( alignment );

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetHorizontalAlignmentjintjstringID ,objID, alignment_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWidgetVerticalAlignment (JavaVM * jvm_, int objID, char * alignment){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetVerticalAlignmentjintjstringID = curEnv->GetStaticMethodID(cls, "setWidgetVerticalAlignment", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetVerticalAlignmentjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetVerticalAlignment" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring alignment_ = curEnv->NewStringUTF( alignment );

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetVerticalAlignmentjintjstringID ,objID, alignment_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setSliderMinorTickSpacing (JavaVM * jvm_, int objID, int space){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderMinorTickSpacingjintjintID = curEnv->GetStaticMethodID(cls, "setSliderMinorTickSpacing", "(II)V" ) ;
if (voidsetSliderMinorTickSpacingjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setSliderMinorTickSpacing" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderMinorTickSpacingjintjintID ,objID, space);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setSliderMajorTickSpacing (JavaVM * jvm_, int objID, int space){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderMajorTickSpacingjintjintID = curEnv->GetStaticMethodID(cls, "setSliderMajorTickSpacing", "(II)V" ) ;
if (voidsetSliderMajorTickSpacingjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setSliderMajorTickSpacing" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderMajorTickSpacingjintjintID ,objID, space);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setListBoxSelectedIndices (JavaVM * jvm_, int objID, int * indices, int indicesSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetListBoxSelectedIndicesjintjintArrayID = curEnv->GetStaticMethodID(cls, "setListBoxSelectedIndices", "(I[I)V" ) ;
if (voidsetListBoxSelectedIndicesjintjintArrayID == NULL) {
std::cerr << "Could not access to the method " << "setListBoxSelectedIndices" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jintArray indices_ = curEnv->NewIntArray( indicesSize ) ;

curEnv->SetIntArrayRegion( indices_, 0, indicesSize, (jint*) indices ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetListBoxSelectedIndicesjintjintArrayID ,objID, indices_);
curEnv->DeleteLocalRef(indices_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int * CallScilabBridge::getListBoxSelectedIndices (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArraygetListBoxSelectedIndicesjintID = curEnv->GetStaticMethodID(cls, "getListBoxSelectedIndices", "(I)[I" ) ;
if (jintArraygetListBoxSelectedIndicesjintID == NULL) {
std::cerr << "Could not access to the method " << "getListBoxSelectedIndices" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jintArray res =  (jintArray) curEnv->CallObjectMethod(cls, jintArraygetListBoxSelectedIndicesjintID ,objID);

jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myArray;

}

int CallScilabBridge::getListBoxSelectionSize (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetListBoxSelectionSizejintID = curEnv->GetStaticMethodID(cls, "getListBoxSelectionSize", "(I)I" ) ;
if (jintgetListBoxSelectionSizejintID == NULL) {
std::cerr << "Could not access to the method " << "getListBoxSelectionSize" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetListBoxSelectionSizejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setPopupMenuSelectedIndex (JavaVM * jvm_, int objID, int index){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetPopupMenuSelectedIndexjintjintID = curEnv->GetStaticMethodID(cls, "setPopupMenuSelectedIndex", "(II)V" ) ;
if (voidsetPopupMenuSelectedIndexjintjintID == NULL) {
std::cerr << "Could not access to the method " << "setPopupMenuSelectedIndex" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetPopupMenuSelectedIndexjintjintID ,objID, index);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::getPopupMenuSelectedIndex (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetPopupMenuSelectedIndexjintID = curEnv->GetStaticMethodID(cls, "getPopupMenuSelectedIndex", "(I)I" ) ;
if (jintgetPopupMenuSelectedIndexjintID == NULL) {
std::cerr << "Could not access to the method " << "getPopupMenuSelectedIndex" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetPopupMenuSelectedIndexjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setSliderValue (JavaVM * jvm_, int objID, int index){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderValuejintjintID = curEnv->GetStaticMethodID(cls, "setSliderValue", "(II)V" ) ;
if (voidsetSliderValuejintjintID == NULL) {
std::cerr << "Could not access to the method " << "setSliderValue" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderValuejintjintID ,objID, index);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::getSliderValue (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetSliderValuejintID = curEnv->GetStaticMethodID(cls, "getSliderValue", "(I)I" ) ;
if (jintgetSliderValuejintID == NULL) {
std::cerr << "Could not access to the method " << "getSliderValue" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetSliderValuejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setRadioButtonChecked (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRadioButtonCheckedjintjbooleanID = curEnv->GetStaticMethodID(cls, "setRadioButtonChecked", "(IZ)V" ) ;
if (voidsetRadioButtonCheckedjintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setRadioButtonChecked" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetRadioButtonCheckedjintjbooleanID ,objID, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

bool CallScilabBridge::isRadioButtonChecked (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisRadioButtonCheckedjintID = curEnv->GetStaticMethodID(cls, "isRadioButtonChecked", "(I)Z" ) ;
if (jbooleanisRadioButtonCheckedjintID == NULL) {
std::cerr << "Could not access to the method " << "isRadioButtonChecked" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanisRadioButtonCheckedjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

void CallScilabBridge::setCheckBoxChecked (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetCheckBoxCheckedjintjbooleanID = curEnv->GetStaticMethodID(cls, "setCheckBoxChecked", "(IZ)V" ) ;
if (voidsetCheckBoxCheckedjintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setCheckBoxChecked" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetCheckBoxCheckedjintjbooleanID ,objID, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

bool CallScilabBridge::isCheckBoxChecked (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisCheckBoxCheckedjintID = curEnv->GetStaticMethodID(cls, "isCheckBoxChecked", "(I)Z" ) ;
if (jbooleanisCheckBoxCheckedjintID == NULL) {
std::cerr << "Could not access to the method " << "isCheckBoxChecked" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanisCheckBoxCheckedjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

void CallScilabBridge::setSliderMinValue (JavaVM * jvm_, int objID, int value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderMinValuejintjintID = curEnv->GetStaticMethodID(cls, "setSliderMinValue", "(II)V" ) ;
if (voidsetSliderMinValuejintjintID == NULL) {
std::cerr << "Could not access to the method " << "setSliderMinValue" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderMinValuejintjintID ,objID, value);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setSliderMaxValue (JavaVM * jvm_, int objID, int value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderMaxValuejintjintID = curEnv->GetStaticMethodID(cls, "setSliderMaxValue", "(II)V" ) ;
if (voidsetSliderMaxValuejintjintID == NULL) {
std::cerr << "Could not access to the method " << "setSliderMaxValue" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderMaxValuejintjintID ,objID, value);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setSliderVertical (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderVerticaljintID = curEnv->GetStaticMethodID(cls, "setSliderVertical", "(I)V" ) ;
if (voidsetSliderVerticaljintID == NULL) {
std::cerr << "Could not access to the method " << "setSliderVertical" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderVerticaljintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setSliderHorizontal (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetSliderHorizontaljintID = curEnv->GetStaticMethodID(cls, "setSliderHorizontal", "(I)V" ) ;
if (voidsetSliderHorizontaljintID == NULL) {
std::cerr << "Could not access to the method " << "setSliderHorizontal" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetSliderHorizontaljintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setListBoxMultipleSelectionEnabled (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetListBoxMultipleSelectionEnabledjintjbooleanID = curEnv->GetStaticMethodID(cls, "setListBoxMultipleSelectionEnabled", "(IZ)V" ) ;
if (voidsetListBoxMultipleSelectionEnabledjintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setListBoxMultipleSelectionEnabled" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetListBoxMultipleSelectionEnabledjintjbooleanID ,objID, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char ** CallScilabBridge::getListBoxAllItemsText (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArraygetListBoxAllItemsTextjintID = curEnv->GetStaticMethodID(cls, "getListBoxAllItemsText", "(I)[Ljava/lang/String;" ) ;
if (jobjectArraygetListBoxAllItemsTextjintID == NULL) {
std::cerr << "Could not access to the method " << "getListBoxAllItemsText" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jobjectArray res =  (jobjectArray) curEnv->CallObjectMethod(cls, jobjectArraygetListBoxAllItemsTextjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

jsize len = curEnv->GetArrayLength(res);
char **arrayOfString;
                        arrayOfString= arrayOfString= new char *[len + 1];
for (jsize i = 0; i < len; i++){
jstring resString = (jstring)curEnv->GetObjectArrayElement(res, i);
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

curEnv->DeleteLocalRef(res);
return arrayOfString;

}

int CallScilabBridge::getListBoxNumberOfItems (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetListBoxNumberOfItemsjintID = curEnv->GetStaticMethodID(cls, "getListBoxNumberOfItems", "(I)I" ) ;
if (jintgetListBoxNumberOfItemsjintID == NULL) {
std::cerr << "Could not access to the method " << "getListBoxNumberOfItems" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetListBoxNumberOfItemsjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setListBoxText (JavaVM * jvm_, int objID, char ** text, int textSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetListBoxTextjintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setListBoxText", "(I[Ljava/lang/String;)V" ) ;
if (voidsetListBoxTextjintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setListBoxText" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray text_ = curEnv->NewObjectArray( textSize, stringArrayClass, NULL);
if (text_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < textSize; i++)
{
jstring TempString = curEnv->NewStringUTF( text[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( text_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetListBoxTextjintjobjectArrayID ,objID, text_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(text_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char ** CallScilabBridge::getPopupMenuAllItemsText (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArraygetPopupMenuAllItemsTextjintID = curEnv->GetStaticMethodID(cls, "getPopupMenuAllItemsText", "(I)[Ljava/lang/String;" ) ;
if (jobjectArraygetPopupMenuAllItemsTextjintID == NULL) {
std::cerr << "Could not access to the method " << "getPopupMenuAllItemsText" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jobjectArray res =  (jobjectArray) curEnv->CallObjectMethod(cls, jobjectArraygetPopupMenuAllItemsTextjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

jsize len = curEnv->GetArrayLength(res);
char **arrayOfString;
                        arrayOfString= arrayOfString= new char *[len + 1];
for (jsize i = 0; i < len; i++){
jstring resString = (jstring)curEnv->GetObjectArrayElement(res, i);
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

curEnv->DeleteLocalRef(res);
return arrayOfString;

}

int CallScilabBridge::getPopupMenuNumberOfItems (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetPopupMenuNumberOfItemsjintID = curEnv->GetStaticMethodID(cls, "getPopupMenuNumberOfItems", "(I)I" ) ;
if (jintgetPopupMenuNumberOfItemsjintID == NULL) {
std::cerr << "Could not access to the method " << "getPopupMenuNumberOfItems" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetPopupMenuNumberOfItemsjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setPopupMenuText (JavaVM * jvm_, int objID, char ** text, int textSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetPopupMenuTextjintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setPopupMenuText", "(I[Ljava/lang/String;)V" ) ;
if (voidsetPopupMenuTextjintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setPopupMenuText" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray text_ = curEnv->NewObjectArray( textSize, stringArrayClass, NULL);
if (text_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < textSize; i++)
{
jstring TempString = curEnv->NewStringUTF( text[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( text_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetPopupMenuTextjintjobjectArrayID ,objID, text_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(text_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWidgetRelief (JavaVM * jvm_, int objID, char * reliefType){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetReliefjintjstringID = curEnv->GetStaticMethodID(cls, "setWidgetRelief", "(ILjava/lang/String;)V" ) ;
if (voidsetWidgetReliefjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetRelief" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring reliefType_ = curEnv->NewStringUTF( reliefType );

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetReliefjintjstringID ,objID, reliefType_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFrameRelief (JavaVM * jvm_, int objID, char * reliefType){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameReliefjintjstringID = curEnv->GetStaticMethodID(cls, "setFrameRelief", "(ILjava/lang/String;)V" ) ;
if (voidsetFrameReliefjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setFrameRelief" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring reliefType_ = curEnv->NewStringUTF( reliefType );

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameReliefjintjstringID ,objID, reliefType_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setRootMenuEnabled (JavaVM * jvm_, char * menuName, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRootMenuEnabledjstringjbooleanID = curEnv->GetStaticMethodID(cls, "setRootMenuEnabled", "(Ljava/lang/String;Z)V" ) ;
if (voidsetRootMenuEnabledjstringjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setRootMenuEnabled" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring menuName_ = curEnv->NewStringUTF( menuName );

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetRootMenuEnabledjstringjbooleanID ,menuName_, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setRootSubMenuEnabled (JavaVM * jvm_, char * menuName, int position, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetRootSubMenuEnabledjstringjintjbooleanID = curEnv->GetStaticMethodID(cls, "setRootSubMenuEnabled", "(Ljava/lang/String;IZ)V" ) ;
if (voidsetRootSubMenuEnabledjstringjintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setRootSubMenuEnabled" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring menuName_ = curEnv->NewStringUTF( menuName );

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetRootSubMenuEnabledjstringjintjbooleanID ,menuName_, position, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFigureMenuEnabled (JavaVM * jvm_, int figureID, char * menuName, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFigureMenuEnabledjintjstringjbooleanID = curEnv->GetStaticMethodID(cls, "setFigureMenuEnabled", "(ILjava/lang/String;Z)V" ) ;
if (voidsetFigureMenuEnabledjintjstringjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setFigureMenuEnabled" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring menuName_ = curEnv->NewStringUTF( menuName );

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFigureMenuEnabledjintjstringjbooleanID ,figureID, menuName_, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFigureSubMenuEnabled (JavaVM * jvm_, int figureID, char * menuName, int position, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFigureSubMenuEnabledjintjstringjintjbooleanID = curEnv->GetStaticMethodID(cls, "setFigureSubMenuEnabled", "(ILjava/lang/String;IZ)V" ) ;
if (voidsetFigureSubMenuEnabledjintjstringjintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setFigureSubMenuEnabled" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring menuName_ = curEnv->NewStringUTF( menuName );

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFigureSubMenuEnabledjintjstringjintjbooleanID ,figureID, menuName_, position, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWidgetEnable (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetEnablejintjbooleanID = curEnv->GetStaticMethodID(cls, "setWidgetEnable", "(IZ)V" ) ;
if (voidsetWidgetEnablejintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetEnable" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetEnablejintjbooleanID ,objID, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFrameEnable (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameEnablejintjbooleanID = curEnv->GetStaticMethodID(cls, "setFrameEnable", "(IZ)V" ) ;
if (voidsetFrameEnablejintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setFrameEnable" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameEnablejintjbooleanID ,objID, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

bool CallScilabBridge::isWidgetEnable (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisWidgetEnablejintID = curEnv->GetStaticMethodID(cls, "isWidgetEnable", "(I)Z" ) ;
if (jbooleanisWidgetEnablejintID == NULL) {
std::cerr << "Could not access to the method " << "isWidgetEnable" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanisWidgetEnablejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

bool CallScilabBridge::isFrameEnable (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisFrameEnablejintID = curEnv->GetStaticMethodID(cls, "isFrameEnable", "(I)Z" ) ;
if (jbooleanisFrameEnablejintID == NULL) {
std::cerr << "Could not access to the method " << "isFrameEnable" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanisFrameEnablejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

void CallScilabBridge::removeRootMenu (JavaVM * jvm_, char * menuName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveRootMenujstringID = curEnv->GetStaticMethodID(cls, "removeRootMenu", "(Ljava/lang/String;)V" ) ;
if (voidremoveRootMenujstringID == NULL) {
std::cerr << "Could not access to the method " << "removeRootMenu" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring menuName_ = curEnv->NewStringUTF( menuName );

                         curEnv->CallStaticVoidMethod(cls, voidremoveRootMenujstringID ,menuName_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::removeFigureMenu (JavaVM * jvm_, int figureID, char * menuName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidremoveFigureMenujintjstringID = curEnv->GetStaticMethodID(cls, "removeFigureMenu", "(ILjava/lang/String;)V" ) ;
if (voidremoveFigureMenujintjstringID == NULL) {
std::cerr << "Could not access to the method " << "removeFigureMenu" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring menuName_ = curEnv->NewStringUTF( menuName );

                         curEnv->CallStaticVoidMethod(cls, voidremoveFigureMenujintjstringID ,figureID, menuName_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char * CallScilabBridge::displayAndWaitContextMenu (JavaVM * jvm_, int ID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringdisplayAndWaitContextMenujintID = curEnv->GetStaticMethodID(cls, "displayAndWaitContextMenu", "(I)Ljava/lang/String;" ) ;
if (jstringdisplayAndWaitContextMenujintID == NULL) {
std::cerr << "Could not access to the method " << "displayAndWaitContextMenu" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringdisplayAndWaitContextMenujintID ,ID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

int CallScilabBridge::newMessageBox (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewMessageBoxID = curEnv->GetStaticMethodID(cls, "newMessageBox", "()I" ) ;
if (jintnewMessageBoxID == NULL) {
std::cerr << "Could not access to the method " << "newMessageBox" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewMessageBoxID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setMessageBoxTitle (JavaVM * jvm_, int id, char * title){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxTitlejintjstringID = curEnv->GetStaticMethodID(cls, "setMessageBoxTitle", "(ILjava/lang/String;)V" ) ;
if (voidsetMessageBoxTitlejintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxTitle" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring title_ = curEnv->NewStringUTF( title );

                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxTitlejintjstringID ,id, title_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setMessageBoxMessage (JavaVM * jvm_, int id, char * message){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxMessagejintjstringID = curEnv->GetStaticMethodID(cls, "setMessageBoxMessage", "(ILjava/lang/String;)V" ) ;
if (voidsetMessageBoxMessagejintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxMessage" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring message_ = curEnv->NewStringUTF( message );

                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxMessagejintjstringID ,id, message_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setMessageBoxMessage (JavaVM * jvm_, int id, char ** message, int messageSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxMessagejintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setMessageBoxMessage", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxMessagejintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxMessage" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray message_ = curEnv->NewObjectArray( messageSize, stringArrayClass, NULL);
if (message_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < messageSize; i++)
{
jstring TempString = curEnv->NewStringUTF( message[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( message_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxMessagejintjobjectArrayID ,id, message_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(message_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::messageBoxDisplayAndWait (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidmessageBoxDisplayAndWaitjintID = curEnv->GetStaticMethodID(cls, "messageBoxDisplayAndWait", "(I)V" ) ;
if (voidmessageBoxDisplayAndWaitjintID == NULL) {
std::cerr << "Could not access to the method " << "messageBoxDisplayAndWait" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidmessageBoxDisplayAndWaitjintID ,id);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::getMessageBoxSelectedButton (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMessageBoxSelectedButtonjintID = curEnv->GetStaticMethodID(cls, "getMessageBoxSelectedButton", "(I)I" ) ;
if (jintgetMessageBoxSelectedButtonjintID == NULL) {
std::cerr << "Could not access to the method " << "getMessageBoxSelectedButton" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetMessageBoxSelectedButtonjintID ,id);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setMessageBoxDefaultSelectedButtons (JavaVM * jvm_, int id, int * index, int indexSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxDefaultSelectedButtonsjintjintArrayID = curEnv->GetStaticMethodID(cls, "setMessageBoxDefaultSelectedButtons", "(I[I)V" ) ;
if (voidsetMessageBoxDefaultSelectedButtonsjintjintArrayID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxDefaultSelectedButtons" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jintArray index_ = curEnv->NewIntArray( indexSize ) ;

curEnv->SetIntArrayRegion( index_, 0, indexSize, (jint*) index ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxDefaultSelectedButtonsjintjintArrayID ,id, index_);
curEnv->DeleteLocalRef(index_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int * CallScilabBridge::getMessageBoxUserSelectedButtons (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArraygetMessageBoxUserSelectedButtonsjintID = curEnv->GetStaticMethodID(cls, "getMessageBoxUserSelectedButtons", "(I)[I" ) ;
if (jintArraygetMessageBoxUserSelectedButtonsjintID == NULL) {
std::cerr << "Could not access to the method " << "getMessageBoxUserSelectedButtons" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jintArray res =  (jintArray) curEnv->CallObjectMethod(cls, jintArraygetMessageBoxUserSelectedButtonsjintID ,id);

jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myArray;

}

void CallScilabBridge::setMessageBoxButtonsLabels (JavaVM * jvm_, int id, char ** labels, int labelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxButtonsLabelsjintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setMessageBoxButtonsLabels", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxButtonsLabelsjintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxButtonsLabels" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray labels_ = curEnv->NewObjectArray( labelsSize, stringArrayClass, NULL);
if (labels_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < labelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( labels[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( labels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxButtonsLabelsjintjobjectArrayID ,id, labels_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(labels_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setMessageBoxInitialValue (JavaVM * jvm_, int id, char ** value, int valueSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxInitialValuejintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setMessageBoxInitialValue", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxInitialValuejintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxInitialValue" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray value_ = curEnv->NewObjectArray( valueSize, stringArrayClass, NULL);
if (value_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < valueSize; i++)
{
jstring TempString = curEnv->NewStringUTF( value[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( value_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxInitialValuejintjobjectArrayID ,id, value_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(value_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char ** CallScilabBridge::getMessageBoxValue (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jobjectArraygetMessageBoxValuejintID = curEnv->GetStaticMethodID(cls, "getMessageBoxValue", "(I)[Ljava/lang/String;" ) ;
if (jobjectArraygetMessageBoxValuejintID == NULL) {
std::cerr << "Could not access to the method " << "getMessageBoxValue" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jobjectArray res =  (jobjectArray) curEnv->CallObjectMethod(cls, jobjectArraygetMessageBoxValuejintID ,id);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

jsize len = curEnv->GetArrayLength(res);
char **arrayOfString;
                        arrayOfString= arrayOfString= new char *[len + 1];
for (jsize i = 0; i < len; i++){
jstring resString = (jstring)curEnv->GetObjectArrayElement(res, i);
const char *tempString = curEnv->GetStringUTFChars(resString, 0);
arrayOfString[i] = new char[strlen(tempString) + 1];

strcpy(arrayOfString[i], tempString);
curEnv->ReleaseStringUTFChars(resString, tempString);
curEnv->DeleteLocalRef(resString);
}

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

curEnv->DeleteLocalRef(res);
return arrayOfString;

}

int CallScilabBridge::getMessageBoxValueSize (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMessageBoxValueSizejintID = curEnv->GetStaticMethodID(cls, "getMessageBoxValueSize", "(I)I" ) ;
if (jintgetMessageBoxValueSizejintID == NULL) {
std::cerr << "Could not access to the method " << "getMessageBoxValueSize" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetMessageBoxValueSizejintID ,id);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setMessageBoxListBoxItems (JavaVM * jvm_, int id, char ** items, int itemsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxListBoxItemsjintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setMessageBoxListBoxItems", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxListBoxItemsjintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxListBoxItems" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray items_ = curEnv->NewObjectArray( itemsSize, stringArrayClass, NULL);
if (items_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < itemsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( items[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( items_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxListBoxItemsjintjobjectArrayID ,id, items_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(items_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::getMessageBoxSelectedItem (JavaVM * jvm_, int id){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetMessageBoxSelectedItemjintID = curEnv->GetStaticMethodID(cls, "getMessageBoxSelectedItem", "(I)I" ) ;
if (jintgetMessageBoxSelectedItemjintID == NULL) {
std::cerr << "Could not access to the method " << "getMessageBoxSelectedItem" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetMessageBoxSelectedItemjintID ,id);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setMessageBoxLineLabels (JavaVM * jvm_, int id, char ** labels, int labelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxLineLabelsjintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setMessageBoxLineLabels", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxLineLabelsjintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxLineLabels" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray labels_ = curEnv->NewObjectArray( labelsSize, stringArrayClass, NULL);
if (labels_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < labelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( labels[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( labels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxLineLabelsjintjobjectArrayID ,id, labels_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(labels_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setMessageBoxColumnLabels (JavaVM * jvm_, int id, char ** labels, int labelsSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxColumnLabelsjintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setMessageBoxColumnLabels", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxColumnLabelsjintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxColumnLabels" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray labels_ = curEnv->NewObjectArray( labelsSize, stringArrayClass, NULL);
if (labels_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < labelsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( labels[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( labels_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxColumnLabelsjintjobjectArrayID ,id, labels_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(labels_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setMessageBoxDefaultInput (JavaVM * jvm_, int id, char ** values, int valuesSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxDefaultInputjintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setMessageBoxDefaultInput", "(I[Ljava/lang/String;)V" ) ;
if (voidsetMessageBoxDefaultInputjintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxDefaultInput" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray values_ = curEnv->NewObjectArray( valuesSize, stringArrayClass, NULL);
if (values_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < valuesSize; i++)
{
jstring TempString = curEnv->NewStringUTF( values[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( values_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxDefaultInputjintjobjectArrayID ,id, values_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(values_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setMessageBoxModal (JavaVM * jvm_, int id, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxModaljintjbooleanID = curEnv->GetStaticMethodID(cls, "setMessageBoxModal", "(IZ)V" ) ;
if (voidsetMessageBoxModaljintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxModal" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxModaljintjbooleanID ,id, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setMessageBoxIcon (JavaVM * jvm_, int id, char * name){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetMessageBoxIconjintjstringID = curEnv->GetStaticMethodID(cls, "setMessageBoxIcon", "(ILjava/lang/String;)V" ) ;
if (voidsetMessageBoxIconjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setMessageBoxIcon" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring name_ = curEnv->NewStringUTF( name );

                         curEnv->CallStaticVoidMethod(cls, voidsetMessageBoxIconjintjstringID ,id, name_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

bool CallScilabBridge::isToolbarVisible (JavaVM * jvm_, int figNum){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisToolbarVisiblejintID = curEnv->GetStaticMethodID(cls, "isToolbarVisible", "(I)Z" ) ;
if (jbooleanisToolbarVisiblejintID == NULL) {
std::cerr << "Could not access to the method " << "isToolbarVisible" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanisToolbarVisiblejintID ,figNum);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

void CallScilabBridge::setToolbarVisible (JavaVM * jvm_, int figNum, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetToolbarVisiblejintjbooleanID = curEnv->GetStaticMethodID(cls, "setToolbarVisible", "(IZ)V" ) ;
if (voidsetToolbarVisiblejintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setToolbarVisible" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetToolbarVisiblejintjbooleanID ,figNum, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setEventHandler (JavaVM * jvm_, int figNum, char * command){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetEventHandlerjintjstringID = curEnv->GetStaticMethodID(cls, "setEventHandler", "(ILjava/lang/String;)V" ) ;
if (voidsetEventHandlerjintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setEventHandler" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring command_ = curEnv->NewStringUTF( command );

                         curEnv->CallStaticVoidMethod(cls, voidsetEventHandlerjintjstringID ,figNum, command_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setEventHandlerEnabled (JavaVM * jvm_, int figNum, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetEventHandlerEnabledjintjbooleanID = curEnv->GetStaticMethodID(cls, "setEventHandlerEnabled", "(IZ)V" ) ;
if (voidsetEventHandlerEnabledjintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setEventHandlerEnabled" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetEventHandlerEnabledjintjbooleanID ,figNum, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::newWaitBar (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewWaitBarID = curEnv->GetStaticMethodID(cls, "newWaitBar", "()I" ) ;
if (jintnewWaitBarID == NULL) {
std::cerr << "Could not access to the method " << "newWaitBar" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewWaitBarID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::setWaitBarMessage (JavaVM * jvm_, int id, char ** message, int messageSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWaitBarMessagejintjobjectArrayID = curEnv->GetStaticMethodID(cls, "setWaitBarMessage", "(I[Ljava/lang/String;)V" ) ;
if (voidsetWaitBarMessagejintjobjectArrayID == NULL) {
std::cerr << "Could not access to the method " << "setWaitBarMessage" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray message_ = curEnv->NewObjectArray( messageSize, stringArrayClass, NULL);
if (message_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < messageSize; i++)
{
jstring TempString = curEnv->NewStringUTF( message[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( message_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidsetWaitBarMessagejintjobjectArrayID ,id, message_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(message_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWaitBarValue (JavaVM * jvm_, int id, int value){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWaitBarValuejintjintID = curEnv->GetStaticMethodID(cls, "setWaitBarValue", "(II)V" ) ;
if (voidsetWaitBarValuejintjintID == NULL) {
std::cerr << "Could not access to the method " << "setWaitBarValue" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetWaitBarValuejintjintID ,id, value);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::destroyWaitBar (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiddestroyWaitBarjintID = curEnv->GetStaticMethodID(cls, "destroyWaitBar", "(I)V" ) ;
if (voiddestroyWaitBarjintID == NULL) {
std::cerr << "Could not access to the method " << "destroyWaitBar" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voiddestroyWaitBarjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWaitBarIndeterminateMode (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWaitBarIndeterminateModejintjbooleanID = curEnv->GetStaticMethodID(cls, "setWaitBarIndeterminateMode", "(IZ)V" ) ;
if (voidsetWaitBarIndeterminateModejintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setWaitBarIndeterminateMode" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetWaitBarIndeterminateModejintjbooleanID ,objID, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::launchHelpBrowser (JavaVM * jvm_, char ** helps, int helpsSize, char * language){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidlaunchHelpBrowserjobjectArrayjstringID = curEnv->GetStaticMethodID(cls, "launchHelpBrowser", "([Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidlaunchHelpBrowserjobjectArrayjstringID == NULL) {
std::cerr << "Could not access to the method " << "launchHelpBrowser" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray helps_ = curEnv->NewObjectArray( helpsSize, stringArrayClass, NULL);
if (helps_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < helpsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( helps[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( helps_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring language_ = curEnv->NewStringUTF( language );

                         curEnv->CallStaticVoidMethod(cls, voidlaunchHelpBrowserjobjectArrayjstringID ,helps_, language_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(helps_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::searchKeyword (JavaVM * jvm_, char ** helps, int helpsSize, char * keyword, char * language, bool fullText){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsearchKeywordjobjectArrayjstringjstringjbooleanID = curEnv->GetStaticMethodID(cls, "searchKeyword", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V" ) ;
if (voidsearchKeywordjobjectArrayjstringjstringjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "searchKeyword" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray helps_ = curEnv->NewObjectArray( helpsSize, stringArrayClass, NULL);
if (helps_ == NULL)
{
std::cerr << "Could not allocate Java string array, memory full." << std::endl;
exit(EXIT_FAILURE);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < helpsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( helps[i] );
if (TempString == NULL)
{
std::cerr << "Could not convert C string to Java UTF string, memory full." << std::endl;
exit(EXIT_FAILURE);
}

curEnv->SetObjectArrayElement( helps_, i, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
jstring keyword_ = curEnv->NewStringUTF( keyword );

jstring language_ = curEnv->NewStringUTF( language );

jboolean fullText_ = ((bool) fullText ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsearchKeywordjobjectArrayjstringjstringjbooleanID ,helps_, keyword_, language_, fullText_);
curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(helps_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::saveMainWindowSettings (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsaveMainWindowSettingsID = curEnv->GetStaticMethodID(cls, "saveMainWindowSettings", "()V" ) ;
if (voidsaveMainWindowSettingsID == NULL) {
std::cerr << "Could not access to the method " << "saveMainWindowSettings" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsaveMainWindowSettingsID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::newExportFileChooser (JavaVM * jvm_, int figureId){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewExportFileChooserjintID = curEnv->GetStaticMethodID(cls, "newExportFileChooser", "(I)I" ) ;
if (jintnewExportFileChooserjintID == NULL) {
std::cerr << "Could not access to the method " << "newExportFileChooser" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewExportFileChooserjintID ,figureId);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::newFontChooser (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewFontChooserID = curEnv->GetStaticMethodID(cls, "newFontChooser", "()I" ) ;
if (jintnewFontChooserID == NULL) {
std::cerr << "Could not access to the method " << "newFontChooser" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewFontChooserID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::fontChooserDisplayAndWait (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidfontChooserDisplayAndWaitjintID = curEnv->GetStaticMethodID(cls, "fontChooserDisplayAndWait", "(I)V" ) ;
if (voidfontChooserDisplayAndWaitjintID == NULL) {
std::cerr << "Could not access to the method " << "fontChooserDisplayAndWait" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidfontChooserDisplayAndWaitjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFontChooserFontName (JavaVM * jvm_, int objID, char * fontName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserFontNamejintjstringID = curEnv->GetStaticMethodID(cls, "setFontChooserFontName", "(ILjava/lang/String;)V" ) ;
if (voidsetFontChooserFontNamejintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setFontChooserFontName" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring fontName_ = curEnv->NewStringUTF( fontName );

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserFontNamejintjstringID ,objID, fontName_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFontChooserFontSize (JavaVM * jvm_, int objID, int fontSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserFontSizejintjintID = curEnv->GetStaticMethodID(cls, "setFontChooserFontSize", "(II)V" ) ;
if (voidsetFontChooserFontSizejintjintID == NULL) {
std::cerr << "Could not access to the method " << "setFontChooserFontSize" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserFontSizejintjintID ,objID, fontSize);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFontChooserBold (JavaVM * jvm_, int objID, bool bold){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserBoldjintjbooleanID = curEnv->GetStaticMethodID(cls, "setFontChooserBold", "(IZ)V" ) ;
if (voidsetFontChooserBoldjintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setFontChooserBold" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean bold_ = ((bool) bold ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserBoldjintjbooleanID ,objID, bold_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFontChooserItalic (JavaVM * jvm_, int objID, bool italic){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFontChooserItalicjintjbooleanID = curEnv->GetStaticMethodID(cls, "setFontChooserItalic", "(IZ)V" ) ;
if (voidsetFontChooserItalicjintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setFontChooserItalic" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean italic_ = ((bool) italic ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFontChooserItalicjintjbooleanID ,objID, italic_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

char * CallScilabBridge::getFontChooserFontName (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetFontChooserFontNamejintID = curEnv->GetStaticMethodID(cls, "getFontChooserFontName", "(I)Ljava/lang/String;" ) ;
if (jstringgetFontChooserFontNamejintID == NULL) {
std::cerr << "Could not access to the method " << "getFontChooserFontName" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetFontChooserFontNamejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

int CallScilabBridge::getFontChooserFontSize (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetFontChooserFontSizejintID = curEnv->GetStaticMethodID(cls, "getFontChooserFontSize", "(I)I" ) ;
if (jintgetFontChooserFontSizejintID == NULL) {
std::cerr << "Could not access to the method " << "getFontChooserFontSize" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetFontChooserFontSizejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

bool CallScilabBridge::getFontChooserBold (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleangetFontChooserBoldjintID = curEnv->GetStaticMethodID(cls, "getFontChooserBold", "(I)Z" ) ;
if (jbooleangetFontChooserBoldjintID == NULL) {
std::cerr << "Could not access to the method " << "getFontChooserBold" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleangetFontChooserBoldjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

bool CallScilabBridge::getFontChooserItalic (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleangetFontChooserItalicjintID = curEnv->GetStaticMethodID(cls, "getFontChooserItalic", "(I)Z" ) ;
if (jbooleangetFontChooserItalicjintID == NULL) {
std::cerr << "Could not access to the method " << "getFontChooserItalic" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleangetFontChooserItalicjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

int CallScilabBridge::newColorChooser (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintnewColorChooserID = curEnv->GetStaticMethodID(cls, "newColorChooser", "()I" ) ;
if (jintnewColorChooserID == NULL) {
std::cerr << "Could not access to the method " << "newColorChooser" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintnewColorChooserID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

void CallScilabBridge::colorChooserDisplayAndWait (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcolorChooserDisplayAndWaitjintID = curEnv->GetStaticMethodID(cls, "colorChooserDisplayAndWait", "(I)V" ) ;
if (voidcolorChooserDisplayAndWaitjintID == NULL) {
std::cerr << "Could not access to the method " << "colorChooserDisplayAndWait" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidcolorChooserDisplayAndWaitjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setColorChooserDefaultColor (JavaVM * jvm_, int objID, int * rgb, int rgbSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetColorChooserDefaultColorjintjintArrayID = curEnv->GetStaticMethodID(cls, "setColorChooserDefaultColor", "(I[I)V" ) ;
if (voidsetColorChooserDefaultColorjintjintArrayID == NULL) {
std::cerr << "Could not access to the method " << "setColorChooserDefaultColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jintArray rgb_ = curEnv->NewIntArray( rgbSize ) ;

curEnv->SetIntArrayRegion( rgb_, 0, rgbSize, (jint*) rgb ) ;


                         curEnv->CallStaticVoidMethod(cls, voidsetColorChooserDefaultColorjintjintArrayID ,objID, rgb_);
curEnv->DeleteLocalRef(rgb_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int * CallScilabBridge::getColorChooserSelectedColor (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintArraygetColorChooserSelectedColorjintID = curEnv->GetStaticMethodID(cls, "getColorChooserSelectedColor", "(I)[I" ) ;
if (jintArraygetColorChooserSelectedColorjintID == NULL) {
std::cerr << "Could not access to the method " << "getColorChooserSelectedColor" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jintArray res =  (jintArray) curEnv->CallObjectMethod(cls, jintArraygetColorChooserSelectedColorjintID ,objID);

jsize len = curEnv->GetArrayLength(res);
jboolean isCopy = JNI_FALSE;

/* faster than getXXXArrayElements */
jint *resultsArray = (jint *) curEnv->GetPrimitiveArrayCritical(res, &isCopy);
int * myArray= new int[len];

for (jsize i = 0; i < len; i++){
myArray[i]=resultsArray[i];
}
curEnv->ReleasePrimitiveArrayCritical(res, resultsArray, JNI_ABORT);

                        curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myArray;

}

void CallScilabBridge::setColorChooserTitle (JavaVM * jvm_, int objID, char * title){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetColorChooserTitlejintjstringID = curEnv->GetStaticMethodID(cls, "setColorChooserTitle", "(ILjava/lang/String;)V" ) ;
if (voidsetColorChooserTitlejintjstringID == NULL) {
std::cerr << "Could not access to the method " << "setColorChooserTitle" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring title_ = curEnv->NewStringUTF( title );

                         curEnv->CallStaticVoidMethod(cls, voidsetColorChooserTitlejintjstringID ,objID, title_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setWidgetVisible (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetWidgetVisiblejintjbooleanID = curEnv->GetStaticMethodID(cls, "setWidgetVisible", "(IZ)V" ) ;
if (voidsetWidgetVisiblejintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setWidgetVisible" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetWidgetVisiblejintjbooleanID ,objID, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setFrameVisible (JavaVM * jvm_, int objID, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetFrameVisiblejintjbooleanID = curEnv->GetStaticMethodID(cls, "setFrameVisible", "(IZ)V" ) ;
if (voidsetFrameVisiblejintjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "setFrameVisible" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean status_ = ((bool) status ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidsetFrameVisiblejintjbooleanID ,objID, status_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

bool CallScilabBridge::isWidgetVisible (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisWidgetVisiblejintID = curEnv->GetStaticMethodID(cls, "isWidgetVisible", "(I)Z" ) ;
if (jbooleanisWidgetVisiblejintID == NULL) {
std::cerr << "Could not access to the method " << "isWidgetVisible" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanisWidgetVisiblejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

bool CallScilabBridge::isFrameVisible (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanisFrameVisiblejintID = curEnv->GetStaticMethodID(cls, "isFrameVisible", "(I)Z" ) ;
if (jbooleanisFrameVisiblejintID == NULL) {
std::cerr << "Could not access to the method " << "isFrameVisible" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanisFrameVisiblejintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

char * CallScilabBridge::getClipboardContents (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jstringgetClipboardContentsID = curEnv->GetStaticMethodID(cls, "getClipboardContents", "()Ljava/lang/String;" ) ;
if (jstringgetClipboardContentsID == NULL) {
std::cerr << "Could not access to the method " << "getClipboardContents" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jstring res =  (jstring) curEnv->CallStaticObjectMethod(cls, jstringgetClipboardContentsID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}


const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return myStringBuffer;

}

void CallScilabBridge::pasteClipboardIntoConsole (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidpasteClipboardIntoConsoleID = curEnv->GetStaticMethodID(cls, "pasteClipboardIntoConsole", "()V" ) ;
if (voidpasteClipboardIntoConsoleID == NULL) {
std::cerr << "Could not access to the method " << "pasteClipboardIntoConsole" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidpasteClipboardIntoConsoleID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::copyConsoleSelection (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcopyConsoleSelectionID = curEnv->GetStaticMethodID(cls, "copyConsoleSelection", "()V" ) ;
if (voidcopyConsoleSelectionID == NULL) {
std::cerr << "Could not access to the method " << "copyConsoleSelection" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidcopyConsoleSelectionID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::emptyClipboard (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidemptyClipboardID = curEnv->GetStaticMethodID(cls, "emptyClipboard", "()V" ) ;
if (voidemptyClipboardID == NULL) {
std::cerr << "Could not access to the method " << "emptyClipboard" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidemptyClipboardID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::setClipboardContents (JavaVM * jvm_, char * text){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidsetClipboardContentsjstringID = curEnv->GetStaticMethodID(cls, "setClipboardContents", "(Ljava/lang/String;)V" ) ;
if (voidsetClipboardContentsjstringID == NULL) {
std::cerr << "Could not access to the method " << "setClipboardContents" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring text_ = curEnv->NewStringUTF( text );

                         curEnv->CallStaticVoidMethod(cls, voidsetClipboardContentsjstringID ,text_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::copyFigureToClipBoard (JavaVM * jvm_, int figID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcopyFigureToClipBoardjintID = curEnv->GetStaticMethodID(cls, "copyFigureToClipBoard", "(I)V" ) ;
if (voidcopyFigureToClipBoardjintID == NULL) {
std::cerr << "Could not access to the method " << "copyFigureToClipBoard" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidcopyFigureToClipBoardjintID ,figID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

int CallScilabBridge::getScreenResolution (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetScreenResolutionID = curEnv->GetStaticMethodID(cls, "getScreenResolution", "()I" ) ;
if (jintgetScreenResolutionID == NULL) {
std::cerr << "Could not access to the method " << "getScreenResolution" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetScreenResolutionID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

double CallScilabBridge::getScreenWidth (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublegetScreenWidthID = curEnv->GetStaticMethodID(cls, "getScreenWidth", "()D" ) ;
if (jdoublegetScreenWidthID == NULL) {
std::cerr << "Could not access to the method " << "getScreenWidth" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jdouble res =  (jdouble) curEnv->CallStaticDoubleMethod(cls, jdoublegetScreenWidthID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

double CallScilabBridge::getScreenHeight (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jdoublegetScreenHeightID = curEnv->GetStaticMethodID(cls, "getScreenHeight", "()D" ) ;
if (jdoublegetScreenHeightID == NULL) {
std::cerr << "Could not access to the method " << "getScreenHeight" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jdouble res =  (jdouble) curEnv->CallStaticDoubleMethod(cls, jdoublegetScreenHeightID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

int CallScilabBridge::getScreenDepth (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jintgetScreenDepthID = curEnv->GetStaticMethodID(cls, "getScreenDepth", "()I" ) ;
if (jintgetScreenDepthID == NULL) {
std::cerr << "Could not access to the method " << "getScreenDepth" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jint res =  (jint) curEnv->CallIntMethod(cls, jintgetScreenDepthID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return res;

}

bool CallScilabBridge::printFigure (JavaVM * jvm_, int figID, bool postScript, bool displayDialog){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanprintFigurejintjbooleanjbooleanID = curEnv->GetStaticMethodID(cls, "printFigure", "(IZZ)Z" ) ;
if (jbooleanprintFigurejintjbooleanjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "printFigure" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean postScript_ = ((bool) postScript ? JNI_TRUE : JNI_FALSE);

jboolean displayDialog_ = ((bool) displayDialog ? JNI_TRUE : JNI_FALSE);

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanprintFigurejintjbooleanjbooleanID ,figID, postScript_, displayDialog_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

bool CallScilabBridge::printFile (JavaVM * jvm_, char * fileName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanprintFilejstringID = curEnv->GetStaticMethodID(cls, "printFile", "(Ljava/lang/String;)Z" ) ;
if (jbooleanprintFilejstringID == NULL) {
std::cerr << "Could not access to the method " << "printFile" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring fileName_ = curEnv->NewStringUTF( fileName );

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanprintFilejstringID ,fileName_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

bool CallScilabBridge::printString (JavaVM * jvm_, char * theString, char * pageHeader){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanprintStringjstringjstringID = curEnv->GetStaticMethodID(cls, "printString", "(Ljava/lang/String;Ljava/lang/String;)Z" ) ;
if (jbooleanprintStringjstringjstringID == NULL) {
std::cerr << "Could not access to the method " << "printString" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jstring theString_ = curEnv->NewStringUTF( theString );

jstring pageHeader_ = curEnv->NewStringUTF( pageHeader );

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanprintStringjstringjstringID ,theString_, pageHeader_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

bool CallScilabBridge::pageSetup (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanpageSetupID = curEnv->GetStaticMethodID(cls, "pageSetup", "()Z" ) ;
if (jbooleanpageSetupID == NULL) {
std::cerr << "Could not access to the method " << "pageSetup" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanpageSetupID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

void CallScilabBridge::requestWidgetFocus (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrequestWidgetFocusjintID = curEnv->GetStaticMethodID(cls, "requestWidgetFocus", "(I)V" ) ;
if (voidrequestWidgetFocusjintID == NULL) {
std::cerr << "Could not access to the method " << "requestWidgetFocus" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidrequestWidgetFocusjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::requestFrameFocus (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidrequestFrameFocusjintID = curEnv->GetStaticMethodID(cls, "requestFrameFocus", "(I)V" ) ;
if (voidrequestFrameFocusjintID == NULL) {
std::cerr << "Could not access to the method " << "requestFrameFocus" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidrequestFrameFocusjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::raiseWindow (JavaVM * jvm_, int objID){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidraiseWindowjintID = curEnv->GetStaticMethodID(cls, "raiseWindow", "(I)V" ) ;
if (voidraiseWindowjintID == NULL) {
std::cerr << "Could not access to the method " << "raiseWindow" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                         curEnv->CallStaticVoidMethod(cls, voidraiseWindowjintID ,objID);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

void CallScilabBridge::useCanvasForDisplay (JavaVM * jvm_, bool onOrOff){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voiduseCanvasForDisplayjbooleanID = curEnv->GetStaticMethodID(cls, "useCanvasForDisplay", "(Z)V" ) ;
if (voiduseCanvasForDisplayjbooleanID == NULL) {
std::cerr << "Could not access to the method " << "useCanvasForDisplay" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

jboolean onOrOff_ = ((bool) onOrOff ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voiduseCanvasForDisplayjbooleanID ,onOrOff_);

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

}

bool CallScilabBridge::useCanvasForDisplay (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread((void **) &curEnv, NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID jbooleanuseCanvasForDisplayID = curEnv->GetStaticMethodID(cls, "useCanvasForDisplay", "()Z" ) ;
if (jbooleanuseCanvasForDisplayID == NULL) {
std::cerr << "Could not access to the method " << "useCanvasForDisplay" << std::endl;
curEnv->ExceptionDescribe();
exit(EXIT_FAILURE);
}

                        jboolean res =  (jboolean) curEnv->CallStaticBooleanMethod(cls, jbooleanuseCanvasForDisplayID );

if (curEnv->ExceptionCheck()) {
curEnv->ExceptionDescribe() ;
}

return (res == JNI_TRUE);

}

}
