#include "BuildDocObject.hxx"
/* Generated by GIWS (version 1.0.1) */
/*

Copyright 2007-2008 INRIA

Author : Sylvestre Ledru & others

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_helptools {

// Returns the current env

JNIEnv * BuildDocObject::getCurrentEnv() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);
return curEnv;
}
// Destructor

BuildDocObject::~BuildDocObject() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread((void **) &curEnv, NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors

BuildDocObject::BuildDocObject(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass) ;

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jbooleansetOutputDirectoryjstringID=NULL; 
voidsetWorkingLanguagejstringID=NULL; 
voidsetExportFormatjstringID=NULL; 
jstringprocessjstringjstringID=NULL; 


}

BuildDocObject::BuildDocObject(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = (jclass) curEnv->NewGlobalRef(localClass);
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        jbooleansetOutputDirectoryjstringID=NULL; 
voidsetWorkingLanguagejstringID=NULL; 
voidsetExportFormatjstringID=NULL; 
jstringprocessjstringjstringID=NULL; 


}

// Generic methods


void BuildDocObject::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
std::cerr << "Fail to enter monitor." << std::endl;
exit(EXIT_FAILURE);
}
}


void BuildDocObject::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
std::cerr << "Fail to exit monitor." << std::endl;
exit(EXIT_FAILURE);
}
}

// Method(s)

bool BuildDocObject::setOutputDirectory (char * directory){

JNIEnv * curEnv = getCurrentEnv();

if (jbooleansetOutputDirectoryjstringID==NULL) { /* Use the cache Luke */ jbooleansetOutputDirectoryjstringID = curEnv->GetMethodID(this->instanceClass, "setOutputDirectory", "(Ljava/lang/String;)Z" ) ;
if (jbooleansetOutputDirectoryjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setOutputDirectory");
}
}
jstring directory_ = curEnv->NewStringUTF( directory );

                        jboolean res =  (jboolean) curEnv->CallBooleanMethod( this->instance, jbooleansetOutputDirectoryjstringID ,directory_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return (res == JNI_TRUE);

}

void BuildDocObject::setWorkingLanguage (char * language){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetWorkingLanguagejstringID==NULL) { /* Use the cache Luke */ voidsetWorkingLanguagejstringID = curEnv->GetMethodID(this->instanceClass, "setWorkingLanguage", "(Ljava/lang/String;)V" ) ;
if (voidsetWorkingLanguagejstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setWorkingLanguage");
}
}
jstring language_ = curEnv->NewStringUTF( language );

                         curEnv->CallVoidMethod( this->instance, voidsetWorkingLanguagejstringID ,language_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void BuildDocObject::setExportFormat (char * format){

JNIEnv * curEnv = getCurrentEnv();

if (voidsetExportFormatjstringID==NULL) { /* Use the cache Luke */ voidsetExportFormatjstringID = curEnv->GetMethodID(this->instanceClass, "setExportFormat", "(Ljava/lang/String;)V" ) ;
if (voidsetExportFormatjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "setExportFormat");
}
}
jstring format_ = curEnv->NewStringUTF( format );

                         curEnv->CallVoidMethod( this->instance, voidsetExportFormatjstringID ,format_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

char * BuildDocObject::process (char * sourceDoc, char * styleSheet){

JNIEnv * curEnv = getCurrentEnv();

if (jstringprocessjstringjstringID==NULL) { /* Use the cache Luke */ jstringprocessjstringjstringID = curEnv->GetMethodID(this->instanceClass, "process", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;" ) ;
if (jstringprocessjstringjstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "process");
}
}
jstring sourceDoc_ = curEnv->NewStringUTF( sourceDoc );

jstring styleSheet_ = curEnv->NewStringUTF( styleSheet );

                        jstring res =  (jstring) curEnv->CallObjectMethod( this->instance, jstringprocessjstringjstringID ,sourceDoc_, styleSheet_);
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;

}

}
