/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.36
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.scilab.modules.history_manager;


 /** 
   * All Scilab history management used in Java console 
   * @author Vincent COUVERT
   * @author Allan CORNET
   * @copyright INRIA 
   */
public class HistoryManagement {

  /**
    * Constructor
    */
  protected HistoryManagement() {
	throw new UnsupportedOperationException();
  }
  
	/**
	* add a line to History manager
	* @param line a line to add
	* line isn't added if it is the same as previous (false)
	* @return true or false
	*/
public static boolean appendLineToScilabHistory(String line) {
    return HistoryManagementJNI.appendLineToScilabHistory(line);
  }

  
	/**
	* append lines to History manager
	* @param lines array of string
	* @param numberoflines size of the array of string
	* @return true or false
	*/
public static boolean appendLinesToScilabHistory(String[] lines, int numberoflines) {
    return HistoryManagementJNI.appendLinesToScilabHistory(lines, numberoflines);
  }

  
	/**
	* Display history
	*/
public static void displayScilabHistory() {
    HistoryManagementJNI.displayScilabHistory();
  }

  
	/**
	* save history in a file
	* @param filename if NULL saves in default filename
	* default filename --> SCIHOME/history.scilab
	* @return true or false
	*/
public static boolean writeScilabHistoryToFile(String filename) {
    return HistoryManagementJNI.writeScilabHistoryToFile(filename);
  }

  
	/**
	* load history from a file
	* @param filename if NULL load from default filename
	* default filename --> SCIHOME/history.scilab
	* @return true or false
	*/
public static boolean loadScilabHistoryFromFile(String filename) {
    return HistoryManagementJNI.loadScilabHistoryFromFile(filename);
  }

  
	/**
	* set filename of history
	* @param filename of history
	* @return true or false
	*/
public static boolean setFilenameScilabHistory(String filename) {
    return HistoryManagementJNI.setFilenameScilabHistory(filename);
  }

  
	/**
	* get filename of history
	* @return a filename
	*/
public static String getFilenameScilabHistory() {
    return HistoryManagementJNI.getFilenameScilabHistory();
  }

  
	/**
	* set default filename of history
	* @return true or false
	*/
public static boolean setDefaultFilenameScilabHistory() {
    return HistoryManagementJNI.setDefaultFilenameScilabHistory();
  }

  
	/**
	* reset history manager
	*/
public static void resetScilabHistory() {
    HistoryManagementJNI.resetScilabHistory();
  }

  
	/**
	* Get all lines in history
	* @return a array of string
	*/
public static String[] getAllLinesOfScilabHistory() {
    return HistoryManagementJNI.getAllLinesOfScilabHistory();
  }

  
	/**
	* Get numbers of lines in history
	* size of array returned by getAllLinesOfScilabHistory
	* @return int 
	*/
public static int getSizeAllLinesOfScilabHistory() {
    return HistoryManagementJNI.getSizeAllLinesOfScilabHistory();
  }

  
	/**
	* set new token to search in history
	* @param token (a string)
	* @return true or false
	*/
public static boolean setSearchedTokenInScilabHistory(String token) {
    return HistoryManagementJNI.setSearchedTokenInScilabHistory(token);
  }

  
	/**
	* reset search in history
	* @return true or false
	*/
public static boolean resetSearchedTokenInScilabHistory() {
    return HistoryManagementJNI.resetSearchedTokenInScilabHistory();
  }

  
	/**
	* get token searched in history
	* @return token (a string)
	*/
public static String getSearchedTokenInScilabHistory() {
    return HistoryManagementJNI.getSearchedTokenInScilabHistory();
  }

  
	/**
	* Get the previous line in Scilab history
	* @return a line or NULL
	* after a appendLine iterator go to end
	*/
public static String getPreviousLineInScilabHistory() {
    return HistoryManagementJNI.getPreviousLineInScilabHistory();
  }

  
	/**
	* Get the next line in Scilab history
	* @return a line or NULL
	* after a appendLine iterator go to end
	*/
public static String getNextLineInScilabHistory() {
    return HistoryManagementJNI.getNextLineInScilabHistory();
  }

  
	/**
	* Get numbers of lines in history
	* @return number of lines
	*/
public static int getNumberOfLinesInScilabHistory() {
    return HistoryManagementJNI.getNumberOfLinesInScilabHistory();
  }

  
	/**
	* set consecutive duplicate lines are added
	* @param doit (true or false)
	*/
public static void setSaveConsecutiveDuplicateLinesInScilabHistory(boolean doit) {
    HistoryManagementJNI.setSaveConsecutiveDuplicateLinesInScilabHistory(doit);
  }

  
	/**
	* indicate if consecutive duplicate lines are added
	* @return true or false
	*/
public static boolean getSaveConsecutiveDuplicateLinesInScilabHistory() {
    return HistoryManagementJNI.getSaveConsecutiveDuplicateLinesInScilabHistory();
  }

  
	/**
	* Set after how many lines history is saved
	* @param num number between 0 and Max
	* default value is 0 (disabled)
	*/
public static void setAfterHowManyLinesScilabHistoryIsSaved(int num) {
    HistoryManagementJNI.setAfterHowManyLinesScilabHistoryIsSaved(num);
  }

  
	/**
	* Get after how many lines history is saved
	* @return number between 0 and Max
	* default value is 0 (disabled)
	*/
public static int getAfterHowManyLinesScilabHistoryIsSaved() {
    return HistoryManagementJNI.getAfterHowManyLinesScilabHistoryIsSaved();
  }

  
	/**
	* Get the Nth Line in history
	* @param N the number of the line to get
	* @return the Nth Line
	*/
public static String getNthLineInScilabHistory(int N) {
    return HistoryManagementJNI.getNthLineInScilabHistory(N);
  }

  
	/**
	* delete the Nth Line in history
	* @param N the number of the line to delete
	* @return true or false
	*/
public static boolean deleteNthLineScilabHistory(int N) {
    return HistoryManagementJNI.deleteNthLineScilabHistory(N);
  }

  
	/**
	* get number of lines of history
	* @return a number >= 0
	*/
public static int getSizeScilabHistory() {
    return HistoryManagementJNI.getSizeScilabHistory();
  }

  
	/**
	* get history manager state
	* @return true or false
	*/
public static boolean historyIsEnabled() {
    return HistoryManagementJNI.historyIsEnabled();
  }

}
