// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2009 - Digiteo - Michael Baudin
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt

mprintf("Running optimization...\n");

xref=[1;2;3];
x0=[1;-1;1];
function [f,g,ind] = cost(x,ind)
  f=0.5*norm(x-xref)^2;
  g=x-xref;
endfunction
function [f,g,ind] = cost(x,ind)
  if ( ind == 1 | ind == 4 ) then
    f=0.5*norm(x-xref)^2;
  end
  if ( ind == 1 | ind == 4 ) then
    g=x-xref;
  end
  if ( ind == 1 ) then
    mprintf("===========\n")
    mprintf("x = %s\n", strcat(string(x)," "))
    mprintf("f = %e\n", f)
    g=x-xref;
    mprintf("g = %s\n", strcat(string(g)," "))
  end
endfunction
[f,xopt]=optim(cost,x0,imp=-1)
//
// Load this script into the editor
//
filename = 'optim_output.sce';
dname = get_absolute_file_path(filename);
editor ( dname + filename );

